# DIDON IPTV Backend API Documentation

## Server Status: ✅ FULLY OPERATIONAL

### Base URLs
- **API Domain**: `http://chatti.tmaxhosting.com`
- **Media Server**: `http://15.204.231.210`

---

## Authentication Endpoints

### 1. Login
**POST** `/PanelAndroid/2` or `/PanelAndroid/1`

**Request Body:**
```json
{
  "code": "1231231!!!1231231",
  "android_id": "device_id",
  "macE": "",
  "macW": "0"
}
```

**Response (Success):**
```json
{
  "id": 1,
  "userName": "1231231",
  "code": "1231231!!!1231231",
  "android_id": "device_id",
  "exp_date": "Unlimited",
  "cre_date": "2025-11-18 19:00:00"
}
```

**Response (Failed):**
```json
{
  "id": 0,
  "userName": "",
  "code": "",
  "exp_date": "",
  "cre_date": "2025-11-18 19:00:00"
}
```

---

## Data Endpoints

### 2. Get Initial Data
**POST** `/PanelAndroid/API.php?methode=1`

**Returns:** User info + Categories + Radios + Intro + Main menu

---

### 3. Get Categories (Bouquets)
**POST** `/PanelAndroid/API.php?methode=2`

**Request Body:**
```json
{
  "android_id": "device_id",
  "code": "1231231!!!1231231"
}
```

**Response:**
```json
[
  {"id": 114, "name": "114", "path": "usa_news_networks.png"},
  {"id": 2, "name": "2", "path": "usa_tv_networks.png"},
  ...
]
```
**Total:** 102 categories

---

### 4. Get Radios
**POST** `/PanelAndroid/API.php?methode=4`

**Returns:** 4 radio stations

---

### 5. Get Configuration
**GET** `/PanelAndroid/API.php?methode=5`

**Response:**
```json
{
  "str1": "http://chatti.tmaxhosting.com",
  "str8": "http://15.204.231.210",
  "str9": "/Categories",
  "str12": "/PanelAndroid/media",
  "xtream_url": "https://flix-panel.xyz:2087",
  ...
}
```

---

### 6. Get Channels by Category
**POST** `/PanelAndroid/API.php?methode=10`

**Request Body:**
```json
{
  "category_id": "114",
  "android_id": "device_id"
}
```

**Response:**
```json
{
  "channels": [
    {
      "id": "707",
      "name": "USA: ABC News Live",
      "category_id": "114",
      "url": "https://flix-panel.xyz:2087/live/1231231/1231231/707.ts",
      "logo": "...",
      "type": "live"
    },
    ...
  ],
  "date": "25-11-18 19:00:00"
}
```

---

## Media Resources

### Category Images
**URL Pattern:** `http://15.204.231.210/PanelAndroid/media/Categories/{image_name}.png`

**Example:** 
- `http://15.204.231.210/PanelAndroid/media/Categories/usa_news_networks.png`

**Total:** 260 category images available

---

## Testing & Monitoring

### Status Check
**GET** `http://chatti.tmaxhosting.com/PanelAndroid/status.php`

### Interactive Test Page
**GET** `http://chatti.tmaxhosting.com/PanelAndroid/test.html`

### Monitor Recent Requests
**GET** `http://chatti.tmaxhosting.com/PanelAndroid/monitor.php`

---

## Summary

✅ **All endpoints operational**
✅ **102 categories available**
✅ **260+ category images**
✅ **Login accepts any code**
✅ **Xtream API integrated**

**If app not loading:** Clear app cache/data and restart
