# Panel Configuration Guide

## Configuration Structure

The panel uses a configuration system stored in `db.json` under the `config` object. Here's what each field means:

### API Server Configuration

- **str1 (Base URL)**: The base URL where your API panel is hosted (USED BY APP!)
  - Example: `http://chatti.tmaxhosting.com`
  - **IMPORTANT**: This is what the app uses to build API URLs
  - App constructs: `str1 + str2 + "API.php?methode=" + number`

- **str8 (Alternative Base URL)**: Duplicate of str1 for reference
  - Example: `http://chatti.tmaxhosting.com`
  - Keep this same as str1

### Xtream Codes Panel Configuration

- **str4 (Host Xtream)**: The hostname of your Xtream Codes panel (without http:// or port)
  - Example: `flix-panel.xyz`
  - Used for display and reference

- **str5 (Port Xtream)**: The port number for your Xtream Codes panel
  - Example: `80`
  - Common ports: 80 (HTTP), 8080, 2086, 2087

- **str3 (XMLTV URL)**: EPG (Electronic Program Guide) URL
  - Example: `http://flix-panel.xyz:80/xmltv.php?username=!1!&password=!2!`
  - Placeholders: `!1!` = username, `!2!` = password

- **xtream_url (Internal)**: Internal URL used by the API backend to connect to Xtream
  - Example: `http://flix-panel.xyz:80`
  - Should match str1

### Other Configuration

- **str0**: API method parameter format
  - Value: `API.php?methode=`

- **str2**: API path
  - Value: `/PanelAndroid/`

- **str7**: Full API path with method parameter
  - Value: `/PanelAndroid/API.php?methode=`

- **str9-str13**: Media paths
  - str9: `/Flag` - Flag images
  - str10: `/Intro` - Intro videos
  - str11: `/Main` - Main menu images
  - str12: `/PanelAndroid/media` - Media files
  - str13: Reserved for future use

## Current Configuration

```json
{
  "str1": "http://chatti.tmaxhosting.com",    // YOUR API SERVER (app uses this!)
  "str8": "http://chatti.tmaxhosting.com",    // Same as str1
  "str4": "flix-panel.xyz",                   // Xtream hostname
  "str5": "80",                               // Xtream port
  "str3": "http://flix-panel.xyz:80/xmltv.php?username=!1!&password=!2!",
  "xtream_url": "http://flix-panel.xyz:80"    // Backend connects here
}
```

### How the App Builds URLs:
- API Endpoint: `str1 + str2 + "API.php?methode=" + number`
- Result: `http://chatti.tmaxhosting.com/PanelAndroid/API.php?methode=2` ✅

### Important Notes:
- **str1** MUST point to your API server (chatti.tmaxhosting.com), NOT the Xtream panel
- **xtream_url** points to the actual Xtream panel that the API backend connects to
- The app never directly connects to the Xtream panel, only to your API proxy

## How to Update Configuration

### Method 1: Web Interface
1. Go to: `http://chatti.tmaxhosting.com/PanelAndroid/config.php`
2. Login with password: `panel`
3. Update the fields as needed
4. Click "Update Configuration"

### Method 2: Direct JSON Edit
1. Edit `/var/www/html/PanelAndroid/db.json`
2. Modify the `config` object
3. Save the file

## API Endpoints

The panel provides these API methods:

- **login/restore**: User authentication
- **1**: Get all data (categories, radios, intro, main menu)
- **2**: Get bouquets (categories for live TV)
- **3**: Get categories (VOD/Series categories)
- **4**: Get radios
- **5**: Get configuration
- **6**: Get main menu
- **7**: Get intro video
- **8**: Get app info
- **10**: Get live channels by category
- **11**: Get VOD movies by category
- **12**: Get series by category
- **13**: Get series info (seasons/episodes)
- **14**: Authenticate user

## Testing the Configuration

Test the configuration endpoint:
```bash
curl "http://chatti.tmaxhosting.com/PanelAndroid/API.php?methode=5"
```

Test authentication:
```bash
curl -X POST "http://chatti.tmaxhosting.com/PanelAndroid/API.php?methode=14" \
  -H "Content-Type: application/json" \
  -d '{"code":"username!!!password"}'
```

Test getting categories:
```bash
curl -X POST "http://chatti.tmaxhosting.com/PanelAndroid/API.php?methode=2" \
  -H "Content-Type: application/json" \
  -d '{"code":"username!!!password"}'
```

## Security Notes

1. Change the admin password in `config.php` from `panel` to something secure
2. The Xtream credentials format is: `username!!!password` (three exclamation marks)
3. Default test credentials: `1231231!!!1231231`
4. Real credentials should be provided by your Xtream panel provider

## File Structure

```
/var/www/html/PanelAndroid/
├── API.php              # Main API router
├── config.php           # Web configuration interface
├── db.json              # Configuration and static data
├── db_helper.php        # Database helper functions
├── xtream_helper.php    # Xtream API integration
├── .htaccess            # Apache configuration
├── 1                    # Login endpoint (method 1)
├── 2                    # Login endpoint (method 2)
└── media/               # Media files (images, videos)
```

## Troubleshooting

### Problem: API returns empty data
- Check that `xtream_url` is correct
- Verify Xtream panel is accessible: `curl http://flix-panel.xyz:80`
- Check credentials are valid

### Problem: Configuration not updating
- Check file permissions on `db.json`
- Verify Apache has write access to the directory

### Problem: App not connecting
- Verify `str8` points to the correct API server
- Check that all endpoints return 200 status
- Test login endpoint: `http://chatti.tmaxhosting.com/PanelAndroid/1`
