# App Login Guide

## How to Login to the App

The app authenticates users directly against your Xtream Codes panel at `http://flix-panel.xyz:80`.

### Code Formats Supported

The app accepts a "code" field which can be in multiple formats:

#### Format 1: Username!!!Password (Recommended)
```
username!!!password
```

**Example:**
- If Xtream username is `john123` and password is `mypass456`
- Enter in app: `john123!!!mypass456`

**Note:** Three exclamation marks `!!!` as separator

#### Format 2: Single Code (Username = Password)
```
username
```

**Example:**
- If Xtream username is `1231231` and password is `1231231` (same)
- Enter in app: `1231231`
- OR: `12312311231231` (repeated twice)

**Note:** Only works if username and password are identical

#### Format 3: Username Repeated
```
usernameusername
```

**Example:**
- If Xtream username is `test` and password is `test`
- Enter in app: `testtest`

**Note:** Only works if username and password are identical

---

## Testing Authentication

### Method 1: Test Page
Go to: `http://chatti.tmaxhosting.com/PanelAndroid/test_auth.php`

Enter your Xtream username and password to test if they work.

### Method 2: Direct API Test
```bash
curl -X POST "http://chatti.tmaxhosting.com/PanelAndroid/API.php?methode=login" \
  -H "Content-Type: application/json" \
  -d '{"android_id":"test","code":"USERNAME!!!PASSWORD","macE":"","macW":"0"}'
```

Replace `USERNAME` and `PASSWORD` with your actual credentials.

**Success Response:**
```json
{
  "id": "1",
  "username": "USERNAME",
  "status": "active",
  "account_expire_date": "Unlimited"
}
```

**Failure Response:**
```json
{
  "error": "Authentication failed"
}
```

---

## How It Works

```
1. App sends code to: http://chatti.tmaxhosting.com/PanelAndroid/API.php
2. API extracts username and password from code
3. API authenticates with: http://flix-panel.xyz:80/api/player/{username}/{password}
4. If Xtream panel accepts → Login success
5. If Xtream panel rejects → Login failed
```

---

## Troubleshooting

### "Code Incorrect" Error

**Possible Causes:**
1. Username/password don't exist in Xtream panel
2. Xtream panel is not accessible
3. Wrong format (missing `!!!` separator for different username/password)

**Solutions:**
1. Verify credentials work directly on Xtream panel:
   ```
   http://flix-panel.xyz:80/api/player/USERNAME/PASSWORD
   ```

2. Try different format:
   - With separator: `username!!!password`
   - Without separator: `username` (if same as password)

3. Check debug log:
   ```
   http://chatti.tmaxhosting.com/PanelAndroid/debug_log.txt
   ```

### App Shows Categories But Says "Invalid"

If you see categories loading but still get error message:
- The API is working correctly
- This might be a UI bug in the app
- The data endpoints are functioning properly

---

## Example Credentials

### Test User (Default)
- **Username:** `1231231`
- **Password:** `1231231`
- **Code format:** `1231231!!!1231231` or `1231231` or `12312311231231`

### Your Real Users
Replace with actual Xtream Codes credentials from your panel at `http://flix-panel.xyz:80`

**Format:**
```
{xtream_username}!!!{xtream_password}
```

---

## Adding New Users

You don't need to configure users in the API. Any valid Xtream Codes user from your panel will work automatically.

To create new users:
1. Go to your Xtream Codes panel admin interface
2. Create a new user/subscription
3. Use those credentials in the app with format: `username!!!password`

---

## Need Help?

- Test authentication: `http://chatti.tmaxhosting.com/PanelAndroid/test_auth.php`
- View debug logs: `http://chatti.tmaxhosting.com/PanelAndroid/debug_log.txt`
- Check configuration: `http://chatti.tmaxhosting.com/PanelAndroid/config.php` (password: `panel`)
