<?php
/**
 * Activation Code Handler
 * Validates activation codes and returns IPTV credentials
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'db_helper.php';

$rawData = file_get_contents('php://input');
$postData = json_decode($rawData, true);

// Get activation code from POST or GET
$activation_code = null;
if (isset($postData['activation_code'])) {
    $activation_code = $postData['activation_code'];
} elseif (isset($_GET['activation_code'])) {
    $activation_code = $_GET['activation_code'];
} elseif (isset($postData['code'])) {
    $activation_code = $postData['code'];
}

// Log request
$logFile = __DIR__ . '/debug_log.txt';
$debugInfo = array(
    'timestamp' => date('Y-m-d H:i:s'),
    'method' => $_SERVER['REQUEST_METHOD'],
    'url' => '/PanelAndroid/activate.php',
    'activation_code' => $activation_code,
    'post_data' => $postData
);
file_put_contents($logFile, json_encode($debugInfo, JSON_PRETTY_PRINT) . "\n---\n", FILE_APPEND);

// Accept any activation code (for testing)
if ($activation_code && strlen($activation_code) >= 4) {
    // Return valid response with IPTV credentials
    $response = array(
        'status' => 'success',
        'message' => 'Activation successful',
        'activation_code' => $activation_code,
        'user_info' => array(
            'username' => 'uCEp55f8w5',
            'password' => 'yJKj2rCAD3',
            'status' => 'Active',
            'exp_date' => '2099-12-31',
            'max_connections' => 1,
            'is_trial' => false
        ),
        'server_info' => array(
            'url' => 'flix-panel.xyz',
            'port' => '80',
            'https_port' => '2087',
            'server_protocol' => 'https'
        ),
        'app_config' => array(
            'api_url' => 'http://chatti.tmaxhosting.com/PanelAndroid/',
            'media_url' => 'http://15.204.231.210/PanelAndroid/media/',
            'xtream_url' => 'https://flix-panel.xyz:2087'
        )
    );

    echo json_encode($response);
} else {
    // Invalid or missing activation code
    $response = array(
        'status' => 'error',
        'message' => 'Invalid activation code',
        'activation_code' => $activation_code
    );

    http_response_code(400);
    echo json_encode($response);
}
