<?php
/**
 * ═══════════════════════════════════════════════════════════════════
 * PATCH: Add Methods 16 & 17 to Existing Panel
 * ═══════════════════════════════════════════════════════════════════
 * Copy these functions and cases to your existing API.php
 * ═══════════════════════════════════════════════════════════════════
 */

// ═══════════════════════════════════════════════════════════════════
// ADD THESE CASES TO YOUR SWITCH STATEMENT
// ═══════════════════════════════════════════════════════════════════

/*
switch ($methode) {
    // ... existing cases ...

    case '16':
    case 16:
        handleMethod16($pdo, $input);
        break;

    case '17':
    case 17:
        handleMethod17($pdo, $input);
        break;

    // ... rest of cases ...
}
*/

// ═══════════════════════════════════════════════════════════════════
// METHOD 16: User Session Verification (CRITICAL - Fixes expire error)
// ═══════════════════════════════════════════════════════════════════

function handleMethod16($pdo, $input) {
    /*
     * Request: {"str1":"999","str2":"0","str3":"","str4":"e11c464f560d1eba","str5":"","str6":""}
     * str1 = user_id
     * str4 = android_id
     *
     * Response: {"id":999}  // Valid user
     *           {"id":-1}   // Expired/Invalid user (causes "abonnement expire")
     */

    $user_id = $input['str1'] ?? '';
    $android_id = $input['str4'] ?? '';

    try {
        if (empty($user_id)) {
            echo json_encode(['id' => -1]);
            return;
        }

        // Check if user exists and is active
        $stmt = $pdo->prepare("
            SELECT id, status, expiry_date
            FROM users
            WHERE id = :user_id
            AND status = 'active'
            AND (expiry_date IS NULL OR expiry_date >= CURDATE())
        ");
        $stmt->execute(['user_id' => $user_id]);
        $user = $stmt->fetch();

        if ($user) {
            // Valid user
            echo json_encode(['id' => (int)$user['id']]);
        } else {
            // Expired or invalid user
            echo json_encode(['id' => -1]);
        }

    } catch (Exception $e) {
        // On error, return -1 to prevent access
        echo json_encode(['id' => -1]);
    }
}

// ═══════════════════════════════════════════════════════════════════
// METHOD 17: Network Telemetry (Optional - for statistics)
// ═══════════════════════════════════════════════════════════════════

function handleMethod17($pdo, $input) {
    /*
     * Request: {"str1":"10.0.2.15","str2":"Tunisie-Telecom","str3":"TN","str4":"3.58","str5":"999","str6":"2.6"}
     * str1 = IP address
     * str2 = Carrier/ISP
     * str3 = Country code
     * str4 = Latitude
     * str5 = User ID
     * str6 = App version
     *
     * Response: {"success":true}
     */

    $ip = $input['str1'] ?? '';
    $carrier = $input['str2'] ?? '';
    $country = $input['str3'] ?? '';
    $latitude = $input['str4'] ?? '';
    $user_id = $input['str5'] ?? '';
    $app_version = $input['str6'] ?? '';

    try {
        // Check if network_logs table exists
        $tableCheck = $pdo->query("SHOW TABLES LIKE 'network_logs'");

        if ($tableCheck->rowCount() > 0) {
            // Table exists, insert log
            $stmt = $pdo->prepare("
                INSERT INTO network_logs
                (user_id, ip_address, carrier, country, latitude, app_version, logged_at)
                VALUES
                (:user_id, :ip, :carrier, :country, :latitude, :app_version, NOW())
            ");

            $stmt->execute([
                'user_id' => $user_id,
                'ip' => $ip,
                'carrier' => $carrier,
                'country' => $country,
                'latitude' => $latitude,
                'app_version' => $app_version
            ]);
        }

        // Always return success (even if table doesn't exist)
        echo json_encode(['success' => true]);

    } catch (Exception $e) {
        // Return success anyway to prevent app errors
        echo json_encode(['success' => true]);
    }
}

// ═══════════════════════════════════════════════════════════════════
// INSTALLATION INSTRUCTIONS
// ═══════════════════════════════════════════════════════════════════

/*

STEP 1: Open your existing API.php
---------------------------------------

STEP 2: Add these cases to your switch statement
---------------------------------------
Find your switch($methode) block and add:

    case '16':
    case 16:
        handleMethod16($pdo, $input);
        break;

    case '17':
    case 17:
        handleMethod17($pdo, $input);
        break;


STEP 3: Add the functions
---------------------------------------
Copy the handleMethod16() and handleMethod17() functions above to the end of your API.php


STEP 4: Create network_logs table (Optional - for Method 17)
---------------------------------------
Run this SQL if you want to store telemetry:

CREATE TABLE IF NOT EXISTS network_logs (
    id BIGINT PRIMARY KEY AUTO_INCREMENT,
    user_id INT,
    ip_address VARCHAR(45),
    carrier VARCHAR(255),
    country VARCHAR(100),
    latitude VARCHAR(50),
    app_version VARCHAR(20),
    logged_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_user (user_id),
    INDEX idx_time (logged_at)
);


STEP 5: Test
---------------------------------------
Test Method 16:
curl -X POST http://your-server/PanelAndroid/API.php?methode=16 \
  -H "Content-Type: application/json" \
  -d '{"str1":"999","str2":"0","str3":"","str4":"test","str5":"","str6":""}'

Should return: {"id":999}

Test Method 17:
curl -X POST http://your-server/PanelAndroid/API.php?methode=17 \
  -H "Content-Type: application/json" \
  -d '{"str1":"10.0.2.15","str2":"Test-Carrier","str3":"TN","str4":"0","str5":"999","str6":"2.6"}'

Should return: {"success":true}


STEP 6: Test with DIDON App
---------------------------------------
- Open DIDON app
- Login with activation code
- Should NOT show "abonnement expire" error
- App should work normally

*/
