-- ═══════════════════════════════════════════════════════════════════
-- 🔥 DIDON PANEL - Add Sample Data (Prevents App Crashes)
-- ═══════════════════════════════════════════════════════════════════
-- Run this to add test data when database is empty
-- Fixes: "NumberFormatException: s == null" crash
-- ═══════════════════════════════════════════════════════════════════

USE didon_panel;

-- ═══════════════════════════════════════════════════════════════════
-- 1. Add Sample Categories (Bouquets)
-- ═══════════════════════════════════════════════════════════════════

INSERT IGNORE INTO categories (id, name, name_ar, type, display_order, is_active, created_at) VALUES
(1, 'Live TV', 'بث مباشر', 'live', 1, TRUE, NOW()),
(2, 'Movies', 'أفلام', 'vod', 2, TRUE, NOW()),
(3, 'Series', 'مسلسلات', 'series', 3, TRUE, NOW()),
(4, 'Sports', 'رياضة', 'live', 4, TRUE, NOW()),
(5, 'News', 'أخبار', 'live', 5, TRUE, NOW()),
(6, 'Kids', 'أطفال', 'live', 6, TRUE, NOW());

-- ═══════════════════════════════════════════════════════════════════
-- 2. Add Sample Channels
-- ═══════════════════════════════════════════════════════════════════

INSERT IGNORE INTO channels (id, name, name_ar, logo, stream_url, category_id, type, is_active, created_at) VALUES
-- Live TV
(1, 'Test Channel 1', 'قناة اختبار 1', 'http://via.placeholder.com/100x100.png?text=CH1',
 'http://example.com/stream1.m3u8', 1, 'live', TRUE, NOW()),
(2, 'Test Channel 2', 'قناة اختبار 2', 'http://via.placeholder.com/100x100.png?text=CH2',
 'http://example.com/stream2.m3u8', 1, 'live', TRUE, NOW()),

-- Sports
(3, 'Test Sports', 'رياضة اختبار', 'http://via.placeholder.com/100x100.png?text=Sport',
 'http://example.com/sports.m3u8', 4, 'live', TRUE, NOW()),

-- News
(4, 'Test News', 'أخبار اختبار', 'http://via.placeholder.com/100x100.png?text=News',
 'http://example.com/news.m3u8', 5, 'live', TRUE, NOW()),

-- Kids
(5, 'Test Kids', 'أطفال اختبار', 'http://via.placeholder.com/100x100.png?text=Kids',
 'http://example.com/kids.m3u8', 6, 'live', TRUE, NOW());

-- ═══════════════════════════════════════════════════════════════════
-- 3. Add Sample VOD Content (Movies/Series)
-- ═══════════════════════════════════════════════════════════════════

INSERT IGNORE INTO vod_content (stream_id, name, description, type, category_id, poster, backdrop,
                                  director, cast, genre, release_date, rating, duration,
                                  container_extension, is_active, created_at) VALUES
-- Movies
(1001, 'Test Movie 1', 'This is a test movie for demonstration purposes',
 'vod', 2,
 'http://via.placeholder.com/300x400.png?text=Movie1',
 'http://via.placeholder.com/1280x720.png?text=Backdrop',
 'Test Director', 'Actor 1, Actor 2, Actor 3',
 'Action, Adventure', '2024-01-01', '7.5', '120 min',
 'mp4', TRUE, NOW()),

(1002, 'Test Movie 2', 'Another test movie with different genre',
 'vod', 2,
 'http://via.placeholder.com/300x400.png?text=Movie2',
 'http://via.placeholder.com/1280x720.png?text=Backdrop2',
 'Another Director', 'Actor A, Actor B',
 'Comedy, Drama', '2024-02-01', '8.0', '135 min',
 'mp4', TRUE, NOW()),

(1003, 'Test Movie 3', 'Third test movie for variety',
 'vod', 2,
 'http://via.placeholder.com/300x400.png?text=Movie3',
 'http://via.placeholder.com/1280x720.png?text=Backdrop3',
 'Test Director 3', 'Star 1, Star 2, Star 3',
 'Thriller, Mystery', '2024-03-01', '7.8', '142 min',
 'mp4', TRUE, NOW()),

-- Series
(2001, 'Test Series 1', 'A test series with multiple episodes',
 'series', 3,
 'http://via.placeholder.com/300x400.png?text=Series1',
 'http://via.placeholder.com/1280x720.png?text=Series-BG',
 'Series Creator', 'Lead Actor, Supporting Actor',
 'Drama, Suspense', '2024-01-15', '8.5', '45 min/ep',
 'mp4', TRUE, NOW()),

(2002, 'Test Series 2', 'Another test series for testing',
 'series', 3,
 'http://via.placeholder.com/300x400.png?text=Series2',
 'http://via.placeholder.com/1280x720.png?text=Series-BG2',
 'Series Director', 'Main Star, Co-star',
 'Comedy, Family', '2024-02-01', '8.2', '30 min/ep',
 'mp4', TRUE, NOW());

-- ═══════════════════════════════════════════════════════════════════
-- 4. Verify Data
-- ═══════════════════════════════════════════════════════════════════

SELECT '✅ Sample data added successfully!' AS status;

SELECT 'Categories:' AS info;
SELECT id, name, type, is_active FROM categories ORDER BY display_order;

SELECT 'Channels:' AS info;
SELECT id, name, category_id, type FROM channels WHERE is_active = TRUE;

SELECT 'VOD Content:' AS info;
SELECT stream_id, name, type, rating FROM vod_content WHERE is_active = TRUE;

SELECT 'Summary:' AS info;
SELECT
    (SELECT COUNT(*) FROM categories WHERE is_active = TRUE) as categories_count,
    (SELECT COUNT(*) FROM channels WHERE is_active = TRUE) as channels_count,
    (SELECT COUNT(*) FROM vod_content WHERE is_active = TRUE) as vod_count;
