<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Refresh: 5'); // Auto-refresh every 5 seconds

// Get recent requests from debug log
$debugLog = @file_get_contents(__DIR__ . '/debug_log.txt');
$requests = [];
if ($debugLog) {
    $lines = explode('---', $debugLog);
    foreach (array_slice(array_reverse($lines), 0, 10) as $entry) {
        $json = json_decode($entry, true);
        if ($json && isset($json['get_methode'])) {
            $requests[] = [
                'time' => $json['timestamp'] ?? 'unknown',
                'method' => $json['get_methode'],
                'url' => $json['url'] ?? 'unknown'
            ];
        }
    }
}

// Get cache status
$cacheDir = __DIR__ . '/cache/';
$cacheFiles = @scandir($cacheDir);
$cacheCount = count($cacheFiles) - 2; // exclude . and ..

// Check image accessibility
$testImages = [
    'category' => '/PanelAndroid/media/Categories/movie-action.png',
    'radio' => '/PanelAndroid/media/Flag/1677841703tunisie.png',
    'main' => '/PanelAndroid/media/Main/1709569458f.jpg'
];

$imageStatus = [];
foreach ($testImages as $name => $path) {
    $fullPath = __DIR__ . '/../..' . $path;
    $imageStatus[$name] = file_exists($fullPath) ? 'exists' : 'missing';
}

// Get config
$config = json_decode(file_get_contents(__DIR__ . '/db.json'), true)['config'] ?? [];

$status = [
    'timestamp' => date('Y-m-d H:i:s'),
    'backend' => 'operational',
    'recent_requests' => $requests,
    'cache_files' => $cacheCount,
    'images' => $imageStatus,
    'config_paths' => [
        'str8' => $config['str8'] ?? 'N/A',
        'str9' => $config['str9'] ?? 'N/A',
        'str12' => $config['str12'] ?? 'N/A'
    ],
    'test_urls' => [
        'category' => $config['str8'] . ($config['str12'] ?? '') . ($config['str9'] ?? '') . '/movie-action.png',
        'radio' => $config['str8'] . ($config['str12'] ?? '') . '/Flag/1677841703tunisie.png'
    ]
];

echo json_encode($status, JSON_PRETTY_PRINT);
?>
