<?php
header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <title>مسح Cache</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #333;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .info {
            background: #d1ecf1;
            color: #0c5460;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .warning {
            background: #fff3cd;
            color: #856404;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        button {
            background: #007bff;
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background: #0056b3;
        }
        .test-box {
            background: #f8f9fa;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin: 10px 0;
        }
        code {
            background: #272822;
            color: #f8f8f2;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 مسح Cache وحل مشكلة الخطأ 500</h1>
        
        <div class="warning">
            <h3>المشكلة:</h3>
            <p>التطبيق عالق في صفحة التفعيل بسبب خطأ 500 في <code>methode=5</code></p>
            <p>السبب: Cloudflare يحتفظ بنسخة قديمة من الملفات (Cache)</p>
        </div>

        <div class="info">
            <h3>📋 خطوات الحل:</h3>
            <ol>
                <li><strong>مسح Cache من Cloudflare:</strong>
                    <ul>
                        <li>سجل الدخول إلى: <a href="https://dash.cloudflare.com" target="_blank">Cloudflare Dashboard</a></li>
                        <li>اختر domain: <code>chatti.tmaxhosting.com</code></li>
                        <li>اذهب إلى: <strong>Caching</strong> → <strong>Purge Cache</strong></li>
                        <li>اضغط: <strong>Purge Everything</strong></li>
                        <li>انتظر 30 ثانية</li>
                    </ul>
                </li>
                <li><strong>أو أضف قواعد لتجاوز Cache للـ API:</strong>
                    <ul>
                        <li>Page Rules → Create Page Rule</li>
                        <li>URL: <code>*chatti.tmaxhosting.com/PanelAndroid/API.php*</code></li>
                        <li>Setting: <strong>Cache Level</strong> → <strong>Bypass</strong></li>
                        <li>Save</li>
                    </ul>
                </li>
            </ol>
        </div>

        <h3>🧪 اختبار الـ API بعد مسح Cache:</h3>
        
        <div class="test-box">
            <h4>Test 1: Method 5 (Config)</h4>
            <button onclick="testMethod5()">اختبار Method 5</button>
            <pre id="result5" style="margin-top:10px; padding:10px; background:#272822; color:#f8f8f2; border-radius:5px; max-height:200px; overflow:auto;"></pre>
        </div>

        <div class="test-box">
            <h4>Test 2: Login Endpoint</h4>
            <button onclick="testLogin()">اختبار Login</button>
            <pre id="resultLogin" style="margin-top:10px; padding:10px; background:#272822; color:#f8f8f2; border-radius:5px; max-height:200px; overflow:auto;"></pre>
        </div>

        <div class="test-box">
            <h4>Test 3: Method 2 (Categories)</h4>
            <button onclick="testMethod2()">اختبار Method 2</button>
            <pre id="result2" style="margin-top:10px; padding:10px; background:#272822; color:#f8f8f2; border-radius:5px; max-height:200px; overflow:auto;"></pre>
        </div>

        <div class="success" id="successMsg" style="display:none;">
            <h3>✅ كل شيء يعمل!</h3>
            <p>يمكنك الآن استخدام التطبيق مع الكود:</p>
            <ul>
                <li><code>1231231</code> (المستخدم الافتراضي)</li>
                <li><code>mohamed!!!secret123</code> (مستخدم mohamed)</li>
            </ul>
        </div>
    </div>

    <script>
        function testMethod5() {
            const result = document.getElementById('result5');
            result.textContent = 'جاري الاختبار...';
            
            fetch('/PanelAndroid/API.php?methode=5', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({str1: '', str2: ''})
            })
            .then(r => r.json())
            .then(data => {
                result.textContent = JSON.stringify(data, null, 2);
                checkSuccess();
            })
            .catch(e => {
                result.textContent = 'خطأ: ' + e.message;
            });
        }

        function testLogin() {
            const result = document.getElementById('resultLogin');
            result.textContent = 'جاري الاختبار...';
            
            fetch('/PanelAndroid/1', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({
                    android_id: 'test',
                    code: '1231231',
                    macE: '',
                    macW: '0'
                })
            })
            .then(r => r.json())
            .then(data => {
                result.textContent = JSON.stringify(data, null, 2);
                checkSuccess();
            })
            .catch(e => {
                result.textContent = 'خطأ: ' + e.message;
            });
        }

        function testMethod2() {
            const result = document.getElementById('result2');
            result.textContent = 'جاري الاختبار...';
            
            fetch('/PanelAndroid/API.php?methode=2', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({
                    android_id: 'test',
                    code: '1231231',
                    macE: '',
                    macW: '0'
                })
            })
            .then(r => r.json())
            .then(data => {
                result.textContent = JSON.stringify(data, null, 2).substring(0, 500) + '...';
                checkSuccess();
            })
            .catch(e => {
                result.textContent = 'خطأ: ' + e.message;
            });
        }

        function checkSuccess() {
            // If all tests pass, show success message
            setTimeout(() => {
                const r5 = document.getElementById('result5').textContent;
                const rL = document.getElementById('resultLogin').textContent;
                const r2 = document.getElementById('result2').textContent;
                
                if (r5.includes('str0') && (rL.includes('username') || rL.includes('error')) && r2.includes('bou')) {
                    document.getElementById('successMsg').style.display = 'block';
                }
            }, 1000);
        }
    </script>
</body>
</html>
