<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إصلاح مشكلة Cloudflare Cache</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 900px;
            margin: 30px auto;
            padding: 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #333;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 50px rgba(0,0,0,0.3);
        }
        h1 {
            color: #e74c3c;
            text-align: center;
            margin-bottom: 10px;
        }
        .problem {
            background: #f8d7da;
            border: 2px solid #f5c6cb;
            color: #721c24;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .solution {
            background: #d4edda;
            border: 2px solid #c3e6cb;
            color: #155724;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .warning {
            background: #fff3cd;
            border: 2px solid #ffeeba;
            color: #856404;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        ol, ul {
            line-height: 2;
        }
        code {
            background: #272822;
            color: #66d9ef;
            padding: 3px 8px;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
            direction: ltr;
            display: inline-block;
        }
        .step {
            background: #f8f9fa;
            padding: 15px;
            margin: 15px 0;
            border-right: 5px solid #667eea;
            border-radius: 5px;
        }
        .btn {
            display: inline-block;
            background: #667eea;
            color: white;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 8px;
            margin: 10px 5px;
            transition: background 0.3s;
        }
        .btn:hover {
            background: #5568d3;
        }
        .critical {
            font-size: 1.2em;
            font-weight: bold;
            color: #e74c3c;
            text-align: center;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚨 مشكلة: التطبيق عالق في Loading</h1>

        <div class="problem">
            <h2>❌ المشكلة:</h2>
            <p><strong>الخطأ:</strong></p>
            <code>POST /PanelAndroid/API.php?methode=5 → 500 Internal Server Error</code>
            <p style="margin-top: 15px;"><strong>السبب:</strong></p>
            <p>Cloudflare يحتفظ بنسخة قديمة من ملف <code>API.php</code> (Cache)</p>
            <p>التطبيق يستدعي <code>methode=5</code> للحصول على الإعدادات، لكن يحصل على النسخة القديمة التي تعطي خطأ 500!</p>
        </div>

        <div class="critical">
            ⚠️ يجب مسح Cache من Cloudflare فوراً! ⚠️
        </div>

        <div class="solution">
            <h2>✅ الحل الوحيد الفعال:</h2>

            <div class="step">
                <h3>الطريقة 1: مسح Cache من Cloudflare (الأسرع) ⚡</h3>
                <ol>
                    <li>سجل الدخول إلى: <a href="https://dash.cloudflare.com" target="_blank" class="btn">Cloudflare Dashboard</a></li>
                    <li>اختر الموقع: <code>tmaxhosting.com</code> أو <code>chatti.tmaxhosting.com</code></li>
                    <li>من القائمة الجانبية: <strong>Caching</strong></li>
                    <li>ثم: <strong>Configuration</strong></li>
                    <li>اضغط على: <strong>Purge Everything</strong> (مسح كل شيء)</li>
                    <li>أكد العملية</li>
                    <li><strong>انتظر 60 ثانية</strong></li>
                    <li>جرب التطبيق مرة أخرى!</li>
                </ol>
            </div>

            <div class="step">
                <h3>الطريقة 2: مسح Cache لملف محدد (أفضل)</h3>
                <ol>
                    <li>في Cloudflare Dashboard → <strong>Caching</strong></li>
                    <li>اختر: <strong>Purge Cache</strong> → <strong>Custom Purge</strong></li>
                    <li>أدخل هذا الرابط:</li>
                    <code>http://chatti.tmaxhosting.com/PanelAndroid/API.php</code>
                    <li>اضغط <strong>Purge</strong></li>
                    <li>انتظر 30 ثانية</li>
                    <li>جرب التطبيق!</li>
                </ol>
            </div>

            <div class="step">
                <h3>الطريقة 3: تعطيل Cloudflare مؤقتاً</h3>
                <ol>
                    <li>في Cloudflare Dashboard</li>
                    <li>اختر الموقع: <code>tmaxhosting.com</code></li>
                    <li>من الأعلى: اضغط على <strong>SSL/TLS</strong></li>
                    <li>أو في الإعدادات العامة: غيّر من <strong>Proxied</strong> (سحابة برتقالية) إلى <strong>DNS Only</strong> (سحابة رمادية)</li>
                    <li>انتظر 5 دقائق للتطبيق</li>
                    <li>جرب التطبيق - يجب أن يعمل!</li>
                    <li>بعدها يمكنك تفعيل Cloudflare مرة أخرى</li>
                </ol>
            </div>
        </div>

        <div class="warning">
            <h2>📝 بعد مسح الـ Cache:</h2>
            <ol>
                <li>في التطبيق، امسح Cache:
                    <ul>
                        <li>إعدادات Android → التطبيقات → Didon</li>
                        <li>التخزين → Clear Cache + Clear Data</li>
                    </ul>
                </li>
                <li>أعد فتح التطبيق</li>
                <li>أدخل أي كود: <code>test</code> أو <code>1231231</code></li>
                <li>يجب أن يعمل! ✅</li>
            </ol>
        </div>

        <div style="background: #e8f5e9; padding: 20px; border-radius: 10px; margin: 20px 0;">
            <h2>🔍 التحقق من حل المشكلة:</h2>
            <p>بعد مسح Cache، اختبر هذا الرابط في المتصفح:</p>
            <p><a href="http://chatti.tmaxhosting.com/PanelAndroid/API.php?methode=5&test=1" target="_blank" class="btn">اختبار API</a></p>
            <p>يجب أن يظهر JSON مثل:</p>
            <code>{"str0":"API.php?methode=","str1":"http://chatti.tmaxhosting.com",...}</code>
            <p style="margin-top: 10px;">إذا ظهر <code>error code: 500</code> → الـ Cache لم يُمسح بعد، انتظر أكثر!</p>
        </div>

        <div style="background: #f3e5f5; padding: 20px; border-radius: 10px; margin: 20px 0; border: 2px solid #9c27b0;">
            <h2>💡 لماذا حدثت هذه المشكلة؟</h2>
            <p>الملفات على الخادم <strong>محدثة وصحيحة</strong> ✅</p>
            <p>لكن Cloudflare يحتفظ بنسخة من الملفات لتسريع الموقع (Caching)</p>
            <p>عندما نحدّث الملفات، Cloudflare لا يعرف أنها تغيرت، فيعطي التطبيق النسخة القديمة!</p>
            <p><strong>الحل:</strong> مسح الـ Cache لإجبار Cloudflare على جلب الملفات الجديدة</p>
        </div>

        <div class="critical">
            👉 الخطوة الأهم: مسح Cache من Cloudflare Dashboard الآن! 👈
        </div>

        <p style="text-align: center; margin-top: 30px; color: #666;">
            بعد مسح الـ Cache، التطبيق سيعمل بشكل كامل مع جميع الوظائف! 🎉
        </p>
    </div>
</body>
</html>
