<?php
/**
 * Configuration Management Interface
 * Allows viewing and editing the Xtream URL and other settings
 */

require_once 'db_helper.php';

// Simple authentication
$admin_password = 'panel'; // Change this to a secure password
$authenticated = false;

if (isset($_POST['password'])) {
    if ($_POST['password'] === $admin_password) {
        $authenticated = true;
        $_SESSION['authenticated'] = true;
    }
}

if (isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true) {
    $authenticated = true;
}

// Handle configuration update
if ($authenticated && isset($_POST['update_config'])) {
    $config = DB::getConfig();

    if (isset($_POST['str8'])) {
        $config['str8'] = trim($_POST['str8']);
    }
    if (isset($_POST['str4'])) {
        $config['str4'] = trim($_POST['str4']);
    }
    if (isset($_POST['str5'])) {
        $config['str5'] = trim($_POST['str5']);
    }
    if (isset($_POST['str1'])) {
        $config['str1'] = trim($_POST['str1']);
    }
    if (isset($_POST['str3'])) {
        $config['str3'] = trim($_POST['str3']);
    }
    if (isset($_POST['xtream_url'])) {
        $config['xtream_url'] = trim($_POST['xtream_url']);
    }

    // Save to db.json
    $dbFile = __DIR__ . '/db.json';
    $dbData = json_decode(file_get_contents($dbFile), true);
    $dbData['config'] = $config;
    file_put_contents($dbFile, json_encode($dbData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));

    $success_message = "Configuration updated successfully!";
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: config.php");
    exit;
}

$config = DB::getConfig();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel Configuration</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            padding: 40px;
            max-width: 600px;
            width: 100%;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }
        .form-group {
            margin-bottom: 25px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 6px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        input[type="text"]:focus,
        input[type="password"]:focus {
            outline: none;
            border-color: #667eea;
        }
        .help-text {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        button {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 6px;
            font-size: 16px;
            cursor: pointer;
            transition: transform 0.2s;
            width: 100%;
        }
        button:hover {
            transform: translateY(-2px);
        }
        .success {
            background: #10b981;
            color: white;
            padding: 15px;
            border-radius: 6px;
            margin-bottom: 20px;
        }
        .config-display {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 6px;
            padding: 15px;
            margin-top: 10px;
        }
        .config-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        .config-item:last-child {
            border-bottom: none;
        }
        .config-label {
            font-weight: 600;
            color: #374151;
        }
        .config-value {
            color: #6b7280;
            font-family: 'Courier New', monospace;
            font-size: 13px;
        }
        .logout-link {
            display: inline-block;
            margin-top: 20px;
            color: #667eea;
            text-decoration: none;
            font-size: 14px;
        }
        .logout-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if (!$authenticated): ?>
            <h1>Panel Configuration</h1>
            <p class="subtitle">Enter password to access configuration</p>
            <form method="POST">
                <div class="form-group">
                    <label>Admin Password</label>
                    <input type="password" name="password" required>
                </div>
                <button type="submit">Login</button>
            </form>
        <?php else: ?>
            <h1>Panel Configuration</h1>
            <p class="subtitle">Manage your Xtream Codes integration settings</p>

            <?php if (isset($success_message)): ?>
                <div class="success"><?php echo $success_message; ?></div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-group">
                    <label>⚠️ API Server URL (str1) - USED BY APP!</label>
                    <input type="text" name="str1" value="<?php echo htmlspecialchars($config['str1']); ?>" placeholder="http://chatti.tmaxhosting.com">
                    <div class="help-text"><strong>IMPORTANT:</strong> This is where your API proxy is hosted. App constructs URLs as: str1 + str2 + "API.php"</div>
                </div>

                <div class="form-group">
                    <label>Base URL (str8) - Backup</label>
                    <input type="text" name="str8" value="<?php echo htmlspecialchars($config['str8']); ?>" placeholder="http://chatti.tmaxhosting.com">
                    <div class="help-text">Should match str1 (kept for compatibility)</div>
                </div>

                <div class="form-group">
                    <label>Host Xtream (str4)</label>
                    <input type="text" name="str4" value="<?php echo htmlspecialchars($config['str4']); ?>" placeholder="flix-panel.xyz">
                    <div class="help-text">Xtream Codes panel hostname (without http:// or port)</div>
                </div>

                <div class="form-group">
                    <label>Port Xtream (str5)</label>
                    <input type="text" name="str5" value="<?php echo htmlspecialchars($config['str5']); ?>" placeholder="80">
                    <div class="help-text">Xtream Codes panel port number</div>
                </div>

                <div class="form-group">
                    <label>XMLTV URL (str3)</label>
                    <input type="text" name="str3" value="<?php echo htmlspecialchars($config['str3']); ?>" placeholder="http://flix-panel.xyz:80/xmltv.php?username=!1!&password=!2!">
                    <div class="help-text">XMLTV EPG URL with placeholders !1! (username) and !2! (password)</div>
                </div>

                <div class="form-group">
                    <label>Xtream URL (Internal)</label>
                    <input type="text" name="xtream_url" value="<?php echo htmlspecialchars($config['xtream_url']); ?>" placeholder="http://flix-panel.xyz:80">
                    <div class="help-text">Internal Xtream URL used by API backend</div>
                </div>

                <button type="submit" name="update_config">Update Configuration</button>
            </form>

            <h3 style="margin-top: 40px; margin-bottom: 15px; color: #333;">Current Configuration</h3>
            <div class="config-display">
                <div class="config-item">
                    <span class="config-label">Base URL (str8):</span>
                    <span class="config-value"><?php echo htmlspecialchars($config['str8']); ?></span>
                </div>
                <div class="config-item">
                    <span class="config-label">Host Xtream (str4):</span>
                    <span class="config-value"><?php echo htmlspecialchars($config['str4']); ?></span>
                </div>
                <div class="config-item">
                    <span class="config-label">Port Xtream (str5):</span>
                    <span class="config-value"><?php echo htmlspecialchars($config['str5']); ?></span>
                </div>
                <div class="config-item">
                    <span class="config-label">Xtream URL (str1):</span>
                    <span class="config-value"><?php echo htmlspecialchars($config['str1']); ?></span>
                </div>
                <div class="config-item">
                    <span class="config-label">XMLTV URL (str3):</span>
                    <span class="config-value"><?php echo htmlspecialchars($config['str3']); ?></span>
                </div>
                <div class="config-item">
                    <span class="config-label">API Path (str2):</span>
                    <span class="config-value"><?php echo htmlspecialchars($config['str2']); ?></span>
                </div>
                <div class="config-item">
                    <span class="config-label">API Endpoint:</span>
                    <span class="config-value"><?php echo htmlspecialchars($config['str8'] . $config['str2'] . 'API.php'); ?></span>
                </div>
                <div class="config-item">
                    <span class="config-label">Internal Xtream URL:</span>
                    <span class="config-value"><?php echo htmlspecialchars($config['xtream_url']); ?></span>
                </div>
            </div>

            <a href="?logout" class="logout-link">Logout</a>
        <?php endif; ?>
    </div>
</body>
</html>
