<?php
/**
 * Helper pour gérer la base de données JSON
 */

class DB {
    private static $db_file = __DIR__ . '/db.json';
    private static $cache = null; // In-memory cache

    public static function read() {
        // Return cached data if available
        if (self::$cache !== null) {
            return self::$cache;
        }

        if (!file_exists(self::$db_file)) {
            return [];
        }
        $data = file_get_contents(self::$db_file);
        self::$cache = json_decode($data, true);
        return self::$cache;
    }

    public static function write($data) {
        self::$cache = null; // Invalidate cache
        file_put_contents(self::$db_file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }

    public static function getConfig() {
        $db = self::read();
        return $db['config'] ?? [];
    }

    public static function updateConfig($config) {
        $db = self::read();
        $db['config'] = array_merge($db['config'] ?? [], $config);
        self::write($db);
    }

    public static function getRadios() {
        $db = self::read();
        return $db['rad'] ?? [];
    }

    public static function getBouquets() {
        $db = self::read();
        return $db['bou'] ?? [];
    }

    public static function getCategories() {
        $db = self::read();
        return $db['cat'] ?? [];
    }

    public static function getIntro() {
        $db = self::read();
        return $db['intro'] ?? [];
    }

    public static function getMain() {
        $db = self::read();
        return $db['main'] ?? [];
    }

    public static function getAppInfo() {
        $db = self::read();
        return $db['app_info'] ?? [];
    }

    public static function updateAppInfo($info) {
        $db = self::read();
        $db['app_info'] = array_merge($db['app_info'] ?? [], $info);
        self::write($db);
    }

    public static function getUsers() {
        $db = self::read();
        return $db['users'] ?? [];
    }

    public static function addBouquet($name, $path) {
        $db = self::read();
        if (!isset($db['bou'])) $db['bou'] = [];
        $db['bou'][] = ['name' => $name, 'path' => $path];
        self::write($db);
    }

    public static function updateBouquet($index, $name, $path) {
        $db = self::read();
        if (isset($db['bou'][$index])) {
            $db['bou'][$index] = ['name' => $name, 'path' => $path];
            self::write($db);
        }
    }

    public static function deleteBouquet($index) {
        $db = self::read();
        if (isset($db['bou'][$index])) {
            array_splice($db['bou'], $index, 1);
            self::write($db);
        }
    }

    public static function addCategory($name, $path) {
        $db = self::read();
        if (!isset($db['cat'])) $db['cat'] = [];
        $db['cat'][] = ['name' => $name, 'path' => $path];
        self::write($db);
    }

    public static function addRadio($name, $path) {
        $db = self::read();
        if (!isset($db['rad'])) $db['rad'] = [];
        $db['rad'][] = ['name' => $name, 'path' => $path];
        self::write($db);
    }
}
?>
