<?php
/**
 * Configuration de la base de données SQLite
 * Ce script crée toutes les tables nécessaires pour le panel DIDON
 */

$db_file = __DIR__ . '/didon.db';

try {
    $db = new PDO('sqlite:' . $db_file);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Table pour les configurations serveur (str0-str13)
    $db->exec("CREATE TABLE IF NOT EXISTS config (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        str0 TEXT DEFAULT 'API.php?methode=',
        str1 TEXT DEFAULT 'http://pro.netmos.ovh:6051',
        str2 TEXT DEFAULT '/user/',
        str3 TEXT DEFAULT 'http://pro.netmos.ovh:7355/xmltv.php?username=!1!&password=!2!',
        str4 TEXT DEFAULT 'http://pro.netmos.ovh',
        str5 TEXT DEFAULT '7355',
        str6 TEXT DEFAULT '',
        str7 TEXT DEFAULT '/PanelAndroid/API.php?methode=',
        str8 TEXT DEFAULT 'http://chatti.tmaxhosting.com',
        str9 TEXT DEFAULT '/Flag',
        str10 TEXT DEFAULT '/Intro',
        str11 TEXT DEFAULT '/Main',
        str12 TEXT DEFAULT '/PanelAndroid/media',
        str13 TEXT DEFAULT ':80'
    )");

    // Table pour les radios
    $db->exec("CREATE TABLE IF NOT EXISTS radios (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        path TEXT NOT NULL
    )");

    // Table pour les bouquets
    $db->exec("CREATE TABLE IF NOT EXISTS bouquets (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        path TEXT NOT NULL,
        pin_protected INTEGER DEFAULT 0
    )");

    // Table pour les catégories
    $db->exec("CREATE TABLE IF NOT EXISTS categories (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        path TEXT NOT NULL
    )");

    // Table pour l'intro
    $db->exec("CREATE TABLE IF NOT EXISTS intro (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        path TEXT NOT NULL
    )");

    // Table pour le main menu
    $db->exec("CREATE TABLE IF NOT EXISTS main_menu (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        name TEXT NOT NULL,
        path TEXT NOT NULL
    )");

    // Table pour les utilisateurs
    $db->exec("CREATE TABLE IF NOT EXISTS users (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        username TEXT NOT NULL UNIQUE,
        password TEXT NOT NULL,
        role TEXT DEFAULT 'user'
    )");

    // Table pour les informations de l'application
    $db->exec("CREATE TABLE IF NOT EXISTS app_info (
        id INTEGER PRIMARY KEY DEFAULT 1,
        version TEXT DEFAULT '2.6',
        version_code TEXT DEFAULT '19',
        app_name TEXT DEFAULT 'DIDON',
        message TEXT DEFAULT 'message test',
        CHECK (id = 1)
    )");

    // Insérer la configuration par défaut si elle n'existe pas
    $count = $db->query("SELECT COUNT(*) FROM config")->fetchColumn();
    if ($count == 0) {
        $db->exec("INSERT INTO config (id) VALUES (1)");
    }

    // Insérer les infos app par défaut si elles n'existent pas
    $count = $db->query("SELECT COUNT(*) FROM app_info")->fetchColumn();
    if ($count == 0) {
        $db->exec("INSERT INTO app_info (id) VALUES (1)");
    }

    // Insérer l'utilisateur admin par défaut
    $count = $db->query("SELECT COUNT(*) FROM users WHERE username='admin'")->fetchColumn();
    if ($count == 0) {
        $db->exec("INSERT INTO users (username, password, role) VALUES ('admin', 'admin', 'admin')");
        $db->exec("INSERT INTO users (username, password, role) VALUES ('mohamed9696', 'panel', 'user')");
    }

    echo "✅ Base de données créée avec succès!\n";
    echo "📁 Fichier: " . $db_file . "\n";

} catch (PDOException $e) {
    echo "❌ Erreur: " . $e->getMessage() . "\n";
    exit(1);
}
?>
