<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Capture everything
$method = $_SERVER['REQUEST_METHOD'];
$uri = $_SERVER['REQUEST_URI'];
$headers = getallheaders();
$rawBody = file_get_contents('php://input');
$getParams = $_GET;
$postParams = $_POST;
$jsonBody = json_decode($rawBody, true);

$debug = array(
    'timestamp' => date('Y-m-d H:i:s'),
    'method' => $method,
    'uri' => $uri,
    'headers' => $headers,
    'GET' => $getParams,
    'POST' => $postParams,
    'raw_body' => $rawBody,
    'json_body' => $jsonBody,
    'server_info' => array(
        'PHP_SELF' => $_SERVER['PHP_SELF'],
        'SCRIPT_NAME' => $_SERVER['SCRIPT_NAME'],
        'REQUEST_URI' => $_SERVER['REQUEST_URI'],
        'QUERY_STRING' => $_SERVER['QUERY_STRING']
    )
);

// Save to log
$logFile = __DIR__ . '/full_debug.log';
file_put_contents($logFile, json_encode($debug, JSON_PRETTY_PRINT) . "\n\n==========\n\n", FILE_APPEND);

// Return helpful response
echo json_encode(array(
    'message' => 'Debug endpoint - request logged',
    'received' => $debug,
    'hint' => 'Check /PanelAndroid/full_debug.log for details'
), JSON_PRETTY_PRINT);
