<?php
/**
 * Debug Login Requests
 */

header('Content-Type: application/json; charset=UTF-8');

// Log everything
$debug = array();
$debug['timestamp'] = date('Y-m-d H:i:s');
$debug['request_method'] = $_SERVER['REQUEST_METHOD'];
$debug['request_uri'] = $_SERVER['REQUEST_URI'];
$debug['query_string'] = $_SERVER['QUERY_STRING'];

// Get POST data
$rawData = file_get_contents('php://input');
$debug['raw_post_data'] = $rawData;

$postData = json_decode($rawData, true);
$debug['parsed_json'] = $postData;

// Get GET params
$debug['get_params'] = $_GET;

// Headers
$debug['headers'] = array();
foreach (getallheaders() as $name => $value) {
    $debug['headers'][$name] = $value;
}

// Check if login request
if (isset($postData['code'])) {
    $debug['detected_type'] = 'login_request';
    $debug['code'] = $postData['code'];

    if (strpos($postData['code'], '!!!') !== false) {
        list($user, $pass) = explode('!!!', $postData['code'], 2);
        $debug['parsed_username'] = $user;
        $debug['parsed_password'] = $pass;
    }
}

// Save to file
file_put_contents('/tmp/panel_debug.log', json_encode($debug, JSON_PRETTY_PRINT) . "\n\n", FILE_APPEND);

echo json_encode($debug, JSON_PRETTY_PRINT);
?>
