<?php
/**
 * Comprehensive Diagnostic Page
 * Tests all API endpoints and shows cache status
 */
header('Content-Type: text/html; charset=UTF-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

$test_code = isset($_GET['code']) ? $_GET['code'] : '1231231';
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🔍 فحص شامل - IPTV Panel Diagnostic</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            min-height: 100vh;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            padding: 30px;
        }
        h1 {
            color: #667eea;
            text-align: center;
            margin-bottom: 10px;
            font-size: 2em;
        }
        .subtitle {
            text-align: center;
            color: #666;
            margin-bottom: 30px;
            font-size: 1.1em;
        }
        .status-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .test-card {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            border-left: 5px solid #ddd;
            transition: all 0.3s;
        }
        .test-card.loading {
            border-left-color: #ffc107;
            background: #fff9e6;
        }
        .test-card.success {
            border-left-color: #28a745;
            background: #e8f5e9;
        }
        .test-card.error {
            border-left-color: #dc3545;
            background: #ffe6e6;
        }
        .test-card h3 {
            color: #333;
            margin-bottom: 10px;
            font-size: 1.1em;
        }
        .test-result {
            background: #272822;
            color: #f8f8f2;
            padding: 15px;
            border-radius: 5px;
            font-family: 'Courier New', monospace;
            font-size: 0.85em;
            max-height: 200px;
            overflow-y: auto;
            white-space: pre-wrap;
            word-break: break-all;
            margin-top: 10px;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            font-weight: bold;
            font-size: 0.9em;
            margin-top: 10px;
        }
        .badge-success {
            background: #28a745;
            color: white;
        }
        .badge-error {
            background: #dc3545;
            color: white;
        }
        .badge-loading {
            background: #ffc107;
            color: #333;
        }
        .cache-warning {
            background: #fff3cd;
            border: 2px solid #ffc107;
            color: #856404;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            text-align: center;
        }
        .cache-warning h2 {
            color: #e74c3c;
            margin-bottom: 15px;
        }
        .success-message {
            background: #d4edda;
            border: 2px solid #28a745;
            color: #155724;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            text-align: center;
            display: none;
        }
        .btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1em;
            margin: 5px;
            transition: background 0.3s;
        }
        .btn:hover {
            background: #5568d3;
        }
        .btn-success {
            background: #28a745;
        }
        .btn-success:hover {
            background: #218838;
        }
        .controls {
            text-align: center;
            margin: 30px 0;
        }
        .info-box {
            background: #e7f3ff;
            border: 2px solid #2196F3;
            color: #0d47a1;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .info-box h3 {
            color: #1976d2;
            margin-bottom: 10px;
        }
        .summary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin: 30px 0;
            text-align: center;
        }
        .summary h2 {
            margin-bottom: 15px;
            font-size: 1.8em;
        }
        .summary-stats {
            display: flex;
            justify-content: space-around;
            margin-top: 20px;
            flex-wrap: wrap;
        }
        .stat {
            text-align: center;
            padding: 15px;
        }
        .stat-number {
            font-size: 2.5em;
            font-weight: bold;
            display: block;
        }
        .stat-label {
            font-size: 1em;
            opacity: 0.9;
        }
        code {
            background: #272822;
            color: #66d9ef;
            padding: 3px 8px;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
        }
        .loading-spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 1s linear infinite;
            display: inline-block;
            margin-left: 10px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 فحص شامل لنظام IPTV</h1>
        <p class="subtitle">تشخيص كامل لجميع endpoints ومراقبة حالة Cache</p>

        <div class="controls">
            <button class="btn btn-success" onclick="runAllTests()">
                ▶️ تشغيل الفحص الشامل
            </button>
            <button class="btn" onclick="location.reload()">
                🔄 تحديث الصفحة
            </button>
        </div>

        <div id="summary" class="summary" style="display: none;">
            <h2>📊 ملخص النتائج</h2>
            <div class="summary-stats">
                <div class="stat">
                    <span id="total-tests" class="stat-number">0</span>
                    <span class="stat-label">إجمالي الاختبارات</span>
                </div>
                <div class="stat">
                    <span id="passed-tests" class="stat-number">0</span>
                    <span class="stat-label">ناجح ✅</span>
                </div>
                <div class="stat">
                    <span id="failed-tests" class="stat-number">0</span>
                    <span class="stat-label">فاشل ❌</span>
                </div>
            </div>
        </div>

        <div id="cache-warning" class="cache-warning" style="display: none;">
            <h2>⚠️ تحذير: مشكلة في Cache!</h2>
            <p>بعض الاختبارات فشلت. السبب المحتمل: <strong>Cloudflare Cache</strong></p>
            <p style="margin-top: 15px; font-size: 1.2em;">
                يجب مسح Cache من Cloudflare Dashboard:
            </p>
            <ol style="text-align: right; margin: 15px auto; display: inline-block;">
                <li>اذهب إلى: <a href="https://dash.cloudflare.com" target="_blank" style="color: #0056b3;">Cloudflare Dashboard</a></li>
                <li>اختر domain: <code>tmaxhosting.com</code></li>
                <li>Caching → Purge Everything</li>
                <li>انتظر 60 ثانية وأعد الاختبار</li>
            </ol>
        </div>

        <div id="success-message" class="success-message">
            <h2>✅ كل شيء يعمل بشكل مثالي!</h2>
            <p style="font-size: 1.2em; margin-top: 15px;">
                جميع endpoints تعمل بنجاح. يمكنك الآن استخدام التطبيق!
            </p>
            <div style="margin-top: 20px;">
                <p><strong>رموز التفعيل الصالحة:</strong></p>
                <ul style="list-style: none; margin-top: 10px;">
                    <li><code>1231231</code> - الكود الافتراضي</li>
                    <li><code>test</code> - كود الاختبار</li>
                    <li><code>username!!!password</code> - أي username وpassword</li>
                </ul>
            </div>
        </div>

        <div class="info-box">
            <h3>ℹ️ معلومات الاختبار</h3>
            <p><strong>الكود المستخدم:</strong> <code><?php echo htmlspecialchars($test_code); ?></code></p>
            <p><strong>الوقت:</strong> <span id="test-time"><?php echo date('Y-m-d H:i:s'); ?></span></p>
            <p><strong>عدد الاختبارات:</strong> 6 endpoints</p>
        </div>

        <div class="status-grid" id="tests-grid">
            <div class="test-card" id="test-config">
                <h3>1️⃣ Config (methode=5)</h3>
                <div class="status-badge badge-loading">⏳ في الانتظار...</div>
                <div class="test-result" id="result-config">لم يتم الاختبار بعد</div>
            </div>

            <div class="test-card" id="test-login">
                <h3>2️⃣ Login (/1)</h3>
                <div class="status-badge badge-loading">⏳ في الانتظار...</div>
                <div class="test-result" id="result-login">لم يتم الاختبار بعد</div>
            </div>

            <div class="test-card" id="test-alldata">
                <h3>3️⃣ All Data (methode=1)</h3>
                <div class="status-badge badge-loading">⏳ في الانتظار...</div>
                <div class="test-result" id="result-alldata">لم يتم الاختبار بعد</div>
            </div>

            <div class="test-card" id="test-bouquets">
                <h3>4️⃣ Bouquets (methode=2)</h3>
                <div class="status-badge badge-loading">⏳ في الانتظار...</div>
                <div class="test-result" id="result-bouquets">لم يتم الاختبار بعد</div>
            </div>

            <div class="test-card" id="test-radios">
                <h3>5️⃣ Radios (methode=4)</h3>
                <div class="status-badge badge-loading">⏳ في الانتظار...</div>
                <div class="test-result" id="result-radios">لم يتم الاختبار بعد</div>
            </div>

            <div class="test-card" id="test-categories">
                <h3>6️⃣ Categories (methode=3)</h3>
                <div class="status-badge badge-loading">⏳ في الانتظار...</div>
                <div class="test-result" id="result-categories">لم يتم الاختبار بعد</div>
            </div>
        </div>

        <div class="info-box" style="background: #f3e5f5; border-color: #9c27b0; color: #4a148c;">
            <h3>💡 كيفية حل المشكلة إذا فشلت الاختبارات:</h3>
            <ol style="text-align: right; margin-right: 20px; line-height: 2;">
                <li><strong>مسح Cache من Cloudflare:</strong> هذا هو السبب الأكثر شيوعاً</li>
                <li><strong>مسح cache التطبيق:</strong> Settings → Apps → Didon → Clear Cache + Clear Data</li>
                <li><strong>إعادة تشغيل Apache:</strong> على السيرفر نفسه</li>
                <li><strong>الانتظار 5 دقائق:</strong> بعد مسح Cloudflare cache</li>
            </ol>
        </div>
    </div>

    <script>
        let totalTests = 0;
        let passedTests = 0;
        let failedTests = 0;

        async function testEndpoint(name, url, postData, cardId, resultId, expectedFields) {
            const card = document.getElementById(cardId);
            const result = document.getElementById(resultId);
            const badge = card.querySelector('.status-badge');

            totalTests++;

            // Set loading state
            card.className = 'test-card loading';
            badge.className = 'status-badge badge-loading';
            badge.innerHTML = '⏳ جاري الاختبار... <div class="loading-spinner"></div>';
            result.textContent = 'جاري الاتصال...';

            try {
                const startTime = Date.now();
                const response = await fetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Cache-Control': 'no-cache, no-store, must-revalidate',
                        'Pragma': 'no-cache'
                    },
                    body: JSON.stringify(postData),
                    cache: 'no-store'
                });

                const responseTime = Date.now() - startTime;
                const data = await response.json();

                let success = response.ok;
                let details = `HTTP Status: ${response.status}\nResponse Time: ${responseTime}ms\n\n`;

                // Check for expected fields
                if (expectedFields && success) {
                    const hasFields = expectedFields.every(field => {
                        if (field.includes('.')) {
                            const [parent, child] = field.split('.');
                            return data[parent] && data[parent].length > 0;
                        }
                        return field in data;
                    });

                    if (!hasFields) {
                        success = false;
                        details += '⚠️ الحقول المطلوبة غير موجودة\n\n';
                    }
                }

                details += JSON.stringify(data, null, 2).substring(0, 500);
                if (JSON.stringify(data).length > 500) {
                    details += '\n\n... (تم اختصار النتيجة)';
                }

                result.textContent = details;

                if (success) {
                    card.className = 'test-card success';
                    badge.className = 'status-badge badge-success';
                    badge.textContent = `✅ نجح (${responseTime}ms)`;
                    passedTests++;
                } else {
                    card.className = 'test-card error';
                    badge.className = 'status-badge badge-error';
                    badge.textContent = `❌ فشل (HTTP ${response.status})`;
                    failedTests++;
                }
            } catch (error) {
                card.className = 'test-card error';
                badge.className = 'status-badge badge-error';
                badge.textContent = '❌ خطأ في الاتصال';
                result.textContent = `خطأ: ${error.message}\n\nتحقق من:\n- الاتصال بالإنترنت\n- Cloudflare Cache\n- Apache Server Status`;
                failedTests++;
            }

            updateSummary();
        }

        function updateSummary() {
            document.getElementById('total-tests').textContent = totalTests;
            document.getElementById('passed-tests').textContent = passedTests;
            document.getElementById('failed-tests').textContent = failedTests;
            document.getElementById('summary').style.display = 'block';

            if (totalTests === 6) {
                if (failedTests > 0) {
                    document.getElementById('cache-warning').style.display = 'block';
                    document.getElementById('success-message').style.display = 'none';
                } else {
                    document.getElementById('cache-warning').style.display = 'none';
                    document.getElementById('success-message').style.display = 'block';
                }
            }
        }

        async function runAllTests() {
            // Reset counters
            totalTests = 0;
            passedTests = 0;
            failedTests = 0;

            // Hide messages
            document.getElementById('cache-warning').style.display = 'none';
            document.getElementById('success-message').style.display = 'none';

            const code = '<?php echo $test_code; ?>';
            const timestamp = Date.now();

            // Test 1: Config
            await testEndpoint(
                'Config',
                `/PanelAndroid/API.php?methode=5&_t=${timestamp}`,
                {str1: '', str2: ''},
                'test-config',
                'result-config',
                ['str0', 'str1', 'str2']
            );

            // Test 2: Login
            await testEndpoint(
                'Login',
                `/PanelAndroid/1?_t=${timestamp}`,
                {android_id: 'diagnostic_test', code: code, macE: '', macW: '0'},
                'test-login',
                'result-login',
                ['username', 'password', 'active']
            );

            // Test 3: All Data
            await testEndpoint(
                'All Data',
                `/PanelAndroid/API.php?methode=1&_t=${timestamp}`,
                {code: code},
                'test-alldata',
                'result-alldata',
                ['bou', 'rad', 'intro']
            );

            // Test 4: Bouquets
            await testEndpoint(
                'Bouquets',
                `/PanelAndroid/API.php?methode=2&_t=${timestamp}`,
                {android_id: 'diagnostic_test', code: code, macE: '', macW: '0'},
                'test-bouquets',
                'result-bouquets',
                ['bou']
            );

            // Test 5: Radios
            await testEndpoint(
                'Radios',
                `/PanelAndroid/API.php?methode=4&_t=${timestamp}`,
                {},
                'test-radios',
                'result-radios',
                ['rad']
            );

            // Test 6: Categories
            await testEndpoint(
                'Categories',
                `/PanelAndroid/API.php?methode=3&_t=${timestamp}`,
                {code: code},
                'test-categories',
                'result-categories',
                ['cat']
            );
        }

        // Update test time every second
        setInterval(() => {
            document.getElementById('test-time').textContent = new Date().toLocaleString('ar-EG');
        }, 1000);
    </script>
</body>
</html>
