-- ═══════════════════════════════════════════════════════════════════
-- 🔥 QUICK FIX: Prevent App Crash on Empty Database
-- ═══════════════════════════════════════════════════════════════════
-- Adds minimal data to prevent "NumberFormatException: s == null" crash
-- ═══════════════════════════════════════════════════════════════════

USE didon_panel;

-- Add at least ONE category (prevents Method 3 crash)
INSERT IGNORE INTO categories (id, name, type, display_order, is_active) VALUES
(1, 'Live TV', 'live', 1, TRUE);

-- Add at least ONE channel (prevents empty list crash)
INSERT IGNORE INTO channels (id, name, stream_url, category_id, type, is_active) VALUES
(1, 'Test Channel', 'http://test.com/stream.m3u8', 1, 'live', TRUE);

-- Add at least ONE VOD (prevents Method 6 crash)
INSERT IGNORE INTO vod_content (stream_id, name, type, category_id, is_active) VALUES
(1001, 'Test Movie', 'vod', 1, TRUE);

SELECT '✅ Minimal data added - App should not crash now!' AS status;
