<?php require_once 'auth.php'; requireLogin(); ?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="icon" type="image/png" href="assets/img/logo2.png">
    <title><?php echo $page_title ?? 'Android Panel'; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />
    <link href="assets/css/nucleo-icons.css" rel="stylesheet" />
    <link href="assets/css/nucleo-svg.css" rel="stylesheet" />
    <script src="https://kit.fontawesome.com/349ee9c857.js" crossorigin="anonymous"></script>
    <link id="pagestyle" href="assets/css/corporate-ui-dashboard.css?v=1.0.0" rel="stylesheet" />
    <style>
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: 250px;
            background: #344767;
            padding-top: 20px;
        }
        .sidebar a {
            display: block;
            color: #fff;
            padding: 15px 20px;
            text-decoration: none;
            transition: 0.3s;
        }
        .sidebar a:hover, .sidebar a.active {
            background: #2d3748;
        }
        .main-content {
            margin-left: 250px;
            padding: 20px;
        }
        .top-bar {
            background: #fff;
            padding: 15px 30px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div style="color:#fff; padding:20px; font-size:20px; font-weight:bold;">DIDON Panel</div>
        <a href="dashboard.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>"><i class="fas fa-home"></i> Accueil</a>
        <a href="serveur.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'serveur.php' ? 'active' : ''; ?>"><i class="fas fa-server"></i> Serveur</a>
        <a href="bouquets.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'bouquets.php' ? 'active' : ''; ?>"><i class="fas fa-folder"></i> Bouquets</a>
        <a href="categories.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'active' : ''; ?>"><i class="fas fa-list"></i> Categories</a>
        <a href="radio.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'radio.php' ? 'active' : ''; ?>"><i class="fas fa-broadcast-tower"></i> Radio</a>
        <a href="intro.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'intro.php' ? 'active' : ''; ?>"><i class="fas fa-video"></i> Intro</a>
        <a href="code_pin.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'code_pin.php' ? 'active' : ''; ?>"><i class="fas fa-lock"></i> Code PIN</a>
        <a href="menu.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'menu.php' ? 'active' : ''; ?>"><i class="fas fa-bars"></i> Menu</a>
        <a href="users.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>"><i class="fas fa-users"></i> Users</a>
        <a href="app_info.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'app_info.php' ? 'active' : ''; ?>"><i class="fas fa-mobile-alt"></i> App Info</a>
    </div>
    <div class="main-content">
        <div class="top-bar">
            <h4><?php echo $page_title ?? 'Dashboard'; ?></h4>
            <div>
                <span style="margin-right:20px;">
                    <i class="fas fa-user-circle"></i> <?php echo $_SESSION['username']; ?>
                </span>
                <a href="logout.php" class="btn btn-sm btn-danger">
                    <i class="fas fa-sign-out-alt"></i> Déconnectez-vous
                </a>
            </div>
        </div>
        <div class="container-fluid">
