<?php
/**
 * Script d'importation des données depuis l'ancien serveur
 * Lit les fichiers JSON téléchargés et crée un nouveau db.json
 */

echo "🔄 Importation des données de l'ancien serveur...\n\n";

// Lire les données de méthode 1 (rad, bou, cat, main, intro)
$methode1 = json_decode(file_get_contents('/tmp/methode1.json'), true);

// Lire les données de méthode 5 (config)
$methode5 = json_decode(file_get_contents('/tmp/methode5.json'), true);

// Créer la nouvelle structure de base de données
$new_db = array(
    'config' => $methode5,
    'rad' => $methode1['rad'] ?? [],
    'bou' => $methode1['bou'] ?? [],
    'cat' => $methode1['cat'] ?? [],
    'intro' => $methode1['intro'] ?? [],
    'main' => $methode1['main'] ?? [],
    'app_info' => array(
        'version' => '2.6',
        'version_code' => '19',
        'app_name' => 'DIDON',
        'message' => 'message test'
    ),
    'users' => array(
        array('username' => 'admin', 'password' => 'admin', 'role' => 'admin'),
        array('username' => 'mohamed9696', 'password' => 'panel', 'role' => 'user')
    )
);

// IMPORTANT: Changer str8 vers le nouveau domaine
$new_db['config']['str8'] = 'http://chatti.tmaxhosting.com';

// Sauvegarder dans db.json
$json_output = json_encode($new_db, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
file_put_contents(__DIR__ . '/db.json', $json_output);

// Afficher les statistiques
echo "✅ Importation terminée!\n\n";
echo "📊 STATISTIQUES:\n";
echo "  - Radios: " . count($new_db['rad']) . "\n";
echo "  - Bouquets: " . count($new_db['bou']) . "\n";
echo "  - Catégories: " . count($new_db['cat']) . "\n";
echo "  - Main Menu: " . count($new_db['main']) . "\n";
echo "  - Intro: " . count($new_db['intro']) . "\n";
echo "\n";
echo "🔑 CONFIGURATION:\n";
echo "  - str8 (Base URL): " . $new_db['config']['str8'] . "\n";
echo "  - str4 (Xtream Host): " . $new_db['config']['str4'] . "\n";
echo "  - str5 (Xtream Port): " . $new_db['config']['str5'] . "\n";
echo "\n";
echo "💾 Fichier créé: " . __DIR__ . "/db.json\n";
echo "📦 Taille: " . round(filesize(__DIR__ . '/db.json') / 1024, 2) . " KB\n";

?>
