<?php
require_once 'auth.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (login($username, $password)) {
        header('Location: dashboard.php');
        exit();
    } else {
        $error = "Nom d'utilisateur ou mot de passe incorrect";
    }
}

if (isLoggedIn()) {
    header('Location: dashboard.php');
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="apple-touch-icon" sizes="76x76" href="assets/img/logo2.png">
  <link rel="icon" type="image/png" href="assets/img/logo2.png">
  <title>Android - Login</title>
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Noto+Sans:300,400,500,600,700,800|PT+Mono:300,400,500,600,700" rel="stylesheet" />
  <link href="assets/css/nucleo-icons.css" rel="stylesheet" />
  <link href="assets/css/nucleo-svg.css" rel="stylesheet" />
  <script src="https://kit.fontawesome.com/349ee9c857.js" crossorigin="anonymous"></script>
  <link id="pagestyle" href="assets/css/corporate-ui-dashboard.css?v=1.0.0" rel="stylesheet" />
</head>
<body class="hold-transition login-page">
	  <main class="main-content  mt-0">
	    <section>
	      <div class="page-header min-vh-100">
	        <div class="container">
	          <div class="row">
	            <div class="col-xl-4 col-md-6 d-flex flex-column mx-auto">
	              <div class="card card-plain mt-8" style="margin-top:0px !important">
	                <div class="card-header pb-0 text-left bg-transparent">
	                  <h3 class="font-weight-black text-dark display-6">Android App</h3>
	                </div>
	                <div class="card-body">
	                  <?php if (isset($error)): ?>
	                  <div style="color:red"><?php echo $error; ?></div><br>
	                  <?php endif; ?>

	                  <form role="form" action="" method="post">
		                    <label>Nom d'utilisateur</label>
	                    <div class="mb-3">
	                      <input type="text" class="form-control" placeholder="Nom d'utilisateur" name="username" aria-label="Email" required>
	                    </div>
	                    <label>Mot de passe</label>
	                    <div class="mb-3">
	                      <input type="password" class="form-control" placeholder="Mot de passe" name="password" aria-label="Password" required>
	                    </div>
	                    <div class="text-center">
	                      <button type="submit" class="btn btn-dark w-100 mt-4 mb-3">Se Connecter</button>
	                    </div>
	                  </form>
	                </div>
	              </div>
	            </div>
	          </div>
	        </div>
	      </div>
	    </section>
	  </main>
	  <script src="assets/js/core/popper.min.js"></script>
	  <script src="assets/js/core/bootstrap.min.js"></script>
</body>
</html>
