#!/bin/bash
# ═══════════════════════════════════════════════════════════════════
# 🔥 DIDON Panel - Automatic Installation Script
# ═══════════════════════════════════════════════════════════════════

# Colors
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
PURPLE='\033[0;35m'
CYAN='\033[0;36m'
NC='\033[0m' # No Color

# Banner
echo -e "${CYAN}"
cat << "EOF"
╔═══════════════════════════════════════════════════════════════════╗
║                                                                   ║
║   🔥 DIDON PANEL - AUTOMATIC INSTALLATION                        ║
║                                                                   ║
║   Complete API with all discovered methods                       ║
║   Methods: 1, 2, 3, 5, 6, 8, 10, 13, 16, 17, 19                 ║
║                                                                   ║
╚═══════════════════════════════════════════════════════════════════╝
EOF
echo -e "${NC}\n"

# Check if running as root
if [ "$EUID" -ne 0 ]; then
    echo -e "${RED}❌ Please run as root or with sudo${NC}"
    exit 1
fi

# Get MySQL password
echo -e "${YELLOW}🔐 MySQL Configuration${NC}"
read -sp "Enter MySQL root password: " MYSQL_PASS
echo ""

# Test MySQL connection
echo -e "${BLUE}🔍 Testing MySQL connection...${NC}"
mysql -u root -p"$MYSQL_PASS" -e "SELECT 1;" > /dev/null 2>&1
if [ $? -ne 0 ]; then
    echo -e "${RED}❌ MySQL connection failed! Check password.${NC}"
    exit 1
fi
echo -e "${GREEN}✅ MySQL connection successful${NC}\n"

# Step 1: Backup existing API
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}📦 Step 1: Backing up existing API...${NC}"
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"

if [ -f "/var/www/html/PanelAndroid/API.php" ]; then
    cp /var/www/html/PanelAndroid/API.php /var/www/html/PanelAndroid/API.php.backup.$(date +%Y%m%d_%H%M%S)
    echo -e "${GREEN}✅ Backup created${NC}\n"
else
    echo -e "${YELLOW}⚠️  No existing API found, skipping backup${NC}\n"
fi

# Step 2: Update database
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}📊 Step 2: Updating database schema...${NC}"
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"

mysql -u root -p"$MYSQL_PASS" < /var/www/html/PanelAndroid/update_database.sql
if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ Database updated successfully${NC}\n"
else
    echo -e "${RED}❌ Database update failed!${NC}"
    exit 1
fi

# Step 3: Deploy new API
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}🚀 Step 3: Deploying new API...${NC}"
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"

# Update database password in API_NEW.php
sed -i "s/\$db_pass = '';/\$db_pass = '$MYSQL_PASS';/" /var/www/html/PanelAndroid/API_NEW.php

# Copy to API.php
cp /var/www/html/PanelAndroid/API_NEW.php /var/www/html/PanelAndroid/API.php

# Set permissions
chmod 644 /var/www/html/PanelAndroid/API.php
chown www-data:www-data /var/www/html/PanelAndroid/API.php

echo -e "${GREEN}✅ API deployed successfully${NC}\n"

# Step 4: Create logs directory
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}📁 Step 4: Creating logs directory...${NC}"
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"

mkdir -p /var/www/html/PanelAndroid/logs
chmod 755 /var/www/html/PanelAndroid/logs
chown www-data:www-data /var/www/html/PanelAndroid/logs

echo -e "${GREEN}✅ Logs directory created${NC}\n"

# Step 5: Configure Xtream Codes (optional)
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}🌐 Step 5: Xtream Codes Configuration (Optional)${NC}"
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"

read -p "Do you want to configure Xtream Codes? (y/n): " CONFIGURE_XTREAM

if [ "$CONFIGURE_XTREAM" = "y" ] || [ "$CONFIGURE_XTREAM" = "Y" ]; then
    read -p "Enter Xtream URL (e.g., https://flix-panel.xyz:2087): " XTREAM_URL
    read -p "Enter Xtream Username: " XTREAM_USER
    read -sp "Enter Xtream Password: " XTREAM_PASS
    echo ""

    mysql -u root -p"$MYSQL_PASS" didon_panel << EOF
UPDATE users
SET xtream_url = '$XTREAM_URL',
    xtream_username = '$XTREAM_USER',
    xtream_password = '$XTREAM_PASS'
WHERE code = '123456';
EOF

    if [ $? -eq 0 ]; then
        echo -e "${GREEN}✅ Xtream credentials configured${NC}\n"

        # Test Xtream connection
        echo -e "${BLUE}🔍 Testing Xtream connection...${NC}"
        TEST_URL="${XTREAM_URL}/player_api.php?username=${XTREAM_USER}&password=${XTREAM_PASS}&action=get_live_categories"
        if curl -s --max-time 10 "$TEST_URL" | grep -q "category_id"; then
            echo -e "${GREEN}✅ Xtream connection successful${NC}\n"
        else
            echo -e "${YELLOW}⚠️  Could not verify Xtream connection (may be slow or unavailable)${NC}\n"
        fi
    else
        echo -e "${RED}❌ Xtream configuration failed${NC}\n"
    fi
else
    echo -e "${YELLOW}⚠️  Skipping Xtream configuration${NC}\n"
fi

# Step 6: Run tests
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}🧪 Step 6: Running API tests...${NC}"
echo -e "${YELLOW}═══════════════════════════════════════════════════════════════════${NC}"

cd /var/www/html/PanelAndroid
chmod +x test_all_methods.sh
./test_all_methods.sh

if [ $? -eq 0 ]; then
    echo -e "\n${GREEN}✅ All tests passed!${NC}\n"
else
    echo -e "\n${YELLOW}⚠️  Some tests failed, but installation completed${NC}\n"
fi

# Summary
echo -e "${CYAN}"
cat << "EOF"
╔═══════════════════════════════════════════════════════════════════╗
║                                                                   ║
║   ✅ INSTALLATION COMPLETE!                                      ║
║                                                                   ║
╚═══════════════════════════════════════════════════════════════════╝
EOF
echo -e "${NC}"

echo -e "${GREEN}🎉 DIDON Panel installed successfully!${NC}\n"

echo -e "${BLUE}📋 Installation Summary:${NC}"
echo -e "   ✅ Database updated with new tables"
echo -e "   ✅ API deployed with all methods (1,2,3,5,6,8,10,13,16,17,19)"
echo -e "   ✅ Logs directory created"
echo -e "   ✅ Permissions set correctly"

if [ "$CONFIGURE_XTREAM" = "y" ] || [ "$CONFIGURE_XTREAM" = "Y" ]; then
    echo -e "   ✅ Xtream Codes configured"
fi

echo ""
echo -e "${YELLOW}📍 Important Files:${NC}"
echo -e "   API: /var/www/html/PanelAndroid/API.php"
echo -e "   Backup: /var/www/html/PanelAndroid/API.php.backup.*"
echo -e "   Logs: /var/www/html/PanelAndroid/logs/"
echo -e "   Tests: /var/www/html/PanelAndroid/test_all_methods.sh"

echo ""
echo -e "${YELLOW}🔍 Quick Test:${NC}"
echo -e "   curl http://localhost/PanelAndroid/API.php?methode=5"

echo ""
echo -e "${YELLOW}📖 Documentation:${NC}"
echo -e "   Setup Guide: /var/www/html/PanelAndroid/COMPLETE_SETUP_GUIDE.md"
echo -e "   README: /var/www/html/PanelAndroid/README_FINAL.md"
echo -e "   All Methods: /var/www/html/ALL_METHODS_DISCOVERED.md"

echo ""
echo -e "${YELLOW}🎯 Next Steps:${NC}"
echo -e "   1. Test with DIDON app (code: 123456)"
echo -e "   2. Add your content (categories, channels)"
echo -e "   3. Enable HTTPS for production"
echo -e "   4. Set up regular backups"

echo ""
echo -e "${YELLOW}📊 Monitor Logs:${NC}"
echo -e "   tail -f /var/www/html/PanelAndroid/logs/api_\$(date +%Y-%m-%d).log"

echo ""
echo -e "${YELLOW}🗄️  Database Access:${NC}"
echo -e "   mysql -u root -p didon_panel"

echo ""
echo -e "${GREEN}🚀 Your panel is ready to use!${NC}\n"
