<!DOCTYPE html>
<html>
<head>
    <title>Last App Request</title>
    <meta http-equiv="refresh" content="2">
    <style>
        body { font-family: monospace; background: #000; color: #0f0; padding: 20px; }
        .request { border: 1px solid #0f0; padding: 15px; margin: 10px 0; }
        .success { color: #0f0; }
        .error { color: #f00; }
        .time { color: #ff0; }
    </style>
</head>
<body>
    <h1>📱 Last App Request</h1>
    <p class="time">Auto-refreshes every 2 seconds</p>
    <p class="time">Current time: <?= date('Y-m-d H:i:s') ?></p>

    <?php
    $logFile = __DIR__ . '/debug_log.txt';
    if (file_exists($logFile)) {
        $content = file_get_contents($logFile);
        $requests = array_filter(explode('---', $content));
        $last = array_slice(array_reverse($requests), 0, 5);

        foreach ($last as $i => $entry) {
            $data = json_decode(trim($entry), true);
            if ($data) {
                echo '<div class="request">';
                echo '<h3>' . ($i == 0 ? '🔴 LATEST' : '⚪ Previous') . '</h3>';
                echo '<p class="time">Time: ' . ($data['timestamp'] ?? 'unknown') . '</p>';
                echo '<p class="success">Method: ' . ($data['get_methode'] ?? 'none') . '</p>';
                echo '<p>URL: ' . ($data['url'] ?? 'unknown') . '</p>';

                if (isset($data['parsed_json'])) {
                    echo '<p>Request Body:</p>';
                    echo '<pre>' . json_encode($data['parsed_json'], JSON_PRETTY_PRINT) . '</pre>';
                }

                echo '</div>';
            }
        }
    } else {
        echo '<p class="error">No requests logged yet</p>';
    }
    ?>

    <hr>
    <h2>📊 Quick Stats</h2>
    <?php
    if (file_exists($logFile)) {
        $content = file_get_contents($logFile);
        $requests = array_filter(explode('---', $content));
        echo '<p>Total requests logged: ' . count($requests) . '</p>';

        // Count by method
        $methods = [];
        foreach ($requests as $entry) {
            $data = json_decode(trim($entry), true);
            if ($data && isset($data['get_methode'])) {
                $m = $data['get_methode'] ?: 'login';
                $methods[$m] = ($methods[$m] ?? 0) + 1;
            }
        }

        echo '<p>Requests by method:</p>';
        echo '<ul>';
        foreach ($methods as $method => $count) {
            echo '<li>methode=' . ($method ?: '(login)') . ': ' . $count . ' times</li>';
        }
        echo '</ul>';
    }
    ?>
</body>
</html>
