<?php
/**
 * Login/Restore Handler
 * Handles user authentication for the app
 */

header('Content-Type: application/json; charset=UTF-8');
require_once 'db_helper.php';
require_once 'xtream_helper.php';

$rawData = file_get_contents('php://input');
$postData = json_decode($rawData, true);

if ($postData === null && !empty($rawData)) {
    $fixedData = str_replace('\\!', '!', $rawData);
    $postData = json_decode($fixedData, true);
}

if ($postData === null) {
    $postData = array();
}

// Extract code from AuthUser object
$code = isset($postData['code']) ? $postData['code'] : '';
$macW = isset($postData['macW']) ? $postData['macW'] : '';
$macE = isset($postData['macE']) ? $postData['macE'] : '';
$android_id = isset($postData['android_id']) ? $postData['android_id'] : '';

// Parse code: username!!!password
$username = '';
$password = '';

if (strpos($code, '!!!') !== false) {
    list($username, $password) = explode('!!!', $code, 2);
} else {
    $username = $code;
    $password = $code;
}

// Default credentials if empty
if (empty($username)) $username = '1231231';
if (empty($password)) $password = '1231231';

// Get config
$config = DB::getConfig();
$xtream_url = $config['str4'];

// Authenticate with Xtream
$xtream = new XtreamAPI($xtream_url, $username, $password);
$auth = $xtream->authenticate();

if ($auth && isset($auth['username'])) {
    // Success - build User response
    $user = array(
        "id" => "1",
        "username" => $username,
        "password" => $password,
        "code" => $code,
        "macW" => $macW,
        "macE" => $macE,
        "android_id" => $android_id,
        "account_expire_date" => isset($auth['account_expire_date']) ? $auth['account_expire_date'] : 'Unlimited',
        "account_expire_timestamp" => isset($auth['account_expire_timestamp']) ? $auth['account_expire_timestamp'] : null,
        "active" => true,
        "status" => "active",
        "created_at" => isset($auth['created_at']) ? $auth['created_at'] : date('Y-m-d H:i:s'),
        "server_info" => $auth
    );

    echo json_encode($user);
} else {
    // Failed - return error
    http_response_code(401);
    $response = array(
        "error" => "Authentication failed",
        "message" => "Invalid username or password",
        "code" => $code,
        "username" => $username
    );
    echo json_encode($response);
}
?>
