<?php
header('Content-Type: application/json');

// Get all request logs from the last 5 minutes
$logFile = __DIR__ . '/debug_log.txt';
$logs = file_get_contents($logFile);
$entries = explode('---', $logs);

// Parse and filter recent logs (last 100 entries)
$recentLogs = array();
$entries = array_slice($entries, -100);

foreach ($entries as $entry) {
    $entry = trim($entry);
    if (empty($entry)) continue;

    $data = json_decode($entry, true);
    if ($data && isset($data['timestamp'])) {
        $recentLogs[] = array(
            'time' => $data['timestamp'],
            'method' => $data['method'] ?? 'N/A',
            'endpoint' => $data['url'] ?? 'N/A',
            'body' => $data['parsed_json'] ?? null
        );
    }
}

// Get last 20
$recentLogs = array_slice($recentLogs, -20);

echo json_encode(array(
    'total' => count($recentLogs),
    'requests' => $recentLogs
), JSON_PRETTY_PRINT);
