<?php
/**
 * Xtream Codes API Proxy
 *
 * This proxies all Xtream API requests to the real Xtream server
 * using the correct credentials, regardless of what the app sends.
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once __DIR__ . '/db_helper.php';
require_once __DIR__ . '/xtream_helper.php';

// Get request parameters
$username = isset($_GET['username']) ? $_GET['username'] : '';
$password = isset($_GET['password']) ? $_GET['password'] : '';
$action = isset($_GET['action']) ? $_GET['action'] : '';
$category_id = isset($_GET['category_id']) ? $_GET['category_id'] : null;
$stream_id = isset($_GET['stream_id']) ? $_GET['stream_id'] : null;
$series_id = isset($_GET['series_id']) ? $_GET['series_id'] : null;
$vod_id = isset($_GET['vod_id']) ? $_GET['vod_id'] : null;

// Log the request for debugging
$log_entry = array(
    'timestamp' => date('Y-m-d H:i:s'),
    'method' => $_SERVER['REQUEST_METHOD'],
    'uri' => $_SERVER['REQUEST_URI'],
    'username' => $username,
    'action' => $action,
    'real_ip' => $_SERVER['REMOTE_ADDR']
);
file_put_contents(__DIR__ . '/xtream_proxy_log.txt', json_encode($log_entry, JSON_PRETTY_PRINT) . "\n", FILE_APPEND);

// Get real Xtream credentials from config
$config = DB::getConfig();
$xtream_url = isset($config['xtream_url']) ? $config['xtream_url'] : 'http://flix-panel.xyz:80';
$real_username = isset($config['xtream_username']) ? $config['xtream_username'] : 'uCEp55f8w5';
$real_password = isset($config['xtream_password']) ? $config['xtream_password'] : 'yJKj2rCAD3';

// Log what we're using
error_log("Xtream Proxy: Using URL: $xtream_url, Username: $real_username");

// Accept ANY username/password from the app, use real credentials for Xtream
// This allows mohamed9696:mohamed9696 to work even though Xtream doesn't know about it
$xtream = new XtreamAPI($xtream_url, $real_username, $real_password);

// Handle different actions
$response = null;

switch ($action) {
    case 'get_live_categories':
        $response = $xtream->getLiveCategories();
        break;

    case 'get_live_streams':
        $response = $xtream->getLiveStreams($category_id);
        break;

    case 'get_vod_categories':
        $response = $xtream->getVODCategories();
        break;

    case 'get_vod_streams':
        $response = $xtream->getVODStreams($category_id);
        break;

    case 'get_vod_info':
        $response = $xtream->getVODInfo($vod_id);
        break;

    case 'get_series_categories':
        $response = $xtream->getSeriesCategories();
        break;

    case 'get_series':
        $response = $xtream->getSeries($category_id);
        break;

    case 'get_series_info':
        $response = $xtream->getSeriesInfo($series_id);
        break;

    default:
        // No action specified - return user authentication info
        $auth_result = $xtream->authenticate();

        if ($auth_result) {
            // Return successful authentication
            // Use the credentials the app sent, but confirm they work
            $response = array(
                "user_info" => array(
                    "username" => $username,
                    "password" => $password,
                    "message" => "Authenticated",
                    "auth" => 1,
                    "status" => "Active",
                    "exp_date" => "Unlimited",
                    "is_trial" => "0",
                    "active_cons" => "0",
                    "created_at" => time(),
                    "max_connections" => "1",
                    "allowed_output_formats" => ["m3u8", "ts"]
                ),
                "server_info" => array(
                    "url" => $config['str1'],
                    "port" => "80",
                    "https_port" => "443",
                    "server_protocol" => "http",
                    "rtmp_port" => "1935",
                    "timezone" => "UTC",
                    "timestamp_now" => time()
                )
            );
        } else {
            // Authentication failed on real Xtream server
            $response = array(
                "user_info" => array(
                    "auth" => 0,
                    "message" => "Invalid Credentials"
                )
            );
        }
        break;
}

// Output the response
if ($response !== null) {
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode(array("error" => "Invalid action or no data"), JSON_UNESCAPED_UNICODE);
}
?>
