<?php
/**
 * Quick Test Page - Simple one-click test
 * Access from: http://chatti.tmaxhosting.com/PanelAndroid/quick_test.php
 */
header('Content-Type: text/html; charset=UTF-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>اختبار سريع - Quick Test</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            margin: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            text-align: center;
        }
        h1 {
            color: #667eea;
            margin-bottom: 20px;
            font-size: 2em;
        }
        .test-button {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 20px 40px;
            font-size: 1.3em;
            border-radius: 50px;
            cursor: pointer;
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
            transition: all 0.3s;
            width: 100%;
            margin: 20px 0;
        }
        .test-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(102, 126, 234, 0.6);
        }
        .test-button:active {
            transform: translateY(0);
        }
        #result {
            margin-top: 30px;
            padding: 20px;
            border-radius: 10px;
            font-size: 1.2em;
            font-weight: bold;
            display: none;
            animation: fadeIn 0.5s;
        }
        .success {
            background: #d4edda;
            color: #155724;
            border: 3px solid #28a745;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            border: 3px solid #dc3545;
        }
        .loading {
            background: #fff3cd;
            color: #856404;
            border: 3px solid #ffc107;
        }
        .details {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-top: 20px;
            font-size: 0.9em;
            text-align: right;
            font-family: 'Courier New', monospace;
            max-height: 300px;
            overflow-y: auto;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.9); }
            to { opacity: 1; transform: scale(1); }
        }
        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 20px auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .info {
            background: #e7f3ff;
            color: #0c5460;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            font-size: 0.95em;
        }
        code {
            background: #272822;
            color: #66d9ef;
            padding: 3px 8px;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 اختبار سريع</h1>
        <p style="color: #666; margin-bottom: 20px;">اختبر جميع endpoints بضغطة واحدة</p>

        <button class="test-button" onclick="runQuickTest()">
            ▶️ تشغيل الاختبار
        </button>

        <div id="result"></div>

        <div class="info">
            <strong>📌 ملاحظة:</strong><br>
            إذا ظهرت أخطاء، امسح Cloudflare Cache من:<br>
            <a href="https://dash.cloudflare.com" target="_blank">Cloudflare Dashboard</a>
        </div>

        <div style="margin-top: 30px; padding-top: 20px; border-top: 2px solid #eee;">
            <a href="diagnostic.php" style="color: #667eea; text-decoration: none; font-size: 1.1em;">
                📊 للفحص التفصيلي اضغط هنا
            </a>
        </div>
    </div>

    <script>
        async function runQuickTest() {
            const resultDiv = document.getElementById('result');
            resultDiv.style.display = 'block';
            resultDiv.className = 'loading';
            resultDiv.innerHTML = '⏳ جاري الاختبار...<div class="spinner"></div>';

            const tests = [
                {name: 'Config', url: '/PanelAndroid/API.php?methode=5', data: {str1: ''}},
                {name: 'Login', url: '/PanelAndroid/1', data: {android_id: 'test', code: '1231231', macE: '', macW: '0'}},
                {name: 'Data', url: '/PanelAndroid/API.php?methode=1', data: {code: '1231231'}},
                {name: 'Bouquets', url: '/PanelAndroid/API.php?methode=2', data: {code: '1231231'}},
                {name: 'Radios', url: '/PanelAndroid/API.php?methode=4', data: {}}
            ];

            let passed = 0;
            let failed = 0;
            let details = '';

            for (let test of tests) {
                try {
                    const timestamp = Date.now();
                    const response = await fetch(test.url + (test.url.includes('?') ? '&' : '?') + '_t=' + timestamp, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Cache-Control': 'no-cache'
                        },
                        body: JSON.stringify(test.data),
                        cache: 'no-store'
                    });

                    if (response.ok) {
                        passed++;
                        details += `✅ ${test.name}: نجح (${response.status})\n`;
                    } else {
                        failed++;
                        details += `❌ ${test.name}: فشل (${response.status})\n`;
                    }
                } catch (error) {
                    failed++;
                    details += `❌ ${test.name}: خطأ (${error.message})\n`;
                }
            }

            if (failed === 0) {
                resultDiv.className = 'success';
                resultDiv.innerHTML = `
                    <div style="font-size: 3em; margin-bottom: 10px;">✅</div>
                    <div>كل شيء يعمل بشكل مثالي!</div>
                    <div style="font-size: 0.9em; margin-top: 15px; opacity: 0.8;">
                        ${passed} من ${tests.length} اختبار نجح
                    </div>
                    <div class="details">${details}</div>
                    <div style="margin-top: 20px; padding: 15px; background: #fff3cd; border-radius: 8px;">
                        <strong>الآن يمكنك:</strong><br>
                        1. فتح التطبيق<br>
                        2. إدخال الكود: <code>1231231</code> أو <code>test</code><br>
                        3. يجب أن يعمل! 🎉
                    </div>
                `;
            } else {
                resultDiv.className = 'error';
                resultDiv.innerHTML = `
                    <div style="font-size: 3em; margin-bottom: 10px;">❌</div>
                    <div>بعض الاختبارات فشلت</div>
                    <div style="font-size: 0.9em; margin-top: 10px;">
                        نجح: ${passed} | فشل: ${failed}
                    </div>
                    <div class="details">${details}</div>
                    <div style="margin-top: 20px; padding: 15px; background: #fff3cd; border-radius: 8px; text-align: right;">
                        <strong>⚠️ السبب المحتمل: Cloudflare Cache</strong><br><br>
                        <strong>الحل:</strong><br>
                        1. اذهب إلى <a href="https://dash.cloudflare.com" target="_blank">Cloudflare Dashboard</a><br>
                        2. اختر domain: <code>tmaxhosting.com</code><br>
                        3. Caching → Purge Everything<br>
                        4. انتظر دقيقة واحدة<br>
                        5. أعد الاختبار
                    </div>
                `;
            }
        }
    </script>
</body>
</html>
