<?php
$page_title = "Serveur";
require_once 'db_helper.php';
include 'header.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $config = array(
        'str0' => $_POST['str0'] ?? 'API.php?methode=',
        'str1' => $_POST['str1'] ?? '',
        'str2' => $_POST['str2'] ?? '/user/',
        'str3' => $_POST['str3'] ?? '',
        'str4' => $_POST['str4'] ?? '',
        'str5' => $_POST['str5'] ?? '',
        'str7' => $_POST['str7'] ?? '/PanelAndroid/API.php?methode=',
        'str8' => $_POST['str8'] ?? '',
        'str9' => $_POST['str9'] ?? '/Flag',
        'str10' => $_POST['str10'] ?? '/Intro',
        'str11' => $_POST['str11'] ?? '/Main',
        'str12' => $_POST['str12'] ?? '/PanelAndroid/media',
        'str13' => $_POST['str13'] ?? ':80'
    );

    DB::updateConfig($config);
    $success_message = "Configuration sauvegardée avec succès!";
}

// Load current config
$config = DB::getConfig();
?>

<?php if (isset($success_message)): ?>
<div class="alert alert-success"><?php echo $success_message; ?></div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <h5>Configuration Serveur</h5>
        <form method="POST">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>API</label>
                    <input class="form-control" name="str0" value="<?php echo htmlspecialchars($config['str0']); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label>Base Url (str8)</label>
                    <input class="form-control" name="str8" value="<?php echo htmlspecialchars($config['str8']); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label>Host Xtream (str4)</label>
                    <input class="form-control" name="str4" value="<?php echo htmlspecialchars($config['str4']); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label>Port Xtream (str5)</label>
                    <input class="form-control" name="str5" value="<?php echo htmlspecialchars($config['str5']); ?>">
                </div>
                <div class="col-md-12 mb-3">
                    <label>Xtream URL (str1)</label>
                    <input class="form-control" name="str1" value="<?php echo htmlspecialchars($config['str1']); ?>">
                </div>
                <div class="col-md-12 mb-3">
                    <label>XMLTV URL (str3)</label>
                    <input class="form-control" name="str3" value="<?php echo htmlspecialchars($config['str3']); ?>">
                </div>
            </div>
            <button type="submit" class="btn btn-primary mt-3">
                <i class="fas fa-save"></i> Enregistrer
            </button>
        </form>
    </div>
</div>

<?php include 'footer.php'; ?>
