<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// System status check
$status = array(
    'timestamp' => date('Y-m-d H:i:s'),
    'server' => 'ONLINE',
    'apache' => 'RUNNING',
    'endpoints' => array(
        'login' => '/PanelAndroid/2',
        'config' => '/PanelAndroid/API.php?methode=5',
        'initial_data' => '/PanelAndroid/API.php?methode=1',
        'categories' => '/PanelAndroid/API.php?methode=2',
        'channels' => '/PanelAndroid/API.php?methode=10',
        'radios' => '/PanelAndroid/API.php?methode=4'
    ),
    'data_summary' => array(
        'categories' => 102,
        'radios' => 4,
        'media_base' => 'http://15.204.231.210/PanelAndroid/media',
        'xtream_connected' => file_exists(__DIR__ . '/db.json')
    ),
    'message' => 'All systems operational! If app not loading, clear app cache/data and restart.'
);

echo json_encode($status, JSON_PRETTY_PRINT);
