<?php
/**
 * Debug API call
 */

header('Content-Type: application/json; charset=UTF-8');
require_once 'db_helper.php';
require_once 'xtream_helper.php';

$debug = array();
$debug['step'] = 'Start';

try {
    $config = DB::getConfig();
    $debug['config_loaded'] = true;
    $debug['xtream_url'] = $config['str4'];

    $xtream = new XtreamAPI($config['str4'], '1231231', '1231231');
    $debug['xtream_created'] = true;

    $all_categories = $xtream->getAllCategories();
    $debug['categories_count'] = count($all_categories);
    $debug['first_3_categories'] = array_slice($all_categories, 0, 3);

    $formatted = $xtream->transformCategoriesToAppFormat($all_categories);
    $debug['formatted_count'] = count($formatted);
    $debug['first_3_formatted'] = array_slice($formatted, 0, 3);

    $debug['status'] = 'success';

} catch (Exception $e) {
    $debug['error'] = $e->getMessage();
    $debug['status'] = 'failed';
}

echo json_encode($debug, JSON_PRETTY_PRINT);
?>
