<!DOCTYPE html>
<html>
<head>
    <title>Test Authentication</title>
    <style>
        body { font-family: monospace; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        h1 { color: #333; }
        .test-box { background: #f9f9f9; border: 1px solid #ddd; padding: 15px; margin: 10px 0; border-radius: 4px; }
        .success { color: #10b981; }
        .error { color: #ef4444; }
        pre { background: #1f2937; color: #10b981; padding: 15px; border-radius: 4px; overflow-x: auto; }
        button { background: #667eea; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; margin: 5px; }
        button:hover { background: #5568d3; }
        input { padding: 8px; border: 1px solid #ddd; border-radius: 4px; width: 300px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔐 Authentication Test Panel</h1>

        <div class="test-box">
            <h3>Test 1: Direct Xtream API</h3>
            <button onclick="testXtreamDirect()">Test Xtream Direct</button>
            <pre id="xtream-result">Click button to test...</pre>
        </div>

        <div class="test-box">
            <h3>Test 2: Login Endpoint</h3>
            <button onclick="testLogin()">Test Login Endpoint</button>
            <pre id="login-result">Click button to test...</pre>
        </div>

        <div class="test-box">
            <h3>Test 3: Method 2 (Bouquets)</h3>
            <button onclick="testMethod2()">Test Method 2</button>
            <pre id="method2-result">Click button to test...</pre>
        </div>

        <div class="test-box">
            <h3>Test 4: Custom Credentials</h3>
            <input type="text" id="custom-user" placeholder="Username" value="1231231">
            <input type="text" id="custom-pass" placeholder="Password" value="1231231">
            <br><br>
            <button onclick="testCustom()">Test Custom Credentials</button>
            <pre id="custom-result">Enter credentials and click button...</pre>
        </div>

        <div class="test-box">
            <h3>View Debug Log</h3>
            <button onclick="viewLog()">View Recent Requests</button>
            <button onclick="clearLog()">Clear Log</button>
            <pre id="log-result">Click button to view...</pre>
        </div>
    </div>

    <script>
        async function testXtreamDirect() {
            const result = document.getElementById('xtream-result');
            result.textContent = 'Testing...';
            try {
                const response = await fetch('http://flix-panel.xyz:80/api/player/1231231/1231231');
                const data = await response.json();
                result.textContent = JSON.stringify(data, null, 2);
                result.className = 'success';
            } catch (e) {
                result.textContent = 'Error: ' + e.message;
                result.className = 'error';
            }
        }

        async function testLogin() {
            const result = document.getElementById('login-result');
            result.textContent = 'Testing...';
            try {
                const response = await fetch('/PanelAndroid/API.php?methode=login', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        android_id: 'e11c464f560d1eba',
                        code: '1231231!!!1231231',
                        macE: '',
                        macW: '0'
                    })
                });
                const data = await response.json();
                result.textContent = JSON.stringify(data, null, 2);
                result.className = response.ok ? 'success' : 'error';
            } catch (e) {
                result.textContent = 'Error: ' + e.message;
                result.className = 'error';
            }
        }

        async function testMethod2() {
            const result = document.getElementById('method2-result');
            result.textContent = 'Testing...';
            try {
                const response = await fetch('/PanelAndroid/API.php?methode=2', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        android_id: 'e11c464f560d1eba',
                        code: '1231231!!!1231231',
                        macE: '',
                        macW: '0'
                    })
                });
                const data = await response.json();
                result.textContent = JSON.stringify(data, null, 2).substring(0, 500) + '...';
                result.className = response.ok ? 'success' : 'error';
            } catch (e) {
                result.textContent = 'Error: ' + e.message;
                result.className = 'error';
            }
        }

        async function testCustom() {
            const user = document.getElementById('custom-user').value;
            const pass = document.getElementById('custom-pass').value;
            const result = document.getElementById('custom-result');
            result.textContent = 'Testing...';
            try {
                const response = await fetch('/PanelAndroid/API.php?methode=login', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        android_id: 'test123',
                        code: user + '!!!' + pass,
                        macE: '',
                        macW: '0'
                    })
                });
                const data = await response.json();
                result.textContent = JSON.stringify(data, null, 2);
                result.className = response.ok ? 'success' : 'error';
            } catch (e) {
                result.textContent = 'Error: ' + e.message;
                result.className = 'error';
            }
        }

        async function viewLog() {
            const result = document.getElementById('log-result');
            result.textContent = 'Loading...';
            try {
                const response = await fetch('/PanelAndroid/debug_log.txt');
                const data = await response.text();
                result.textContent = data || 'Log is empty';
            } catch (e) {
                result.textContent = 'Error: ' + e.message;
            }
        }

        async function clearLog() {
            const result = document.getElementById('log-result');
            try {
                await fetch('/PanelAndroid/clear_log.php');
                result.textContent = 'Log cleared!';
                setTimeout(() => result.textContent = 'Click button to view...', 2000);
            } catch (e) {
                result.textContent = 'Error: ' + e.message;
            }
        }
    </script>
</body>
</html>
