<?php
require_once 'db_helper.php';
require_once 'xtream_helper.php';

echo "Testing Category Transformation\n";
echo "================================\n\n";

$xtream = new XtreamAPI();

echo "1. Getting all categories...\n";
$all_categories = $xtream->getAllCategories();
echo "Got " . count($all_categories) . " categories\n\n";

echo "First 5 categories (raw):\n";
foreach (array_slice($all_categories, 0, 5) as $cat) {
    print_r($cat);
}

echo "\n2. Transforming to app format...\n";
$formatted = $xtream->transformCategoriesToAppFormat($all_categories);
echo "Formatted to " . count($formatted) . " categories\n\n";

echo "First 5 formatted categories:\n";
foreach (array_slice($formatted, 0, 5) as $cat) {
    echo "  name: " . $cat['name'] . ", path: " . $cat['path'] . "\n";
}

echo "\nIs formatted array empty? " . (empty($formatted) ? "YES" : "NO") . "\n";
