<?php
require_once 'db_helper.php';
require_once 'xtream_helper.php';

echo "Testing Xtream API Connection\n";
echo "==============================\n\n";

$config = DB::getConfig();
echo "Config xtream_url: " . (isset($config['xtream_url']) ? $config['xtream_url'] : 'NOT SET') . "\n";
echo "Config xtream_username: " . (isset($config['xtream_username']) ? $config['xtream_username'] : 'NOT SET') . "\n";
echo "Config xtream_password: " . (isset($config['xtream_password']) ? $config['xtream_password'] : 'NOT SET') . "\n\n";

// Test with config defaults
$xtream = new XtreamAPI();
echo "Testing with default config credentials...\n";
$categories = $xtream->getLiveCategories();

if ($categories) {
    echo "SUCCESS! Got " . count($categories) . " categories\n";
    echo "First 3 categories:\n";
    foreach (array_slice($categories, 0, 3) as $cat) {
        echo "  - ID: " . (isset($cat['category_id']) ? $cat['category_id'] : 'N/A');
        echo ", Name: " . (isset($cat['category_name']) ? $cat['category_name'] : 'N/A') . "\n";
    }
} else {
    echo "FAILED! No categories returned\n";
}

echo "\n";

// Test with explicit credentials
echo "Testing with explicit credentials (uCEp55f8w5 / yJKj2rCAD3)...\n";
$xtream2 = new XtreamAPI('https://flix-panel.xyz:2087', 'uCEp55f8w5', 'yJKj2rCAD3');
$categories2 = $xtream2->getLiveCategories();

if ($categories2) {
    echo "SUCCESS! Got " . count($categories2) . " categories\n";
    echo "First 3 categories:\n";
    foreach (array_slice($categories2, 0, 3) as $cat) {
        echo "  - ID: " . (isset($cat['category_id']) ? $cat['category_id'] : 'N/A');
        echo ", Name: " . (isset($cat['category_name']) ? $cat['category_name'] : 'N/A') . "\n";
    }
} else {
    echo "FAILED! No categories returned\n";
}
