<?php
/**
 * User Authentication API
 * NO LOGIN REQUIRED - Always returns success
 */

header('Content-Type: application/json; charset=UTF-8');

// Enable logging
$log_file = '/tmp/user_api_debug.log';
$log_enabled = true;

function debug_log($message) {
    global $log_file, $log_enabled;
    if ($log_enabled) {
        $timestamp = date('Y-m-d H:i:s');
        file_put_contents($log_file, "[$timestamp] $message\n", FILE_APPEND);
    }
}

// Get method parameter
$methode = isset($_GET['methode']) ? $_GET['methode'] : '';
debug_log("========== NEW REQUEST ==========");
debug_log("Method: $methode");
debug_log("Request URI: " . $_SERVER['REQUEST_URI']);

// Read POST data
$rawData = file_get_contents('php://input');
debug_log("Raw POST data: " . $rawData);

$postData = json_decode($rawData, true);

// If json_decode failed, try to handle escaped exclamation marks
if ($postData === null && !empty($rawData)) {
    debug_log("JSON decode failed, trying to fix escaped chars");
    $fixedData = str_replace('\\!', '!', $rawData);
    $postData = json_decode($fixedData, true);
}

if ($postData === null) {
    $postData = array();
    debug_log("POST data is null/empty");
}

debug_log("Parsed POST data: " . json_encode($postData));

switch ($methode) {
    case '2':
        // NO AUTHENTICATION - Always allow
        debug_log("=== LOGIN REQUEST ===");

        $code = isset($postData['code']) ? $postData['code'] : '';
        $android_id = isset($postData['android_id']) ? $postData['android_id'] : '';

        debug_log("Code: " . $code);
        debug_log("Android ID: " . $android_id);

        // Extract username from code if present
        $username = '1231231';
        $password = '1231231';

        if (!empty($code) && strpos($code, '!!!') !== false) {
            list($username, $password) = explode('!!!', $code, 2);
            debug_log("Extracted username: $username");
        }

        // Always return success - EXACTLY as app expects
        $response = array(
            "id" => 1,
            "userName" => $username,
            "code" => $code,
            "android_id" => $android_id,
            "exp_date" => "2099-12-31 23:59:59",
            "cre_date" => date('Y-m-d H:i:s')
        );

        debug_log("Response: " . json_encode($response));
        echo json_encode($response);
        break;

    default:
        // Unknown method
        echo json_encode(array(
            "error" => "Unknown method: $methode"
        ));
        break;
}
?>
