# استيراد الحلقات للمسلسلات

## الوضع الحالي

- **إجمالي المسلسلات:** 6,909 مسلسل
- **المسلسلات مع حلقات:** 60 مسلسل
- **إجمالي الحلقات:** 601 حلقة

## كيفية استيراد المزيد من الحلقات

### 1. استيراد دفعة صغيرة (50 مسلسل)
```bash
cd /var/www/html/VOD
php import_episodes_batch.php 50 60
```

### 2. استيراد دفعة متوسطة (200 مسلسل)
```bash
cd /var/www/html/VOD
php import_episodes_batch.php 200 100
```

### 3. استيراد دفعة كبيرة في الخلفية (500 مسلسل)
```bash
cd /var/www/html/VOD
nohup php import_episodes_batch.php 500 300 > /tmp/episode_import_500.log 2>&1 &

# لمتابعة التقدم:
tail -f /tmp/episode_import_500.log
```

### 4. استيراد جميع المسلسلات (قد يستغرق ساعات)
```bash
cd /var/www/html/VOD
nohup php import_episodes_batch.php 6900 0 > /tmp/episode_import_all.log 2>&1 &

# لمتابعة التقدم:
tail -f /tmp/episode_import_all.log
```

## معلومات الاستيراد

- **متوسط الحلقات لكل مسلسل:** ~10 حلقات
- **المتوقع إجمالاً:** ~69,000 حلقة من جميع المسلسلات
- **مدة الاستيراد:** 
  - 50 مسلسل: ~1-2 دقيقة
  - 500 مسلسل: ~10-20 دقيقة
  - جميع المسلسلات: ~2-4 ساعات

## التحقق من التقدم

```bash
# عدد الحلقات المستوردة
mysql -u root -p'Admin@123' vod_import -e "SELECT COUNT(*) FROM episodes;"

# المسلسلات مع حلقات
mysql -u root -p'Admin@123' vod_import -e "SELECT COUNT(*) FROM series WHERE episodes_count > 0;"

# إحصائيات عبر API
curl -s "http://localhost/VOD/api/stats" | python3 -m json.tool
```

## ملاحظات

- يتم استيراد الحلقات فقط للمسلسلات التي لم يتم استيراد حلقاتها بعد (episodes_count = 0)
- يمكن إيقاف الاستيراد في أي وقت بدون مشاكل
- يمكن متابعة الاستيراد من حيث توقف
