# 🎬 VOD Panel - Complete Installation Package

## 📦 Package Contents

This archive contains a complete VOD (Video on Demand) management panel with:

- ✅ Full admin panel for managing series and movies
- ✅ Simple user interface for browsing and downloading
- ✅ Xtream Codes API integration
- ✅ TMDB metadata integration
- ✅ Remote server download management
- ✅ Episode and movie import system
- ✅ Automated installation script

---

## 🚀 Quick Installation (Fresh Server)

### Requirements:
- **OS:** Ubuntu 20.04/22.04 or Debian 10/11
- **RAM:** Minimum 2GB
- **Disk:** Minimum 20GB
- **Access:** Root or sudo access

### Installation Steps:

```bash
# 1. Extract the archive
tar -xzf VOD_Panel_Complete.tar.gz

# 2. Go to VOD directory
cd VOD

# 3. Make installation script executable
chmod +x INSTALL.sh

# 4. Run installation script as root
sudo bash INSTALL.sh

# 5. Follow the prompts and wait (~5-10 minutes)
```

---

## 🔐 Default Credentials

After installation, use these credentials:

### Panel Login:
- **URL:** `http://YOUR_SERVER_IP/VOD/`
- **Username:** `admin`
- **Password:** `admin`

### MySQL Database:
- **Database:** `vod_import`
- **Root Password:** `Admin@123`
- **Host:** `localhost`

---

## 📋 What Gets Installed

### Software:
- ✅ Apache 2.4 Web Server
- ✅ MySQL 8.0 Server
- ✅ PHP 7.4 (with extensions: mysql, curl, json, mbstring, xml, zip)
- ✅ FFmpeg (video processing)
- ✅ Python 3 (for download scripts)
- ✅ Additional tools (curl, wget, git, unzip)

### Database Tables:
- ✅ `users` - Admin and user accounts
- ✅ `series` - TV series metadata
- ✅ `episodes` - Episode information
- ✅ `movies` - Movie metadata
- ✅ `categories` - Content categories
- ✅ `servers` - Xtream Codes servers
- ✅ `remote_servers` - Remote download servers
- ✅ `download_jobs` - Download queue management
- ✅ `import_logs` - Import history
- ✅ `settings` - System settings

---

## 🎯 Post-Installation Steps

### 1. Access the Panel
```
http://YOUR_SERVER_IP/VOD/
```

### 2. Login with Default Credentials
- Username: `admin`
- Password: `admin`

### 3. Change Admin Password
- Go to Settings → Users
- Change the default password

### 4. Add Your Xtream Codes Server
- Go to "Servers" tab
- Click "Add Server"
- Enter your Xtream Codes credentials:
  - Name: (e.g., "My Server")
  - URL: `http://server-url.com:port`
  - Username: `your_username`
  - Password: `your_password`
- Click "Save"

### 5. Import Series
- Go to "Series" tab
- Click "Sync Series from Remote"
- Wait for import to complete
- Your series will appear in the list

### 6. Import Episodes
- Series automatically import with their episodes
- Episodes are linked to each series
- You can view episodes in the series details

### 7. (Optional) Add Remote Download Server
- Go to "Remote Servers" tab
- Add your SSH-accessible server for downloading
- Enter SSH credentials

---

## 🌐 Available Interfaces

### Admin Panel (Full Features):
```
http://YOUR_SERVER_IP/VOD/index.php
```
**Features:**
- Import series/movies from Xtream servers
- Manage content
- View statistics
- Bulk operations
- Download management
- User management

### Simple Interface (User-Friendly):
```
http://YOUR_SERVER_IP/VOD/vod.html
```
**Features:**
- Browse series by genre
- Search functionality
- Episode selection
- Download scripts
- Clean, fast interface

---

## 🔧 System Configuration

### Apache Configuration:
- **Document Root:** `/var/www/html/VOD`
- **Modules Enabled:** rewrite, headers, ssl
- **Permissions:** www-data:www-data

### PHP Settings (Optimized):
- `upload_max_filesize = 2048M`
- `post_max_size = 2048M`
- `memory_limit = 512M`
- `max_execution_time = 300`

### Firewall:
- Port 80 (HTTP) - Open
- Port 443 (HTTPS) - Open

---

## 📁 Directory Structure

```
/var/www/html/VOD/
├── INSTALL.sh              # Installation script
├── index.php               # Main admin panel
├── vod.html               # Simple user interface
├── login.php              # Authentication
├── api/                   # API endpoints
├── assets/                # CSS, JS, images
│   ├── css/
│   └── js/
│       └── app.js         # Main JavaScript (v51)
├── classes/               # PHP classes
│   ├── Auth.php
│   ├── Logger.php
│   ├── M3UParser.php
│   └── XtreamAPI.php
├── config/                # Configuration
│   ├── config.php         # Database settings
│   └── database.sql       # Database schema
├── scripts/               # Python scripts
│   └── smart_downloader.py
└── workers/               # Background workers
    └── cron.php
```

---

## 🧪 Testing the Installation

### Test 1: Access Admin Panel
```bash
curl http://localhost/VOD/
```
Should return HTML page

### Test 2: Check MySQL
```bash
mysql -u root -pAdmin@123 -e "USE vod_import; SHOW TABLES;"
```
Should show 10 tables

### Test 3: Check PHP
```bash
php -v
```
Should show PHP 7.4.x

### Test 4: Login
1. Open browser: `http://YOUR_SERVER_IP/VOD/`
2. Login with admin/admin
3. Should see admin dashboard

---

## 🔍 Troubleshooting

### Issue: Can't access panel
**Solution:**
```bash
sudo systemctl status apache2
sudo systemctl restart apache2
```

### Issue: MySQL connection error
**Solution:**
```bash
sudo systemctl status mysql
sudo systemctl restart mysql
```

### Issue: Permission denied
**Solution:**
```bash
sudo chown -R www-data:www-data /var/www/html/VOD
sudo chmod -R 755 /var/www/html/VOD
```

### Issue: PHP errors
**Solution:**
```bash
sudo tail -f /var/log/apache2/error.log
```

### Issue: Can't import series
**Check:**
1. Xtream Codes server URL is correct
2. Username and password are correct
3. Server is online and accessible

---

## 📊 Useful Commands

### Check Services Status:
```bash
systemctl status apache2
systemctl status mysql
```

### Restart Services:
```bash
systemctl restart apache2
systemctl restart mysql
```

### View Logs:
```bash
tail -f /var/log/apache2/error.log
tail -f /var/log/apache2/access.log
tail -f /var/log/mysql/error.log
```

### Database Access:
```bash
mysql -u root -pAdmin@123 vod_import
```

### Check Disk Space:
```bash
df -h
```

### Check Running Downloads:
```bash
ps aux | grep python
```

---

## 🛡️ Security Recommendations

1. **Change Default Passwords:**
   - Admin panel password
   - MySQL root password

2. **Enable HTTPS:**
   ```bash
   sudo apt install certbot python3-certbot-apache
   sudo certbot --apache
   ```

3. **Configure Firewall:**
   ```bash
   sudo ufw enable
   sudo ufw allow 80/tcp
   sudo ufw allow 443/tcp
   sudo ufw allow 22/tcp
   ```

4. **Regular Backups:**
   ```bash
   # Backup database
   mysqldump -u root -pAdmin@123 vod_import > backup_$(date +%Y%m%d).sql

   # Backup files
   tar -czf vod_backup_$(date +%Y%m%d).tar.gz /var/www/html/VOD
   ```

---

## 📝 Features Overview

### Import Features:
- ✅ Import from multiple Xtream Codes servers
- ✅ Automatic TMDB metadata enrichment
- ✅ Episode and season management
- ✅ Category and genre organization
- ✅ Import history and logs

### Content Management:
- ✅ Search and filter series/movies
- ✅ Genre-based filtering (23+ genres)
- ✅ Year-based filtering
- ✅ Bulk operations
- ✅ Edit metadata

### Download Features:
- ✅ Remote server integration
- ✅ Download queue management
- ✅ Progress tracking (speed, time remaining)
- ✅ Automatic retry on failure
- ✅ Python-based smart downloader

### User Interface:
- ✅ Responsive Bootstrap 5 design
- ✅ Dark/light theme support
- ✅ Real-time updates
- ✅ Mobile-friendly
- ✅ Fast client-side filtering

---

## 🎬 Supported Features

### Xtream Codes API:
- ✅ Series import
- ✅ Movie import
- ✅ Live streams support
- ✅ EPG data
- ✅ VOD categories

### TMDB Integration:
- ✅ Automatic metadata fetching
- ✅ Posters and backdrops
- ✅ Cast and crew information
- ✅ Ratings and reviews
- ✅ Genre information

---

## 💡 Tips for Best Performance

1. **Increase PHP Memory for Large Imports:**
   ```bash
   sudo nano /etc/php/7.4/apache2/php.ini
   # Set: memory_limit = 1024M
   sudo systemctl restart apache2
   ```

2. **Optimize MySQL:**
   ```bash
   sudo nano /etc/mysql/mysql.conf.d/mysqld.cnf
   # Add under [mysqld]:
   # innodb_buffer_pool_size = 1G
   sudo systemctl restart mysql
   ```

3. **Use Cron for Automated Imports:**
   ```bash
   sudo crontab -e
   # Add:
   # 0 2 * * * php /var/www/html/VOD/workers/cron.php
   ```

---

## 📞 Support

### Documentation:
- Located in `/var/www/html/VOD/` directory
- Key files:
  - `QUICK_REFERENCE.md` - Quick usage guide
  - `SYSTEM_STATUS.md` - System information
  - `CATEGORY_FILTER_WORKING.md` - Category filter guide

### Common Issues:
- Check Apache error logs: `/var/log/apache2/error.log`
- Check MySQL status: `systemctl status mysql`
- Check PHP version: `php -v` (should be 7.4)

---

## 🎯 Quick Start Summary

```bash
# 1. Extract
tar -xzf VOD_Panel_Complete.tar.gz

# 2. Install
cd VOD && sudo bash INSTALL.sh

# 3. Access
http://YOUR_SERVER_IP/VOD/

# 4. Login
Username: admin
Password: admin

# 5. Add Server & Import Content
```

---

## ✅ Installation Complete Checklist

After installation, verify:

- [ ] Can access `http://YOUR_SERVER_IP/VOD/`
- [ ] Can login with admin/admin
- [ ] Apache is running: `systemctl status apache2`
- [ ] MySQL is running: `systemctl status mysql`
- [ ] Database exists: `mysql -u root -pAdmin@123 -e "SHOW DATABASES;"`
- [ ] PHP 7.4 is active: `php -v`
- [ ] Can add Xtream server
- [ ] Can import series
- [ ] Can view episodes

---

**Package Version:** 1.0
**Last Updated:** 2025-11-25
**PHP Version:** 7.4
**MySQL Version:** 8.0
**Apache Version:** 2.4

**Enjoy your VOD Panel!** 🎬🍿
