# استكشاف أخطاء عرض المسلسلات

## المشكلة
الواجهة تعرض "No Series Found" رغم وجود 6,909 مسلسل في قاعدة البيانات.

## التحقق من أن API يعمل

### 1. اختبار API مباشرة
```bash
curl "http://localhost/VOD/api/series?limit=10"
```
يجب أن يعيد 10 مسلسلات.

### 2. اختبار من المتصفح
افتح:
```
http://15.204.231.210/VOD/api/series?limit=10
```

## الحلول المحتملة

### الحل 1: تنظيف Cache المتصفح
1. افتح الواجهة: http://15.204.231.210/VOD/
2. اضغط `Ctrl + Shift + R` (أو `Cmd + Shift + R` على Mac)
3. أو امسح cache المتصفح بالكامل

### الحل 2: فحص Console Errors
1. افتح Developer Tools (F12)
2. اذهب إلى Console tab
3. إذا وجدت أخطاء، أرسلها للمطور

### الحل 3: فحص Network Tab
1. افتح Developer Tools (F12)
2. اذهب إلى Network tab
3. حدث الصفحة
4. ابحث عن طلب `series?limit=...`
5. تحقق من:
   - Status Code (يجب أن يكون 200)
   - Response (يجب أن يحتوي على بيانات)

## التحقق من البيانات

```bash
# عدد المسلسلات
mysql -u root -p'Admin@123' vod_import -e "SELECT COUNT(*) FROM series;"

# عدد المسلسلات مع حلقات
mysql -u root -p'Admin@123' vod_import -e "SELECT COUNT(*) FROM series WHERE episodes_count > 0;"

# أول 5 مسلسلات
mysql -u root -p'Admin@123' vod_import -e "SELECT id, title, episodes_count FROM series ORDER BY id DESC LIMIT 5;"
```

## إذا استمرت المشكلة

### طريقة الوصول البديلة - عبر API مباشرة

يمكنك الوصول للمسلسلات عبر API مباشرة:

```
http://15.204.231.210/VOD/api/series?limit=50
http://15.204.231.210/VOD/api/series/newest?limit=20
http://15.204.231.210/VOD/api/series/6909  (مسلسل محدد)
```

### تحديث الواجهة
```bash
# مسح opcache
curl http://localhost/VOD/clear_opcache.php

# إعادة تشغيل Apache
sudo systemctl restart apache2
```
