#!/bin/bash

#############################################
# Quick MySQL Fix Script
# سكربت سريع لإصلاح MySQL
#############################################

echo "=========================================="
echo "  MySQL Password Fix Script"
echo "  سكربت إصلاح كلمة مرور MySQL"
echo "=========================================="
echo ""

# Check if running as root
if [ "$EUID" -ne 0 ]; then
    echo "❌ Please run as root (sudo bash FIX_MYSQL.sh)"
    echo "❌ يرجى التشغيل كمدير (sudo bash FIX_MYSQL.sh)"
    exit 1
fi

# Variables
MYSQL_ROOT_PASSWORD="Admin@123"

echo "🔧 Setting MySQL root password to: $MYSQL_ROOT_PASSWORD"
echo "🔧 تعيين كلمة مرور MySQL إلى: $MYSQL_ROOT_PASSWORD"
echo ""

# Method 1: Try with sudo (for auth_socket)
echo "📌 Method 1: Using sudo mysql..."
sudo mysql -e "ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY '$MYSQL_ROOT_PASSWORD';" 2>/dev/null
if [ $? -eq 0 ]; then
    sudo mysql -e "FLUSH PRIVILEGES;"
    echo "✅ Success with sudo mysql"
    echo ""
    echo "🔑 MySQL Root Password: $MYSQL_ROOT_PASSWORD"
    echo "✅ تم تعيين كلمة المرور بنجاح"
    exit 0
fi

# Method 2: Try without password
echo "📌 Method 2: Using mysql without password..."
mysql -e "ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY '$MYSQL_ROOT_PASSWORD';" 2>/dev/null
if [ $? -eq 0 ]; then
    mysql -e "FLUSH PRIVILEGES;"
    echo "✅ Success without password"
    echo ""
    echo "🔑 MySQL Root Password: $MYSQL_ROOT_PASSWORD"
    echo "✅ تم تعيين كلمة المرور بنجاح"
    exit 0
fi

# Method 3: Try mysqladmin
echo "📌 Method 3: Using mysqladmin..."
mysqladmin -u root password "$MYSQL_ROOT_PASSWORD" 2>/dev/null
if [ $? -eq 0 ]; then
    echo "✅ Success with mysqladmin"
    echo ""
    echo "🔑 MySQL Root Password: $MYSQL_ROOT_PASSWORD"
    echo "✅ تم تعيين كلمة المرور بنجاح"
    exit 0
fi

# Method 4: Manual method
echo "📌 Method 4: Manual configuration..."
echo ""
echo "⚠️ Automatic methods failed. Please try manual method:"
echo "⚠️ فشلت الطرق التلقائية. يرجى تجربة الطريقة اليدوية:"
echo ""
echo "1. Stop MySQL:"
echo "   sudo systemctl stop mysql"
echo ""
echo "2. Start MySQL in safe mode:"
echo "   sudo mysqld_safe --skip-grant-tables &"
echo ""
echo "3. Login to MySQL:"
echo "   mysql -u root"
echo ""
echo "4. Run these commands:"
echo "   FLUSH PRIVILEGES;"
echo "   ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY 'Admin@123';"
echo "   FLUSH PRIVILEGES;"
echo "   exit"
echo ""
echo "5. Restart MySQL:"
echo "   sudo systemctl restart mysql"
echo ""
echo "6. Test connection:"
echo "   mysql -u root -pAdmin@123 -e \"SELECT 1;\""
echo ""

exit 1
