<?php 
$time_start = microtime(true);
error_reporting(1);
// Disable gzip compression for consistent XOR encrypted responses
// ob_start('ob_gzhandler');
ob_start();
@date_default_timezone_set('Asia/Gaza');
include('./api_cfg_v6.php');
include('./API6Core.php');

// Debug logging function
function debug_log($message, $data = null) {
    global $_CFG;
    if(isset($_CFG['debug']) && $_CFG['debug']) {
        $log_message = date('[Y-m-d H:i:s] ') . $message;
        if($data !== null) {
            $log_message .= ': ' . (is_array($data) || is_object($data) ? json_encode($data) : $data);
        }
        error_log($log_message);
        @file_put_contents('./logs/debug_' . date('Y-m-d') . '.log', $log_message . "\n", FILE_APPEND | LOCK_EX);
    }
}

// Log request for debugging
if(isset($_CFG['debug']) && $_CFG['debug']) {
    $data = "------------POST-----------------\n";
    foreach($_POST as $key => $val) {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= "------------_REQUEST-----------------\n";
    foreach($_REQUEST as $key => $val) {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= ('------------PHP/INPUT=' . file_get_contents('php://input') . "\n");
    $data .= "------------END--POST-----------------\n";
    $data .= "---------SERVER------------\n";
    foreach($_SERVER as $key => $val) {
        $data .= ($key . '=>' . $val . "\n");
    }
    $data .= "========END========REQUEST========\n\n";
    @file_put_contents('./logs/' . $_SERVER['REMOTE_ADDR'] . '_.log', $data, FILE_APPEND | LOCK_EX);
}

class APIv6 extends API6Core
{
    // Flag to determine if responses should be XOR encrypted
    //private $useXorEncryption = true;
     
    public function __construct()
    {
        global $_CFG;
        
        debug_log("API Request received");
        
        // Check for the JSON data in the raw input first
        $raw_input = file_get_contents('php://input');
        debug_log("Raw input received", substr($raw_input, 0, 200));
        
        // Initialize input data
        $json = null;
        
        // Try to parse as direct JSON first
        if(!empty($raw_input)) {
            $direct_json = json_decode($raw_input, true);
            if(is_array($direct_json) && isset($direct_json['mode'])) {
                debug_log("Successfully parsed direct JSON input");
                $json = $direct_json;
                $this->useXorEncryption = false; // Response should match input format
            }
        }
        
        // If no direct JSON, check for XOR encrypted data
        if($json === null) {
            debug_log("No direct JSON found, checking for XOR encrypted data");
            
            // Check if POST data contains json parameter
            if(!isset($_POST['json'])) {
                debug_log("No 'json' parameter found in POST data");
                
                // Parse raw input for POST-like format
                if(preg_match('/json=([^&]+)/', $raw_input, $matches)) {
                    $_POST['json'] = urldecode($matches[1]);
                    debug_log("Extracted json parameter from raw input");
                } else {
                    // Fall back to checking for direct JSON again, as a last resort
                    $potentially_json = json_decode($raw_input, true);
                    if(is_array($potentially_json) && isset($potentially_json['mode'])) {
                        debug_log("Found JSON directly in raw input");
                        $json = $potentially_json;
                        $this->useXorEncryption = false;
                    } else {
                        debug_log("No valid input data found");
                        $this->_die('error: you did not send the POSTFIELDS: json=xor_encrypted_data');
                    }
                }
            }
            
            // If json parameter is found, try to decrypt it
            if(isset($_POST['json']) && $json === null) {
                debug_log("Found json parameter, trying to decrypt");
                
                try {
                    // PHP already URL-decodes $_POST data, so don't decode again
                    $encryptedData = $_POST['json'];
                    $jsonRow = $this->runXOR($encryptedData);
                    
                    // Try to parse the decrypted data
                    $json = json_decode($jsonRow, true);
                    
                    if(!is_array($json)) {
                        debug_log("Failed to parse JSON after XOR decryption", substr($jsonRow, 0, 200));
                        $this->_die('error: converting json data. Data you sent is: ' . substr($jsonRow, 0, 100) . "...\n\r");
                    } else {
                        debug_log("Successfully decrypted and parsed XOR data");
                        $this->useXorEncryption = true;
                    }
                } catch(Exception $e) {
                    debug_log("Exception during XOR decryption", $e->getMessage());
                    $this->_die('error: decryption failed: ' . $e->getMessage());
                }
            }
        }
        
        // At this point, $json should contain the parsed data
        if($json === null) {
            debug_log("Failed to parse input data");
            $this->_die('error: could not parse input data');
        }
        
        // Validate required fields based on the mode
        $token_auth_modes = [
            'movies_cat', 'movies_latest', 'movies_list', 'movies_netflix', 'movies_trends', 'movies_info',
            'series_cat', 'series_latest', 'series_list', 'series_info', 'series_episodes',
            'packages', 'channels', 'kids', 'trends', 'trends_cat', 'trends_list', 'movies_shahid', 'movies_top', 'series_top'
        ];
        
        debug_log("Input data", $json);
        
        // Check mode
        if(!isset($json['mode']) || trim($json['mode']) == '') {
            debug_log("No mode specified in input data");
            $this->_die('error: no mode');
        }
        
        $json['mode'] = trim($json['mode']);
        debug_log("Mode found: " . $json['mode']);
        
        // Check if we can use token authentication
        $using_token_auth = false;
        if(in_array($json['mode'], $token_auth_modes) && isset($json['token']) && !empty($json['token'])) {
            debug_log("Token authentication available for mode: " . $json['mode']);
            $using_token_auth = true;
        }
        
        // Check required fields if not using token authentication
        if(!$using_token_auth) {
            if(!isset($json['code'])) {
                debug_log("Missing code parameter");
                $this->_die('error: no code');
            }
            if(!isset($json['mac'])) {
                debug_log("Missing mac parameter");
                $this->_die('error: no mac');
            }
            if(!isset($json['sn'])) {
                debug_log("Missing serial parameter");
                $this->_die('error: no serial');
            }
        }
        
        // Store all JSON parameters in class properties
        foreach($json as $key => $value) {
            if(property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
        
        // Connect to database and load configuration
        $this->mac_enable = true;
        $this->connect();
        $this->config();
        
        // Validate token if using token authentication
        if($using_token_auth) {
            debug_log("Validating token authentication");
            if(!$this->validateToken($json['token'])) {
                debug_log("Token validation failed");
                $this->_die('error: invalid or expired token');
            }
        } else {
            // Traditional authentication - sanitize inputs
            $this->code = mysqli_real_escape_string($this->link, $json['code']);
            $this->mac = mysqli_real_escape_string($this->link, $json['mac']);
            $this->sn = mysqli_real_escape_string($this->link, $json['sn']);
        }
        
        $this->chipid = mysqli_real_escape_string($this->link, $this->chipid ?? '');
        $this->model = mysqli_real_escape_string($this->link, $this->model ?? '');
        $this->firmware_ver = mysqli_real_escape_string($this->link, $this->firmware_ver ?? '');
        
        // Set up other required properties
        $this->ip = $this->ip();
        $this->get_free_codes();
        $this->getMasterCodes();
        $this->capture();
        
        $this->iptv_stream_host = trim($this->conf['iptv_host']);
        if(!is_dir('./cache/')) {
            $this->cache = false;
        }
        
        // Store the data for access by other methods
        $_POST['data'] = $json;
        $_POST['mode'] = $json['mode'];
    }
    
    // Validate token authentication
    public function validateToken($token) {
        // Basic validation to make sure we have a string
        if(empty($token) || !is_string($token)) {
            return false;
        }
        
        // Escape the token for SQL query
        $token = mysqli_real_escape_string($this->link, $token);
        
        // Look up the token
        $sql = "SELECT u.id, u.username, u.password, u.exp_date, u.admin_enabled, u.enabled 
                FROM user_tokens t 
                JOIN users u ON t.user_id = u.id 
                WHERE t.token = '$token' 
                AND t.expires > " . time();
        
        debug_log("Executing token validation query", $sql);
        $result = $this->query($sql);
        
        if(mysqli_num_rows($result) === 0) {
            debug_log("Token not found or expired");
            return false;
        }
        
        $user = mysqli_fetch_assoc($result);
        
        // Check if user account is active
        if($user['enabled'] != 1 || $user['admin_enabled'] != 1) {
            debug_log("User account is disabled");
            return false;
        }
        
        // Check if account is expired
        if(time() > $user['exp_date']) {
            debug_log("User account is expired");
            return false;
        }
        
        // Store the user credentials for use in other methods
        $this->user = $user['username'];
        $this->pass = $user['password'];
        
        // Update last used timestamp for the token
        $this->query("UPDATE user_tokens SET last_used = " . time() . " WHERE token = '$token'");
        
        debug_log("Token validation successful for user: " . $this->user);
        return true;
    }
    
    // Override msg method to handle both encrypted and unencrypted responses
    public function msg($array, $msg = '', $cache_file = '')
    {
        global $_CFG;
        $this->html_header();
        
        // Convert the response to JSON
        $data = json_encode($array, JSON_UNESCAPED_SLASHES);
        
        // Handle caching if requested
        if($cache_file != '' && $this->cache) {
            $this->cache_file($data, $cache_file, true);
        }
        
        // Log the message if provided
        if($msg != '') {
            $this->log($msg);
        }
        
        debug_log("Sending response", [
            'encryption' => $this->useXorEncryption ? 'XOR' : 'None',
            'response_sample' => substr($data, 0, 100) . '...'
        ]);
        
        // Send the response with or without encryption
        if($this->useXorEncryption) {
            echo $this->runXOR($data);
        } else {
            echo $data;
        }
        
        exit();
    }
    
    // Override _die to respect the encryption setting
    public function _die($msg)
    {
        debug_log("API Error: " . $msg);
        
        if($this->useXorEncryption) {
            echo $this->runXOR($msg);
        } else {
            echo json_encode(['error' => $msg, 'status' => 999]);
        }
        
        exit();
    }

    // All other methods from the original class...
    // active(), login(), series_list(), etc. 

    // Include the full active method from the original code
    public function active()
    {
        global $_CFG;
        
        debug_log("active() method called");
        
        // Get the current code, serial number, MAC address, and IP
        $code = $this->code;
        $sn = $this->sn;
        $mac = $this->mac;
        $ip = $this->ip();
        
        // Initialize the response array with all expected fields
        $response = [
            'status' => 103, // Default to error status
            'server_name' => 'V6apk',
            'apk_ver_code' => $this->conf['apk_ver_code'] ?? '',
            'message' => 'The Code is not Found!',
            'osd_msg' => '',
            'osd_msg_global' => '',
            'expire' => '',
            'user_agent' => '',
            'username' => '',
            'password' => '',
            'allowed_output_formats' => [],
            'max_connections' => 0,
            'host' => '',
            'player_api' => '',
            'epg_api' => '',
            'code_id' => '',
            'force_update' => $this->conf['force_update'] ?? 0,
            'update_url' => $this->conf['update_url'] ?? '',
            'apk_page' => $this->conf['apk_page'] ?? '',
            'update_ch' => 'true',
            'timezone' => $this->conf['timezone'] ?? 'Europe/Berlin',
            'server_info' => [],
            'total_streams' => 0,
            'total_movies' => 0,
            'total_series' => 0,
            'token' => '',
            'debug' => ''
        ];
        
        // Check for free codes
        if(in_array($code, $this->free_codes)) {
            debug_log("Processing free code: " . $code);
            $this->proccess_free_code($code, $sn, $mac, $ip);
            // The above function will call msg() which exits, so no need for further processing
        }
        
        // Determine query type (code, MAC, or serial)
        $why_worng_code = '';
        $qry = $sql_grp = '';
        $txt = 'byCode';
        $codeMacQry = 'c.userid=u.id';
        
        if(isset($this->MasterCodes[$code])) {
            if($this->MasterCodes[$code] == 1) {
                $qry = ' AND mac=\'' . $this->mac . '\'';
                $txt = 'byMAC';
                $codeMacQry = 'c.userid=u.id';
            } else if($this->MasterCodes[$code] == 2) {
                $qry = ' AND serial=\'' . $this->sn . '\'';
                $txt = 'bySerial';
                $codeMacQry = 'c.userid=u.id';
            }
        }
        
        // Get group info if needed
        if(isset($_CFG['enable_group']) && $_CFG['enable_group'] == 'Yes') {
            $sql_grp = ',(SELECT group_id from solus_admin adm where adm.adminid=cod.adminid) AS groupID';
        }
        
        // Look up the code in the database
        $sql_code = $this->query('SELECT * ' . (' ' . $sql_grp . ' ') . ' from ' . PREFIX . ('_codes cod where cod.code=\'' . $code . '\' ' . $qry . ';'));
        if(mysqli_num_rows($sql_code) == 1) {
            $row_code = mysqli_fetch_array($sql_code);
            $code_status = $row_code['status'];
            $code_replaced = $row_code['code_replaced'];
            $groupID = intval($row_code['groupID'] ?? 0);
            
            // Check if code belongs to the right group
            if($groupID != 0 && isset($_CFG['enable_group']) && $_CFG['enable_group'] == 'Yes' && intval($GLOBALS['GROUP'] ?? 0) != 0 && $groupID != $GLOBALS['GROUP']) {
                $response['status'] = 119;
                $response['message'] = 'This code is not for this Brand.';
                $this->msg($response, '@CodeNotForBrand');
                return;
            }
            
            // Check MAC and SN match if code is active
            if($code_status == 1) {
                if($this->mac != $row_code['mac']) {
                    $why_worng_code = ' MAC not match ';
                }
                if($this->sn != $row_code['serial']) {
                    $why_worng_code .= ' SN not match ';
                }
            }
            
            // Handle reset_me codes and replaced codes
            if($row_code['inputBy'] == 0) {
                if($row_code['mac'] == 'reset_me' && $row_code['serial'] == 'reset_me') {
                    $this->query('update ' . PREFIX . ('_codes set mac=\'' . $mac . '\',serial=\'' . $sn . '\' where id=\'' . $row_code['id'] . '\';'));
                }
                if($code_replaced != '' && $code_status == 5) {
                    $response['status'] = 115;
                    $response['message'] = 'Code is replaced. Please use this code: ' . $code_replaced;
                    $this->msg($response, '@Replaced');
                    return;
                }
            }
            
            // Handle code based on status
            if($code_status == 0) {
                // Activate new code
                debug_log("Activating new code: " . $code);
                $this->activate_new_code_enhanced($row_code);
                return;
            } else if($code_status == 2) {
                $response['status'] = 102;
                $response['message'] = 'The Code is suspended';
                $this->msg($response, '@Suspended ' . $txt);
                return;
            } else if($code_status == 3) {
                $response['status'] = 103;
                $response['message'] = 'The Code is Deleted!';
                $this->msg($response, '@Deleted ' . $txt);
                return;
            }
        } else {
            $this->insertIP('notfound');
            $response['status'] = 103;
            $response['message'] = 'The Code is not Found!';
            $this->msg($response, '@Wrong ' . $txt);
            return;
        }
        
        // Get user info for this code
        $qry = 'SELECT c.id, c.code, c.userid, c.date_expire, c.status, c.osd_msg, u.* FROM solus_codes c, users u ' . 
               (' WHERE c.userid=u.id AND c.code = \'' . $code . '\' AND c.mac=\'' . $this->mac . '\' AND c.serial=\'' . $this->sn . '\';');
        $result = $this->query($qry);
        
        if(mysqli_num_rows($result) == 0) {
            $response['status'] = 103;
            $response['message'] = 'The Code is Not valid for this device.';
            $this->msg($response, '@NotValidForDevice ' . $txt . ' ' . $why_worng_code);
            return;
        }
        
        $row = mysqli_fetch_array($result);
        $username = $row['username'];
        $password = $row['password'];
        $this->user = $username;
        $this->pass = $password;
        $this->code_id = $row['id'];
        $userid = intval($row['userid']);
        $status = intval($row['status']);
        $expire = date('Y-m-d', $row['date_expire']);
        
        // Check if expired
        if($expire < date('Y-m-d')) {
            $status = 4;
        }
        
        // Handle status
        switch($status) {
            case 1:
                // Code is active, update password if needed
                if(isset($_CFG['update_password']) && $_CFG['update_password'] == 'yes') {
                    $password = $this->generateRandomString(10);
                    $this->query('UPDATE `users` set `password`=\'' . $password . '\' where `id`=' . $userid . ';');
                    $this->pass = $password;
                }
                
                // Update protocol
                $this->query('UPDATE solus_codes set protocol=6 where id=' . $this->code_id . ';');
                
                // Get server info
                $timezone = $this->conf['timezone'] ?? 'Europe/Berlin';
                date_default_timezone_set($timezone);
                
                // Always use HTTPS (Cloudflare)
                $server_protocol = "https";
                $url = isset($_CFG['url']) && !empty($_CFG['url']) ? $_CFG['url'] : $_SERVER['HTTP_HOST'] ?? '204.188.233.170';
                $port = isset($_CFG['port']) && !empty($_CFG['port']) ? ":" . $_CFG['port'] : ':' . ($_SERVER['SERVER_PORT'] ?? '80');
                
                // Get allowed output formats
                $allowed_formats = json_decode($row['allowed_output_formats'] ?? '[]', true);
                if(!is_array($allowed_formats) || count($allowed_formats) == 0) {
                    $allowed_formats = ["m3u8", "ts"]; // Default formats
                }
                
                // Get active connections count
                $sql_connections = "SELECT COUNT(*) as active_connections FROM user_activity 
                                    WHERE user_id = {$userid} AND date_end IS NULL";
                $result_connections = $this->query($sql_connections);
                $connections = mysqli_fetch_assoc($result_connections);
                $active_connections = $connections['active_connections'] ?? 0;
                
                // Generate token
                $token = md5(uniqid() . $username . time()) . base64_encode(random_bytes(64));
                
                // Record token in database for future use
                $this->insert('user_tokens', [
                    'user_id' => $userid,
                    'token' => $token,
                    'created' => time(),
                    'expires' => time() + (86400 * 7), // 7 days
                    'ip' => $this->ip(),
                    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
                ]);
                $this->query("UPDATE users SET enabled = 1, admin_enabled = 1 WHERE id = {$userid}");

                // Build the complete response
                $response = [
                    'status' => 100,
                    'server_name' => 'V6apk',
                    'apk_ver_code' => $this->conf['apk_ver_code'] ?? '',
                    'message' => 'The Code is active',
                    'osd_msg' => $this->osd ?? '',
                    'osd_msg_global' => $this->conf['global_message'] ?? '',
                    'expire' => $this->expire_date($row['date_expire']),
                    'user_agent' => trim($this->conf['user_agent']),
                    'username' => $username,
                    'password' => $password,
                    'allowed_output_formats' => $allowed_formats,
                    'max_connections' => intval($row['max_connections'] ?? 1),
                    'active_connections' => intval($active_connections),
                    'host' => $server_protocol . '://' . $url . $port,
                    'player_api' => $server_protocol . '://' . $url . $port . '/player_api.php',
                    'epg_api' => $server_protocol . '://' . $url . $port . '/epg/{stream_id}.json?user={user}&pass={pass}',
                    'code_id' => intval($this->code_id),
                    'force_update' => $this->conf['force_update'] ?? 0,
                    'update_url' => $this->conf['update_url'] ?? '',
                    'apk_page' => $this->conf['apk_page'] ?? '',
                    'update_ch' => 'true',
                    'timezone' => $timezone,
                    'server_info' => [
                        'server_protocol' => $server_protocol,
                        'url' => $url,
                        'port' => $port,
                        'https_port' => $port,
                        'timezone' => $timezone,
                        'timestamp_now' => time(),
                        'time_now' => date('Y-m-d H:i:s')
                    ],
                    'total_streams' => 0,
                    'total_movies' => 0,
                    'total_series' => 0,
                    'token' => $token
                ];
                
                debug_log("Code activated successfully", $response);
                $this->insertModel();
                $this->msg($response, 'ReActivation');
                break;
                
            case 2:
                $response['status'] = 102;
                $response['message'] = 'The Code is suspended';
                $this->msg($response, '@Suspended');
                break;
                
            case 3:
                $response['status'] = 103;
                $response['message'] = 'The Code is Deleted';
                $this->msg($response, '@Deleted Code');
                break;
                
            case 4:
                $response['status'] = 104;
                $response['message'] = 'The Code is Expired';
                $this->msg($response, '@Expired Code');
                break;
        }
    }


// Enhanced version of activate_new_code that returns detailed information
public function activate_new_code_enhanced($row)
{
    global $_CFG;
    
    // First check if we need to use multi_code functionality
    if($this->conf['multi_code'] == 1) {
        $this->activate_new_code_on_same_box($row);
        // The above function will handle messaging and exiting if successful
    }
    
    // Process the activation
    $days = intval($row['days']);
    $period = intval($row['period']);
    $free_days = intval($row['free_days']);
    $code = trim($row['code']);
    $fullname = trim($row['fullname']);
    $forced_country = trim($row['forced_country']);
    $codeID = intval($row['id']);
    
    // Calculate expiration date
    if(in_array($period, $this->free)) {
        $dd = $period - 100;
        $exp_date = strtotime('+' . $dd . ' days');
    } else {
        $exp_date = strtotime('+' . $period . ' month');
        if($free_days > 0) {
            $exp_date = strtotime('+' . $free_days . ' days', $exp_date);
        }
    }
    
    // Determine username
    if($row['inputBy'] == 0) {
        $username = $code;
    } else {
        $username = trim($row['username']);
    }
    
    // Set up user data
    $data = [];
    $data['member_id'] = 1;
    $data['username'] = $username;
    $data['password'] = rand() . uniqid();
    $data['exp_date'] = $exp_date;
    $data['admin_notes'] = (string)$fullname . ((($row['inputBy'] == 1 ? ' MAC' : $row['inputBy'] == 2) ? ' SN' : ''));
    $data['admin_enabled'] = 1;
    $data['enabled'] = 1;
    $data['bouquet'] = '[' . $row['bouquets'] . ']';
    $data['max_connections'] = 1;
    $data['created_at'] = time();
    $data['created_by'] = 1;
    $data['forced_country'] = $forced_country;
    if($row['allowed_uagent'] != '') {
        $data['allowed_ua'] = $row['allowed_uagent'];
    }
    
    // Check if user already exists
    $sql = $this->query('SELECT id,username from users where username = \'' . $username . '\' LIMIT 1;');
    if(mysqli_num_rows($sql) == 0) {
        // Create user
        $xtID = $this->insert('users', $data);
        $this->insert('user_output', [
            'user_id' => $xtID,
            'access_output_id' => 2
        ]);
    } else {
        $xrow = mysqli_fetch_array($sql);
        $xtID = $xrow['id'];
    }
    
    // Determine what to update based on inputBy
    if($row['inputBy'] == 0) {
        $whatToUpdate = 'mac=\'' . $this->mac . '\',serial=\'' . $this->sn . '\'';
        $txt = 'Code';
    } else if($row['inputBy'] == 1) {
        $whatToUpdate = 'serial=\'' . $this->sn . '\'';
        $txt = 'MAC';
    } else if($row['inputBy'] == 2) {
        $whatToUpdate = 'mac=\'' . $this->mac . '\'';
        $txt = 'Serial';
    }
    
    // Update code status
    $now = time();
    $up = $this->query('update solus_codes set ' . 
                       (' status=1,' . $whatToUpdate . ',date_start=\'' . $now . '\',date_expire=\'' . $exp_date . '\',userid=\'' . $xtID . '\',protocol=6,model=\'' . $this->model . '\' ') . 
                       (' where id=' . $codeID . ';'));
    
    if($this->link->error != '') {
        $response = [
            'status' => 112,
            'message' => 'Error With Database, Please contact admin. ' . $this->link->error,
            'server_name' => 'V6apk'
        ];
        $this->msg($response, '@Database Error = ' . $this->link->error);
        return;
    }
    
    // Log the activation
    $this->log('Activate By ' . $txt . ' |expire = ' . date('Y-m-d H:i:s', $exp_date));
    
    // Create a new line in the IPTV panel via API
    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'http://204.188.233.170:2087/';
    $api_key = isset($_CFG['api_key']) ? $_CFG['api_key'] : 'eJIdy5sAgD';
    $max_connections = isset($_CFG['max_connections']) ? intval($_CFG['max_connections']) : 1;
    $restreamer = isset($_CFG['restreamer']) ? intval($_CFG['restreamer']) : 0;
    $subscription_plan = isset($_CFG['subscription_plan']) ? intval($_CFG['subscription_plan']) : 1;
    
    // Prepare POST data for API
    $post_data = [
        'api_key' => $api_key,
        'data' => [
            'username' => $username,
            'password' => $data['password'],
            'max_allowed_connections' => $max_connections,
            'allow_m3u' => 1,
            'https' => 1,
            'restreamer' => $restreamer,
            'expire_date' => $exp_date,
            'subscription_plan_id' => $subscription_plan
        ]
    ];
    
    // Perform API Request using cURL
    try {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $panel_url . "api/line/new");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-type: application/x-www-form-urlencoded']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        $api_response = curl_exec($ch);
        curl_close($ch);

        // Log the API response
        $this->log("IPTV Panel API Response: " . $api_response);

        // Parse the response (optional)
        $api_result = json_decode($api_response, true);
        if (isset($api_result['result']) && $api_result['result'] == 'success') {
            $this->log("IPTV Panel line created successfully for user: " . $username);
        } else {
            $this->log("IPTV Panel line creation failed: " . ($api_result['message'] ?? 'Unknown error'));
        }
    } catch (Exception $e) {
        // Log any error
        $this->log("IPTV Panel API Error: " . $e->getMessage());
    }
    
    // Get server info
    $timezone = $this->conf['timezone'] ?? 'Europe/Berlin';
    date_default_timezone_set($timezone);
    
    // Always use HTTPS (Cloudflare)
    $server_protocol = "https";
    $url = isset($_CFG['url']) && !empty($_CFG['url']) ? $_CFG['url'] : $_SERVER['HTTP_HOST'] ?? '204.188.233.170';
    $port = isset($_CFG['port']) && !empty($_CFG['port']) ? ":" . $_CFG['port'] : ':' . ($_SERVER['SERVER_PORT'] ?? '80');

    // Generate token
    $token = md5(uniqid() . $username . time()) . base64_encode(random_bytes(64));

    // Save token to database
    $token_expiry_days = isset($_CFG['token_expiry_days']) ? intval($_CFG['token_expiry_days']) : 7;
    $token_created = time();
    $token_expires = $token_created + (86400 * $token_expiry_days);

    $this->insert('user_tokens', [
        'user_id' => $xtID,
        'token' => $token,
        'created' => $token_created,
        'expires' => $token_expires,
        'ip' => $this->ip(),
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'
    ]);

    debug_log("Token saved for user: " . $username . " (ID: " . $xtID . ")");

    // Default allowed formats
    $allowed_formats = ["m3u8", "ts"];
    
    // Save credentials for future reference
    $this->user = $username;
    $this->pass = $data['password'];
    $this->code_id = $codeID;
    
    // Create the response
    $response = [
        'status' => 100,
        'server_name' => 'V6apk',
        'apk_ver_code' => $this->conf['apk_ver_code'] ?? '',
        'message' => 'The Code has been activated successfully',
        'osd_msg' => (string)$this->osd,
        'osd_msg_global' => $this->conf['global_message'] ?? '',
        'expire' => $this->expire_date($exp_date),
        'user_agent' => trim($this->conf['user_agent']),
        'username' => $username,
        'password' => $data['password'],
        'allowed_output_formats' => $allowed_formats,
        'max_connections' => 1,
        'active_connections' => 0,
        'host' => $server_protocol . '://' . $url . $port,
        'player_api' => $server_protocol . '://' . $url . $port . '/player_api.php',
        'epg_api' => $server_protocol . '://' . $url . $port . '/epg/{stream_id}.json?user={user}&pass={pass}',
        'code_id' => intval($codeID),
        'force_update' => $this->conf['force_update'] ?? 0,
        'update_url' => $this->conf['update_url'] ?? '',
        'apk_page' => $this->conf['apk_page'] ?? '',
        'update_ch' => 'true',
        'timezone' => $timezone,
        'server_info' => [
            'server_protocol' => $server_protocol,
            'url' => $url,
            'port' => $port,
            'https_port' => $port,
            'timezone' => $timezone,
            'timestamp_now' => time(),
            'time_now' => date('Y-m-d H:i:s')
        ],
        'total_streams' => 0,
        'total_movies' => 0,
        'total_series' => 0,
        'token' => $token
    ];


    $this->insertModel();
    $this->msg($response, 'Success ' . $txt);
} 

	
	public function login()
{
    // Get user credentials from POST data
    $username = isset($_POST['data']['user']) ? $_POST['data']['user'] : '';
    $password = isset($_POST['data']['pass']) ? $_POST['data']['pass'] : '';
    $mac = $this->mac;
    $sn = $this->sn;
    
    // Query the database to validate the user
    $sql = "SELECT u.id, u.username, u.password, u.exp_date, u.admin_notes, 
            u.enabled, u.admin_enabled, u.max_connections, u.is_trial, u.created_at,
            u.allowed_output_formats, u.bouquet
            FROM users u 
            WHERE u.username = '$username' AND u.password = '$password' LIMIT 1";
    
    $result = $this->query($sql);
    
    // If user is not found, return error
    if (mysqli_num_rows($result) == 0) {
        $response = [
            'status' => 101,
            'message' => 'Invalid username or password.',
            'server_name' => 'V6apk'
        ];
        $this->msg($response, 'Login failed: Invalid credentials');
        exit();
    }
    
    $user = mysqli_fetch_assoc($result);
    
    // Check if user account is enabled
    if ($user['enabled'] != 1 || $user['admin_enabled'] != 1) {
        $response = [
            'status' => 102,
            'message' => 'Account is disabled.',
            'server_name' => 'V6apk'
        ];
        $this->msg($response, 'Login failed: Account disabled');
        exit();
    }
    
    // Check if account is expired
    if (time() > $user['exp_date']) {
        $response = [
            'status' => 103,
            'message' => 'Account has expired.',
            'server_name' => 'V6apk'
        ];
        $this->msg($response, 'Login failed: Account expired');
        exit();
    }
     
    // Get active connections count
    $sql_connections = "SELECT COUNT(*) as active_connections FROM user_activity 
                        WHERE user_id = {$user['id']} AND date_end IS NULL";
    $result_connections = $this->query($sql_connections);
    $connections = mysqli_fetch_assoc($result_connections);
    $active_connections = $connections['active_connections'];
    
    // Get allowed output formats
    $allowed_formats = json_decode($user['allowed_output_formats'], true);
    if (!is_array($allowed_formats) || count($allowed_formats) == 0) {
        $allowed_formats = ["m3u8", "ts"]; // Default formats
    }
    
    // Get server info
    $timezone = $this->conf['timezone'] ?? 'Europe/Berlin';
    date_default_timezone_set($timezone);
    
    // Always use HTTPS (Cloudflare)
    $server_protocol = "https";
            $url = isset($_CFG['url']) && !empty($_CFG['url']) ? $_CFG['url'] : $_SERVER['HTTP_HOST'] ?? '204.188.233.170';
			$port = isset($_CFG['port']) && !empty($_CFG['port']) ? ":" . $_CFG['port'] : ':' . ($_SERVER['SERVER_PORT'] ?? '80');

    // Log the login
    $this->insert('user_activity', [
        'user_id' => $user['id'],
        'stream_id' => 0,
        'server_id' => 0,
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
        'user_ip' => $this->ip(),
        'date_start' => time(),
        'date_end' => NULL,
        'action' => 'login'
    ]);
    
    // Generate token (simplified version)
    $token = md5(uniqid() . $username . time()) . base64_encode(random_bytes(128));
    
    // Record the token in the database
    $this->insert('user_tokens', [
        'user_id' => $user['id'],
        'token' => $token,
        'created' => time(),
        'expires' => time() + (86400 * 7), // 7 days token expiry
        'ip' => $this->ip(),
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
    ]);
    
    // Check for OSD messages
    $osd_msg = "";
    $osd_global_msg = "";
    $osd = [
        'enable' => 0,
        'title' => '',
        'img' => '',
        'desc' => ''
    ];
    
    // Check for user-specific OSD
    $sql_osd = "SELECT osd_msg FROM solus_codes WHERE userid = {$user['id']} LIMIT 1";
    $result_osd = $this->query($sql_osd);
    if (mysqli_num_rows($result_osd) > 0) {
        $osd_data = mysqli_fetch_assoc($result_osd);
        $osd_msg = $osd_data['osd_msg'];
        
        if (!empty($osd_msg)) {
            $osd['enable'] = 1;
            $osd['desc'] = $osd_msg;
            $osd['title'] = 'Message';
        }
    }
    
    // Check for global OSD
    $sql_global_osd = "SELECT val FROM solus_options WHERE name = 'global_message' LIMIT 1";
    $result_global_osd = $this->query($sql_global_osd);
    if (mysqli_num_rows($result_global_osd) > 0) {
        $global_osd_data = mysqli_fetch_assoc($result_global_osd);
        $osd_global_msg = $global_osd_data['val'];
    }
    
    // Build the response
    $response = [
        'status' => 100,
        'server_name' => 'V6apk',
        'message' => 'Login Success.',
        'osd_msg' => $osd_msg,
        'osd_msg_global' => $osd_global_msg,
        'osd' => $osd,
        'username' => $username,
        'password' => $password,
        'expire' => $this->expire_date($user['exp_date']),
        'is_trial' => intval($user['is_trial']),
        'max_connections' => intval($user['max_connections']),
        'active_connections' => intval($active_connections),
        'user_agent' => trim($this->conf['user_agent']),
        'created_on' => intval($user['created_at']),
        'allowed_output_formats' => $allowed_formats,
        'host' => $server_protocol . '://' . $url . $port,
        'player_api' => $server_protocol . '://' . $url . $port . '/player_api.php',
        'epg_api' => $server_protocol . '://' . $url . $port . '/epg/{stream_id}.json?user={user}&pass={pass}',
        'code_id' => 0,
        'apk_ver_code' => $this->conf['apk_ver_code'] ?? '',
        'force_update' => $this->conf['force_update'] ?? 0,
        'update_url' => $this->conf['update_url'] ?? '',
        'apk_page' => $this->conf['apk_page'] ?? '',
        'update_ch' => 'true',
        'timezone' => $timezone,
        'server_info' => [
            'server_protocol' => $server_protocol,
            'url' => $url,
            'port' => $port,
            'https_port' => $port,
            'timezone' => $timezone,
            'timestamp_now' => time(),
            'time_now' => date('Y-m-d H:i:s')
        ],
        'total_streams' => 0,  // These could be computed with additional queries
        'total_movies' => 0,
        'total_series' => 0,
        'token' => $token
    ];
    
    // Send the response
    $this->msg($response, 'Login successful for user: ' . $username);
}
	
	
	
	
    public function boolVerifyUser($func = '')
    {
        // If user credentials are already set (via token authentication), skip the lookup
        if(!empty($this->user) && !empty($this->pass)) {
            debug_log("boolVerifyUser: Using existing credentials for function: $func");
            return true;
        }

        // First try: lookup by code in solus_codes table
        $sql = 'SELECT c.code,c.adminid,c.transid,c.date_expire,c.status,c.bouquets,c.output,u.username, u.password FROM solus_codes c, users u ' . (' WHERE c.userid=u.id AND c.code = \'' . $this->code . '\' AND c.mac=\'' . $this->mac . '\' AND c.serial=\'' . $this->sn . '\' LIMIT 1;');
        $result = $this->query($sql);
        $num = mysqli_num_rows($result);
        if( $num == 1 )
        {
            $row = mysqli_fetch_array($result);
            $this->adminid = intval($row['adminid']);
            $this->transid = intval($row['transid']);
            $this->user = trim($row['username']);
            $this->pass = trim($row['password']);
            $this->date_expire = trim($row['date_expire']);
            $this->output = trim($row['output']);
            if( $row['bouquets'] != '' )
            {
                $this->bouquets = $row['bouquets'];
            }
            return true;
        }

        // Second try: If code is numeric (Xtream username), lookup in users table directly
        if(preg_match('/^\d{6,}$/', $this->code)) {
            $sql = "SELECT id, username, password, exp_date FROM users WHERE username = '" . mysqli_real_escape_string($this->link, $this->code) . "' LIMIT 1";
            $result = $this->query($sql);
            if(mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                $this->user = trim($row['username']);
                $this->pass = trim($row['password']);
                $this->date_expire = $row['exp_date'] ?? '';
                debug_log("boolVerifyUser: Found user via users table for code: {$this->code}");
                return true;
            }
        }

        $this->error('Error: Something Wrong with code. check MAC/Serial.', 'Code Not found in boolVerifyUser() from : ' . $func);
    }


public function packages()
{
    global $_CFG;

    $this->boolVerifyUser('packages');

    $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'http://204.188.233.170:2087/';
    $username = $this->user;
    $password = $this->pass;

    $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_live_categories";

    try {
        // Use cURL for HTTPS
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        $response = curl_exec($ch);
        curl_close($ch);

        if ($response === false || empty($response)) {
            $this->log("API Request failed for packages: Unable to connect to $api_url");
            return $this->msg([]);
        }

        $streams = json_decode($response, true);
        if (!is_array($streams)) {
            $this->log("API Request failed for packages: Invalid JSON from $api_url");
            return $this->msg([]);
        }

        $categories = [];
        $view_order = 1;

        foreach ($streams as $cat) {
            $cat_id = (string)($cat['id'] ?? $cat['category_id'] ?? '0');
            $cat_name = $cat['category_name'] ?? $cat['name'] ?? "Category {$cat_id}";

            // Detect icon by category name
            $icon = $this->detect_category_icon($cat_name);

            $categories[] = [
                'id' => $cat_id,
                'category_name' => $cat_name,
                'category_type' => 0,
                'category_icon' => $icon,
                'view_order' => $view_order++,
                'ch_count' => isset($cat['stream_count']) ? intval($cat['stream_count']) : 0,
                'stream_count' => isset($cat['stream_count']) ? intval($cat['stream_count']) : 0,
                'isLocked' => isset($cat['parental_lock']) ? (bool)$cat['parental_lock'] : false,
                'parent' => isset($cat['parent_id']) ? (int)$cat['parent_id'] : 0
            ];
        }

        $this->msg($categories);

    } catch (Exception $e) {
        $this->log("Exception in packages(): " . $e->getMessage());
        $this->msg([]);
    }
}




private function detect_category_icon($cat_name)
{
    $name = mb_strtolower($cat_name);
    if (strpos($name, 'bein') !== false) {
        return 'http://pro.netmos.ovh:6051/img/tsawer/bein/beinnews.png';
    }
    if (strpos($name, 'osn') !== false) {
        return 'http://pro.netmos.ovh:6051/img/tsawer/osn/osn.png';
    }
    if (strpos($name, 'kuwait') !== false || strpos($name, 'alkuwait') !== false) {
        return 'http://pro.netmos.ovh:6051/img/tsawer/kuwait.png';
    }
    return 'http://pro.netmos.ovh:6051/img/tsawer/default.png';
}

public function fallback_packages()
{
    $default = [
        [
            'id' => '0',
            'category_name' => 'Live',
            'category_type' => 0,
            'category_icon' => 'http://pro.netmos.ovh:6051/img/tsawer/default.png',
            'view_order' => 0,
            'ch_count' => 0,
            'stream_count' => 0,
            'isLocked' => false,
            'parent' => 0
        ]
    ];
    $this->msg($default);
}
	
    public function lite_packages()
    {
        $CacheFile = '';
        $this->boolVerifyUser('lite_packages');
        if( $this->cache ) 
        {
            $CacheFile = 'lite_pkgs_' . sha1(str_replace(',', '_', $this->bouquets)) . '.txt';
            $this->cache_display($CacheFile);
        }
        $ar = [];
        $bq = explode(',', $this->bouquets);
        if( is_array($bq) ) 
        {
            if( strlen($this->conf['exclude_movies_pkg']) > 1 ) 
            {
                $ex = explode(',', $this->conf['exclude_movies_pkg']);
                $bq = array_diff($bq, $ex);
            }
            $qry = 'SELECT * FROM bouquets  WHERE id IN (' . implode(',', $bq) . ') order by view_order asc;';
            $sql = mysqli_query($this->link, $qry);
            $i = 0;
            while( $row = mysqli_fetch_array($sql) ) 
            {
                $i++;
                $bouquet_channels = @json_decode($row['bouquet_channels'], true);
                $ch_count = @count($bouquet_channels);
                $ar[] = [
                    'pkg_id' => $row['id'], 
                    'pkg_name' => $row['bouquet_name'], 
                    'pkg_icon' => trim($row['bouquet_icon'])
                ];
            }
            $this->msg($ar, '', $CacheFile);
        }
    }
  







  public function lite_channels()
    {
        $CacheFile = '';
        $ar = [];
        $pkg_id = $this->pkg_id;
        if( $pkg_id == 0 ) 
        {
            $ar[] = [
                'stream_id' => 0, 
                'stream_name' => 'error: Package ID is 0', 
                'stream_pkg_id' => 0, 
                'stream_icon' => '', 
                'stream_order' => 0, 
                'stream_url' => ''
            ];
            $this->msg($ar);
        }
        $this->boolVerifyUser('lite_packages');
        if( $this->cache ) 
        {
            $CacheFile = 'lite_chans_' . $pkg_id . '.txt';
            $this->cache_display($CacheFile, true);
        }
        $sql = $this->query('SELECT * FROM bouquets WHERE id=' . $pkg_id . ';');
        $row = mysqli_fetch_array($sql);
        $ar = $this->channels($row['bouquet_channels'], $row['id']);
        $this->msg($ar, '', $CacheFile);
    }
    public function sat2iptv()
    {
        $ar = [];
        $qry = '';
        $this->isSatToIPTV = true;
        if( intval($this->conf['enable_sat2iptv']) == 0 ) 
        {
            exit();
        }
        $this->boolVerifyUser('sat2ip');
        if( isset($this->stb_groups) && count($this->stb_groups) >= 1 ) 
        {
            $qry = ' WHERE stb_group IN (' . implode(',', $this->stb_groups) . ') ';
        }
        if( $this->cache ) 
        {
            $CacheFile = 'sat2iptv.txt';
            $this->cache_display($CacheFile, true);
        }
        $sql = $this->query('SELECT * FROM ' . PREFIX . ('_stb_to_iptv stb ' . $qry . ' order by angle asc, stb_ch_name ASC;'));
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $stream = str_replace([
                '{type}', 
                '{user}', 
                '{pass}', 
                '{ch}'
            ],

			[
                'live', 
                $this->user, 
                $this->pass, 
                $row['ch_id']
            ], trim($this->conf['iptv_host']));
            $ar[] = [
                'channel_name' => $row['stb_ch_name'], 
                'angle' => $row['angle'], 
                'tp' => $row['tp'], 
                'pol' => $row['pol'], 
                'sid' => $row['sid'], 
                'stream_url' => $stream
            ];
        }
        $this->msg($ar, '', $CacheFile);
    }
public function channels()
{
    global $_CFG;

    $this->boolVerifyUser('channels');

    $this->log("channels() called - user: " . $this->user . " pass: " . $this->pass);

    $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'http://flix-panel.xyz:80/';
    $username = $this->user;
    $password = $this->pass;

    $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_live_streams";
    $this->log("channels() API URL: " . $api_url);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);

    if ($response === false || $error) {
        $this->log("Channels API request failed: " . $error);
        return $this->fallback_channels();
    }

    $data = json_decode($response, true);
    if (!is_array($data)) {
        $this->log("Channels API invalid JSON");
        return $this->fallback_channels();
    }

    $formatted = [];
    $order = 1;

    foreach ($data as $item) {
        $id = $item['stream_id'] ?? $item['id'] ?? null;
        $name = $item['name'] ?? null;
        $category_id = $item['category_id'] ?? 0;
        $icon = $item['stream_icon'] ?? $item['logo'] ?? $item['poster'] ?? '';
        $cmd = $item['direct_source'] ?? $item['cmd'] ?? '';
        $tv_archive = $item['tv_archive_duration'] ?? '0';

        if (empty($id) || empty($name)) {
            continue;
        }

        if (empty($icon) || !filter_var($icon, FILTER_VALIDATE_URL)) {
            $icon = 'https://cdn-icons-png.flaticon.com/512/2523/2523641.png';
        }

        // Build stream URL for live channels
        $stream_url = $panel_url . "live/{$username}/{$password}/{$id}.ts";

        $formatted[] = [
            'id' => (string)$id,
            'type' => '1',
            'stream_display_name' => (string)$name,
            'category_id' => (int)$category_id,
            'catid' => (string)$category_id,
            'catid_new' => 'x',
            'stream_icon' => $icon,
            'view_order' => $order++,
            'tv_archive' => (string)$tv_archive,
            'has_epg' => 0,
            'stream_url' => $stream_url
        ];
    }

    if (empty($formatted)) {
        $this->log("Channels API returned empty formatted data");
        return $this->fallback_channels();
    }

    $this->msg($formatted);
}

public function fallback_channels()
{
    $this->msg([]);
}

public function series_cat()
{
    global $_CFG;
    
    // Log before verification
    $this->log("Starting series_cat with user: " . $this->user . " pass: " . $this->pass);
    
    // Verify the user first
    $this->boolVerifyUser('series_cat');
    
    // Get data from the remote API
    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'http://204.188.233.170:2087/';
    $username = $this->user;
    $password = $this->pass;
    
    // Construct the API URL
    $api_url = $panel_url . "player_api.php?username={$username}&password={$password}&action=get_series_categories";

    try {
        // Use cURL for HTTPS
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        $response = curl_exec($ch);
        curl_close($ch);

        if ($response === false || empty($response)) {
            // Handle error - fall back to local database
            $this->log("API Request failed for series_cat: Unable to connect to remote API");
            $this->fallback_series_cat();
            return;
        }

        // Parse the JSON response
        $categories = json_decode($response, true);

        if (!is_array($categories)) {
            // Handle error - fall back to local database
            $this->log("API Request failed for series_cat: Invalid response format");
            $this->fallback_series_cat();
            return;
        }
        
        // Transform the response to match the desired format
        $formatted_categories = [];
        
        foreach ($categories as $category) {
            $formatted_categories[] = [
                'id' => $category['category_id'] ?? $category['id'] ?? '',
                'category_name' => $category['category_name'] ?? $category['name'] ?? '',
                'category_type' => 'series',
                'category_icon' => $category['category_icon'] ?? '',
                'cat_order' => $category['category_order'] ?? '1',
                'isLocked' => $category['parental_lock'] ?? false,
                'stream_count' => $category['series_count'] ?? 0,
                'parent_id' => $category['parent_id'] ?? '0'
            ];
        }
        
        // Send the response
        $this->msg($formatted_categories);
        
    } catch (Exception $e) {
        $this->log("API Request exception for series_cat: " . $e->getMessage());
        $this->fallback_series_cat();
    }
}
 
 // Fallback method if the API request fails
public function fallback_series_cat()
{
    global $_CFG;
    
    if (isset($_CFG['UseIntroSeries']) && $_CFG['UseIntroSeries'] == 'Yes') {
        $this->IntroSeriesCat();
        exit();
    }
    
    if (isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1) {
        $mv = new Movies($this, 'series_cat');
        exit();
    }
    
    $this->movies_cat('series');
}
    public function movies_kids()
    {
        global $_CFG;
        $this->boolVerifyUser('movies_kids');

        // Use Movies class for consistent encryption and format
        if (isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1) {
            $mv = new Movies($this, 'movies_kids');
            exit();
        }

        // Direct panel API integration for kids movies
        require_once(__DIR__ . '/MidnightStreamerAdapter.php');
        $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://flix-panel.xyz:2087/';
        $adapter = new MidnightStreamerAdapter($this->user, $this->pass, $panel_url);

        // Get kids category IDs from config (Movie-Family + Movie-Animation)
        $kids_ids = isset($_CFG['kids_category_ids']) ? $_CFG['kids_category_ids'] : '46,51';
        $cat_array = array_map('trim', explode(',', $kids_ids));

        $all_movies = [];
        $limit = 50;

        foreach ($cat_array as $cat_id) {
            if (count($all_movies) >= $limit) break;
            $movies = $adapter->getMoviesByCategory($cat_id, $limit - count($all_movies));
            if (is_array($movies)) {
                $all_movies = array_merge($all_movies, $movies);
            }
        }

        debug_log("movies_kids: Got " . count($all_movies) . " movies from categories: $kids_ids");
        $this->msg($all_movies);
    }
    public function movies_netflix()
    {
        global $_CFG;
        $this->boolVerifyUser('movies_netflix');

        // Use Movies class for consistent encryption and format
        if (isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1) {
            $mv = new Movies($this, 'movies_netflix');
            exit();
        }

        // Fallback
        $this->msg([]);
    }
    public function music()
    {
        $ex1 = explode(',', $this->conf['vod_music']);
        $ids = implode(',', $ex1);
        if( $ids == '' ) 
        {
            $ids = 0;
        }
        $this->boolVerifyUser('music');
        $qry = $parent = '';
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' ) 
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $ar = [];
        $qry = 'SELECT * FROM `stream_categories` WHERE `category_type` LIKE \'movie\' ' . (' AND parent_id IN (' . $ids . ') ORDER BY ' . $this->CatOrder . ' ');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            $category_icon = trim($row['category_icon']);
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $ar[] = [
                'cat_id' => $row['id'], 
                'cat_name' => $row['category_name'], 
                'cat_icon' => $icon, 
                'music_files' => $this->getMusicFiles($row['id'], $row, $icon)
            ];
        }
        $this->msg($ar);
    }
    public function getMusicFiles($catid, $rowFather, $icon)
    {
        global $_CFG;
        $ar = [];
        $sql = $this->query('SELECT id, stream_display_name,stream_source,  stream_icon, streams.`order` as view_order,target_container FROM streams ' . (' WHERE category_id=' . $catid . ' AND stream_display_name NOT LIKE \'%*%\' ') . ' AND stream_display_name NOT LIKE \'%===%\' ORDER BY id DESC;');
        $i = 0;
        while( $row = mysqli_fetch_array($sql) )
        {
            $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            // Use panel_url with /live/ path
            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';
            $stream = $panel_url . "live/{$this->user}/{$this->pass}/{$row['id']}{$target_container}";
            $ar[] = [
                'id' => $row['id'],
                'title' => $row['stream_display_name'],
                'catid' => (string)$catid,
                'icon' => trim($row['stream_icon']),
                'stream_url' => $stream
            ];
        }
        return $ar;
    }
    public function lite_vod_cat($category_type = 'movie')
    {
        $this->boolVerifyUser('movies_cat');
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' ) 
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $ar = [];
        $qry = 'SELECT * FROM `stream_categories` WHERE `category_type` LIKE \'' . $category_type . '\' ' . (' AND parent_id=0 ORDER BY ' . $this->CatOrder . ' LIMIT 50');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            $category_icon = trim($row['category_icon']);
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $ar[] = [
                'cat_id' => $row['id'], 
                'cat_name' => $row['category_name'], 
                'cat_icon' => $icon, 
                'cat_view_order' => $i
            ];
        }
        $this->msg($ar);
    }
    public function movies_cat($category_type = 'movie', $qryVod = '')
    {
        global $_CFG;

        $this->boolVerifyUser('movies_cat');

        // Use panel API directly for VOD categories
        if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' && $category_type == 'movie' )
        {
            $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : '';
            $api_url = $panel_url . "player_api.php?username={$this->user}&password={$this->pass}&action=get_vod_categories";

            // Use cURL for HTTPS
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            $response = curl_exec($ch);
            curl_close($ch);

            if ($response !== false && !empty($response)) {
                $categories = json_decode($response, true);
                if (is_array($categories) && !empty($categories)) {
                    $formatted = [];
                    foreach ($categories as $cat) {
                        $formatted[] = [
                            'id' => $cat['category_id'] ?? '',
                            'category_name' => $cat['category_name'] ?? '',
                            'category_type' => 'movie',
                            'category_icon' => $cat['category_icon'] ?? '',
                            'cat_order' => $cat['category_order'] ?? '1',
                            'isLocked' => false,
                            'stream_count' => 0,
                            'parent_id' => $cat['parent_id'] ?? '0'
                        ];
                    }
                    $this->msg($formatted);
                    return;
                }
            }
        }

        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 && $category_type == 'movie' )
        {
            $mv = new Movies($this, 'movies_cat');
            exit();
        }
        $qry = $parent = '';
        if( $qryVod == '' && isset($this->conf['remote_movies_use']) && $this->conf['remote_movies_use'] == 1 )
        {
            $ex1 = explode(',', $this->conf['vod_kids'] ?? '');
            $ex2 = explode(',', $this->conf['vod_series'] ?? '');
            $ex3 = explode(',', $this->conf['vod_netflix'] ?? '');
            $excludeIds = array_merge($ex1, $ex2, $ex3);
            $excludeIds = array_filter($excludeIds); // Remove empty values
            if( count($excludeIds) >= 1 )
            {
                $ids = implode(',', $excludeIds);
                if( $ids != '' )
                {
                    $qryVod = ' AND id NOT IN (' . $ids . ')  ';
                }
            }
        }
        if( isset($this->conf['CategoriesOrder']) && $this->conf['CategoriesOrder'] != '' )
        {
            $this->CatOrder = str_replace(':', ' ', $this->conf['CategoriesOrder']);
        }
        $catsBouqts = '';
        if( isset($_CFG['CatFromBouquets']) && $_CFG['CatFromBouquets'] == 'Yes' )
        {
            $bq = explode(',', $this->bouquets);
            $bq = array_filter(array_map('intval', $bq)); // Filter and sanitize IDs
            if (!empty($bq)) {
                $sqlB = $this->query('SELECT * FROM bouquets  WHERE id IN (' . implode(',', $bq) . ') order by view_order asc;');
                $chans = [];
                while( $rowB = mysqli_fetch_array($sqlB) )
                {
                    $bouquet_channels = @json_decode($rowB['bouquet_channels'], true);
                    if (is_array($bouquet_channels)) {
                        foreach( $bouquet_channels as $ch )
                        {
                            if (is_numeric($ch)) {
                                $chans[] = intval($ch);
                            }
                        }
                    }
                }
                if (!empty($chans)) {
                    $catsBouqts = ' AND id in (select category_id from streams where id IN(' . implode(',', $chans) . '))';
                }
            }
        }
        $ar = [];
        $qry = 'SELECT * FROM `stream_categories` WHERE `category_type` LIKE \'' . $category_type . '\' ' . (' AND parent_id=0 ' . $qryVod . ' ' . $catsBouqts . ' ORDER BY ' . $this->CatOrder);
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) )
        {
            $i++;
            $category_icon = isset($row['category_icon']) ? trim($row['category_icon']) : '';
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $cat_order = isset($row['cat_order']) ? intval($row['cat_order']) : 0;
            $ar[] = [
                'cat_id' => $row['id'],
                'cat_name' => $row['category_name'] ?? '',
                'cat_icon' => $icon,
                'cat_view_order' => ($cat_order == 0 ? $i : $cat_order),
                'sub_cats' => $this->subMoviesCat($row['id'], $row, $icon)
            ];
        }
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $ar[] = [
                'cat_id' => 0, 
                'cat_name' => 'error no-series-cat', 
                'cat_icon' => (string)$qry, 
                'cat_view_order' => 0, 
                'sub_cats' => []
            ];
        }
        $this->msg($ar);
    }
    public function subMoviesCat($parent, $rowFather, $iconFather)
    {
        $parent = intval($parent);
        $ar = [];
        $qry = 'SELECT * FROM `stream_categories` WHERE `category_type` LIKE \'movie\' ' . (' AND parent_id=' . $parent . ' ORDER BY ' . $this->CatOrder . ' ');
        $sql = $this->query($qry);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) )
        {
            $i++;
            $category_icon = isset($row['category_icon']) ? trim($row['category_icon']) : '';
            $icon = ($category_icon == '' ? 'http://intro.ps/uploads/logo/movie.png' : $category_icon);
            $cat_order = isset($row['cat_order']) ? intval($row['cat_order']) : 0;
            $ar[] = [
                'sub_id' => $row['id'],
                'sub_name' => $row['category_name'] ?? '',
                'sub_icon' => $icon,
                'sub_view_order' => ($cat_order == 0 ? $i : $cat_order)
            ];
        }
        if( $i == 0 )
        {
            $cat_order_father = isset($rowFather['cat_order']) ? intval($rowFather['cat_order']) : 0;
            $ar[] = [
                'sub_id' => $rowFather['id'] ?? 0,
                'sub_name' => $rowFather['category_name'] ?? '',
                'sub_icon' => $iconFather,
                'sub_view_order' => ($cat_order_father == 0 ? $i : $cat_order_father)
            ];
        }
        return $ar;
    }
    public function movies_list()
    {
        global $_CFG;
        $ar = [];
        $this->boolVerifyUser('movies_list');

        $this->log("movies_list: vod=" . ($_CFG['vod'] ?? 'NOT SET') . " panel_url=" . ($_CFG['panel_url'] ?? 'NOT SET'));

        // Use panel API directly for VOD list
        if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' )
        {
            $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : '';
            $api_url = $panel_url . "player_api.php?username={$this->user}&password={$this->pass}&action=get_vod_streams";
            if ($this->catid && $this->catid != 'all') {
                $api_url .= "&category_id=" . intval($this->catid);
            }

            // Use cURL for HTTPS
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            $response = curl_exec($ch);
            $curl_error = curl_error($ch);
            curl_close($ch);

            $this->log("movies_list panel API response length: " . strlen($response) . " error: " . $curl_error);

            if ($response !== false && !empty($response)) {
                $movies = json_decode($response, true);
                if (is_array($movies)) {
                    $formatted = [];
                    foreach ($movies as $movie) {
                        $stream_id = $movie['stream_id'] ?? '';
                        $ext = $movie['container_extension'] ?? 'mp4';
                        // Build stream URL with /live/ path for token redirect
                        $base_url = $panel_url . "live/{$this->user}/{$this->pass}/{$stream_id}.{$ext}";

                        $formatted[] = [
                            'id' => $stream_id,
                            'stream_display_name' => $movie['name'] ?? '',
                            'category_id' => $movie['category_id'] ?? '',
                            'stream_icon' => $movie['stream_icon'] ?? '',
                            'view_order' => $movie['num'] ?? '0',
                            'stream_url' => $base_url,
                            'rating' => $movie['rating'] ?? '0',
                            'added' => $movie['added'] ?? '',
                            'year' => $movie['year'] ?? '',
                            'views' => 0,
                            'plot' => '',
                            'genre' => '',
                            'cast' => '',
                            'backdrop' => '',
                            'trailer' => ''
                        ];
                    }
                    $this->msg($formatted);
                    return;
                }
            }
        }

        // Fallback to remote Movies class only if panel API fails
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 )
        {
            $mv = new Movies($this, 'movies_list');
            exit();
        }
        $qry = '';
        if( $this->catid == 'all' ) 
        {
        }
        else
        {
            $qry = 'AND category_id=' . intval($this->catid);
        }
        if( intval($this->catid) == 0 && $this->catid != 'all' ) 
        {
            $ar[] = [
                'id' => '', 
                'title' => 'Error: you must pass (catid) in url.', 
                'catid' => '', 
                'icon' => '', 
                'view_order' => '', 
                'stream_url' => ''
            ];
            $this->msg($ar);
        }
        if( isset($this->conf['MoviesOrder']) && $this->conf['MoviesOrder'] != '' ) 
        {
            $movies_order = $this->conf['MoviesOrder'];
        }
        else
        {
            $movies_order = 'streams.`order` ASC';
        }
        $this->SetLimitForBadBox('bad_stb_tot_vod');
        $sql_ch = $this->query('SELECT id, stream_display_name,category_id,stream_source,  stream_icon, streams.`order` as view_order,movie_propeties,target_container FROM `streams` ' . (' WHERE `type`=2 ' . $qry . ' ORDER BY ' . $movies_order . ' ' . $this->limit_qry . ';'));
        $i = 0;
        while( $row = mysqli_fetch_array($sql_ch) ) 
        {
            $i++;
            $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' )
            {
                // Use panel_url with /live/ path for redirect with token
                $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';
                $stream = $panel_url . "live/{$this->user}/{$this->pass}/{$row['id']}{$target_container}";
            }
            else
            {
                // Fallback - also use panel_url
                $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';
                $stream = $panel_url . "live/{$this->user}/{$this->pass}/{$row['id']}{$target_container}";
            }
            if( isset($_CFG['strm_url_rep']) && isset($_CFG['strm_url_with']) ) 
            {
                $stream = str_replace($_CFG['strm_url_rep'], $_CFG['strm_url_with'], $stream);
            }
            $movie_propeties = json_decode($row['movie_propeties'], true);
            if (!is_array($movie_propeties)) {
                $movie_propeties = [];
            }

            if( isset($movie_propeties['movie_image']) && $movie_propeties['movie_image'] != '' )
            {
                $stream_icon = trim($movie_propeties['movie_image']);
            }
            else
            {
                $stream_icon = isset($row['stream_icon']) ? trim($row['stream_icon']) : '';
            }

            $backdrop = $movie_propeties['backdrop_path'] ?? $stream_icon;

            $ar[] = [
                'id' => $row['id'],
                'stream_display_name' => $row['stream_display_name'],
                'trailer' => $movie_propeties['youtube_trailer'] ?? $movie_propeties['trailer'] ?? '',
                'category_id' => $row['category_id'] ?? '',
                'stream_icon' => $stream_icon,
                'backdrop' => $backdrop,
                'view_order' => $i + 1,
                'views' => 0,
                'plot' => $movie_propeties['plot'] ?? '',
                'rating' => (string)($movie_propeties['rating'] ?? '0'),
                'genre' => $movie_propeties['genre'] ?? '',
                'cast' => $movie_propeties['cast'] ?? '',
                'year' => $movie_propeties['releasedate'] ?? $movie_propeties['year'] ?? '',
                'added' => $movie_propeties['added'] ?? (string)time(),
                'stream_url' => $stream
            ];
        }
        if( $i == 0 ) 
        {
            $ar[] = [
                'id' => 0, 
                'title' => 'empty category: this is sample', 
                'catid' => 0, 
                'icon' => 'https://www.sample-videos.com/images/imgw.png', 
                'view_order' => 0, 
                'stream_url' => 'https://www.sample-videos.com/video/mp4/720/big_buck_bunny_720p_5mb.mp4'
            ];
        }
        $this->msg($ar);
    }
    public function series_latest()
    {
        global $_CFG;
        $ar = [];
        $this->boolVerifyUser('series_latest');

        // Use panel API directly
        $panel_url = rtrim($_CFG['panel_url'], '/') . '/';
        $api_url = $panel_url . "player_api.php?username={$this->user}&password={$this->pass}&action=get_series";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($ch);
        curl_close($ch);

        if ($response !== false && !empty($response)) {
            $series = json_decode($response, true);
            if (is_array($series) && !empty($series)) {
                usort($series, function($a, $b) {
                    return ($b['last_modified'] ?? 0) - ($a['last_modified'] ?? 0);
                });
                $series = array_slice($series, 0, 50);

                foreach ($series as $s) {
                    $icon = $s['cover'] ?? '';
                    $backdrop = $icon;
                    if (isset($s['backdrop_path']) && is_array($s['backdrop_path']) && !empty($s['backdrop_path'])) {
                        $backdrop = $s['backdrop_path'][0];
                    }
                    $ar[] = [
                        'id' => $s['series_id'] ?? '',
                        'title' => $s['name'] ?? '',
                        'catid' => $s['category_id'] ?? '',
                        'icon' => $icon,
                        'icon_big' => $icon,
                        'backdrop' => $backdrop,
                        'rating' => $s['rating'] ?? '0',
                        'plot' => $s['plot'] ?? '',
                        'genre' => $s['genre'] ?? '',
                        'cast' => $s['cast'] ?? '',
                        'releaseDate' => $s['releaseDate'] ?? ''
                    ];
                }
            }
        }

        $this->msg($ar);
    }
    public function series_details()
    {
        $this->boolVerifyUser('series_details');
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'series_details');
            exit();
        }
    }
    public function episode_info()
    {
        $this->boolVerifyUser('episode_info');
        if( isset($this->conf['remote_series_use']) && intval($this->conf['remote_series_use']) == 1 ) 
        {
            $mv = new Movies($this, 'episode_info');
            exit();
        }
    }
    public function movies_latest()
    {
        global $_CFG;
        $ar = [];
        $this->boolVerifyUser('movies_latest');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 )
        {
            $mv = new Movies($this, 'movies_latest');
            exit();
        }

        // Get latest movies from local database
        if( isset($this->conf['MoviesOrder']) && $this->conf['MoviesOrder'] != '' )
        {
            $movies_order = $this->conf['MoviesOrder'];
        }
        else
        {
            $movies_order = 'streams.`id` DESC';
        }

        $this->SetLimitForBadBox('bad_stb_tot_vod');
        $sql_ch = $this->query('SELECT id, stream_display_name,category_id,stream_source, stream_icon, streams.`order` as view_order,movie_propeties,target_container FROM `streams` ' .
                               (' WHERE `type`=2 ORDER BY ' . $movies_order . ' ' . $this->limit_qry . ';'));
        $i = 0;
        while( $row = mysqli_fetch_array($sql_ch) )
        {
            $i++;
            $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' )
            {
                // Use panel_url with /live/ path for redirect with token
                $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';
                $stream = $panel_url . "live/{$this->user}/{$this->pass}/{$row['id']}{$target_container}";
            }
            else
            {
                $stream = trim($row['stream_source']);
            }

            $movie_propeties = json_decode($row['movie_propeties'], true);
            if (!is_array($movie_propeties)) {
                $movie_propeties = [];
            }

            if( isset($movie_propeties['movie_image']) && $movie_propeties['movie_image'] != '' )
            {
                $stream_icon = trim($movie_propeties['movie_image']);
            }
            else
            {
                $stream_icon = isset($row['stream_icon']) ? trim($row['stream_icon']) : '';
            }

            $backdrop = $movie_propeties['backdrop_path'] ?? $stream_icon;

            $ar[] = [
                'id' => $row['id'] ?? '',
                'stream_display_name' => $row['stream_display_name'] ?? '',
                'trailer' => $movie_propeties['youtube_trailer'] ?? $movie_propeties['trailer'] ?? '',
                'category_id' => $row['category_id'] ?? '',
                'stream_icon' => $stream_icon,
                'backdrop' => $backdrop,
                'view_order' => isset($row['view_order']) ? (string)intval($row['view_order']) : '0',
                'views' => 0,
                'plot' => $movie_propeties['plot'] ?? '',
                'rating' => (string)($movie_propeties['rating'] ?? '0'),
                'genre' => $movie_propeties['genre'] ?? '',
                'cast' => $movie_propeties['cast'] ?? '',
                'year' => $movie_propeties['releasedate'] ?? $movie_propeties['year'] ?? '',
                'added' => $movie_propeties['added'] ?? (string)time(),
                'stream_url' => $stream
            ];
        }
        $this->msg($ar);
    }
    public function movies_info()
    {
        $this->boolVerifyUser('movies_info');
        global $_CFG;

        // Get movie_id from POST data or class property
        $id = 0;
        if (isset($_POST['data']['movie_id'])) {
            $id = intval($_POST['data']['movie_id']);
        } elseif (isset($this->movie_id)) {
            $id = intval($this->movie_id);
        }
        debug_log("movies_info: Looking for movie ID: " . $id);

        // Check if movie exists locally
        $sql = $this->query('SELECT id, stream_display_name,category_id, stream_source, stream_icon,movie_propeties,target_container FROM `streams` ' . (' WHERE `type`=2 AND id=' . $id . ';'));
        $row = mysqli_fetch_array($sql);

        // If movie not found locally, use MidnightStreamerAdapter
        if (!$row) {
            debug_log("Movie not found locally, using MidnightStreamerAdapter for ID: " . $id);

            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';

            require_once(__DIR__ . '/MidnightStreamerAdapter.php');
            $adapter = new MidnightStreamerAdapter($this->user, $this->pass, $panel_url);
            $result = $adapter->getMovieInfo($id);

            debug_log("movies_info: Got result from adapter: " . (is_array($result) ? count($result) . " items" : "empty"));

            if (is_array($result) && !empty($result)) {
                return $this->msg($result);
            }

            // Fallback: return minimal info with stream URL
            debug_log("movies_info: No data found, returning minimal info");
            $stream = $panel_url . "movie/{$this->user}/{$this->pass}/{$id}.mp4";
            $ar[] = [
                'id' => (int)$id,
                'title' => 'Movie #' . $id,
                'trailer' => '',
                'catid' => 0,
                'icon' => '',
                'backdrop' => [''],
                'stream' => $stream,
                'stream_url' => [
                    '480p' => '',
                    '720p' => $stream,
                    '1080p' => '',
                    '4k' => ''
                ],
                'subtitle' => '',
                'genre' => '',
                'MPAA' => 'n/a',
                'release_date' => '',
                'plot' => '',
                'cast' => '',
                'cast_images' => [],
                'duration' => '',
                'rating' => '0',
                'director' => '',
                'year' => 'N/A',
                'user_rating' => 0,
                'likes' => 0,
                'dislikes' => 0,
                'tmdb_id' => ''
            ];
            return $this->msg($ar);
        }

        $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container'] ?? 'mp4');

        // Handle stream URL building - use panel_url with /live/ path
        if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' )
        {
            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';
            $stream = $panel_url . "live/{$this->user}/{$this->pass}/{$row['id']}{$target_container}";
        }
        else
        {
            // Fallback - also use panel_url
            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';
            $stream = $panel_url . "live/{$this->user}/{$this->pass}/{$row['id']}{$target_container}";
        }

        $movie_propeties = json_decode($row['movie_propeties'], true);
        if (!is_array($movie_propeties)) {
            $movie_propeties = [];
        }

        if( isset($movie_propeties['movie_image']) && $movie_propeties['movie_image'] != '' )
        {
            $stream_icon = trim($movie_propeties['movie_image']);
        }
        else
        {
            $stream_icon = isset($row['stream_icon']) ? trim($row['stream_icon']) : '';
        }

        $backdrop_path = $movie_propeties['backdrop_path'] ?? $stream_icon;

        $ar[] = [
            'id' => $row['id'],
            'title' => $row['stream_display_name'],
            'trailer' => $movie_propeties['youtube_trailer'] ?? $movie_propeties['trailer'] ?? '',
            'catid' => isset($row['category_id']) ? intval($row['category_id']) : 0,
            'icon' => $stream_icon,
            'backdrop' => [$backdrop_path],
            'stream' => $stream,
            'stream_url' => [
                '480p' => '',
                '720p' => $stream,
                '1080p' => '',
                '4k' => ''
            ],
            'subtitle' => '',
            'genre' => $movie_propeties['genre'] ?? '',
            'MPAA' => 'n/a',
            'release_date' => $movie_propeties['release_date'] ?? $movie_propeties['releasedate'] ?? '',
            'plot' => $movie_propeties['plot'] ?? '',
            'cast' => $movie_propeties['cast'] ?? '',
            'cast_images' => [],
            'duration' => $movie_propeties['duration'] ?? '',
            'rating' => (string)($movie_propeties['rating'] ?? '0'),
            'director' => $movie_propeties['director'] ?? '',
            'year' => 'N/A',
            'user_rating' => 0,
            'likes' => 0,
            'dislikes' => 0,
            'tmdb_id' => (string)($movie_propeties['tmdb_id'] ?? '')
        ];
        $this->msg($ar);
    }
    public function series_netflix()
    {
        $catids = $this->conf['vod_series'];
        $this->catid = $catids;
        $this->series_list();
    }
    public function series_cartoon()
    {
        $catids = $this->conf['vod_kids'];
        $this->catid = $catids;
        $this->series_list();
    }
    public function SetLimitForBadBox($bad_stb_tot)
    {
        if( isset($this->conf['bad_stb_limit_trans']) && trim($this->conf['bad_stb_limit_trans']) != '' && isset($this->conf[$bad_stb_tot]) ) 
        {
            $trans = explode(',', $this->conf['bad_stb_limit_trans']);
            if( in_array($this->transid, $trans) ) 
            {
                $this->limit_qry = ' LIMIT ' . intval($this->conf[$bad_stb_tot]);
            }
        }
    }

public function series_list()
{
    global $_CFG;

    // First verify the user
    $this->boolVerifyUser('series_list');

    // Log the request for debugging
    $this->log("series_list called with catid: " . $this->catid);

    // Use panel API directly for series list
    if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' )
    {
        $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : '';
        $api_url = $panel_url . "player_api.php?username={$this->user}&password={$this->pass}&action=get_series";
        if ($this->catid && $this->catid != 'all') {
            $api_url .= "&category_id=" . intval($this->catid);
        }

        // Use cURL for HTTPS
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        $response = curl_exec($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);

        if ($response !== false && !empty($response)) {
            $series = json_decode($response, true);
            if (is_array($series) && !empty($series)) {
                $formatted = [];
                foreach ($series as $s) {
                    $formatted[] = [
                        'id' => $s['series_id'] ?? '',
                        'title' => $s['name'] ?? '',
                        'catid' => $s['category_id'] ?? '',
                        'icon' => $s['cover'] ?? '',
                        'view_order' => $s['num'] ?? '0',
                        'rating' => $s['rating'] ?? '',
                        'plot' => $s['plot'] ?? ''
                    ];
                }
                $this->msg($formatted);
                return;
            }
        }
    }

    // Fallback to remote API via Movies class only if panel API fails
    if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 )
    {
        $mv = new Movies($this, 'series_list');
        exit();
    }

    // Apply limit for certain set-top boxes
    $this->SetLimitForBadBox('bad_stb_tot_series');
    
    // Get server details for API connection
    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'http://204.188.233.170:2087/';
    $username = $this->user;
    $password = $this->pass;
    
    // Log credentials for debugging
    $this->log("Using credentials - Username: " . $username . ", Password: " . substr($password, 0, 3) . "...");
    
    // Build API URL with proper parameters
    $api_url = rtrim($panel_url, '/') . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&action=get_series";
    
    // Add category ID if specified
    if ($this->catid && $this->catid != 'all' && intval($this->catid) > 0) {
        $api_url .= "&category_id=" . intval($this->catid);
    }
    
    // Log the API URL for debugging (redact password)
    $log_url = preg_replace('/password=([^&]*)/', 'password=REDACTED', $api_url);
    $this->log("Connecting to API: " . $log_url);
    
    try {
        // Make API request
        $response = @file_get_contents($api_url);
        
        // Check if request failed
        if ($response === false) {
            $this->log("API Request failed: Could not connect to " . $log_url);
            $this->fallback_series_list();
            return;
        }
        
        // Parse response
        $series_data = json_decode($response, true);
        
        // Check if response is valid
        if (!is_array($series_data)) {
            $this->log("API Request returned invalid JSON: " . substr($response, 0, 100) . "...");
            $this->fallback_series_list();
            return;
        }
        
        // Log success
        $this->log("API Request successful, found " . count($series_data) . " series items");
        
        // Format the response to match the expected format
        $formatted_series = [];
        
        foreach ($series_data as $series) {
            // Make sure we have all required fields with fallbacks
            $formatted_series[] = [
                'id' => isset($series['id']) ? $series['id'] : (isset($series['series_id']) ? $series['series_id'] : 0),
                'title' => isset($series['title']) ? $series['title'] : (isset($series['name']) ? $series['name'] : 'Unknown Title'),
                'icon' => isset($series['icon']) ? $series['icon'] : (isset($series['cover']) ? $series['cover'] : ''),
                'catid' => isset($series['catid']) ? $series['catid'] : (isset($series['category_id']) ? $series['category_id'] : $this->catid),
                'icon_big' => isset($series['icon_big']) ? $series['icon_big'] : (isset($series['cover_big']) ? $series['cover_big'] : (isset($series['icon']) ? $series['icon'] : '')),
                'backdrop' => isset($series['backdrop']) ? $series['backdrop'] : (isset($series['backdrop_path']) ? (is_array($series['backdrop_path']) ? $series['backdrop_path'][0] : $series['backdrop_path']) : ''),
                'genre' => isset($series['genre']) ? $series['genre'] : '',
                'plot' => isset($series['plot']) ? $series['plot'] : '',
                'cast' => isset($series['cast']) ? $series['cast'] : '',
                'rating' => isset($series['rating']) ? $series['rating'] : '0',
                'director' => isset($series['director']) ? $series['director'] : '',
                'releaseDate' => isset($series['releaseDate']) ? $series['releaseDate'] : '',
                'last_modified' => isset($series['last_modified']) ? $series['last_modified'] : time(),
                'youtube_trailer' => isset($series['youtube_trailer']) ? $series['youtube_trailer'] : '',
                'view_order' => isset($series['view_order']) ? $series['view_order'] : (isset($series['num']) ? $series['num'] : 0),
                'views' => isset($series['views']) ? $series['views'] : 0
            ];
        }
        
        // If no series found, return message
        if (empty($formatted_series)) {
            $formatted_series[] = [
                'id' => 0,
                'title' => 'No Series Found in This Category',
                'icon' => '',
                'catid' => $this->catid,
                'icon_big' => '',
                'backdrop' => '',
                'genre' => '',
                'plot' => '',
                'cast' => '',
                'rating' => '0',
                'director' => '',
                'releaseDate' => '',
                'last_modified' => time(),
                'youtube_trailer' => '',
                'view_order' => 0,
                'views' => 0
            ];
        }
        
        // Send the response
        $this->msg($formatted_series);
        
    } catch (Exception $e) {
        $this->log("API Request exception: " . $e->getMessage());
        $this->fallback_series_list();
    }
}

// Fallback method for when the API request fails
public function fallback_series_list()
{
    $this->log("Using fallback database query for series_list");
    
    $err = '';
    $ar = [];
    
    // Build query based on catid
    $qry = '';
    if ($this->catid == 'all') {
        $qry = '';
    } else if (intval($this->catid) > 0) {
        $catID = intval($this->catid);
        $qry = ' AND category_id=' . $catID . ' ';
    } else {
        $err = ' Error: you must pass the catid like: "catid":"xx" or "catid":"all" ';
    }
    
    // Query the local database
    $sql_ch = $this->query('SELECT * FROM `series` ' . 
                         (' WHERE TRUE ' . $qry . ' ORDER BY category_id ASC,id DESC ' . $this->limit_qry . ';'));
    
    $row_count = mysqli_num_rows($sql_ch);
    $this->log("Found {$row_count} series in local database");
    
    // Process results
    $view_order = 0;
    while ($row = mysqli_fetch_array($sql_ch)) {
        $view_order++;
        
        // Handle backdrop path
        $backdrop_path = '';
        if (isset($row['backdrop_path'])) {
            if (is_string($row['backdrop_path']) && strpos($row['backdrop_path'], '[') === 0) {
                // It's a JSON array string, try to decode it
                $backdrop_arr = json_decode($row['backdrop_path'], true);
                if (is_array($backdrop_arr) && !empty($backdrop_arr)) {
                    $backdrop_path = $backdrop_arr[0];
                }
            } else {
                $backdrop_path = $row['backdrop_path'];
            }
        }
        
        $ar[] = [
            'id' => $row['id'],
            'title' => $row['title'],
            'icon' => $row['cover'],
            'catid' => $row['category_id'],
            'icon_big' => $row['cover_big'],
            'backdrop' => $backdrop_path,
            'genre' => isset($row['genre']) ? $row['genre'] : '',
            'plot' => isset($row['plot']) ? $row['plot'] : '',
            'cast' => isset($row['cast']) ? $row['cast'] : '',
            'rating' => isset($row['rating']) ? $row['rating'] : '0',
            'director' => isset($row['director']) ? $row['director'] : '',
            'releaseDate' => isset($row['releaseDate']) ? $row['releaseDate'] : '',
            'last_modified' => isset($row['last_modified']) ? $row['last_modified'] : time(),
            'youtube_trailer' => isset($row['youtube_trailer']) ? $row['youtube_trailer'] : '',
            'view_order' => $view_order,
            'views' => 0
        ];
    }
    
    // If no series found, return error message
    if ($row_count == 0) {
        $ar[] = [
            'id' => 0,
            'title' => ($err != '' ? $err : 'No Series Found'),
            'icon' => '',
            'catid' => $this->catid,
            'icon_big' => '',
            'backdrop' => '',
            'genre' => '',
            'plot' => '',
            'cast' => '',
            'rating' => '0',
            'director' => '',
            'releaseDate' => '',
            'last_modified' => time(),
            'youtube_trailer' => '',
            'view_order' => 0,
            'views' => 0
        ];
    }
     
    // Send the response
    $this->msg($ar);
}

    public function series_info()
    {
        $this->series_episodes();
    }
    public function series_episodes()
    {
        global $_CFG;
        $this->boolVerifyUser('series_episodes');

        // Use panel API directly for series info/episodes
        if( isset($_CFG['vod']) && $_CFG['vod'] == 'Yes' )
        {
            $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : '';
            $series_id = intval($this->series_id);
            $api_url = $panel_url . "player_api.php?username={$this->user}&password={$this->pass}&action=get_series_info&series_id={$series_id}";

            // Use cURL for HTTPS
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            $response = curl_exec($ch);
            curl_close($ch);

            if ($response !== false && !empty($response)) {
                $data = json_decode($response, true);
                if (is_array($data) && isset($data['episodes'])) {
                    // Get series info
                    $info = $data['info'] ?? [];
                    $icon = $info['cover'] ?? '';

                    // Get backdrop
                    $backdrop = [];
                    if (isset($info['backdrop_path'])) {
                        if (is_array($info['backdrop_path'])) {
                            $backdrop = $info['backdrop_path'];
                        } else {
                            $backdrop = [$info['backdrop_path']];
                        }
                    }
                    if (empty($backdrop)) {
                        $backdrop = [$icon];
                    }

                    // Format info section
                    $formatted_info = [
                        'id' => $series_id,
                        'title' => $info['name'] ?? '',
                        'icon' => $icon,
                        'catid' => $info['category_id'] ?? '',
                        'icon_big' => $icon,
                        'backdrop' => $backdrop,
                        'genre' => $info['genre'] ?? '',
                        'plot' => $info['plot'] ?? '',
                        'cast' => $info['cast'] ?? '',
                        'cast_images' => [],
                        'rating' => (string)($info['rating'] ?? '0'),
                        'director' => $info['director'] ?? '',
                        'releaseDate' => $info['releaseDate'] ?? $info['release_date'] ?? '',
                        'last_modified' => (string)($info['last_modified'] ?? time()),
                        'trailer' => '',
                        'likes' => 0,
                        'dislikes' => 0,
                        'tmdb_id' => (string)($info['tmdb_id'] ?? '')
                    ];

                    // Format seasons and episodes
                    $seasons = [];
                    foreach ($data['episodes'] as $season_num => $season_episodes) {
                        $formatted_episodes = [];

                        foreach ($season_episodes as $ep) {
                            $stream_id = $ep['id'] ?? '';
                            $ext = $ep['container_extension'] ?? 'mp4';
                            $base_url = $panel_url . "series/{$this->user}/{$this->pass}/{$stream_id}.{$ext}";

                            $formatted_episodes[] = [
                                'episode_num' => (string)($ep['episode_num'] ?? ''),
                                'episode_name' => $ep['title'] ?? '',
                                'stream_url' => $base_url
                            ];
                        }

                        if (!empty($formatted_episodes)) {
                            $seasons[] = [
                                'season_num' => intval($season_num),
                                'episodes' => $formatted_episodes
                            ];
                        }
                    }

                    $this->msg([
                        'info' => $formatted_info,
                        'seasons' => $seasons
                    ]);
                    return;
                }
            }
        }

        // Fallback to remote API via Movies class only if panel API fails
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 )
        {
            $mv = new Movies($this, 'series_info');
            exit();
        }
        $err = '';
        $ar = [];
        $qry = '';
        $series_id = intval($this->series_id);
        if( $series_id == 0 ) 
        {
            $err = ' Error: you must pass the series_id=xx';
        }
        $sql_ch = $this->query('SELECT s.id, s.stream_display_name,s.stream_source,s.redirect_stream  ,s.stream_icon,s.movie_propeties,s.target_container,ep.season_num FROM `streams` s ,`series_episodes` ep WHERE s.id=ep.stream_id /*AND s.`type`=5*/ ' . (' AND  ep.series_id=' . $series_id . ' ORDER BY season_num ASC, ep.`sort` ASC;'));
        $i = 0;
        while( $row = mysqli_fetch_array($sql_ch) ) 
        {
            $i++;
            $target_container = '.' . preg_replace('/[^A-Za-z0-9]/', '', $row['target_container']);
            // Use panel_url with /live/ path for series
            $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';
            $stream = $panel_url . "live/{$this->user}/{$this->pass}/{$row['id']}{$target_container}";
            $ar[] = [
                'season_num' => $row['season_num'], 
                'episode_num' => $i, 
                'episode_name' => $row['stream_display_name'], 
                'stream_url' => $stream, 
                'stream_icon' => $row['stream_icon']
            ];
        }
        if( mysqli_num_rows($sql_ch) == 0 ) 
        {
            $ar[] = [
                'season_num' => 0, 
                'episode_num' => 0, 
                'episode_name' => ($err != '' ? $err : 'No Episodes'), 
                'stream_url' => '', 
                'stream_icon' => $row['stream_icon']
            ];
        }
        $this->msg($ar);
    }
    public function getList()
    {
        $this->boolVerifyUser('getList');
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, 'getList');
            exit();
        }
    }
    public function myQuran($for = 'Quran')
    {
        $this->boolVerifyUser($for);
        if( isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1 ) 
        {
            $mv = new Movies($this, $for);
            exit();
        }
    }
    public function myRadio()
    {
        $this->myQuran('Radio');
    }
    public function myKids()
    {
        $this->myQuran('Kids');
    }
    public function myMusic()
    {
        $this->myQuran('Music');
    }
    public function myClip()
    {
        $this->myQuran('Clip');
    }
    public function restore()
    {
        if( strtolower($this->sn) == 'null' || strtolower($this->mac) == 'null' || strtolower($this->mac) == '02:00:00:00:00:00' || strtolower($this->mac) == 'nu:ll:00:00:00:00' || strlen($this->mac) < 10 || strlen($this->sn) < 10 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2001: We can\'t restore your code. Your Device is not Readable. Please contact Reseller.', 
                'code' => ''
            ]);
            exit();
        }
        $qry = 'SELECT code FROM solus_codes WHERE serial=\'' . $this->sn . '\' AND mac=\'' . $this->mac . '\';';
        $result = $this->query($qry);
        $found = intval(mysqli_num_rows($result));
        if( $found == 1 ) 
        {
            $row = mysqli_fetch_array($result);
            $code = trim($row['code']);
            $this->msg([
                'status' => 100, 
                'message' => 'success', 
                'code' => $code
            ]);
        }
        else if( $found == 0 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2002: Your device is not found!', 
                'code' => ''
            ]);
        }
        else if( $found > 1 ) 
        {
            $this->msg([
                'status' => 200, 
                'message' => 'Error 2003: we found many devices like yours!', 
                'code' => ''
            ]);
        }
    }
    public function __destruct()
    {
        global $time_start;
        if( is_resource($this->link) ) 
        {
            mysqli_close($this->link);
        }
    }
    public function IntroSeriesCat()
    {
        $qry = $parent = '';
        $ar = []; 
        $sql = 'SELECT * from ' . PREFIX . '_series_cat where true order by w asc ';
        $sql = $this->query($sql);
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            extract($row);
            if( $catimage != '' ) 
            {
                $catimage = (string)$catimage;
            }
            else
            {
                $catimage = 'http://intro.ps/uploads/logo/movie.png';
            }
            $ar[] = [
                'cat_id' => $catid, 
                'cat_name' => $catname, 
                'cat_icon' => $catimage, 
                'cat_view_order' => $w
            ];
        }
        $this->msg($ar);
    }
    public function IntroSeriesList()
    {
        $qry = '';
        if( $this->catid == 'all' ) 
        {
            $qry = '';
        }
        else
        {
            $qry = ' WHERE `catid`=' . intval($this->catid);
        }
        $ar = [];
        $sql = $this->query('SELECT * from ' . PREFIX . ('_series ' . $qry . ' order by catid asc, sid desc'));
        $genre = '';
        $i = 0;
        while( $row = mysqli_fetch_array($sql) ) 
        {
            $i++;
            extract($row);
            if( $s_photo != '' ) 
            {
                $s_photo = (string)$s_photo;
            }
            else
            {
                $s_photo = 'http://intro.ps/uploads/logo/movie.png';
            }
            $JSON = json_decode($s_jsondata, true);
            $plot = (isset($JSON['series_Plot']) ? strip_tags($JSON['series_Plot']) : 'n/a');
            $cast = (isset($JSON['series_Cast']) ? strip_tags($JSON['series_Cast']) : 'n/a');
            $rating = (isset($JSON['series_Rating']) ? $JSON['series_Rating'] : 'n/a');
            $date = (isset($JSON['series_Year']) ? $JSON['series_Year'] : 'n/a');
            $ar[] = [
                'id' => $sid, 
                'title' => $s_title, 
                'icon' => $s_photo, 
                'icon_big' => $s_photo, 
                'catid' => $catid, 
                'genre' => $genre, 
                'plot' => $plot, 
                'cast' => $cast, 
                'rating' => $rating, 
                'director' => 'n/a', 
                'releaseDate' => $date
            ];
        }
        $this->msg($ar);
    }
    public function IntroSeriesGetDetails()
    {
        $qry = $parent = '';
        $sid = intval($this->series_id);
        $this->query('update ' . PREFIX . ('_series set hits=hits+1 where sid=' . $sid . ';'));
        $sqlSeries = $this->query('SELECT *   FROM ' . PREFIX . ('_series se where sid=' . $sid . ';'));
        $row = mysqli_fetch_array($sqlSeries);
        extract($row);
        $JSON = json_decode($s_jsondata, true);
        if( $s_photo != '' ) 
        {
            $s_photo = (string)$s_photo;
        }
        else
        {
            $s_photo = 'http://intro.ps/uploads/logo/movie.png';
        }
        $ar = [];
        $ar['id'] = $sid;
        $ar['title'] = $s_title;
        $ar['trailer'] = $trailer;
        $ar['user_rating'] = 0;
        $ar['likes'] = $likes;
        $ar['dislikes'] = $dislikes;
        $ar['icon'] = $s_photo;
        $ar['plot'] = (isset($JSON['series_Plot']) ? strip_tags($JSON['series_Plot']) : 'n/a');
        $ar['cast'] = (isset($JSON['series_Cast']) ? strip_tags($JSON['series_Cast']) : 'n/a');
        $ar['rate'] = (isset($JSON['series_Rating']) ? $JSON['series_Rating'] : 'n/a');
        $ar['date'] = (isset($JSON['series_Year']) ? $JSON['series_Year'] : 'n/a');
        $sql = $this->query('SELECT * from ' . PREFIX . ('_series_seasons where seriesid=' . $sid . ' order by s_num asc;'));
        $i = 0;
        $arSeasons = [];
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $arSeasons[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episodes' => $this->IntroSeriesGetEpisodes(0)
            ];
            $arSeasons[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episodes' => $this->IntroSeriesGetEpisodes(0)
            ];
        }
        else
        {
            while( $row = mysqli_fetch_array($sql) ) 
            {
                $i++;
                extract($row);
                $arSeasons[] = [
                    'id' => $seasonid, 
                    'title' => $season_name, 
                    'episodes' => $this->IntroSeriesGetEpisodes(intval($row['seasonid']))
                ];
            }
        }
        $ar['seasons'] = $arSeasons;
        $this->msg($ar);
    }
    public function IntroSeriesGetEpisodes($seasonid)
    {
        $seasonid = intval($seasonid);
        $ar = [];
        $qry = ' SELECT * from ' . PREFIX . ('_seriesepisodes where seasonid=' . $seasonid . '  order by epnum ASC;');
        $sql = $this->query($qry);
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $ar = [];
            $ar[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episode_name' => 'Soon...', 
                'stream_url' => '', 
                'streams' => [
                    '480p' => '', 
                    '720p' => '', 
                    '1080p' => '', 
                    '4k' => ''
                ]
            ];
            $ar[] = [
                'id' => 0, 
                'title' => 'Soon...', 
                'episode_name' => 'Soon...', 
                'stream_url' => '', 
                'streams' => [
                    '480p' => '', 
                    '720p' => '', 
                    '1080p' => '', 
                    '4k' => ''
                ]
            ];
            return $ar;
        }
    }

    // Trends - New Movies 2020-2025
    // Trends Categories
    public function trends_cat()
    {
        global $_CFG;
        $this->boolVerifyUser('trends_cat');

        $cat_ids = isset($_CFG['trends_category_ids']) ? $_CFG['trends_category_ids'] : '85,84,83,82,81,80';
        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';
        $allowed_ids = array_map('trim', explode(',', $cat_ids));
        $formatted = [];

        // Try XC API first
        $api_url = $panel_url . "player_api.php?username={$this->user}&password={$this->pass}&action=get_vod_categories";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        $response = curl_exec($ch);
        curl_close($ch);

        if ($response !== false && !empty($response) && $response !== 'Forbidden') {
            $categories = json_decode($response, true);
            if (is_array($categories) && !empty($categories)) {
                $order = 1;
                foreach ($categories as $cat) {
                    $cat_id = (string)($cat['category_id'] ?? $cat['id'] ?? '');
                    if (in_array($cat_id, $allowed_ids)) {
                        $formatted[] = [
                            'id' => $cat_id,
                            'category_name' => $cat['category_name'] ?? $cat['name'] ?? '',
                            'category_type' => 'movie',
                            'category_icon' => $cat['category_icon'] ?? '',
                            'cat_order' => (string)$order,
                            'isLocked' => false,
                            'stream_count' => 0,
                            'parent_id' => $cat['parent_id'] ?? '0'
                        ];
                        $order++;
                    }
                }
            }
        }

        // If no results, try MidnightStreamer API
        if (empty($formatted)) {
            $api_url2 = $panel_url . "api/player/{$this->user}/{$this->pass}/vod/categories";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url2);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 15);
            $response = curl_exec($ch);
            curl_close($ch);

            if ($response !== false && !empty($response)) {
                $categories = json_decode($response, true);
                if (is_array($categories) && !empty($categories)) {
                    $order = 1;
                    foreach ($categories as $cat) {
                        $cat_id = (string)($cat['category_id'] ?? $cat['id'] ?? '');
                        if (in_array($cat_id, $allowed_ids)) {
                            $formatted[] = [
                                'id' => $cat_id,
                                'category_name' => $cat['category_name'] ?? $cat['name'] ?? '',
                                'category_type' => 'movie',
                                'category_icon' => $cat['category_icon'] ?? '',
                                'cat_order' => (string)$order,
                                'isLocked' => false,
                                'stream_count' => 0,
                                'parent_id' => '0'
                            ];
                            $order++;
                        }
                    }
                }
            }
        }

        // Fallback: create categories from config IDs with default names
        if (empty($formatted)) {
            $default_names = [
                '85' => 'NEW MOVIES 2025',
                '84' => 'NEW MOVIES 2024',
                '83' => 'NEW MOVIES 2023',
                '82' => 'NEW MOVIES 2022',
                '81' => 'NEW MOVIES 2021',
                '80' => 'NEW MOVIES 2020',
                '56' => 'Disney Plus',
                '88' => 'Asia China'
            ];
            $order = 1;
            foreach ($allowed_ids as $cat_id) {
                $formatted[] = [
                    'id' => $cat_id,
                    'category_name' => $default_names[$cat_id] ?? 'Category ' . $cat_id,
                    'category_type' => 'movie',
                    'category_icon' => '',
                    'cat_order' => (string)$order,
                    'isLocked' => false,
                    'stream_count' => 0,
                    'parent_id' => '0'
                ];
                $order++;
            }
        }

        $this->msg($formatted);
    }

    public function movies_trends()
    {
        global $_CFG;
        $this->boolVerifyUser('movies_trends');

        debug_log("movies_trends: Using Movies class for consistent encryption");

        // Use Movies class like movies_latest for consistent XOR encryption
        if (isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1) {
            $mv = new Movies($this, 'movies_trends');
            exit();
        }

        // Fallback: direct adapter call (should not reach here normally)
        $cat_id = isset($this->catid) && $this->catid ? $this->catid : (isset($_CFG['trends_category_ids']) ? explode(',', $_CFG['trends_category_ids'])[0] : '85');
        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : '';

        require_once(__DIR__ . '/MidnightStreamerAdapter.php');
        $adapter = new MidnightStreamerAdapter($this->user, $this->pass, $panel_url);
        $movies = $adapter->getMoviesByCategory($cat_id, 50);

        debug_log("movies_trends: Got " . count($movies) . " movies");

        if (is_array($movies) && !empty($movies)) {
            $this->msg($movies);
            return;
        }

        $this->msg([]);
    }

    // Top Movies
    public function top_movies()
    {
        global $_CFG;
        $this->boolVerifyUser('top_movies');

        // Use Movies class for consistent encryption and format
        if (isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1) {
            $mv = new Movies($this, 'top_movies');
            exit();
        }

        // Fallback
        $this->msg([]);
    }

    // Top Series
    public function top_series()
    {
        global $_CFG;
        $this->boolVerifyUser('top_series');
        $cat_ids = isset($_CFG['top_series_category_ids']) ? $_CFG['top_series_category_ids'] : '1,58,60,61,63,64,65,66,67,68,69';
        $panel_url = isset($_CFG['panel_url']) ? rtrim($_CFG['panel_url'], '/') . '/' : 'https://flix-panel.xyz:2087/';
        $this->fetchSeriesFromPanel($cat_ids, $panel_url, 50);
    }

    // Shahid
    public function movies_shahid()
    {
        global $_CFG;
        $this->boolVerifyUser('movies_shahid');

        // Use Movies class for consistent encryption and format
        if (isset($this->conf['remote_movies_use']) && intval($this->conf['remote_movies_use']) == 1) {
            $mv = new Movies($this, 'movies_shahid');
            exit();
        }

        // Fallback
        $this->msg([]);
    }

    // Helper: Fetch Movies from Panel
    private function fetchMoviesFromPanel($cat_ids, $panel_url, $limit = 50)
    {
        $cat_array = array_map('trim', explode(',', $cat_ids));
        $filtered = [];
        foreach ($cat_array as $cat_id) {
            if (count($filtered) >= $limit) break;
            $api_url = $panel_url . "player_api.php?username={$this->user}&password={$this->pass}&action=get_vod_streams&category_id={$cat_id}";
            $ch = curl_init();
            curl_setopt_array($ch, [CURLOPT_URL => $api_url, CURLOPT_RETURNTRANSFER => true, CURLOPT_SSL_VERIFYPEER => false, CURLOPT_TIMEOUT => 30]);
            $response = curl_exec($ch);
            curl_close($ch);
            if ($response === false) continue;
            $movies = json_decode($response, true);
            if (!is_array($movies)) continue;
            foreach ($movies as $movie) {
                if (count($filtered) >= $limit) break;
                $container = $movie['container_extension'] ?? 'mp4';
                $filtered[] = [
                    'num' => count($filtered) + 1, 'name' => $movie['name'], 'stream_type' => 'movie',
                    'stream_id' => $movie['stream_id'], 'stream_icon' => $movie['stream_icon'] ?? '',
                    'rating' => $movie['rating'] ?? '0', 'added' => $movie['added'] ?? '',
                    'category_id' => $movie['category_id'], 'container_extension' => $container,
                    'direct_source' => $panel_url . "movie/{$this->user}/{$this->pass}/{$movie['stream_id']}.{$container}"
                ];
            }
        }
        $this->msg($filtered);
    }

    // Helper: Fetch Series from Panel
    private function fetchSeriesFromPanel($cat_ids, $panel_url, $limit = 50)
    {
        $cat_array = array_map('trim', explode(',', $cat_ids));
        $filtered = [];
        foreach ($cat_array as $cat_id) {
            if (count($filtered) >= $limit) break;
            $api_url = $panel_url . "player_api.php?username={$this->user}&password={$this->pass}&action=get_series&category_id={$cat_id}";
            $ch = curl_init();
            curl_setopt_array($ch, [CURLOPT_URL => $api_url, CURLOPT_RETURNTRANSFER => true, CURLOPT_SSL_VERIFYPEER => false, CURLOPT_TIMEOUT => 30]);
            $response = curl_exec($ch);
            curl_close($ch);
            if ($response === false) continue;
            $series = json_decode($response, true);
            if (!is_array($series)) continue;
            foreach ($series as $s) {
                if (count($filtered) >= $limit) break;
                $filtered[] = [
                    'num' => count($filtered) + 1, 'name' => $s['name'], 'series_id' => $s['series_id'],
                    'cover' => $s['cover'] ?? '', 'plot' => $s['plot'] ?? '', 'cast' => $s['cast'] ?? '',
                    'director' => $s['director'] ?? '', 'genre' => $s['genre'] ?? '', 'rating' => $s['rating'] ?? '0',
                    'releaseDate' => $s['releaseDate'] ?? '', 'category_id' => $s['category_id'] ?? $cat_id
                ];
            }
        }
        $this->msg($filtered);
    }
}

// Update to handle potential invalid modes and provide aliases for common typos
$class = new APIv6();
$mode = $_POST['mode'] ?? null;

// Debug the incoming data
debugLog("Received mode", $mode);
debugLog("POST data", $_POST);

// Add mode aliases - this will map truncated or alternative mode names to the correct function
$mode_aliases = [
    'series_lis' => 'series_list',
    'serie' => 'series_list',
    'series' => 'series_list',
    'seri' => 'series_list',
    'movie_lis' => 'movies_list',
    'movi' => 'movies_list',
    'act' => 'active',
    'kids' => 'movies_kids',
    'Kids' => 'movies_kids',
    'trends' => 'movies_trends',
    'trending' => 'movies_trends',
    'trends_list' => 'movies_trends',
    'netflix' => 'movies_netflix',
    'shahid' => 'movies_shahid',
    'movies_top' => 'top_movies',
    'series_top' => 'top_series',
    'topmovies' => 'top_movies',
    'topseries' => 'top_series'
];

// Check if we need to use an alias
if(isset($mode_aliases[$mode])) {
    debugLog("Using mode alias", "$mode -> {$mode_aliases[$mode]}");
    $mode = $mode_aliases[$mode];
}

// Further debug
debugLog("Final mode being used", $mode);

if($mode != '' && method_exists($class, $mode)) {
    $class->$mode();
} else {
    debugLog("Invalid mode", $mode);
    $class->_die('Error: mode (' . $mode . ') not defined.');
    exit();
}
 
function get_post($index = '')
{
    if(!isset($_POST[$index])) {
        return $_GET[$index] ?? null;
    } else {
        return $_POST[$index];
    }
}

// Debug logging function (global scope version)
function debugLog($message, $data = null) {
    global $_CFG;
    if(isset($_CFG['debug']) && $_CFG['debug']) {
        $logMsg = date('[Y-m-d H:i:s] ') . $message;
        if($data !== null) {
            $logMsg .= ': ' . print_r($data, true);
        }
        error_log($logMsg);
        @file_put_contents('./logs/debug_' . date('Y-m-d') . '.log', $logMsg . "\n", FILE_APPEND | LOCK_EX);
    }
}