<?php
/**
 * Fixed activate_new_code_enhanced function
 * This version saves the token to database on first activation
 */

public function activate_new_code_enhanced($row)
{
    global $_CFG;

    // First check if we need to use multi_code functionality
    if($this->conf['multi_code'] == 1) {
        $this->activate_new_code_on_same_box($row);
        // The above function will handle messaging and exiting if successful
    }

    // Process the activation
    $days = intval($row['days']);
    $period = intval($row['period']);
    $free_days = intval($row['free_days']);
    $code = trim($row['code']);
    $fullname = trim($row['fullname']);
    $forced_country = trim($row['forced_country']);
    $codeID = intval($row['id']);

    // Calculate expiration date
    if(in_array($period, $this->free)) {
        $dd = $period - 100;
        $exp_date = strtotime('+' . $dd . ' days');
    } else {
        $exp_date = strtotime('+' . $period . ' month');
        if($free_days > 0) {
            $exp_date = strtotime('+' . $free_days . ' days', $exp_date);
        }
    }

    // Determine username
    if($row['inputBy'] == 0) {
        $username = $code;
    } else {
        $username = trim($row['username']);
    }

    // Set up user data
    $data = [];
    $data['member_id'] = 1;
    $data['username'] = $username;
    $data['password'] = rand() . uniqid();
    $data['exp_date'] = $exp_date;
    $data['admin_notes'] = (string)$fullname . ((($row['inputBy'] == 1 ? ' MAC' : $row['inputBy'] == 2) ? ' SN' : ''));
    $data['admin_enabled'] = 1;
    $data['enabled'] = 1;
    $data['bouquet'] = '[' . $row['bouquets'] . ']';
    $data['max_connections'] = 1;
    $data['created_at'] = time();
    $data['created_by'] = 1;
    $data['forced_country'] = $forced_country;
    if($row['allowed_uagent'] != '') {
        $data['allowed_ua'] = $row['allowed_uagent'];
    }

    // Check if user already exists
    $sql = $this->query('SELECT id,username from users where username = \'' . $username . '\' LIMIT 1;');
    if(mysqli_num_rows($sql) == 0) {
        // Create user
        $xtID = $this->insert('users', $data);
        $this->insert('user_output', [
            'user_id' => $xtID,
            'access_output_id' => 2
        ]);
    } else {
        $xrow = mysqli_fetch_array($sql);
        $xtID = $xrow['id'];
    }

    // Determine what to update based on inputBy
    if($row['inputBy'] == 0) {
        $whatToUpdate = 'mac=\'' . $this->mac . '\',serial=\'' . $this->sn . '\'';
        $txt = 'Code';
    } else if($row['inputBy'] == 1) {
        $whatToUpdate = 'serial=\'' . $this->sn . '\'';
        $txt = 'MAC';
    } else if($row['inputBy'] == 2) {
        $whatToUpdate = 'mac=\'' . $this->mac . '\'';
        $txt = 'Serial';
    }

    // Update code status
    $now = time();
    $up = $this->query('update solus_codes set ' .
                       (' status=1,' . $whatToUpdate . ',date_start=\'' . $now . '\',date_expire=\'' . $exp_date . '\',userid=\'' . $xtID . '\',protocol=6,model=\'' . $this->model . '\' ') .
                       (' where id=' . $codeID . ';'));

    if($this->link->error != '') {
        $response = [
            'status' => 112,
            'message' => 'Error With Database, Please contact admin. ' . $this->link->error,
            'server_name' => 'V6apk'
        ];
        $this->msg($response, '@Database Error = ' . $this->link->error);
        return;
    }

    // Log the activation
    $this->log('Activate By ' . $txt . ' |expire = ' . date('Y-m-d H:i:s', $exp_date));

    // Create a new line in the IPTV panel via API
    $panel_url = isset($_CFG['panel_url']) ? $_CFG['panel_url'] : 'https://45.154.207.117:8000/';
    $api_key = isset($_CFG['api_key']) ? $_CFG['api_key'] : 'eJIdy5sAgD';
    $max_connections = isset($_CFG['max_connections']) ? intval($_CFG['max_connections']) : 1;
    $restreamer = isset($_CFG['restreamer']) ? intval($_CFG['restreamer']) : 0;
    $subscription_plan = isset($_CFG['subscription_plan']) ? intval($_CFG['subscription_plan']) : 1;
    $allow_m3u = isset($_CFG['allow_m3u']) ? intval($_CFG['allow_m3u']) : 1;

    // Prepare POST data for API
    $post_data = [
        'api_key' => $api_key,
        'data' => [
            'username' => $username,
            'password' => $data['password'],
            'max_allowed_connections' => $max_connections,
            'allow_m3u' => $allow_m3u,
            'restreamer' => $restreamer,
            'expire_date' => $exp_date,
            'subscription_plan_id' => $subscription_plan
        ]
    ];

    // Prepare Stream Context
    $opts = [
        'http' => [
            'method' => 'POST',
            'header' => 'Content-type: application/x-www-form-urlencoded',
            'content' => http_build_query($post_data)
        ]
    ];

    // Create Stream Context
    $context = stream_context_create($opts);

    // Perform API Request
    try {
        $api_response = @file_get_contents(
            $panel_url . "api/line/new",
            false,
            $context
        );

        // Log the API response
        $this->log("IPTV Panel API Response: " . $api_response);

        // Parse the response (optional)
        $api_result = json_decode($api_response, true);
        if (isset($api_result['result']) && $api_result['result'] == 'success') {
            $this->log("IPTV Panel line created successfully for user: " . $username);
        } else {
            $this->log("IPTV Panel line creation failed: " . ($api_result['message'] ?? 'Unknown error'));
        }
    } catch (Exception $e) {
        // Log any error
        $this->log("IPTV Panel API Error: " . $e->getMessage());
    }

    // Get server info
    $timezone = $this->conf['timezone'] ?? 'Europe/Berlin';
    date_default_timezone_set($timezone);

    $server_protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
    $url = isset($_CFG['url']) && !empty($_CFG['url']) ? $_CFG['url'] : $_SERVER['HTTP_HOST'] ?? '45.154.207.117';
    $port = isset($_CFG['port']) && !empty($_CFG['port']) ? ":" . $_CFG['port'] : ':' . ($_SERVER['SERVER_PORT'] ?? '8000');

    // ═══════════════════════════════════════════════════════════════════════
    // ⭐ FIX: Generate token and SAVE IT to database
    // ═══════════════════════════════════════════════════════════════════════

    // Generate token
    $token = md5(uniqid() . $username . time()) . base64_encode(random_bytes(64));

    // Get token expiry days from config (default 7 days)
    $token_expiry_days = isset($_CFG['token_expiry_days']) ? intval($_CFG['token_expiry_days']) : 7;
    $token_created = time();
    $token_expires = $token_created + (86400 * $token_expiry_days); // 86400 = seconds in a day

    // Save token to database
    $token_data = [
        'user_id' => $xtID,
        'token' => $token,
        'created' => $token_created,
        'expires' => $token_expires,
        'ip' => $this->ip(),
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'
    ];

    // Insert token into user_tokens table
    try {
        $token_insert_result = $this->insert('user_tokens', $token_data);

        if($token_insert_result) {
            debug_log("Token saved successfully for user: " . $username);
            debug_log("Token: " . substr($token, 0, 32) . "...");
            debug_log("Token expires: " . date('Y-m-d H:i:s', $token_expires));
        } else {
            debug_log("Warning: Failed to save token for user: " . $username);
            $this->log("Failed to save token for user: " . $username . " Error: " . $this->link->error);
        }
    } catch (Exception $e) {
        debug_log("Error saving token: " . $e->getMessage());
        $this->log("Error saving token: " . $e->getMessage());
    }

    // ═══════════════════════════════════════════════════════════════════════
    // End of token save fix
    // ═══════════════════════════════════════════════════════════════════════

    // Default allowed formats
    $allowed_formats = ["m3u8", "ts"];

    // Save credentials for future reference
    $this->user = $username;
    $this->pass = $data['password'];
    $this->code_id = $codeID;

    // Create the response
    $response = [
        'status' => 100,
        'server_name' => 'V6apk',
        'apk_ver_code' => $this->conf['apk_ver_code'] ?? '',
        'message' => 'The Code has been activated successfully',
        'osd_msg' => (string)$this->osd,
        'osd_msg_global' => $this->conf['global_message'] ?? '',
        'expire' => $this->expire_date($exp_date),
        'user_agent' => trim($this->conf['user_agent']),
        'username' => $username,
        'password' => $data['password'],
        'allowed_output_formats' => $allowed_formats,
        'max_connections' => 1,
        'active_connections' => 0,
        'host' => $server_protocol . '://' . $url . $port,
        'player_api' => $server_protocol . '://' . $url . $port . '/player_api.php',
        'epg_api' => $server_protocol . '://' . $url . $port . '/epg/{stream_id}.json?user={user}&pass={pass}',
        'code_id' => $codeID,
        'force_update' => $this->conf['force_update'] ?? 0,
        'update_url' => $this->conf['update_url'] ?? '',
        'apk_page' => $this->conf['apk_page'] ?? '',
        'update_ch' => 'true',
        'timezone' => $timezone,
        'server_info' => [
            'server_protocol' => $server_protocol,
            'url' => $url,
            'port' => $port,
            'https_port' => $port,
            'timezone' => $timezone,
            'timestamp_now' => time(),
            'time_now' => date('Y-m-d H:i:s')
        ],
        'total_streams' => 0,
        'total_movies' => 0,
        'total_series' => 0,
        'token' => $token  // Token is now saved in database!
    ];

    $this->insertModel();
    $this->msg($response, 'Success ' . $txt);
}
