<?php
/**
 * Activate Code and Get Token
 * This simulates what the app should do when token is empty
 */

$XOR_KEY = "KvuZRm365wk5Sz&Xy.Zx";

function xor_encrypt($data, $key) {
    $json_str = json_encode($data);
    $keyLen = strlen($key);
    $encrypted = '';
    for ($i = 0; $i < strlen($json_str); $i++) {
        $encrypted .= chr(ord($json_str[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $encrypted;
}

function xor_decrypt($encrypted, $key) {
    $keyLen = strlen($key);
    $decrypted = '';
    for ($i = 0; $i < strlen($encrypted); $i++) {
        $decrypted .= chr(ord($encrypted[$i]) ^ ord($key[$i % $keyLen]));
    }
    return $decrypted;
}

// Get parameters
$code = $argv[1] ?? '225666426500';
$mac = $argv[2] ?? '8c:fd:f0:00:7f:13';

echo "╔══════════════════════════════════════════════════════════════════╗\n";
echo "║           ACTIVATION & TOKEN RETRIEVAL                           ║\n";
echo "╚══════════════════════════════════════════════════════════════════╝\n\n";

echo "📋 Step 1: Check if token exists\n";
echo str_repeat("─", 70) . "\n";
echo "Token status: EMPTY ❌\n";
echo "Action: Need to activate code to get token\n\n";

echo "📋 Step 2: Activate Code\n";
echo str_repeat("─", 70) . "\n";
echo "Code: $code\n";
echo "MAC: $mac\n\n";

// Prepare activation request
$activation_request = [
    'code' => $code,
    'mac' => $mac,
    'sn' => $mac,
    'model' => 'SM-N975F',
    'group' => 1,
    'mode' => 'active'
];

echo "Sending activation request...\n";

// Encrypt and send
$encrypted = xor_encrypt($activation_request, $XOR_KEY);
$response = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted),
        'ignore_errors' => true,
        'timeout' => 15
    ]
]));

if (!$response) {
    die("❌ Error: No response from server\n");
}

// Decrypt response
$decrypted = xor_decrypt($response, $XOR_KEY);
$activation_data = json_decode($decrypted, true);

if (!$activation_data) {
    die("❌ Error: Invalid response format\n");
}

echo "Response received!\n\n";

echo "📋 Step 3: Process Activation Response\n";
echo str_repeat("─", 70) . "\n";

if (!isset($activation_data['status'])) {
    echo "❌ Error: No status in response\n";
    echo "Response: $decrypted\n";
    exit(1);
}

$status = $activation_data['status'];

if ($status != 100) {
    echo "❌ Activation Failed!\n";
    echo "Status: $status\n";
    echo "Message: " . ($activation_data['message'] ?? 'Unknown error') . "\n";
    exit(1);
}

echo "✅ Activation Successful!\n\n";

echo "📝 Account Information:\n";
echo "   Status: " . $status . " (" . $activation_data['message'] . ")\n";
echo "   Username: " . $activation_data['username'] . "\n";
echo "   Password: " . $activation_data['password'] . "\n";
echo "   Expires: " . $activation_data['expire'] . "\n";
echo "   Max Connections: " . $activation_data['max_connections'] . "\n";
echo "   Active Connections: " . $activation_data['active_connections'] . "\n\n";

echo "🔑 Token Retrieved:\n";
echo str_repeat("─", 70) . "\n";

if (!isset($activation_data['token']) || empty($activation_data['token'])) {
    die("❌ Error: No token in activation response!\n");
}

$token = $activation_data['token'];
echo $token . "\n";
echo str_repeat("─", 70) . "\n";
echo "Length: " . strlen($token) . " characters\n";
echo "MD5 Prefix: " . substr($token, 0, 32) . "\n\n";

echo "📋 Step 4: Save Token (What App Should Do)\n";
echo str_repeat("─", 70) . "\n";
echo "// In Android App:\n";
echo "SharedPreferences prefs = getSharedPreferences(\"app_data\", MODE_PRIVATE);\n";
echo "prefs.edit()\n";
echo "    .putString(\"token\", \"$token\")\n";
echo "    .putString(\"username\", \"" . $activation_data['username'] . "\")\n";
echo "    .putString(\"password\", \"" . $activation_data['password'] . "\")\n";
echo "    .putString(\"expire\", \"" . $activation_data['expire'] . "\")\n";
echo "    .putBoolean(\"is_activated\", true)\n";
echo "    .apply();\n\n";

echo "📋 Step 5: Test Token\n";
echo str_repeat("─", 70) . "\n";
echo "Testing token with 'packages' request...\n";

$test_request = [
    'mode' => 'packages',
    'token' => $token
];

$encrypted_test = xor_encrypt($test_request, $XOR_KEY);
$response_test = @file_get_contents('http://45.154.207.45/iptv/V6APK/API-V6APK.php', false, stream_context_create([
    'http' => [
        'method' => 'POST',
        'header' => "Content-Type: application/x-www-form-urlencoded\r\nUser-Agent: okhttp/3.10.0\r\n",
        'content' => 'json=' . urlencode($encrypted_test),
        'ignore_errors' => true
    ]
]));

if ($response_test) {
    $decrypted_test = xor_decrypt($response_test, $XOR_KEY);
    if (strpos($decrypted_test, 'error') === false) {
        echo "✅ Token is working correctly!\n";
        $test_data = json_decode($decrypted_test, true);
        if (is_array($test_data)) {
            echo "   Retrieved " . count($test_data) . " packages\n";
        }
    } else {
        echo "❌ Token test failed: $decrypted_test\n";
    }
} else {
    echo "⚠️  Could not test token (no response)\n";
}

echo "\n";
echo "╔══════════════════════════════════════════════════════════════════╗\n";
echo "║                        ✅ COMPLETE!                              ║\n";
echo "║                                                                  ║\n";
echo "║  Token has been generated and is ready to use.                  ║\n";
echo "║  Make sure your app saves this token correctly!                 ║\n";
echo "╚══════════════════════════════════════════════════════════════════╝\n";
