<?php 
class Mac
{
    private $link = null;
    private $code = null;
    private $sn = null;
    private $mac = null;
    private $inputBy = 1;
    public function __construct($link, $code, $sn, $mac)
    {
        $this->link = $link;
        $this->code = $code;
        $this->sn = $sn;
        $this->mac = $mac;
        $sql_code = mysqli_query($this->link, 'SELECT * from solus_codes ' . (' where code=\'' . $code . '\' AND mac=\'' . $mac . '\' and inputBy=1;'));
        if( mysqli_num_rows($sql_code) == 1 ) 
        {
            $row = mysqli_fetch_array($sql_code);
            @extract($row);
            if( $status == 0 ) 
            {
                $this->activate_new_code($row);
                exit();
            }
            else if( $status == 2 ) 
            {
                $array = [
                    'status' => 2, 
                    'message' => 'The Code is Suspended', 
                    'expire' => '', 
                    'username' => '', 
                    'password' => ''
                ];
                $this->msg($array, '@Suspended');
            }
            else if( $status == 3 ) 
            {
                $array = [
                    'status' => 3, 
                    'message' => 'The Code is Not Found', 
                    'expire' => '', 
                    'username' => '', 
                    'password' => ''
                ];
                $this->msg($array, '@NotFound');
            }
        }
        $qry = 'SELECT c.code,c.date_expire,c.status,u.username, u.password FROM solus_codes c, users u ' . (' WHERE c.username=u.username AND c.code = \'' . $code . '\' AND c.serial=\'' . $sn . '\' AND c.mac=\'' . $mac . '\';');
        $result = mysqli_query($this->link, $qry) or         exit( mysqli_error($this->link) );
        if( mysqli_num_rows($result) == 0 ) 
        {
            $array = [
                'status' => 3, 
                'message' => 'The Code is not Not valid for this device.', 
                'expire' => '', 
                'username' => '', 
                'password' => ''
            ];
            $this->msg($array, '@Wrong Code');
        }
        $row = mysqli_fetch_array($result);
        $username = $row['username'];
        $password = $row['password'];
        $status = $row['status'];
        $expire = date('Y-m-d', $row['date_expire']);
        if( $expire < date('Y-m-d') ) 
        {
            $status = 4;
        }
        switch( $status ) 
        {
            case 1:
                $array = [
                    'status' => 1, 
                    'message' => 'The Code is active', 
                    'expire' => (string)$expire, 
                    'username' => (string)$username, 
                    'password' => (string)$password, 
                    'force_update' => 'false'
                ];
                $this->msg($array, 'ReActivation');
                break;
            case 2:
                $array = [
                    'status' => 2, 
                    'message' => 'The Code is suspended', 
                    'expire' => (string)$expire, 
                    'username' => (string)$username, 
                    'password' => (string)$password
                ];
                $this->msg($array, 'Suspended');
                break;
            case 3:
                $array = [
                    'status' => 3, 
                    'message' => 'The Code is not found', 
                    'expire' => '', 
                    'username' => '', 
                    'password' => ''
                ];
                $this->msg($array, '@Wrong Code');
                break;
            case 4:
                $array = [
                    'status' => 4, 
                    'message' => 'The Code is Expired', 
                    'expire' => '', 
                    'username' => '', 
                    'password' => ''
                ];
                $this->msg($array, '@Expired Code');
                break;
        }
    }
    public function msg($array, $msg = '')
    {
        if( !headers_sent() ) 
        {
            header('Content-Type:text/json');
        }
        echo json_encode($array);
        if( $msg != '' ) 
        {
            $this->log($msg);
        }
        exit();
    }
    public function activate_new_code($row)
    {
        $days = intval($row['days']);
        $period = intval($row['period']);
        $code = trim($row['code']);
        $username = trim($row['username']);
        $fullname = trim($row['fullname']);
        $forced_country = trim($row['forced_country']);
        $id = intval($row['id']);
        $exp_date = strtotime('+' . $period . ' month');
        if( $code == '' ) 
        {
            $this->log(' error: code is empty ');
            exit( 'error: code is empty' );
        }
        $data['member_id'] = 1;
        $data['username'] = $username;
        $data['password'] = uniqid();
        $data['exp_date'] = $exp_date;
        $data['admin_notes'] = (string)$fullname;
        $data['admin_enabled'] = 1;
        $data['enabled'] = 1;
        $data['bouquet'] = '[' . $row['bouquets'] . ']';
        $data['max_connections'] = 1;
        $data['created_at'] = time();
        $data['created_by'] = 1;
        $data['forced_country'] = $forced_country;
        $data['reseller_notes'] = 'byMAC: ' . $this->mac;
        $sql = mysqli_query($this->link, 'SELECT id,username from users where username = \'' . $username . '\';');
        if( mysqli_num_rows($sql) == 0 ) 
        {
            $id = $this->insert('users', $data);
            $this->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 1
            ]);
            $this->insert('user_output', [
                'user_id' => $id, 
                'access_output_id' => 2
            ]);
        }
        else
        {
            $xrow = mysqli_fetch_array($sql);
            $id = $xrow['id'];
        }
        $code_id = intval($row['id']);
        $up = mysqli_query($this->link, 'update solus_codes set ' . (' status=1,serial=\'' . $this->sn . '\',date_expire=\'' . $exp_date . '\',userid=\'' . $id . '\' ') . (' where id=' . $code_id . ';'));
        $array = [
            'status' => 0, 
            'message' => 'The account has been activated successfully', 
            'expire' => date('Y-m-d', $exp_date), 
            'username' => $data['username'], 
            'password' => $data['password'], 
            'force_update' => 'false'
        ];
        $this->msg($array, 'Success');
    }
    public function insert($tableName, $insData = [])
    {
        $columns = implode(', ', array_keys($insData));
        foreach( $insData as $idx => $data ) 
        {
            $insData[$idx] = '\'' . mysqli_real_escape_string($this->link, $data) . '\'';
        }
        $values = implode(', ', $insData);
        mysqli_query($this->link, 'INSERT INTO ' . $tableName . ' (' . $columns . ') VALUES (' . $values . ')') or         exit( 'error insert in users table: ' . mysqli_error($this->link) );
        return mysqli_insert_id($this->link);
    }
    public function log($thelog)
    {
        $dtime = time();
        $ip = $_SERVER['REMOTE_ADDR'];
        $code = $this->code;
        $serial = $this->sn;
        $mac = $this->mac;
        $sql = 'INSERT INTO `solus_logs`  (`id`, `dtime`, `thelog`, `ip`, `code`, `serial`, `mac`, `adminid`) VALUES ' . (' (NULL, \'' . $dtime . '\', \'' . $thelog . '\', \'' . $ip . '\', \'' . $code . '\', \'' . $serial . '\', \'' . $mac . '\', \'0\');');
        $result = mysqli_query($this->link, $sql);
    }
}
