<?php 
class Movies
{
    public function __construct($API, $mode)
    {
        $data = [];
        $data['u'] = $API->user;
        $data['p'] = $API->pass;
        $data['e'] = $API->date_expire;
        $data['mode'] = $mode;
        $data['parent'] = (isset($_GET['parent']) ? $_GET['parent'] : '');
        $data['catid'] = (isset($_GET['catid']) ? intval($_GET['catid']) : '');
        $data['details'] = (isset($_GET['details']) ? intval($_GET['details']) : '');
        $data['movie_id'] = (isset($_GET['movie_id']) ? intval($_GET['movie_id']) : 0);
        $data['url'] = str_replace('|', '/', trim($API->conf['remote_movies_url']));
        $url = str_replace('|', '/', trim($API->conf['remote_movies_api']));
        $json = $this->intro_url($url, $data);
        if( preg_match('/error/i', $json) ) 
        {
            $API->insert('solus_logs_sys', [
                'dtime' => date('Y-m-d H:i:s'), 
                'admin_user' => 'movies_api', 
                'app' => 'movies_api', 
                'ip' => $API->ip, 
                'action' => 'error', 
                'the_log' => $json
            ]);
        }
        echo $json;
    }
    public function intro_url($url, $data = [])
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
}
