<?php 
class Bouquets_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $type = [
        '1' => '[live]', 
        '2' => '[movies]', 
        '3' => '[created]', 
        '4' => '[radio]', 
        '5' => '[series]'
    ];
    public $adminRow = [];
    public $admin = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        $this->adminRow = $intro->auth->admin_data($this->admin['adminid']);
        if( !in_array($this->admin['level'], [
            1, 
            5, 
            8, 
            9
        ]) && $this->adminRow['manage_streams'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        $intro->db->halt_on_errors = false;
        $result = $intro->db->query('SELECT * from `bouquets` WHERE bouquet_status=0;');
        $totalrows = $intro->db->returned_rows;
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-list"></icon>') . $intro->lang['bouquets_appname'] . "</a> \r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . '/Form?t=add"><icon class="icon-plus-squared"></icon>') . $intro->lang['bouquets_add'] . ("</a>  \t\t \t\t \r\n\t\t<a class=\"btn btn-default\" href=\"" . $this->base . '/index/?bouquet_status=0"><icon class="icon-eye"></icon>Hidden (' . $totalrows . ')</a> ');
        if( in_array($this->admin['level'], [
            1, 
            5, 
            8, 
            9
        ]) ) 
        {
            echo '<a class="btn btn-warning" href="' . $this->base . "/restore_bq\"><icon class=\"icon-reload\"></icon>Backup/Restore Bouquets </a> \r\n\t\t<a class=\"btn btn-danger\" href=\"" . $this->base . '/col"><icon class="icon-bug"></icon>Stream Collison/Duplicated </a> ';
        }
        echo "\r\n\t\t</div>";
        $intro->db->halt_on_errors = true;
    }
    public function Start()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));
        $x = new XtreamApi('EmptyFunc');
        echo $x->Start($streams);
    }
    public function Stop()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));
        $x = new XtreamApi('EmptyFunc');
        echo $x->Stop($streams);
    }
    public function RestartCycle()
    {
        $this->Restart();
    }
    public function Restart()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));
        $x = new XtreamApi('EmptyFunc');
        echo $x->Restart($id);
    }
    public function getStreamStatus()
    {
        global $intro;
        global $array;
        $e = new StreamsEdit($this->base, $this->type);
        $e->getStreamStatus();
    }
    public function restore_bq()
    {
        global $intro;
        global $array;
        $intro->db->debug = false;
        $intro->db->halt_on_errors = false;
        $maa = '';
        $sql = $intro->db->query('SHOW COLUMNS FROM `bouquets` LIKE \'bouquet_status\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query(' ALTER TABLE `bouquets` ADD `bouquet_icon` VARCHAR( 255 ) NOT NULL , ADD `view_order` INT NOT NULL ;  ');
            $intro->db->query('ALTER TABLE `bouquets` ADD `bouquet_status` TINYINT(1) NOT NULL AFTER `view_order`;  ');
            $intro->db->query('ALTER TABLE `bouquets` ADD `bouquet_for` TINYINT(1) NOT NULL AFTER `bouquet_status`;  ');
            $intro->db->query('ALTER TABLE `bouquets` ADD `isLocked` TINYINT(1) NOT NULL AFTER `bouquet_status`;  ');
            $intro->db->query('UPDATE `bouquets` SET `bouquet_status`=1;  ');
            $sql2 = $intro->db->query('SELECT data_json from ' . PREFIX . '_data ' . ' WHERE  data_type=1000 AND data_catid=1000 AND data_bqt=1000 AND data_icon=\'bouquets\';');
            if( $intro->db->returned_rows == 1 ) 
            {
                $row2 = $intro->db->fetch_assoc($sql2);
                $xdata = json_decode($row2['data_json'], true);
                foreach( $xdata as $xkey => $xorw ) 
                {
                }
            }
            $maa .= '<h1>Restore bouquet done.</h1>';
        }
        $sql2 = $intro->db->query('SHOW COLUMNS FROM `stream_categories` LIKE \'category_icon\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query(' ALTER TABLE `stream_categories` ADD `category_icon` VARCHAR( 255 ) NOT NULL AFTER `category_name` ;  ');
            $intro->db->query(' ALTER TABLE `stream_categories` ADD `isLocked` TINYINT(1) NOT NULL AFTER `cat_order` ;  ');
            $maa .= '<h1>Restore category icon done.</h1>';
        }
        $sql = $intro->db->query('SHOW COLUMNS FROM `stream_categories` LIKE \'isLocked\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query('ALTER TABLE `stream_categories` ADD `isLocked` TINYINT(1) NOT NULL AFTER `cat_order` ;');
            echo '<br/> stream_categories isLocked added </br>';
        }
        $sql = $intro->db->query('SHOW COLUMNS FROM `bouquets` LIKE \'bouquet_for\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query('ALTER TABLE `bouquets` ADD `bouquet_for` TINYINT(1) NOT NULL AFTER `bouquet_status`;  ');
            echo '<br/> bouquet_for added </br>';
        }
        $sql = $intro->db->query('SHOW COLUMNS FROM `bouquets` LIKE \'isLocked\';');
        if( $intro->db->returned_rows == 0 ) 
        {
            $intro->db->query('ALTER TABLE `bouquets` ADD `isLocked` TINYINT(1) NOT NULL AFTER `bouquet_status`;  ');
            echo '<br/> isLocked added </br>';
        }
        if( $maa != '' ) 
        {
            echo $maa;
            echo '<h1>Finish.</h1>';
        }
        else
        {
            echo '<h1>No need for restore. All ok.</h1>';
            $intro->db->halt_on_errors = true;
            $ar = [];
            $result = $intro->db->query('SELECT * from bouquets ');
            while( $row = $intro->db->fetch_assoc($result) ) 
            {
                $ar[] = $row;
            }
            $data = [];
            $data['data_type'] = 1000;
            $data['data_catid'] = 1000;
            $data['data_bqt'] = 1000;
            $data['data_icon'] = 'bouquets';
            $data['data_json'] = json_encode($ar);
            $sql = $intro->db->query('SELECT data_id from ' . PREFIX . '_data ' . ' WHERE  data_type=1000 AND data_catid=1000 AND data_bqt=1000 AND data_icon=\'bouquets\';');
            if( $intro->db->returned_rows == 1 ) 
            {
                $row = $intro->db->fetch_assoc($sql);
                $intro->db->update('' . PREFIX . '_data', $data, 'data_id=' . intval($row['data_id']) . '');
                echo '<h1>Backup Done.</h1>';
            }
            else if( $intro->db->returned_rows == 0 ) 
            {
                $intro->db->insert('' . PREFIX . '_data', $data);
                echo '<h1>Backup Done.</h1>';
            }
        }
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = '';
        $order = trim($intro->input->get_post('order'));
        $search_txt = trim($intro->input->get_post('search_txt'));
        $bouquet_status = trim($intro->input->get_post('bouquet_status'));
        if( $bouquet_status == '' ) 
        {
            $bouquet_status = 1;
        }
        $this->nav();
        if( $search_txt != '' ) 
        {
            $qry = ' AND bouquet_name  LIKE \'%' . $search_txt . '%\' ';
        }
        if( $order == '' ) 
        {
            $order = 'view_order:asc';
        }
        $order = str_replace(':', ' ', $order);
        $result = $intro->db->query('SELECT * from bouquets WHERE bouquet_status=' . $bouquet_status . ' ' . $qry . ' order by ' . $order . ';');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> ' . $intro->lang['bouquets_cur'] . (' (' . $totalrows . ')'), 'info');
        echo "\r\n\t\t\r\n\t\t<fieldset>\r\n\t\t\t<form action=\"\" method=\"post\">\r\n\t\t\t\t<input type=\"text\" name=\"search_txt\" value=\"" . $search_txt . '" placeholder="' . $intro->lang['search_form'] . "\" size=\"20\">\r\n\t\t\t\t<input name=\"name\" value=\"" . $intro->lang['search'] . "\" type=\"submit\">\r\n\t\t\t</form>\r\n\t\t</fieldset>\r\n\t\t\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\" id='tableBQ'>\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th> </th>\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . "</th>\r\n\t\t\t<th>" . $intro->lang['bouquets_bouquet_name'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('bouquet_name', 'index') . " </th>\r\n\t\t\t<th># Channels </th>\r\n\t\t\t<th>View Order" . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('view_order', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['bouquets_bouquet_icon'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('bouquet_icon', 'index') . " </th>\r\n\t\t\t<th>Status " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('bouquet_status', 'index') . " </th>\r\n\t\t\t<th>" . $intro->lang['options'] . "</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $ch = json_decode($myrow['bouquet_channels'], true);
            $ser = json_decode($myrow['bouquet_series'], true);
            $tot_ch = (is_array($ch) ? count($ch) : 0);
            $tot_ser = (is_array($ser) ? count($ser) : 0);
            if( $tot_ser < 600 || $tot_ch < 600 ) 
            {
                $totals = '<a href="' . $this->base . '/EditChans?id=' . $id . '" class="btn btn-warning icon-edit">(' . $tot_ch . ') ' . (($tot_ser > 0 ? ' (Series=' . $tot_ser . ')' : '')) . '</a>';
            }
            else
            {
                $totals = '<a class="btn btn-warning icon-edit">(' . $tot_ch . ') ' . (($tot_ser > 0 ? ' (Series=' . $tot_ser . ')' : '')) . '</a>';
            }
            echo "\r\n\t\t\t<tr id=\"" . $id . '" class="' . _obf_0D0E3B292A301E3D17315C402B08361326052C04400E22($i) . ("\">\r\n\t\t\t\t<td class=\"center\"><input type=\"checkbox\" value=\"" . $id . "\" name=\"selected_fld[]\"></td>\r\n\t\t\t\t<td class=\"center dragHandle\">" . $id . "</td>\r\n\t\t\t\t<td>" . $bouquet_name . "</td>\r\n\t\t\t\t<td class=\"center\">" . $totals . "</td>\r\n\t\t\t\t<td class=\"center\"><span class=\"editable\" data-type=\"text\" data-pk=\"" . $id . '" data-name="view_order">' . $view_order . "</span></td>\r\n\t\t\t\t<td class=\"center\"><img src=\"" . $bouquet_icon . "\" style=\"max-height:50px;\" alt=\"\" /></td>\r\n\t\t\t\t<td class=\"center\"><span class=\"editableVis\" data-type=\"select\" data-pk=\"" . $id . "\" data-name=\"bouquet_status\">\r\n\t\t\t\t\t") . (($bouquet_status == 1 ? '<span class=\'label label-success\'>Visible</span>' : '<span class=\'label label-default\'>Hidden</span>')) . ("\r\n\t\t\t\t</span></td>\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t\t<a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="') . $intro->lang['edit'] . '"><i class="icon-edit"></i></a>';
            if( in_array($this->admin['level'], [
                1, 
                5, 
                8, 
                9
            ]) ) 
            {
                echo '<a class="btn btn-danger p_del intro_ui_del" href="' . $this->base . '/Del?id=' . $id . '" OnClick="return false;" title="' . $intro->lang['del'] . '"><i class="icon-cancel-circled2"></i></a>';
            }
            echo "\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        echo "</tbody>\r\n\t\t</table>\r\n\t\t</div>";
        $order = str_replace(' ', ':', $order);
        if( in_array($this->admin['level'], [
            1, 
            5, 
            8, 
            9
        ]) ) 
        {
            echo "<div class=center>\r\n\t\t\t<a href=\"" . $this->base . "/FixOrder\">Fix View Order</a>\r\n\t\t\t<div id=\"AjaxResult\">.....</div>\r\n\t\t</div>";
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo '</fieldset>';
        echo "<style>\r\n\t\t#table-1 tr td:first-child\r\n\t\t{\r\n\t\t\tcursor:move;\r\n\t\t}\r\n\t\t.ui-state-highlight\r\n\t\t{\r\n\t\t\tborder:1px dotted #ccc;\r\n\t\t\tcursor:move;\r\n\t\t}\r\n\t\t</style>\r\n\t\t<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\$( \"#tableBQ>tbody\" ).sortable({\r\n\t\t\t\tplaceholder : \"ui-state-highlight\",\r\n\t\t\t\tupdate  : function(event, ui)\r\n\t\t\t\t{\r\n\t\t\t\t\tvar All_IDs = new Array();\r\n\t\t\t\t\t\$('#tableBQ>tbody>tr').each(function(){\r\n\t\t\t\t\t\tAll_IDs.push(\$(this).attr(\"id\"));\r\n\t\t\t\t\t});\r\n\t\t\t\t\t\$.ajax({\r\n\t\t\t\t\t\turl:\"" . $this->base . "/doSort?noHeader=1&NH=1\",\r\n\t\t\t\t\t\tmethod:\"POST\",\r\n\t\t\t\t\t\tdata:{All_IDs:All_IDs},\r\n\t\t\t\t\t\tsuccess:function(data)\r\n\t\t\t\t\t\t{\r\n\t\t\t\t\t\t\t\$('#AjaxResult').html(data);\r\n\t\t\t\t\t\t}\r\n\t\t\t\t\t});\r\n\t\t\t\t}\r\n\t\t\t});\r\n\r\n\t\t});\r\n\t\t/* inline */\r\n\t\t\$.fn.editable.defaults.mode = 'inline';     \r\n\t\t\$('.editable').editable({\r\n\t\t\turl: '" . $this->base . "/EditInPlace?NH=1',\r\n\t\t\tsuccess: function(response) {\r\n\t\t\t/*alert(response);*/\r\n\t\t\t}\r\n\t\t});\r\n\t\t\$('.editableVis').editable({\r\n\t\t\t\turl: '" . $this->base . "/EditInPlace?NH=1',\r\n\t\t\t\tsuccess: function(response) {\r\n\t\t\t\t\t/*alert(response);*/\r\n\t\t\t\t},\r\n\t\t\t\t/*value: 2,*/\r\n\t\t\t\tsource: [{value: '1', text: 'Visibile'},{value: '0', text: 'Hidden'}]\r\n\t\t\t});\r\n\t\t</script>";
    }
    public function EditInPlace()
    {
        global $intro;
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        $data = [];
        $data[$name] = $value;
        $intro->db->update('bouquets', $data, 'id=' . $id);
    }
    public function doSort()
    {
        global $intro;
        $data_id = '';
        $menu = $intro->input->get_post('All_IDs');
        $j = 0;
        for( $i = 0; $i < count($menu); $i++ ) 
        {
            $j++;
            $id = intval($menu[$i]);
            $data_id .= ($i . ' ');
            $intro->db->query('UPDATE bouquets SET view_order=' . $j . ' WHERE id=' . $id . ' ');
        }
        echo ' :: Sort Done :: ' . $data_id;
    }
    public function FixOrder()
    {
        global $intro;
        $sql = $intro->db->query('select id from bouquets order by view_order ASC');
        $w1 = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $w1++;
            $id = intval($row['id']);
            $intro->db->query('UPDATE bouquets SET view_order=' . $w1 . ' WHERE id=' . $id . ' ');
        }
        $intro->redirect($this->appname);
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $bouquet_name;
        global $bouquet_icon;
        global $bouquet_status;
        global $bouquet_series;
        global $bouquet_channels;
        global $isLocked;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $id = intval($intro->input->get_post('id'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        echo '<script type="text/javascript" src="' . admin_path . "style/multi-select/jquery.min.js\"></script>\r\n\t\t<script type=\"text/javascript\" src=\"" . admin_path . "style/multi-select/jquery-ui.min.js\"></script>\r\n\t\t<script type=\"text/javascript\" src=\"" . admin_path . "style/multi-select/multiselect.js\"></script>\r\n\t\t<script type=\"text/javascript\" src=\"" . admin_path . "style/multi-select/multiselect_custom.js\"></script>\r\n\t\t<style>\r\n\t\t.centerButtons {\r\n\t\ttext-align:center;\r\n\t\t}\r\n\t\t.centerButtons div{\r\n\t\tmargin-top:10px;\r\n\t\t}\r\n\t\tselect#search, select#search_to\r\n\t\t{\r\n\t\tmin-height:300px;\r\n\t\twidth:100%;\r\n\t\t}\r\n\t\t#search option,#search_to option{\r\n\t\tmargin-top:10px;\r\n\t\t}\t\t\r\n\t\t</style>";
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * FROM bouquets where id=\'' . $id . '\'');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $bouquet_channels = $row['bouquet_channels'];
            $bouquet_series = $row['bouquet_series'];
            $btn['legend_name'] = $intro->lang['bouquets_edit'] . (' <b>' . $id . '</b>');
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = 'Save Changes';
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = $intro->lang['bouquets_add'];
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = 'Add New';
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $isLocked = ($isLocked == '' ? 0 : $isLocked);
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ', 'info');
        $max_input_vars = @ini_get('max_input_vars');
        $max_input_vars = intval($max_input_vars);
        if( $max_input_vars < 20000 ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Warning! You can add only (' . ($max_input_vars - 10) . ") streams to this bouquet.\r\n\t\t\t<br/> Ask you system admin to increase (max_input_vars) in php.ini file.", 'danger');
        }
        echo '<form method="POST"  action="' . $this->base . '/' . $btn['action'] . "\">\r\n\t\t\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>" . $intro->lang['bouquets_bouquet_name'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t\t\t<td><input  type=\"text\" name=\"bouquet_name\" value=\"" . $bouquet_name . '"  class="form-control"> ' . $this->error('bouquet_name') . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>") . $intro->lang['bouquets_bouquet_icon'] . ("</td>\r\n\t\t\t\t\t\t<td><input  type=\"text\" name=\"bouquet_icon\" value=\"" . $bouquet_icon . '" class="form-control"> ' . $this->error('bouquet_icon') . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Status :</td>\r\n\t\t\t\t\t\t<td>") . $this->bouquet_status($bouquet_status) . "</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>" . tooltip('tooltip_bouquet', 'isLocked') . " Locked :</td>\r\n\t\t\t\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('isLocked', $isLocked) . "</td>\r\n\t\t\t\t\t</tr>";
        echo "\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td>Streams :</td>\r\n\t\t\t\t\t\t<td>";
        $array = [];
        $optionsfisrt = $options_right = '';
        if( $t == 'edit' ) 
        {
            $chans = json_decode($bouquet_channels, true);
            if( is_array($chans) && count($chans) > 0 ) 
            {
                $array = array_map('intval', $chans);
                $array = implode(',', $array);
                $sql = $intro->db->query('SELECT id,stream_display_name,type ' . (' FROM  `streams` WHERE type!=5 AND id IN (' . $array . ')  ') . (' ORDER BY FIELD(id,' . $array . ') /*ORDER BY `order` ASC*/'));
                while( $myrowsql = $intro->db->fetch_assoc($sql) ) 
                {
                    $type = $myrowsql['type'];
                    $type_name = $this->type[$type];
                    $options_right .= ('<option value=\'' . $type . '|' . $myrowsql['id'] . '\'>' . $type_name . ' ' . $myrowsql['stream_display_name'] . '</option>');
                }
            }
            $options_right .= $this->series_right($bouquet_series);
        }
        $qq = '';
        if( $t == 'edit' && is_array($array) && count($array) > 0 ) 
        {
            $qq = ' AND id not IN (' . $array . ')';
        }
        $sql2 = $intro->db->query('SELECT id,stream_display_name,type FROM  `streams` where type!=5  ' . $qq . ' ORDER BY `type` ASC , `order` ASC');
        while( $myrowsql = $intro->db->fetch_assoc($sql2) ) 
        {
            $type = $myrowsql['type'];
            $type_name = $this->type[$type];
            $optionsfisrt .= ('<option value=\'' . $type . '|' . $myrowsql['id'] . '\'>' . $type_name . ' ' . $myrowsql['stream_display_name'] . '</option>');
        }
        $optionsfisrt .= $this->series_left($bouquet_series, $t);
        echo "\r\n\t\t\t\t<div class=\"row\">\r\n\t\t\t\t<div class=\"col-xs-5\">\r\n\t\t\t\t\t<select name=\"\" id=\"search\" style=\"background:#f2f2f2;\" size=\"20\" multiple=\"multiple\">\r\n\t\t\t\t\t\t" . $optionsfisrt . "\r\n\t\t\t\t\t</select>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class=\"col-xs-2 centerButtons\">\r\n\t\t\t\t\t<div><a id=\"search_rightAll\" class=\"btn btn-info\"><i class=\"glyphicon glyphicon-forward\"></i></a></div>\r\n\t\t\t\t\t<div><a id=\"search_rightSelected\" class=\"btn btn-info\"><i class=\"glyphicon glyphicon-chevron-right\"></i></a></div>\r\n\t\t\t\t\t<div><a id=\"search_leftSelected\" class=\"btn btn-info\"><i class=\"glyphicon glyphicon-chevron-left\"></i></a></div>\r\n\t\t\t\t\t<div><a id=\"search_leftAll\" class=\"btn btn-info\"><i class=\"glyphicon glyphicon-backward\"></i></a></div>\r\n\t\t\t\t</div>\r\n\r\n\t\t\t\t<div class=\"col-xs-5\">\r\n\t\t\t\t\r\n\t\t\t\t<select name=\"to[]\" id=\"search_to\" style=\"background:#f2f2f2;\" size=\"20\" multiple=\"multiple\" class=\"ui-droppable\">\r\n\t\t\t\t" . $options_right . "\r\n\t\t\t\t</select>\r\n\t\t\t\t\r\n\t\t\t\t<a class=\"btn btn-info btnAsc\" style=\"float:left;width:10%;\">A-Z</a><a class=\"btn btn-info btnDesc\" style=\"float:left;width:10%;margin-top:0px;margin-left:2px;\">Z-A</a>\r\n\t\t\t\t<a class=\"btn btn-info btnUp\" style=\"float:left;width:10%;margin-top:0px;margin-left:2px;\">U</a> <a  class=\"btn btn-info btnDown\" style=\"float:left;width:10%;margin-top:0px;margin-left:2px;\">D</a>\r\n\t\t\t\t\r\n\t\t\t\t</div>\r\n\t\t\t\t</div>";
        echo "</td>\r\n\t\t\t</tr>";
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td></td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\r\n\t\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \r\n\t\t\t\t\t</button>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function series_left($bouquet_series, $t)
    {
        global $intro;
        global $array;
        $html = '';
        $qry = '';
        if( $t == 'edit' ) 
        {
            $chans = json_decode($bouquet_series, true);
            if( is_array($chans) && count($chans) > 0 ) 
            {
                $array = array_map('intval', $chans);
                $array = implode(',', $array);
                $qry = ' WHERE id not IN (' . $array . ') ';
            }
        }
        $result = $intro->db->query('SELECT id,title FROM `series` ' . $qry . ' ORDER BY `last_modified` DESC');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $html .= ('<option  value="5|' . $id . '">[series] ' . $title . ' </option>');
        }
        return $html;
    }
    public function series_right($bouquet_series)
    {
        global $intro;
        global $array;
        $html = '';
        $chans = json_decode($bouquet_series, true);
        if( is_array($chans) && count($chans) > 0 ) 
        {
            $array = array_map('intval', $chans);
            $array = implode(',', $array);
            $result = $intro->db->query('SELECT id,title FROM `series` WHERE id IN (' . $array . ') ORDER BY `last_modified` DESC');
            while( $myrow = $intro->db->fetch_assoc($result) ) 
            {
                @extract($myrow);
                $html .= ('<option  value="5|' . $id . '">[series]' . $title . '</option>');
            }
        }
        return $html;
    }
    public function Stream_Chanels_found($id)
    {
        global $intro;
        global $array;
        $bouquet_channels = '';
        $result = $intro->db->query('SELECT * FROM  bouquets WHERE id=\'' . $id . '\' ');
        $myrow = $intro->db->fetch_assoc($result);
        @extract($myrow);
        $bouquet_channels = json_decode($myrow['bouquet_channels']);
        return $bouquet_channels;
    }
    public function Stream_Chanels()
    {
        global $intro;
        global $array;
        $result = $intro->db->query('SELECT * FROM `streams` WHERE type!=5 order by `order` ASC');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<option  value="' . $id . '">' . $stream_display_name . ' </option>';
        }
    }
    public function bouquet_status($bouquet_status)
    {
        global $intro;
        global $error;
        if( $bouquet_status == '' ) 
        {
            $bouquet_status = 1;
        }
        $html = "<label class=\"radio-inline\">\r\n\t\t\t\t<input type=\"radio\" name=\"bouquet_status\" value='1' " . (($bouquet_status == 1 ? 'checked' : '')) . ">\r\n\t\t\t\t\t<span class='label label-success'>Visibile To Resellers</span>\r\n\t\t\t\t</label>\r\n\t\t\t<label class=\"radio-inline\">\r\n\t\t\t\t<input type=\"radio\" name=\"bouquet_status\" value='0' " . (($bouquet_status == 0 ? 'checked' : '')) . ">\r\n\t\t\t\t<span class='label label-default'>Hidden</span>\r\n\t\t\t</label>";
        return $html;
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $added_series = $intro->input->post('added_series');
        $added_streams = $intro->input->post('added_streams');
        $added_movies = $intro->input->post('added_movies');
        $bouquet_name = trim($intro->input->post('bouquet_name'));
        $bouquet_icon = trim($intro->input->post('bouquet_icon'));
        $bouquet_status = intval($intro->input->post('bouquet_status'));
        if( $bouquet_name == '' ) 
        {
            if( $bouquet_name == '' ) 
            {
                $error['bouquet_name'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            $this->Form('add');
            exit();
        }
        $data = [];
        $data['bouquet_name'] = $bouquet_name;
        $data['bouquet_icon'] = $bouquet_icon;
        $data['bouquet_status'] = $bouquet_status;
        $data_to = $intro->input->post('to');
        if( is_array($data_to) && count($data_to) > 0 ) 
        {
            foreach( $data_to as $id ) 
            {
                list($type, $strm_id) = explode('|', $id);
                if( $type == 5 ) 
                {
                    $ar_series[] = $strm_id;
                }
                else
                {
                    $ar_streams[] = $strm_id;
                }
            }
            if( count($ar_streams) > 0 ) 
            {
                $data['bouquet_channels'] = json_encode($ar_streams);
            }
            else
            {
                $data['bouquet_channels'] = '[]';
            }
            if( count($ar_series) > 0 ) 
            {
                $data['bouquet_series'] = json_encode($ar_series);
            }
            else
            {
                $data['bouquet_series'] = '[]';
            }
        }
        $intro->db->insert('bouquets', $data);
        $intro->redirect($this->appname);
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        global $error;
        global $bouquet_channels;
        $id = intval($intro->input->post('id'));
        $data = [];
        $data['bouquet_name'] = trim($intro->input->post('bouquet_name'));
        $data['bouquet_icon'] = trim($intro->input->post('bouquet_icon'));
        $data['bouquet_status'] = intval($intro->input->post('bouquet_status'));
        $ar_streams = $ar_series = [];
        $data_to = $intro->input->post('to');
        if( is_array($data_to) && count($data_to) > 0 ) 
        {
            foreach( $data_to as $Postid ) 
            {
                list($type, $strm_id) = explode('|', $Postid);
                if( $type == 5 ) 
                {
                    $ar_series[] = $strm_id;
                }
                else
                {
                    $ar_streams[] = $strm_id;
                }
            }
            if( count($ar_streams) > 0 ) 
            {
                $data['bouquet_channels'] = json_encode($ar_streams);
            }
            else
            {
                $data['bouquet_channels'] = '[]';
            }
            if( count($ar_series) > 0 ) 
            {
                $data['bouquet_series'] = json_encode($ar_series);
            }
            else
            {
                $data['bouquet_series'] = '[]';
            }
        }
        $intro->db->update('bouquets', $data, 'id=' . $id);
        $aff = $intro->db->affected_rows;
        $intro->redirect($this->appname);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('DELETE FROM bouquets WHERE id=' . $id . ' ');
        $intro->redirect($this->appname);
    }
    public function EditChans()
    {
        global $intro;
        global $array;
        $qry = '';
        $edit = new StreamsEdit($this->base);
        $id = intval($intro->input->get_post('id'));
        $this->nav();
        $result = $intro->db->query('SELECT * from bouquets WHERE id=' . $id . ';');
        $myrow = $intro->db->fetch_assoc($result);
        extract($myrow);
        $chans = json_decode($bouquet_channels, true);
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<h3><i class="icon-edit"></i>' . $bouquet_name . '</h3>', 'info');
        $edit->TableStart();
        $i = 0;
        if( is_array($chans) && count($chans) > 0 ) 
        {
            foreach( $chans as $chID ) 
            {
                $i++;
                $sql = $intro->db->query('SELECT * ,(select count(*) from user_activity_now where stream_id=s.id) as tot  from streams s  LEFT JOIN `streams_sys` sys ON s.id=sys.stream_id where s.id=' . intval($chID));
                $row = $intro->db->fetch_assoc($sql);
                if( !$row ) 
                {
                    continue;
                }
                $edit->Row($row, $i);
            }
        }
        echo "</tbody>\r\n\t\t</table>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        $edit->JavaScript();
    }
    public function EditChannel()
    {
        global $intro;
        global $array;
        $edit = new StreamsEdit($this->base);
        $edit->EditChannel();
    }
    public function doEditChannel()
    {
        global $intro;
        global $array;
        $edit = new StreamsEdit($this->base);
        $edit->doEditChannel();
    }
    public function getStreams($bouquet_channels, $t)
    {
        global $intro;
        global $array;
        return '';
        $cur_chans = json_decode($bouquet_channels, true);
        echo '<select multiple="multiple" size="10" name="BqChans[]" id="sourceSelect">';
        $result = $intro->db->query('select id,stream_display_name,category_id,type from streams WHERE type IN (1,2,3,4) Order by type ASC ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            if( $type == 1 ) 
            {
                $type = 'Live';
            }
            if( $type == 2 ) 
            {
                $type = 'Movie';
            }
            if( $type == 3 ) 
            {
                $type = 'Created';
            }
            echo '<option value="' . $id . '" ' . ((is_array($cur_chans) && in_array($id, $cur_chans) ? 'selected=\'\'' : '')) . ('>[' . $type . '] ' . $stream_display_name . '</option>');
        }
        echo '</select>';
    }
    public function getChannels($bouquet_channels, $bouquet_series)
    {
        global $intro;
        global $array;
        $chans = json_decode($bouquet_channels, true);
        $qry = implode(',', $chans);
        if( $qry == '' ) 
        {
            $qry = 0;
        }
        $result = $intro->db->query('select id,stream_display_name,category_id,type from streams WHERE id IN (' . $qry . ') ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<li>' . $category_id . ' = ' . $stream_display_name . '</li>';
        }
        echo '<ul>';
        $chans = json_decode($bouquet_series, true);
        $qry = implode(',', $chans);
        if( $qry == '' ) 
        {
            $qry = 0;
        }
        $result = $intro->db->query('select * from series WHERE id IN (' . $qry . ') ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<li>' . $category_id . ' = ' . $title . '</li>';
        }
        echo '</ul>';
    }
    public function copy_cat()
    {
        global $intro;
        $sql = $intro->db->query('select * from bouquets order by view_order ASC');
        $bq = [];
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $ch = json_decode($row['bouquet_channels'], true);
            $ser = json_decode($row['bouquet_series'], true);
            $tot_ch = (is_array($ch) ? count($ch) : 0);
            $tot_ser = (is_array($ser) ? count($ser) : 0);
            $bq[$id] = $bouquet_name . (' (' . $tot_ch . ') ') . (($tot_ser > 0 ? ' (Series=' . $tot_ser . ')' : ''));
        }
        $sql = $intro->db->query('select * ,(select count(id) from streams where category_id=st_cat.id) as tot_streams  from stream_categories st_cat where st_cat.category_type=\'live\' order by st_cat.cat_order ASC');
        $cats = [];
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $cats[$id] = $category_name . (' (' . $tot_streams . ')');
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' <h3>Make streams of bouquet=category</h3>', 'warning');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doCopy_bq2cat\" enctype=\"multipart/form-data\">\r\n\t\t\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>Bouquet:</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('bq', $bq, 0, 'Choose Bouquet') . "</td>\r\n\t\t\t<td>Category:</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('cat', $cats, 0, 'Choose Category') . "</td>\r\n\t\t\t\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\tThis clear all streams for target (Category) and copy all streams form selected (Bouquet)\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\r\n\t\t\t\t\tMake Channels of Bouquet = Category\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' <h3>Make streams of category=bouquet</h3>', 'info');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doCopy_cat2bq\" enctype=\"multipart/form-data\">\r\n\t\t\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>Category:</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('cat', $cats, 0, 'Choose Category') . "</td>\r\n\t\t\t<td>Bouquet:</td>\r\n\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('bq', $bq, 0, 'Choose Bouquet') . "</td>\r\n\t\t</tr>\r\n\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\r\n\t\t\t\t\tMake Channels of Category = Bouquet\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\t\$( document ).ready(function() {\r\n\t\t\t\t\$('.chosen-drop').css({minWidth: '400px', width: 'auto'});\r\n\t\t\t\t\$('.chosen-select').each(function() {\r\n\t\t\t\t\tvar itm = \$(this);\r\n\t\t\t\t\titm.next().css({'width': '225px'});\r\n\t\t\t\t});\r\n\t\t\t});\r\n\t\t</script>";
    }
    public function doCopy_bq2cat()
    {
        global $intro;
        $bq = intval($intro->input->post('bq'));
        $cat = intval($intro->input->post('cat'));
        $aff = $cleared_cat = 0;
        if( $cat == 0 || $bq == 0 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('error you must chose both sides', 'danger') );
        }
        $sql = $intro->db->query('select bouquet_channels from bouquets where id=' . $bq . ';');
        $streams = [];
        $row = $intro->db->fetch_assoc($sql);
        $ch = json_decode($row['bouquet_channels'], true);
        $intro->db->query('START TRANSACTION;');
        if( is_array($ch) && count($ch) > 1 ) 
        {
            $intro->db->query('UPDATE streams SET category_id=0 where category_id=' . $cat . ';');
            $cleared_cat = $intro->db->affected_rows;
            $aff = 0;
            foreach( $ch as $id ) 
            {
                $intro->db->update('streams', ['category_id' => $cat], 'id=\'' . $id . '\'');
                $aff += $intro->db->affected_rows;
            }
        }
        $intro->db->query('COMMIT;');
        $intro->redirect($this->appname, 'copy_cat', '?affected=' . $aff . '&amp;cleared_ch_from_cat=' . $cleared_cat);
    }
    public function doCopy_cat2bq()
    {
        global $intro;
        $bq = intval($intro->input->post('bq'));
        $cat = intval($intro->input->post('cat'));
        if( $cat == 0 || $bq == 0 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('error you must chose both sides', 'danger') );
        }
        $sql = $intro->db->query('select id from streams where category_id=' . $cat . ' order by `order` ASC');
        $streams = [];
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $streams[] = $id;
        }
        if( count($streams) <= 0 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('error: selected bouquet is empty', 'danger') );
        }
        $intro->db->update('bouquets', ['bouquet_channels' => json_encode($streams)], 'id=' . $bq);
        $aff = $intro->db->affected_rows;
        $intro->redirect($this->appname, 'copy_cat', '?affected=' . $aff);
    }
    public function col()
    {
        global $intro;
        $sql = $intro->db->query('CREATE  TABLE IF NOT EXISTS `solus_bq_col` (`bq` int(11) NOT NULL,`ch` int(11) NOT NULL,KEY `bq` (`bq`),KEY `ch` (`ch`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;');
        $sql = $intro->db->query('delete from solus_bq_col where true;');
        $sql = $intro->db->query('truncate solus_bq_col;');
        $sql = $intro->db->query('SELECT * from bouquets order by view_order ASC;');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Find Duplicated Streams Across Bouquets', 'danger');
        echo "<h5 class='red'>This tool helps you find duplicated streams between Bouquets.<br/>\r\n\t\tSometimes by mistake a wrong stream added to wrong Bouquet and all streams on m3u get wrong Order.</h5>";
        $all_chans = $found = [];
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $id = $row['id'];
            $bouquet_name = $row['bouquet_name'];
            $bouquet_channels = json_decode($row['bouquet_channels'], true);
            $bouquet_series = json_decode($row['bouquet_series'], true);
            foreach( $bouquet_channels as $ch ) 
            {
                if( is_array($ch) ) 
                {
                    echo ' <li>Error in bouquet: ' . $bouquet_name . '<li>';
                    $ch = '';
                    continue;
                }
                $intro->db->query_fast('INSERT INTO `solus_bq_col` (`bq`, `ch`) VALUES (\'' . $id . '\', \'' . $ch . '\');');
            }
        }
        $sql = $intro->db->query('SELECT *,(select type from streams where id=ch) as ch_type,(select stream_display_name from streams where id=ch) as ch_name,(select bouquet_name from bouquets where id=bq) as bq_name FROM `solus_bq_col` where bq!=2 ORDER BY bq ASC;');
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22();
        echo "<table class=\"table table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<th>#</th>\r\n\t\t\t<th>Stream ID</th>\r\n\t\t\t<th>Stream Name</th>\r\n\t\t\t<th>Bouquet ID</th>\r\n\t\t\t<th>Bouquet Name</th>\r\n\t\t\t<th> </th>\r\n\t\t</tr>";
        $all_chans = $found = [];
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $i++;
            if( $ch_type != 1 ) 
            {
                echo "<tr>\r\n\t\t\t\t<td>" . $i . "</td>\r\n\t\t\t\t<td>" . $ch . "</td>\r\n\t\t\t\t<td>" . $ch_type . ' | ' . $ch_name . "</td>\r\n\t\t\t\t<td>" . $bq . "</td>\r\n\t\t\t\t<td>" . $bq_name . "</td>\r\n\t\t\t\t<td></td>\r\n\t\t\t</tr>";
            }
        }
        echo '</table>';
        exit();
        $sql = $intro->db->query('SELECT *,(select stream_display_name from streams where id=ch) as ch_name,(select bouquet_name from bouquets where id=bq) as bq_name FROM `solus_bq_col` WHERE ch IN (SELECT ch FROM `solus_bq_col` GROUP BY ch HAVING COUNT(ch)>1) order by ch DESC;');
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22();
        echo "<table class=\"table table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<th>#</th>\r\n\t\t\t<th>Stream ID</th>\r\n\t\t\t<th>Stream Name</th>\r\n\t\t\t<th>Bouquet ID</th>\r\n\t\t\t<th>Bouquet Name</th>\r\n\t\t\t<th> </th>\r\n\t\t</tr>";
        $all_chans = $found = [];
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            extract($row);
            $i++;
            echo "<tr>\r\n\t\t\t\t<td>" . $i . "</td>\r\n\t\t\t\t<td>" . $ch . "</td>\r\n\t\t\t\t<td>" . $ch_name . "</td>\r\n\t\t\t\t<td>" . $bq . "</td>\r\n\t\t\t\t<td>" . $bq_name . "</td>\r\n\t\t\t\t<td><a class=\"btn btn-info p_edit\" href=\"" . $this->base . '/Form?t=edit&amp;id=' . $bq . '" title="' . $intro->lang['edit'] . "\"><i class=\"icon-edit\"></i></a></td>\r\n\t\t\t</tr>";
        }
        echo '</table>';
        $sql = $intro->db->query('delete from solus_bq_col where true;');
        $sql = $intro->db->query('truncate solus_bq_col;');
    }
}
