<?php 
class Bouquets_resel_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $max_input_vars = 0;
    public $admin = [];
    public $inputBy = [
        'Code', 
        'MAC', 
        'Serial'
    ];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . "/index\">\r\n\t\t\t<icon class=\"icon-edit\"></icon>Edit ") . $intro->lang['bouquets_appname'] . "</a> \r\n\t\t\r\n\t\t</div>";
    }
    public function index()
    {
        global $intro;
        $this->nav();
        echo '<div class=\'ltr\' dir=\'ltr\'>';
        $this->search_form();
        echo '</div>';
    }
    public function search_form()
    {
        global $intro;
        global $array;
        $max_input_vars = @ini_get('max_input_vars');
        $max_input_vars = intval($max_input_vars);
        if( $max_input_vars == 0 ) 
        {
            $max_input_vars = 1000;
        }
        else
        {
            $max_input_vars = $max_input_vars - 100;
        }
        $this->max_input_vars = $max_input_vars;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<icon class="icon-edit"></icon> Bouquets Oprations', 'danger');
        echo "\r\n\t\t<form id=\"form_add\" action=\"\" method=\"post\">\r\n\t\t<table class='table table-bordered' style='max-width:600px'>\r\n\t\t<tr>\r\n\t\t\t\t<td>Fullname</td>\r\n\t\t\t\t<td>Use * for wildcards <input type='hidden' name='fullname_op' value='LIKE'></td>\r\n\t\t\t\t<td><input type=\"text\" name=\"fullname\" value=\"\" id=\"fullname\" /> exaple: jhon* or *hon* </td>\r\n\t\t</tr> \r\n\t\t<tr>\r\n\t\t\t\t<td>TransID</td>\r\n\t\t\t\t<td>" . $this->operator('transid') . "</td>\r\n\t\t\t\t<td><input type=\"text\" name=\"transid\" value=\"\" id=\"transid\" /></td>\r\n\t\t</tr> \r\n\r\n\t\t<tr>\r\n\t\t\t\t<td>Days (Months)</td>\r\n\t\t\t\t<td>" . $this->operator('period') . "</td>\r\n\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', $array['period'], '', 'ALL ...') . "</td>\r\n\t\t</tr> \r\n\t\t<tr>\r\n\t\t\t\t<td>Username</td>\r\n\t\t\t\t<td>Use * for wildcards <input type='hidden' name='username_op' value='LIKE'></td>\r\n\t\t\t\t<td><input type=\"text\" name=\"username\" value=\"\" id=\"username\" /></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t\t<td>Status</td>\r\n\t\t\t\t<td>" . $this->operator('status') . "</td>\r\n\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('status', $intro->status, '', 'ALL ...') . ("</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t\t<td>Row Limit : " . $max_input_vars . "</td>\r\n\t\t\t\t<td> Example:</td>\r\n\t\t\t\t<td><input type=\"text\" name=\"limit\" value=\"0\" id=\"limit\" size=\"10\" /> 0= unlimited\r\n\t\t\t\t<li>0,1000</li>\r\n\t\t\t\t<li>1000,1000</li>\r\n\t\t\t\t<li>2000,1000</li>\r\n\t\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t\t<td> </td>\r\n\t\t\t\t<td> </td>\r\n\t\t\t\t<td><input name=\"name\" value=\" Search \" type=\"submit\"></td>\r\n\t\t</tr>\t\t\r\n\t\t</table>\r\n\t\t<input type=\"hidden\" name=\"max_input_vars\" value=\"" . $max_input_vars . "\" />\r\n\t\t</form>");
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\t\t<script type=\"text/javascript\">\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\$(\"#form_add\").submit( function () {   \r\n\t\t\t\t\$('#result').html('loading...');\r\n\t\t\t\t\$.post('";
        echo $this->base;
        echo "/doSearch?NH=1',\$(this).serialize(),function(data){\r\n\t\t\t\t\t\$(\"#result\").html(data)\r\n\t\t\t\t}\r\n\t\t\t  );\r\n\t\t\t  return false;   \r\n\t\t\t});   \r\n\t\t});\r\n\t\t</script>\r\n\t\t<div id=\"result\"></div>\r\n\t\t";
    }
    public function operator($fld)
    {
        return '<select name="' . $fld . "_op\">\r\n\t\t<option value=\"=\">=</option>\r\n\t\t<option value=\">\">&gt;</option>\r\n\t\t<option value=\">=\">&gt;=</option>\r\n\t\t<option value=\"<\">&lt;</option>\r\n\t\t<option value=\"<=\">&lt;=</option>\r\n\t\t<option value=\"!=\">!=</option>\r\n\t\t<option value=\"LIKE\">LIKE * *</option>\r\n\t\t<option value=\"NOT LIKE\">NOT LIKE</option>\r\n\t\t<option value=\"IN (...)\">IN (...)</option>\r\n\t\t<option value=\"NOT IN (...)\">NOT IN (...)</option>\r\n\t\t<option value=\"IS NULL\">IS NULL</option>\r\n\t\t<option value=\"IS NOT NULL\">IS NOT NULL</option>\r\n\t\t</select>";
    }
    public function doSearch()
    {
        global $intro;
        global $array;
        $limit = intval($intro->input->post('limit'));
        $max_input_vars = intval($intro->input->post('max_input_vars')) - 50;
        if( $limit != 0 ) 
        {
            $limit = 'LIMIT ' . $limit;
        }
        else
        {
            $limit = '';
        }
        $qry = $this->_getWhereClause($_POST);
        if( $qry == '' ) 
        {
            exit( '<fieldset><span class=\'red big\'>Please put anything to search for.</span></fieldset>' );
        }
        $adminid = intval($this->admin['adminid']);
        $result = $intro->db->query('SELECT * from ' . PREFIX . '_codes ' . (' where adminid=' . $adminid . ' ' . $qry . ' order by date_expire ASC ' . $limit));
        $totalrows = $intro->db->returned_rows;
        if( $max_input_vars < $totalrows ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4>We found: ' . number_format($totalrows) . (" codes.\r\n\t\t\t<br/>Codes are more than " . $max_input_vars . ", please narrow your search.<br/>\r\n\t\t\tYou can run the following commands on the (") . number_format($totalrows) . ' rows) at once.</h4>', 'info');
            $this->sqlCMD($qry, $totalrows);
            exit();
        }
        if( $totalrows > 0 ) 
        {
            echo '<form action="' . $this->base . '/doCMD" method="post" name="fieldsForm"  id="fieldsForm">';
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Found Codes (' . $totalrows . ') ', 'info');
            echo "\t\t\t\r\n\t\t\t<table class=\"table table-bordered\">\r\n\t\t\t<thead>\r\n\t\t\t<tr>\r\n\t\t\t\t<th> </th>\r\n\t\t\t\t<th>" . $intro->lang['codes_fullname'] . ' ' . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('fullname', 'index') . " </th>\r\n\t\t\t\t<th>" . $intro->lang['codes_code'] . '  </th>';
            if( $intro->input->post('username') != '' ) 
            {
                echo '<th>Username </th>';
            }
            echo "\r\n\t\t\t\t<th>" . $intro->lang['codes_days'] . " </th>\r\n\t\t\t\t<th>" . $intro->lang['codes_transid'] . " </th>\r\n\t\t\t\t<th>" . $intro->lang['codes_status'] . "  </th>\r\n\t\t\t\t<th>MAC </th>\r\n\t\t\t\t<th>Serial</th>\r\n\t\t\t\t<th>Expire</th>\r\n\t\t\t\t<th>Input</th>\r\n\t\t\t\t<th>Options</th>\r\n\t\t\t</tr>\r\n\t\t\t</thead>\r\n\t\t\t\r\n\t\t\t<tbody>";
            $i = 0;
            while( $myrow = $intro->db->fetch_assoc($result) ) 
            {
                @extract($myrow);
                $i++;
                $code_replaced = $myrow['code_replaced'];
                if( $status == 0 ) 
                {
                    $label = 'default';
                }
                else if( $status == 1 ) 
                {
                    $label = 'success';
                }
                else if( $status == 2 ) 
                {
                    $label = 'info';
                }
                else if( $status == 3 ) 
                {
                    $label = 'danger';
                }
                else if( $status == 4 ) 
                {
                    $label = 'default';
                }
                else if( $status == 5 ) 
                {
                    $label = 'warning';
                }
                else
                {
                    $label = 'danger';
                }
                $date_expire = ($date_expire != '' ? @date('Y-m-d', $date_expire) : '-');
                echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td><input type=\"checkbox\" id=\"checkbox_row_" . $id . ('" value="' . $id . "\" name=\"selected_fld[]\"></td>\r\n\t\t\t\t<td>" . $fullname . "</td>\r\n\t\t\t\t<td>" . $code . '</td>');
                if( $intro->input->post('username') != '' ) 
                {
                    echo '<td>' . $username . '</td>';
                }
                echo "\r\n\t\t\t\t<td>" . $days . "</td>\r\n\t\t\t\t<td>" . $transid . "</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<span class='label label-" . $label . '\'>' . $intro->status[$status] . ' ' . (($code_replaced != '' ? '<br/>' . $code_replaced : '')) . '</span>';
                if( $status != 3 ) 
                {
                }
                echo "\r\n\t\t\t\t</td>\r\n\t\t\t\t<td>" . $mac . "</td>\r\n\t\t\t\t<td>" . $serial . "</td>\r\n\t\t\t\t<td>" . $date_expire . "</td>\r\n\t\t\t\t<td>" . $this->inputBy[$inputBy] . "</td>\r\n\t\t\t\t<td class=\"center\"> \r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
            }
            echo "</tbody>\r\n\t\t\t\t</table>";
            $this->optionCMD();
            echo '</fieldset>';
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            echo '</form>';
            echo $this->base;
            echo "/doCMD?NH=1',\$(this).serialize(),function(data){\r\n\t\t\t\t\t\t\r\n\t\t\t\t\t\t\$(\"#resultCMD\").html(data)\r\n\t\t\t\t\t}\r\n\t\t\t\t  );\r\n\t\t\t\t  return false;   \r\n\t\t\t\t});\r\n\t\t\t});\r\n\t\t\t</script>\r\n\t\t\t";
        }
        else
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Nothing found.', 'danger');
        }
    }
    public function _getWhereClause($post)
    {
        $where = '';
        foreach( $post as $key => $val ) 
        {
            $op = $key . '_op';
            if( isset($post[$op]) ) 
            {
                if( $post[$op] == '=' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' = \'' . $val . '\' ');
                }
                if( $post[$op] == '>' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' > \'' . $val . '\' ');
                }
                if( $post[$op] == '<' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' < \'' . $val . '\' ');
                }
                if( $post[$op] == '!=' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' != \'' . $val . '\'');
                }
                if( $post[$op] == '>=' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' >= \'' . $val . '\' ');
                }
                if( $post[$op] == '<=' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' <= \'' . $val . '\' ');
                }
                if( $post[$op] == 'LIKE' && $val != '' ) 
                {
                    $val = str_replace('*', '%', $val);
                    $where .= ('AND ' . $key . ' LIKE \'' . $val . '\' ');
                }
                if( $post[$op] == 'IN (...)' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' IN (' . $val . ') ');
                }
                if( $post[$op] == 'NOT IN (...)' && $val != '' ) 
                {
                    $where .= ('AND ' . $key . ' NOT IN (' . $val . ') ');
                }
            }
        }
        return $where;
    }
    public function optionCMD($totalrows = 0)
    {
        global $intro;
        global $array;
        global $adminid;
        global $type;
        global $status;
        $adminid = 0;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Warning: Warning: Warning: Backup your data first!!! ', 'danger');
        echo " \r\n\t\t<table class=\"table table-bordered\" id=\"TableCMD\">\r\n\t\t<tr>\r\n\t\t\t<td style='width:200px'> Change Bouquets:\r\n\t\t\t\t<div>\r\n\t\t\t\t\t   تحديد الكل <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\r\n\t\t\t\t</div>\r\n\t\t\t\t\r\n\t\t\t</td>\r\n\t\t\t<td id=\"BQ_CHECK_BOXES\" style='width:250px;'>" . bouquets([]) . "</td>\r\n\t\t\t<td style='width:70%'>\r\n\t\t\t\t<table class='table table-bordered'>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td><input type=\"radio\" name=\"bouquetsOptions\" value=\"all\"/></td>\r\n\t\t\t\t\t\t<td style='color:red;'>(Replace ALL)</td>\r\n\t\t\t\t\t\t<td>This will override all Bouquets for all selected codes.</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td><input type=\"radio\" name=\"bouquetsOptions\" value=\"add\"/></td>\r\n\t\t\t\t\t\t<td style='color:green;'>(Add Selected)</td>\r\n\t\t\t\t\t\t<td>Select the Bouquets to add to codes , this option will keep all packages and add the new ones you select.</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t\t<tr>\r\n\t\t\t\t\t\t<td><input type=\"radio\" name=\"bouquetsOptions\" value=\"remove\"/></td>\r\n\t\t\t\t\t\t<td style='color:blue;'>(Remove Selected)</td>\r\n\t\t\t\t\t\t<td>Remove selected Bouquets, this option will keep all packages and remove the new ones you select.</td>\r\n\t\t\t\t\t</tr>\r\n\t\t\t\t</table>\r\n\t\t\t\t\t\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t</table>\r\n\t\t<input class=\"btn btn-danger\" name=\"namesubbtn\" value=\"  " . (($totalrows > 0 ? ' Update All (' . number_format($totalrows) . ') rows Now!' : '  GO  ')) . ' " type="submit" OnClick="return confirm(\'Are you sure? this is final.\');">';
        echo "\r\n\t\t<style>\r\n\t\t\t#TableCMD tr{cursor:pointer}\r\n\t\t</style>\r\n\t\t<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\r\n\t\t\t\r\n\t\t\t\$(\"#checkAll\").change(function () {\r\n\t\t\t\t\$(\"#BQ_CHECK_BOXES input:checkbox\").prop('checked', \$(this).prop(\"checked\"));\r\n\t\t\t});\r\n\t\t});\r\n\t\t</script>";
    }
    public function doCMD()
    {
        global $intro;
        global $array;
        $maa = trim($intro->input->post('maa'));
        $bouquetsOptions = trim($intro->input->post('bouquetsOptions'));
        $all_ids = $intro->input->post('selected_fld');
        $bouquets_post_array = $intro->input->post('bouquets');
        if( !is_array($bouquets_post_array) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Please choose bouquets', 'danger');
            exit();
        }
        if( !is_array($all_ids) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Please choose codes', 'danger');
            exit();
        }
        $bouquets_str = implode(',', $bouquets_post_array);
        if( $bouquetsOptions == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Please choose Replace or Add or Remove bouquets', 'danger');
            exit();
        }
        $num = $num2 = 0;
        for( $i = 0; $i < count($all_ids); $i++ ) 
        {
            $id = intval($all_ids[$i]);
            $sql = $intro->db->query('select code,username,bouquets,inputBy from ' . PREFIX . ('_codes where id=' . $id . ';'));
            $row = $intro->db->fetch_assoc($sql);
            $db_bq = explode(',', $row['bouquets']);
            if( $bouquetsOptions == 'add' ) 
            {
                $merge = array_merge($db_bq, $bouquets_post_array);
                $unique = array_unique($merge);
                $bouquets_str = implode(',', $unique);
            }
            if( $bouquetsOptions == 'remove' ) 
            {
                $diff = array_diff($db_bq, $bouquets_post_array);
                $bouquets_str = implode(',', $diff);
            }
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set bouquets=\'' . $bouquets_str . '\' where id=' . $id . ';'));
            $num += $intro->db->affected_rows;
            if( $row['username'] != '' && $row['inputBy'] > 0 ) 
            {
                $intro->db->query_fast('UPDATE users SET bouquet=\'[' . $bouquets_str . ']\' where username=\'' . $row['username'] . '\';');
            }
            else
            {
                $intro->db->query_fast('UPDATE users SET bouquet=\'[' . $bouquets_str . ']\' where username=\'' . $row['code'] . '\';');
            }
            $num2 += $intro->db->affected_rows;
        }
        $xtream = ', Xtream Affected rows (' . $num2 . ') ';
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Affected Rows = (' . $num . ') ' . $xtream, 'success');
    }
    public function sqlCMD($qry, $totalrows = 0)
    {
        global $intro;
        echo "\r\n\t\t<form action=\"" . $this->base . '/doCMDsql" method="post" name="fieldsForm"  id="fieldsForm">';
        echo '<fieldset>';
        $this->optionCMD($totalrows);
        echo '</fieldset>';
        echo "\r\n\t\t\t<input type=\"hidden\" name=\"qry\" value=\"" . $qry . "\" />\r\n\t\t\t</form>";
        echo "\t\t<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\$(\"#fieldsForm\").submit( function () {   \r\n\t\t\t\t\$('#resultCMD').html('loading...');\r\n\t\t\t\t\$.post('";
        echo $this->base;
        echo "/doCMDsql?NH=1',\$(this).serialize(),function(data){\r\n\t\t\t\t\t\r\n\t\t\t\t\t\$(\"#resultCMD\").html(data)\r\n\t\t\t\t}\r\n\t\t\t  );\r\n\t\t\t  return false;   \r\n\t\t\t});   \r\n\t\t});\r\n\t\t</script>\r\n\t\t<div id=\"resultCMD\"></div>\r\n\t\t";
    }
    public function doCMDsql()
    {
        global $intro;
        global $array;
        $xtream = '';
        $maa = trim($intro->input->post('maa'));
        $bouquetsOptions = trim($intro->input->post('bouquetsOptions'));
        $bouquets_post_array = $intro->input->post('bouquets');
        if( !is_array($bouquets_post_array) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Please choose bouquets', 'danger');
            exit();
        }
        $bouquets_str = implode(',', $bouquets_post_array);
        if( $bouquetsOptions == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Please choose Replace or Add or Remove bouquets', 'danger');
            exit();
        }
        $qry = $_POST['qry'];
        $num = $num2 = 0;
        $adminid = intval($this->admin['adminid']);
        $sql = $intro->db->query_fast('select id,code,username,bouquets,inputBy from ' . PREFIX . '_codes ' . (' WHERE adminid=' . $adminid . ' ' . $qry . ';'));
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $id = intval($row['id']);
            $db_bq = explode(',', $row['bouquets']);
            if( $bouquetsOptions == 'add' ) 
            {
                $merge = array_merge($db_bq, $bouquets_post_array);
                $unique = array_unique($merge);
                $bouquets_str = implode(',', $unique);
            }
            if( $bouquetsOptions == 'remove' ) 
            {
                $diff = array_diff($db_bq, $bouquets_post_array);
                $bouquets_str = implode(',', $diff);
            }
            $intro->db->query('UPDATE ' . PREFIX . ('_codes set bouquets=\'' . $bouquets_str . '\' where id=' . $id . ';'));
            $num += $intro->db->affected_rows;
            if( $row['username'] != '' && $row['inputBy'] > 0 ) 
            {
                $intro->db->query_fast('UPDATE users SET bouquet=\'[' . $bouquets_str . ']\' where username=\'' . $row['username'] . '\';');
            }
            else
            {
                $intro->db->query_fast('UPDATE users SET bouquet=\'[' . $bouquets_str . ']\' where username=\'' . $row['code'] . '\';');
            }
            $num2 += $intro->db->affected_rows;
        }
        $xtream = ' Xtream Affected rows (' . $num2 . ') ';
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232(' Affected Code Rows = (' . $num . ') ' . $xtream . ' ', 'success');
    }
}
