<?php 
class Commands_resel_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $max_input_vars = 0;
    public $admin = [];
    public $inputBy = [
        'Code', 
        'MAC', 
        'Serial'
    ];
    public $level = [
        '1' => 'Admin', 
        '2' => 'Super Reseller', 
        '3' => 'Reseller', 
        '4' => 'Reset Codes Only', 
        '5' => 'Reset,Expire,Suspend', 
        '8' => 'Reset,Expire,Suspend, Streams, Logs, Bouquets', 
        '9' => 'Admin No bulk,inv,pay,code list', 
        '6' => 'Reseller With Sub-Resel', 
        '7' => 'Sub-Reselller'
    ];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        if( $this->admin['level'] != 1 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Sorry: no access!!!', 'danger') );
        }
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo "\n\t\t<div class=\"app_nav\">\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $intro->app_url('commands_resel', 'index') . "\">\n\t\t\t\t<icon class=\"icon-list\"></icon>\n\t\t\t\tBulk Commands for Resellers\n\t\t\t</a>\n\t\t\t\n\t\t\t<a class=\"btn btn-default\" href=\"" . $intro->app_url('commands_users', 'index') . "\">\n\t\t\t\t<icon class=\"icon-code\"></icon>\n\t\t\t\tBulk Commands for Users\n\t\t\t</a>\n\t\t\t\n\t\t\t<a class=\"btn btn-default\" href=\"" . $intro->app_url('commands_codes', 'index') . "\">\n\t\t\t\t<icon class=\"icon-list\"></icon>\n\t\t\t\tBulk Commands for Codes\n\t\t\t</a>\n\t\t\t\n\t\t</div>");
    }
    public function index()
    {
        global $intro;
        $this->nav();
        echo '<div>';
        $this->search_form();
        echo '</div>';
    }
    public function form_resellers_all()
    {
        global $intro;
        $html = '<input type="text" placeholder="Search.." id="reselSearch" onkeyup="IntroFilterInput(\'reselSearch\',\'allResels\');" style="width: 400px;">';
        $html .= '<div id="allResels" style="height: 400px; overflow-y: auto;padding:5px; ">';
        $html .= '<ol>';
        $sql_q = $intro->db->query('select * from ' . PREFIX . '_admin where father=0 order by admin_name ASC');
        while( $row = $intro->db->fetch_assoc($sql_q) ) 
        {
            $db_adminid = $row['adminid'];
            $db_modname = $row['admin_name'];
            $user = $row['adm_username'];
            $html .= ('<li><input type="checkbox" class="ReselTrigCheck" data-id="' . $db_adminid . '" name="adminid[]" value="' . $db_adminid . '"> ' . $user . ' | ' . $db_modname . ' ');
            $this->css = 'SubCheck_' . $db_adminid;
            $html .= $this->sub($db_adminid, $db_modname);
            $html .= '</li>';
        }
        $html .= '</ol>';
        $html .= '</div>';
        return $html;
    }
    public function sub($father, $father_name, $css = '')
    {
        global $intro;
        $html = '';
        $sql2 = $intro->db->query('select adminid,admin_name from ' . PREFIX . ('_admin where father=' . $father . ' order by admin_name ASC'));
        if( $intro->db->returned_rows > 0 ) 
        {
            $html .= '<ol>';
            while( $row2 = $intro->db->fetch_assoc($sql2) ) 
            {
                $aid = $row2['adminid'];
                $admin_name = $row2['admin_name'];
                $html .= ('<li><input type="checkbox" class="ReselTrigCheck ' . $this->css . ' SubCheck_' . $father . '" data-id="' . $aid . '" name="adminid[]" value="' . $aid . "\"> \n\t\t\t\t\t<span style='display:none'>" . $father_name . '</span> ' . $admin_name . ' ');
                $html .= $this->sub($aid, $father_name .= (' ' . $admin_name . ' '), 'SubCheck_' . $father);
                $html .= '</li>';
            }
            $html .= '</ol>';
        }
        return $html;
    }
    public function form_resellers($html_name, $txt = 'Reseller')
    {
        global $intro;
        $html = '<select name="' . $html_name . "\" class=\"searchable\"  style='min-width:500px'>\n\n\t\t<option value='' selected>" . $txt . "</option>\n";
        $sql_q = $intro->db->query('select * from ' . PREFIX . '_admin order by admin_name ASC');
        while( $row = $intro->db->fetch_assoc($sql_q) ) 
        {
            $db_adminid = $row['adminid'];
            $db_modname = $row['admin_name'];
            $html .= ('<option value="' . $db_adminid . '">' . $db_modname . " </option>\n");
            $sql2 = $intro->db->query('select * from ' . PREFIX . ('_admin where father=' . $db_adminid . ' order by admin_name ASC'));
            if( $intro->db->returned_rows > 0 ) 
            {
                while( $row2 = $intro->db->fetch_assoc($sql2) ) 
                {
                    $db2_adminid = $row2['adminid'];
                    $db2_modname = $row2['admin_name'];
                    $html .= ('<option value="' . $db2_adminid . '">' . $db_modname . ' -> ' . $db2_modname . " </option>\n");
                }
            }
        }
        $html .= "</select>\n\n\n";
        return $html;
    }
    public function search_form()
    {
        global $intro;
        global $array;
        global $admin_name;
        global $adm_username;
        global $adm_password;
        global $email;
        global $cost_1;
        global $cost_3;
        global $cost_6;
        global $cost_12;
        global $cost_24;
        global $cost_36;
        global $fullname;
        global $site;
        global $country;
        global $city;
        global $tel;
        global $regdate;
        global $ipaddress;
        global $lastlogin;
        global $level;
        global $resel_bouquets;
        global $can_add_free;
        global $can_delete;
        global $can_change;
        global $can_add_free_1;
        global $can_add_free_3;
        global $can_add_free_7;
        global $can_add_free_10;
        global $cost_1_enabled;
        global $cost_3_enabled;
        global $cost_6_enabled;
        global $cost_12_enabled;
        global $cost_24_enabled;
        global $cost_36_enabled;
        global $group_id;
        global $can_add_mac;
        global $can_add_sn;
        global $num_free;
        global $can_m3u;
        global $can_add_sub;
        global $father;
        global $postpaid;
        global $no_invoice;
        global $can_add_mag;
        global $can_add_users;
        global $msg_welcome;
        global $logo;
        global $brand;
        global $act_count;
        global $notes;
        global $host;
        global $extra_free_days;
        global $allowed_ips;
        global $can_add_codes;
        global $manage_streams;
        global $manage_vod;
        global $can_set_country;
        global $can_set_pass;
        global $can_set_mac_opt;
        $is_mag = $is_e2 = 0;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Resellers Oprations', 'danger');
        echo "\n\t\t<form id=\"form_add\" action=\"\" method=\"post\">\n\n\t\t<table class='table table-bordered table-striped'>\n\t\t<thead>\n\t\t<tr>\n\t\t\t<th>Choose</th>\n\t\t\t<th>Option</th>\n\t\t\t<th> </th>\n\t\t\t<th>Value</th>\n\t\t</tr>\n\t\t</thead>\n\t\t<tbody>\n\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[adminid]\" value=\"1\"></td>\n\t\t\t\t<td>Reseller:</td>\n\t\t\t\t<td> = </td>\n\t\t\t\t<td>\n\t\t\t\t\t" . $this->form_resellers_all() . "\n\t\t\t\t\t<hr>\n\t\t\t\t\t<div id=\"ReselCheckedCount\"></div>\n\t\t\t\t\t<br/>\n\t\t\t\t\t<div class='row'>\n\t\t\t\t\t\t<div class='col-md-12'>\n\t\t\t\t\t\t\t<button type=\"button\" id=\"strmCheckALL\">Select all</button>\n\t\t\t\t\t\t\t<button type=\"button\" id=\"strmUnCheckALL\">Deselect all</button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t\n\t\t\t\t</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td><input type=\"checkbox\" name=\"check[level]\" value=\"1\"></td>\n\t\t\t<td> Level: </td>\n\t\t\t<td>=</td>\n\t\t\t<td>" . $this->level($level) . ' ' . $this->error('level') . "</td>\n\t\t</tr>\t\n\t\t<tr>\n\t\t\t<th colspan=4>Service :</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_codes]\" value=\"1\"></td>\n\t\t\t<td>Add Codes : </td>\n\t\t\t<td>=</td>\n\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_codes', 0, 1, 'Yes', 'No', 'primary') . "</td>\n\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_users]\" value=\"1\"></td>\n\t\t\t\t<td>Add Users : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_users', 0, 1, 'Yes', 'No', 'primary') . "</td>\n\t\t\t</tr>\t\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_mag]\" value=\"1\"></td>\n\t\t\t\t<td>Add MAG : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_mag', 0, 1, 'Yes', 'No', 'primary') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_set_country]\" value=\"1\"></td>\n\t\t\t\t<td>Set Country : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_set_country', 0, 1, 'Yes', 'No', 'primary') . " \n\t\t\t\t(Enable/Disable Override General Country Restriction)</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_set_pass]\" value=\"1\"></td>\n\t\t\t\t<td>Set Passwords : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_set_pass', 0, 1, 'Yes', 'No', 'primary') . "\n\t\t\t\t\t(Enable Resller to set password for created users) </td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_set_mac_opt]\" value=\"1\"></td>\n\t\t\t\t<td>Set MAC Options for Code : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_set_mac_opt', 0, 1, 'Yes', 'No', 'primary') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<th colspan='4'>Service Price :</th>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[num_free]\" value=\"1\"></td>\n\t\t\t\t<td>Total free Codes/Users/MAG : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td><input type=\"text\" name=\"num_free\" value=\"\" size=\"10\"></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[postpaid]\" value=\"1\"></td>\n\t\t\t\t<td> Postpaid : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td> " . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('postpaid', 0, 1, 'Yes', 'No', 'primary') . " (Reseller will pay later. He can add codes/users with Zero balance.)</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_free_1]\" value=\"1\"></td>\n\t\t\t\t<td> Free 1 days : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td> " . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_free_1', 0, 1, 'Yes', 'No', 'primary') . " </td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_free_3]\" value=\"1\"></td>\n\t\t\t\t<td> Free 3 days : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td> " . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_free_3', $can_add_free_3, 1, 'Yes', 'No', 'primary') . " </td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_free_7]\" value=\"1\"></td>\n\t\t\t\t<td> Free 7 days : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_free_7', $can_add_free_7, 1, 'Yes', 'No', 'primary') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_free_10]\" value=\"1\"></td>\n\t\t\t\t<td> Free 10 days : </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td> " . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_free_10', $can_add_free_10, 1, 'Yes', 'No', 'primary') . " </td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[cost_1_enabled]\" value=\"1\"></td>\n\t\t\t\t<td> 1 Month | Cost: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('cost_1_enabled', $cost_1_enabled, 1, 'Enabled ', 'Disabled', 'info') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[cost_3_enabled]\" value=\"1\"></td>\n\t\t\t\t<td>3 Months | Cost: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('cost_3_enabled', $cost_3_enabled, 1, 'Enabled ', 'Disabled', 'info') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[cost_6_enabled]\" value=\"1\"></td>\n\t\t\t\t<td>6 Months |  Cost: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('cost_6_enabled', $cost_6_enabled, 1, 'Enabled ', 'Disabled', 'info') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[cost_12_enabled]\" value=\"1\"></td>\n\t\t\t\t<td>12 Months | Cost: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('cost_12_enabled', $cost_12_enabled, 1, 'Enabled ', 'Disabled', 'info') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[cost_24_enabled]\" value=\"1\"></td>\n\t\t\t\t<td>2 Years | Cost: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('cost_24_enabled', $cost_24_enabled, 1, 'Enabled ', 'Disabled', 'info') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[cost_36_enabled]\" value=\"1\"></td>\n\t\t\t\t<td>3 Years | Cost: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('cost_36_enabled', $cost_36_enabled, 1, 'Enabled ', 'Disabled', 'info') . ("</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<th colspan=4>Other Options:</th>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[act_count]\" value=\"1\"></td>\n\t\t\t\t<td>Code Activation Count: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td> <input type=\"text\" name=\"act_count\" value=\"" . $act_count . "\" size=\"5\">\n\t\t\t\t\t<i>Te number of times the code can be activated.</i></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_m3u]\" value=\"1\"></td>\n\t\t\t\t<td>Download <span class='label label-success icon-download'>m3u</span> file <strong>(for Codes only)</strong>: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>") . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_m3u', $can_m3u, 1, 'Yes ', 'No', 'success') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_mac]\" value=\"1\"></td>\n\t\t\t\t<td>Add Codes By MAC <span class='icon-maxcdn'></span>: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_mac', $can_add_mac, 1, 'Yes ', 'No', '') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_add_sn]\" value=\"1\"></td>\n\t\t\t\t<td>Add Codes By Serial <span class='icon-barcode'></span>: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_sn', $can_add_sn, 1, 'Yes ', 'No', '') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" class=\"\" name=\"check[can_add_free]\" value=\"1\"></td>\n\t\t\t\t<td>Allow <span class='label label-primary icon-plus'>add</span> Free Codes/Users/MAG: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_add_free', 0, 1, 'Yes ', 'No', 'primary') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_delete]\" value=\"1\"></td>\n\t\t\t\t<td>Allow <span class='label label-danger icon-trash'>Delete</span> Codes/Users/MAG + Invoices: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_delete', 0, 1, 'Yes ', 'No', 'danger') . "</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><input type=\"checkbox\" name=\"check[can_change]\" value=\"1\"></td>\n\t\t\t\t<td>Allow <span class='label label-info icon-edit'>Change/Edit</span> Codes/Users/MAG: </td>\n\t\t\t\t<td>=</td>\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('can_change', 0, 1, 'Yes ', 'No', 'info') . "</td>\n\t\t\t</tr>" . "<tr>\n\t\t\t\t<td colspan='4' class='text-center'><input class='btn btn-success' name=\"name\" value=\" Search Resellers\" type=\"submit\"></td>\n\t\t</tr>\n\t\t</tbody>\t\n\t\t</table>\n\t\t\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\t\t<script type=\"text/javascript\">\n\t\t\$(document).ready(function(){\n\t\t\t\$(\"#form_add\").submit( function () {   \n\t\t\t\t\$('#result').html('loading...');\n\t\t\t\t\$.post('";
        echo $this->base;
        echo "/doSearch?NH=1',\$(this).serialize(),function(data){\n\t\t\t\t\t\$(\"#result\").html(data)\n\t\t\t\t}\n\t\t\t  );\n\t\t\t  return false;   \n\t\t\t});   \n\t\t\t\n\t\t\t\$(\".toggle\").click( function () {   \n\t\t\t\t   \$(this).closest(\"tr\").find(\"td:first\").find(\":checkbox\").attr('Checked','Checked'); \n\t\t\t\t   \$(this).closest(\"tr\").addClass('success');\n\t\t\t});\n\t\t\t\n\t\t});\n\t\t</script>\n\t\t<div id=\"result\"></div>\n\t\t";
    }
    public function level($comp)
    {
        global $intro;
        if( $intro->input->post('level') != '' ) 
        {
            $comp = $intro->input->post('level');
        }
        $html = "\n\t\t<select name=\"level\" id=\"level\">";
        $html .= '<option value="0" selected="selected">Choose level</option>';
        foreach( $this->level as $key => $val ) 
        {
            $html .= ('<option value="' . $key . '" ' . (($comp == $key ? 'selected="selected"' : '')) . ('>' . $val . '</option>'));
        }
        $html .= "\n\t\t</select>";
        return $html;
    }
    public function operator($fld)
    {
        return '<select name="' . $fld . "_op\">\n\t\t<option value=\"=\">=</option>\n\t\t<option value=\">\">&gt;</option>\n\t\t<option value=\">=\">&gt;=</option>\n\t\t<option value=\"<\">&lt;</option>\n\t\t<option value=\"<=\">&lt;=</option>\n\t\t<option value=\"!=\">!=</option>\n\t\t<option value=\"LIKE\">LIKE * *</option>\n\t\t<option value=\"NOT LIKE\">NOT LIKE</option>\n\t\t<option value=\"IN (...)\">IN (...)</option>\n\t\t<option value=\"NOT IN (...)\">NOT IN (...)</option>\n\t\t<option value=\"IS NULL\">IS NULL</option>\n\t\t<option value=\"IS NOT NULL\">IS NOT NULL</option>\n\t\t</select>";
    }
    public function _getWhereClause($post)
    {
        global $intro;
        $where = '';
        $check = $intro->input->post('check');
        foreach( $check as $key => $val ) 
        {
            if( isset($_POST[$key]) ) 
            {
                $val = $_POST[$key];
                if( $key == 'level' && $val == 0 ) 
                {
                    continue;
                }
                if( $key == 'adminid' && count($_POST['adminid']) > 0 ) 
                {
                    $where .= (' AND adminid IN (' . implode(',', $_POST['adminid']) . ') ');
                    continue;
                }
                $where .= (' AND ' . $key . ' = ' . intval($val) . ' ');
            }
        }
        return $where;
    }
    public function doSearch()
    {
        global $intro;
        global $array;
        $qry = $this->_getWhereClause($_POST);
        if( $qry == '' ) 
        {
            exit( '<fieldset><span class=\'red big\'>Please put anything to search for.</span></fieldset>' );
        }
        echo '<fieldset>x</fieldset>';
        $result = $intro->db->query('SELECT * from  ' . PREFIX . ('_admin WHERE TRUE ' . $qry . ' order by adminid ASC '));
        $totalrows = $intro->db->returned_rows;
        if( $totalrows > 0 ) 
        {
            echo '<form action="' . $this->base . '/doCMD" method="post" name="fieldsForm"  id="fieldsForm">';
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Found Users (' . $totalrows . ') ', 'info');
            echo "\n\t\t\t<div class=\"table-responsive\">\n\t\t\t<table class=\"DataTable table-striped table-bordered table-condensed\" id=\"CodesTable\">\n\t\t\t<thead>\n\t\t\t<tr>\n\t\t\t\t<th>#</th>\n\t\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index') . " </th>\n\t\t\t\t<th>Name</th>\n\t\t\t\t<th>Username</th>\n\t\t\t\t<th>Codes?</th>\n\t\t\t\t<th>Users?</th>\n\t\t\t\t<th>MAG?</th>\n\t\t\t\t<th>Country?</th>\n\t\t\t\t<th>Set Pass?</th>\n\t\t\t\t<th>Set Code MAC Options?</th>\n\t\t\t\t<th>Postpaid?</th>\n\t\t\t\t<th>Free 1D?</th>\n\t\t\t\t<th>Free 3D?</th>\n\t\t\t\t<th>Free 7D?</th>\n\t\t\t\t<th>Free 10D?</th>\n\t\t\t\t<th>Cost 1 Month?</th>\n\t\t\t\t<th>3 Months?</th>\n\t\t\t\t<th>6 Months?</th>\n\t\t\t\t<th>1 Year?</th>\n\t\t\t\t<th>2 Years?</th>\n\t\t\t\t<th>3 Years?</th>\n\t\t\t\t<th>m3u for codes?</th>\n\t\t\t\t<th>Add Codes By MAC?</th>\n\t\t\t\t<th>Add Codes By Serial?</th>\n\t\t\t\t<th>Add Free?</th>\n\t\t\t\t<th>Delete?</th>\n\t\t\t\t<th>Change?</th>\n\t\t\t\n\t\t\t</tr>\n\t\t\t</thead>\n\t\t\t\n\t\t\t<tbody>";
            $i = 0;
            while( $myrow = $intro->db->fetch_assoc($result) ) 
            {
                @extract($myrow);
                $i++;
                echo "\n\t\t\t\t<tr id='tr_" . $adminid . "'>\n\t\t\t\t\t<td class='c'>" . $i . "</td>\n\t\t\t\t\t<td class='c'>" . $adminid . '<input type="checkbox" id="checkbox_row_' . $adminid . ('" value="' . $adminid . "\" name=\"selected_fld[]\"></td>\n\t\t\t\t\t<td>" . $admin_name . "</td>\n\t\t\t\t\t<td>" . $adm_username . '</td>');
                if( isset($_POST['check']['can_add_codes']) && $_POST['check']['can_add_codes'] == 1 ) 
                {
                    echo '<td>' . $this->CSS_Yes_No($can_add_codes) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_users) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_mag) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_set_country) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_set_pass) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_set_mac_opt) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($postpaid) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_free_1) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_free_3) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_free_7) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_free_10) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($cost_1) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($cost_3) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($cost_6) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($cost_12) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($cost_24) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($cost_36) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_m3u) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_mac) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_sn) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_add_free) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_delete) . "</td>\n\t\t\t\t\t<td>" . $this->CSS_Yes_No($can_change) . "</td>\n\t\t\t\t</tr>";
                }
            }
            echo "</tbody>\n\t\t\t</table>\n\t\t\t</div>";
            $this->optionCMD();
            echo '</fieldset>';
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            echo "\n\t\t\t<input type='hidden' name='totalrows' value='" . $totalrows . "'>\n\t\t\t</form>";
            echo '<div id="resultCMD"></div>';
            echo $this->base;
            echo "/doCMD?NH=1',\$(this).serialize(),function(data){\n\t\t\t\t\t\t\n\t\t\t\t\t\t\$(\"#resultCMD\").html(data)\n\t\t\t\t\t}\n\t\t\t\t  );\n\t\t\t\t  return false;   \n\t\t\t\t});\n\t\t\t\t\n\t\t\t\tvar \$checkboxes = \$('#CodesTable input[type=\"checkbox\"]');\n\t\t\t\t\n\t\t\t\t\$(\"#checkAllCodes\").change(function () {\n\t\t\t\t\t\$(\"#CodesTable input:checkbox\").prop('checked', \$(this).prop(\"checked\"));\n\t\t\t\t\tvar countCheckedCheckboxes = \$checkboxes.filter(':checked').length;\n\t\t\t\t\t\$('#checked_count').html(countCheckedCheckboxes);\n\t\t\t\t});\n\n\t\t\t\t\$checkboxes.change(function()\n\t\t\t\t{\n\t\t\t\t\tvar countCheckedCheckboxes = \$checkboxes.filter(':checked').length;\n\t\t\t\t\t\$('#checked_count').html(countCheckedCheckboxes);\n\t\t\t\t\t\n\t\t\t\t});\n\t\t\t});\n\t\t\t</script>\n\t\t\t";
        }
        else
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Nothing found.', 'danger');
        }
    }
    public function CSS_Yes_No($str)
    {
        global $intro;
        if( $str == 1 ) 
        {
            return '<span class="label label-success">Yes</span>';
        }
        if( $str == 0 ) 
        {
            return '<span class="label label-default">No</span>';
        }
    }
    public function doCMD()
    {
        global $intro;
        $selected_fld = $intro->input->post('selected_fld');
        $totalrows = intval($intro->input->post('totalrows'));
        if( !is_array($selected_fld) || count($selected_fld) <= 0 ) 
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please select Users', 'danger') );
        }
        $IDs = implode(',', $selected_fld);
        $qry = ' WHERE id IN (' . $IDs . ')';
        $_POST['qry'] = $qry;
        $this->doCMDsql();
    }
    public function optionCMD($totalrows = 0)
    {
        global $intro;
        global $array;
        global $type;
        global $status;
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Warning: Warning: Warning: Backup your database first!!! ', 'danger');
        $i = 1;
        echo " \n\t\t<table class=\"table table-bordered\" id=\"TableCMD\">\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"delete\"/>\n\t\t\t<td style=\"width:250px\">" . $i++ . "- Delete Users from Database.</td>\n\t\t\t<td> </td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"renew\"/></td>\n\t\t\t<td>" . $i++ . "- Renew For: </td>\n\t\t\t<td> " . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('renew_val', $array['period'], '') . " this will renew all and extend expire date. </td>\n\t\t</tr>\n\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"date_expire\"/></td>\n\t\t\t<td>" . $i++ . "- Update Expire Date (End Date): </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"date_expire_val\" value=\"\" maxlength=\"10\" placeholder=\"yyyy-mm-dd\" /></td>\n\t\t</tr>\n\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"member_id\"/></td>\n\t\t\t<td>" . $i++ . "- Change (Reseller): </td>\n\t\t\t<td> " . form_resellers('member_id_val', 0) . " </td>\n\t\t</tr>\n\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"period\"/></td>\n\t\t\t<td>" . $i++ . "- Change Days (Months): </td>\n\t\t\t<td> " . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period_val', $array['period'], '') . " this will change the Period only and will not change expire date. </td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"forced_country\"/></td>\n\t\t\t<td>" . $i++ . "- Override General Country Restriction : </td>\n\t\t\t<td>" . forced_country('') . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"bouquets\"/></td>\n\t\t\t<td>" . $i++ . "- Change Bouquets:\n\t\t\t\t<div>\n\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\n\t\t\t\t</div>\n\t\t\t\t<h3>Choose from the following:</h3>\n\t\t\t\t<div style='color:red;'>\n\t\t\t\t\t<input type=\"radio\" name=\"bouquetsOptions\" value=\"all\"/>\n\t\t\t\t\t(Replace ALL) This will override all Bouquets for all selected codes.\n\t\t\t\t</div>\n\t\t\t\t<div style='color:green;'>\n\t\t\t\t\t<input type=\"radio\" name=\"bouquetsOptions\" value=\"add\"/>\n\t\t\t\t\t(Add Selected) Select the Bouquets to add to codes , this option will keep all packages and add the new ones you select.\n\t\t\t\t</div>\n\t\t\t\t<div style='color:blue;'>\n\t\t\t\t\t<input type=\"radio\" name=\"bouquetsOptions\" value=\"remove\"/>\n\t\t\t\t\t(Remove Selected) Remove selected Bouquets, this option will keep all packages and remove the new ones you select.\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t\t<td id=\"BQ_CHECK_BOXES\">" . bouquets([]) . "</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"fullname\"/></td>\n\t\t\t<td>" . $i++ . "- Change Fullname: </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"fullname_val\" value=\"\" maxlength=\"50\" size='40' /></td>\n\t\t</tr>\n\t\t<tr>\t\n\t\t\t<td> <input type=\"radio\" name=\"maa\" value=\"useragent\"/></td>\n\t\t\t<td>" . $i++ . "- Change Useragent: </td>\n\t\t\t<td> <input dir=ltr type=\"text\" name=\"useragent_val\" value=\"\" maxlength=\"150\" size='40' placeholder='Useragent' /></td>\n\t\t</tr>";
        echo "\n\t\t<tr>\t\n\t\t\t<td> </td>\n\t\t\t<td> <input class=\"btn btn-danger\" name=\"namesubbtn\" value=\"  " . (($totalrows > 0 ? ' Update All (' . number_format($totalrows) . ') rows Now!' : '  GO  ')) . " \" type=\"submit\" OnClick=\"return confirm('Are you sure? this is final.');\"></td>\n\t\t\t<td> </td>\n\t\t</tr>\n\t\t</table>";
        echo "\n\t\t<style>\n\t\t\t#TableCMD tr{cursor:pointer}\n\t\t</style>\n\t\t<script>\n\t\t\$(document).ready(function(){\n\t\t\t\$(\"#TableCMD input[type='radio']\").on( \"click\", function() {\n\t\t\t\t\n\t\t\t\t\$(\"#TableCMD tr\").removeClass('info');\n\t\t\t\t\$(this).closest('tr').addClass('info');\n\t\t\t});\n\t\t\t\$('#TableCMD tr').click(function() {\n\t\t\t\t\n\t\t\t\t\$(\"#TableCMD tr\").removeClass('info');\n\t\t\t\t\$(this).addClass('info');\n\t\t\t\t\$(this).find('td:first-child input:radio').prop('checked', true);\n\t\t\t});\n\t\t\t\n\t\t\t\$(\"#checkAll\").change(function () {\n\t\t\t\t\$(\"#BQ_CHECK_BOXES input:checkbox\").prop('checked', \$(this).prop(\"checked\"));\n\t\t\t});\n\t\t\t\n\t\t\t\$(\"#forced_country,#renew_val,#period_val\").addClass('chosen').chosen({search_contains: true});\n\t\t\t\$(\"select[name='member_id_val']\").addClass('chosen').chosen({search_contains: true});\n\t\t\t\n\t\t});\n\t\t</script>";
    }
    public function sqlCMD($qry, $totalrows = 0)
    {
        global $intro;
        echo "\n\t\t<form action=\"" . $this->base . '/doCMDsql" method="post" name="fieldsForm"  id="fieldsForm">';
        echo '<fieldset>';
        $this->optionCMD($totalrows);
        echo '</fieldset>';
        echo "\n\t\t\t<input type=\"hidden\" name=\"qry\" value=\"" . $qry . "\" />\n\n\t\t\t</form>";
        echo "\t\t<script>\n\t\t\$(document).ready(function(){\n\t\t\t\$(\"#fieldsForm\").submit( function () {   \n\t\t\t\t\$('#resultCMD').html('<span style=\"background:#fff\">loading... this could take serveral minutes</span>');\n\t\t\t\t\$.post('";
        echo $this->base;
        echo "/doCMDsql?NH=1',\$(this).serialize(),function(data){\n\t\t\t\t\t\n\t\t\t\t\t\$(\"#resultCMD\").html(data)\n\t\t\t\t}\n\t\t\t  );\n\t\t\t  return false;   \n\t\t\t});   \n\t\t});\n\t\t</script>\n\t\t<div id=\"resultCMD\"></div>\n\t\t";
    }
    public function doCMDsql()
    {
        global $intro;
        global $array;
        ignore_user_abort(true);
        @set_time_limit(0);
        ob_start();
        $xtream = '';
        $maa = trim($intro->input->post('maa'));
        $bouquetsOptions = trim($intro->input->post('bouquetsOptions'));
        $bouquets_post_array = $intro->input->post('bouquets');
        if( is_array($bouquets_post_array) ) 
        {
            $bouquets_str = implode(',', $bouquets_post_array);
        }
        if( $maa == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please choose command. ', 'danger');
            exit();
        }
        $qry = $_POST['qry'];
        if( $qry == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Unknown Query !!! ', 'danger');
            exit();
        }
        $qry = preg_replace('/AND/', 'WHERE', $qry, 1);
        if( $qry == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: Please choose command. ', 'danger');
            exit();
        }
        $num = $num2 = 0;
        if( $maa == 'delete' ) 
        {
            $intro->db->query_fast('DELETE from users ' . $qry . ';');
            $num = $intro->db->affected_rows;
        }
        else if( $maa == 'renew' ) 
        {
            $period = intval($_POST['renew_val']);
            if( $period > 0 ) 
            {
                $sql = $intro->db->query_fast('select id,exp_date from users ' . $qry . ';');
                while( $row = $intro->db->fetch_assoc($sql) ) 
                {
                    $id = intval($row['id']);
                    $expire = $this->calcPeriod($period, $row['exp_date']);
                    if( $expire != 0 && $expire != '' ) 
                    {
                        $intro->db->query_fast('UPDATE users SET exp_date=\'' . $expire . '\',enabled=1 where id=' . $id . ';');
                        $num += $intro->db->affected_rows;
                    }
                    ob_flush();
                    flush();
                    echo '. ';
                }
            }
            else
            {
                exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232('ERROR: choose the period : 1 or 3 or 6 or 16 months etc... ', 'danger') );
            }
        }
        else if( $maa == 'date_expire' ) 
        {
            $value = strtotime($_POST['date_expire_val']);
            $intro->db->query_fast('UPDATE users set exp_date=\'' . $value . '\' ' . $qry . ';');
            $num = $intro->db->affected_rows;
        }
        else if( $maa == 'unsuspend' ) 
        {
            $num += $intro->db->affected_rows;
        }
        else if( $maa == 'bouquets' ) 
        {
            $sql = $intro->db->query_fast('select id,bouquet from users ' . $qry . ';');
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $id = intval($row['id']);
                $db_bq = json_decode($row['bouquet'], true);
                if( $bouquetsOptions == 'add' ) 
                {
                    $merge = array_merge($db_bq, $bouquets_post_array);
                    $unique = array_unique($merge);
                    $bouquets_str = implode(',', $unique);
                }
                if( $bouquetsOptions == 'remove' ) 
                {
                    $diff = array_diff($db_bq, $bouquets_post_array);
                    $bouquets_str = implode(',', $diff);
                }
                $intro->db->query_fast('UPDATE users SET bouquet=\'[' . $bouquets_str . ']\' where id=' . $id . ';');
                $num += $intro->db->affected_rows;
                ob_flush();
                flush();
                echo '. ';
            }
        }
        else if( $maa == 'forced_country' ) 
        {
            $forced_country = trim($_POST['forced_country']);
            $intro->db->query_fast('UPDATE users SET forced_country=\'' . $forced_country . '\'  ' . $qry . ';');
            $num += $intro->db->affected_rows;
        }
        else if( $maa == 'useragent' ) 
        {
            $useragent = trim($intro->input->post('useragent_val'));
            if( $useragent != '' ) 
            {
                $ex = explode(',', $useragent);
                $agnet = json_encode($ex);
            }
            else
            {
                $agnet = '';
            }
            $intro->db->query_fast('UPDATE users SET allowed_ua=\'' . $agnet . '\' ' . $qry . ';');
            $num += $intro->db->affected_rows;
        }
        else
        {
            $field = $maa;
            $value = $_POST[$maa . '_val'];
            $intro->db->query('UPDATE users set ' . $field . '=\'' . $value . '\' ' . $qry . ';');
            $num = $intro->db->affected_rows;
        }
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232(' Affected Rows = (' . $num . ') ', 'success');
    }
    public function calcPeriod($period, $expire)
    {
        global $array;
        if( $period == 0 ) 
        {
            return 0;
        }
        $exp_date = '';
        if( $expire < time() ) 
        {
            $expire = time();
        }
        if( in_array($period, $array['free']) ) 
        {
            $dd = $period - 100;
            $exp_date = strtotime('+' . $dd . ' days', $expire);
        }
        else
        {
            $exp_date = strtotime('+' . $period . ' month', $expire);
        }
        if( $exp_date != '' ) 
        {
            return $exp_date;
        }
        else
        {
            return 0;
        }
    }
}
