<?php 
class Streams_radio_AppAdmin extends AdminStreams
{
    public $type = 4;
    public $adminRow = [];
    public $admin = [];
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        $this->admin = $intro->auth->sess_admin();
        $this->adminRow = $intro->auth->admin_data($this->admin['adminid']);
        if( !in_array($this->admin['level'], [
            1, 
            5, 
            8, 
            9
        ]) && $this->adminRow['manage_streams'] != 1 ) 
        {
            exit( '<h3>Error: you don\'t have permisions to access this file.</h3>' );
        }
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->app_name = 'Radio';
        $this->app_add = 'Add new Radio';
        $this->app_edit = 'Edit Radio';
        $this->app_color = 'info';
        $this->app_icon = 'icon-mic-2';
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        echo policy($sess_admin['adminid'], $this->appname . '.php');
        echo "<div class=\"app_nav\">\r\n\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="' . $this->app_icon . '"></icon>' . $this->app_name . '</a> ');
        if( $this->admin['level'] == 1 ) 
        {
            echo '<a class="btn btn-' . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="#' . $this->base . '/Form?t=add" OnClick="alert(\'soon...\');"><icon class="icon-plus-squared"></icon>' . $this->app_add . '</a>');
        }
        echo "\r\n\t\t</div>";
    }
    public function del_source()
    {
        global $intro;
        global $array;
        $source = trim($intro->input->get_post('source'));
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-trash"></i> del source', 'info');
        $result = $intro->db->query('SELECT * from `streams` ' . (' WHERE type=1 and stream_source LIKE \'%' . $source . '%\' order by `order` ASC'));
        $totrows = $intro->db->returned_rows;
        $i = 0;
        while( $row = $intro->db->fetch_assoc($result) ) 
        {
            $i++;
            $id = intval($row['id']);
            $stream_source = $row['stream_source'];
            echo 'before = ' . $stream_source;
            $new = [];
            $src = json_decode($stream_source, true);
            foreach( $src as $url ) 
            {
                if( preg_match('/' . $source . '/i', $url) ) 
                {
                    $xx = 1;
                }
                else
                {
                    $new[] = $url;
                }
            }
            if( count($new) >= 1 ) 
            {
                $new_source = json_encode($new);
                echo '<br/> New = ' . $new_source . ' <hr>';
            }
            else
            {
                $new_source = json_encode(['no_url']);
                echo '<br/>new = NO DATA <hr>';
            }
            $intro->db->query('UPDATE `streams` SET stream_source=\'' . $new_source . '\' WHERE id = ' . $id . ';');
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Report()
    {
        global $intro;
        global $array;
        $qry = $params = '';
        $JOIN = 'LEFT JOIN';
        $JOIN = 'LEFT OUTER JOIN';
        $page = intval($intro->input->get_post('page'));
        $category_id = intval($intro->input->get_post('category_id'));
        $order = trim($intro->input->get_post('order'));
        $stream_display_name = trim($intro->input->get_post('stream_display_name'));
        $status = trim($intro->input->get_post('status'));
        $stream_status = trim($intro->input->get_post('stream_status'));
        $source = trim($intro->input->get_post('source'));
        $this->nav();
        if( $stream_display_name != '' ) 
        {
            $qry .= (' AND stream_display_name  LIKE \'%' . $stream_display_name . '%\' ');
            $params .= ('&stream_display_name=' . $stream_display_name);
        }
        if( $status != '' ) 
        {
            $qry .= (' AND status=' . intval($status));
            $params .= ('&status=' . $status);
        }
        if( $category_id != 0 ) 
        {
            $qry .= (' AND category_id=' . $category_id);
            $params .= ('&category_id=' . $category_id);
        }
        if( array_key_exists($stream_status, $this->array_stream_status) ) 
        {
            $qry .= $this->array_stream_status_qry[$stream_status];
            $params .= ('&stream_status=' . $stream_status);
        }
        if( $stream_status == 'online' || $stream_status == 'stopped' ) 
        {
            $JOIN = 'INNER JOIN';
        }
        if( $source != '' ) 
        {
            $qry .= (' AND stream_source LIKE \'%' . $source . '%\' ');
            $params .= ('&source=' . $source);
        }
        $result = $intro->db->query('SELECT * from `streams` WHERE type=1 ' . $qry . ' order by `order` ASC');
        $totrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> Streams (' . $totrows . ')', 'info');
        $i = 0;
        $ar = $arPath = [];
        while( $row = $intro->db->fetch_assoc($result) ) 
        {
            @extract($row);
            $i++;
            $src = json_decode($stream_source, true);
            if( !is_array($src) ) 
            {
                $src = [$stream_source];
            }
            if( is_array($src) ) 
            {
                foreach( $src as $url ) 
                {
                    $url = parse_url($url);
                    $host = (isset($url['host']) ? $url['host'] : '');
                    $port = (isset($url['port']) ? $url['port'] : '');
                    $path = (isset($url['path']) ? $url['path'] : '');
                    if( $host != '' ) 
                    {
                        $ar[$host][] = [
                            'id' => $id, 
                            'ch' => $stream_display_name
                        ];
                    }
                    if( $path != '' ) 
                    {
                        $arPath[$host] = [
                            'scheme' => $url['scheme'], 
                            'port' => (isset($url['port']) ? $url['port'] : ''), 
                            'path' => $url['path']
                        ];
                    }
                }
            }
        }
        echo "<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>#</td>\r\n\t\t\t<td>Source</td>\r\n\t\t\t<td>Total</td>\r\n\t\t\t<td>Streams</td>\r\n\t\t\t<td></td>\r\n\t\t</tr>";
        $x = 0;
        foreach( $ar as $source => $streams ) 
        {
            $x++;
            $html = '<table border=1>';
            $i = 0;
            foreach( $streams as $key => $row ) 
            {
                $i++;
                $html .= ("<tr>\r\n\t\t\t\t\t\t\t<td>" . $i . "</td>\r\n\t\t\t\t\t\t\t<td></td>\r\n\t\t\t\t\t\t\t<td>" . $row['ch'] . "</td>\r\n\t\t\t\t\t\t\t<td><a target='_blank' href=\"" . $this->base . '/index/?stream_display_name=' . urlencode($row['ch']) . "\">Edit</a></td>\r\n\t\t\t\t\t\t</tr>");
            }
            $html .= '</table>';
            $txt = '';
            if( isset($arPath[$source]) ) 
            {
                $host = $source;
                $port = $arPath[$host]['port'];
                $scheme = $arPath[$host]['scheme'];
                $path = $arPath[$host]['path'];
                $ex = explode('/', $path);
                if( count($ex) > 3 ) 
                {
                    $pos_u = count($ex) - 3;
                    $pos_p = count($ex) - 2;
                    $u = $ex[$pos_u];
                    $p = $ex[$pos_p];
                    $full_url = $scheme . '://' . $host . ':' . $port . ('/panel_api.php?username=' . $u . '&password=' . $p);
                    $ctx = stream_context_create([
                        'http' => ['timeout' => 2]
                    ]);
                    $json = @file_get_contents($full_url, false, $ctx);
                    if( strlen($json) > 200 ) 
                    {
                        $data = json_decode($json, true);
                        if( is_array($data) ) 
                        {
                            $auth = $data['user_info']['auth'];
                            $status = $data['user_info']['status'];
                            $exp_date = $data['user_info']['exp_date'];
                            $is_trial = $data['user_info']['is_trial'];
                            $active_cons = $data['user_info']['active_cons'];
                            $max_connections = $data['user_info']['max_connections'];
                        }
                        $txt = ' <br/><br/> ActiveCons: ' . $active_cons . ' MaxCons: ' . $max_connections;
                        $txt .= ('<br/> <a target=\'_blank\' href="' . str_replace('panel_api', 'get', $full_url) . '&type=m3u&output=ts">m3u8</a>');
                    }
                }
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>" . $x . "</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t" . $source . ' <a target=\'_blank\' href="' . $this->base . '/index/?source=' . urlencode($source) . ("\">Edit</a>\r\n\t\t\t\t\t" . $txt . "\r\n\t\t\t\t</td>\r\n\t\t\t\t<td>") . count($streams) . ("</td>\r\n\t\t\t\t<td><div style=\"max-height:200px;overflow: auto;\">" . $html . "</div></td>\r\n\t\t\t\t<td></td>\r\n\t\t\t</tr>");
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Token()
    {
        global $intro;
        global $array;
        global $error;
        $old_tokens = '';
        $old_red_tokens = '';
        $this->nav();
        $sql = $intro->db->query('SELECT  distinct substring(stream_source, POSITION(\'?key=\' IN stream_source)+0, 32) as old_token  FROM streams WHERE stream_source like \'%?key=%\'');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $old_tokens .= ('<li>' . $row['old_token'] . '</li>');
        }
        $sql = $intro->db->query('SELECT  distinct substring(stream_source, POSITION(\'?token=\' IN stream_source)+7, 32) as old_red_tokens  FROM streams WHERE stream_source like \'%?token=%\'');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $old_red_tokens .= ('<li>' . $row['old_red_tokens'] . '</li>');
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-exchange"></i> Key Change ', 'info');
        echo $this->error('msg');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doKey\" enctype=\"multipart/form-data\">\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>Old key=  </td>\r\n\t\t\t<td>" . $old_tokens . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td><b>New ?key=: </b></td>\r\n\t\t\t<td><input  type=\"text\" name=\"new\" value=\"?key=\" class='form-control'></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-exchange\"></i> Update key\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</div>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-exchange"></i> Token CHange ', 'warning');
        echo $this->error('msg2');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doToken\" enctype=\"multipart/form-data\">\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">\r\n\t\t<tr>\r\n\t\t\t<td>Old  Token : </td>\r\n\t\t\t<td>" . $old_red_tokens . "</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td><b>New Token ?token=  </b></td>\r\n\t\t\t<td><input  type=\"text\" name=\"new_red\" value=\"\" class='form-control'></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\t\t\t\t<button type=\"submit\">\r\n\t\t\t\t\t<i class=\"icon-exchange\"></i> Update Token\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</div>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function ChangeDNS()
    {
        global $intro;
        global $array;
        global $error;
        $mov = $se = '';
        $result = $intro->db->query('SELECT   TRIM(TRAILING CONCAT(\'/\', SUBSTRING_INDEX(stream_source, \'/\', -1)) FROM stream_source) as stream_url  from streams where type=1 group by stream_url   /*order by id desc LIMIT 0,5*/');
        $seen = '';
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            if( $stream_url != '' ) 
            {
                $url = str_replace([
                    '["', 
                    '\\', 
                    '"'
                ], '', $stream_url);
                $url = str_replace(',', ', ', $url);
                if( $url != $seen ) 
                {
                    $mov .= ('<li>' . $url . '</li>');
                }
                $seen = $url;
            }
        }
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Change Stream URL/USER/PASS/String ', 'primary');
        if( $this->msg != '' ) 
        {
            echo $this->msg;
        }
        echo "\r\n\t\t\t<h2>Warning: this could damage your links!!! Please backup first. </h2>\r\n\t\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doChangeDNS\">\r\n\t\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Streams URLs:</td>\r\n\t\t\t\t<td><div class=\"json\" style=\"height:100px;overflow: scroll;\">" . $mov . "</div></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>OLD Host:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"old_host\" value=\"\" class=\"form-control\" \r\n\t\t\t\t\tplaceholder=\"like: http://www.example-host.net or http://www.example-host.net/folder1\" /></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>NEW Host:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"new_host\" value=\"\" class=\"form-control\" \r\n\t\t\t\t\tplaceholder=\"Like: http://www.host.com or http://www.example-host.net/folder2\" /></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">\r\n\t\t\t\t\t\t<i class=\"icon-floppy\"> </i> Change Source Stream DNS </button>\t\t\t\t\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Change Stream Icons DNS ', 'info');
        if( $this->msg != '' ) 
        {
            echo $this->msg;
        }
        echo "\r\n\t\t\t<h2>Warning: this could damage your links!!! Please backup first. </h2>\r\n\t\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doChangeIconsDNS\">\r\n\t\t\t<table class=\"table table-bordered table-hover\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td>OLD Host:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"old_host\" value=\"\" class=\"form-control\" \r\n\t\t\t\t\tplaceholder=\"like: www.example-host.net or www.example-host.net/folder1\" /></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>NEW Host:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"new_host\" value=\"\" class=\"form-control\" \r\n\t\t\t\t\tplaceholder=\"Like: www.host.com or www.example-host.net/folder2\" /></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<button class=\"btn btn-success\" type=\"submit\" name=\"app_action\" value=\"doEdit\"><i class=\"icon-floppy\"> </i> Change Stream Icons DNS </button>\t\t\t\t\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doChangeDNS()
    {
        global $intro;
        $tot = 0;
        $old_host = preg_replace("/\r\n|\r|\n/", '', trim($intro->input->post('old_host')));
        $new_host = preg_replace("/\r\n|\r|\n/", '', trim($intro->input->post('new_host')));
        if( strlen($old_host) < 5 || strlen($new_host) < 5 ) 
        {
            exit( '<h1 style=\'color:red\'>error: old host and new host must be more than 5 chars long.' );
        }
        $intro->db->query('UPDATE `streams` SET ' . (' stream_source = REPLACE( stream_source, \'' . $old_host . '\', \'' . $new_host . '\' ) ') . (' WHERE `stream_source` LIKE \'%' . $old_host . '%\';'));
        $tot = $intro->db->affected_rows;
        $this->msg = _obf_0D3D40321528110F062A0B0321102712170C15030F2232(" <h1>\r\n\t\tSuccess: <br/>\r\n\t\tTotcal Changed Streams = " . $tot . " <br/>\r\n\t\t</h1>", 'success');
        $this->ChangeDNS();
    }
    public function doChangeIconsDNS()
    {
        global $intro;
        $tot = 0;
        $old_host = preg_replace("/\r\n|\r|\n/", '', trim($intro->input->post('old_host')));
        $new_host = preg_replace("/\r\n|\r|\n/", '', trim($intro->input->post('new_host')));
        if( strlen($old_host) < 5 || strlen($new_host) < 5 ) 
        {
            exit( '<h1 style=\'color:red\'>error: old host and new host must be more than 5 chars long.' );
        }
        $intro->db->query('UPDATE `streams` SET ' . (' stream_icon = REPLACE( stream_icon, \'' . $old_host . '\', \'' . $new_host . '\' ) ') . (' WHERE `stream_icon` LIKE \'%' . $old_host . '%\';'));
        $tot = $intro->db->affected_rows;
        $this->msg = _obf_0D3D40321528110F062A0B0321102712170C15030F2232(" <h1>\r\n\t\tSuccess: <br/>\r\n\t\tTotal Changed Icons = " . $tot . " <br/>\r\n\t\t</h1>", 'success');
        $this->ChangeDNS();
    }
    public function ReplaceString()
    {
        global $intro;
        global $array;
        global $error;
        $html = '';
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Replace URL/USER/PASS/String/.ts ', 'primary');
        if( $this->msg != '' ) 
        {
            echo $this->msg;
        }
        $search_for = trim($intro->input->get_post('search_for'));
        $submit = ' Search ';
        $action = 'ReplaceString';
        if( $search_for != '' ) 
        {
            $result = $intro->db->query('select id,stream_display_name,stream_source ' . (' from streams WHERE stream_source LIKE \'%' . $search_for . '%\' '));
            if( $intro->db->returned_rows > 0 ) 
            {
                while( $myrow = $intro->db->fetch_assoc($result) ) 
                {
                    $stream_source = $myrow['stream_source'];
                    $html .= ($stream_source . "\n");
                }
                $submit = ' Replace ';
                $action = 'doReplaceString';
            }
        }
        echo "\r\n\t\t\t<h2>Warning: this could damage your links!!! Please backup first. </h2>\r\n\t\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $action . "\">\r\n\t\t\t<table class=\"table table-bordered table-hover\">\r\n\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Search for:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"search_for\" value=\"" . $search_for . "\" class=\"form-control\" placeholder=\"\" /></td>\r\n\t\t\t</tr>";
        if( $html != '' ) 
        {
            echo "\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>We found:</td>\r\n\t\t\t\t\t<td><textarea style='width:80%;height:250px;white-space: pre; overflow: scroll;' wrap=\"off\">" . $html . "</textarea></td>\r\n\t\t\t\t</tr>";
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Remove This:</td>\r\n\t\t\t\t<td><input dir=ltr type=\"text\" name=\"remove\" value=\"\" class=\"form-control\" placeholder=\"Like: .ts\" /></td>\r\n\t\t\t</tr>";
        }
        echo "<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<button class=\"btn btn-success\" type=\"submit\">  " . $submit . " </button>\t\t\t\t\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doReplaceString()
    {
        global $intro;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Results ', 'success');
        $search_for = trim($intro->input->get_post('search_for'));
        $remove = trim($intro->input->get_post('remove'));
        $affected_rows = 0;
        if( $search_for != '' ) 
        {
            $result = $intro->db->query('select id,stream_display_name,stream_source ' . (' from streams WHERE stream_source LIKE \'%' . $search_for . '%\' '));
            while( $myrow = $intro->db->fetch_assoc($result) ) 
            {
                $id = intval($myrow['id']);
                $stream_source = $myrow['stream_source'];
                $stream_display_name = $myrow['stream_display_name'];
                $new_source = [];
                if( preg_match('/' . $search_for . '/i', $stream_source) ) 
                {
                    $stream_array = json_decode($stream_source, true);
                    foreach( $stream_array as $old_stream ) 
                    {
                        if( preg_match('/' . $search_for . '/i', $old_stream) ) 
                        {
                            echo '<li>' . str_replace((string)$remove, '<span style=\'background:#ffff00\'>' . $remove . '</span>', $old_stream);
                            $old_stream = str_replace((string)$remove, '', $old_stream);
                            echo ' | after remove = ' . $old_stream . '</li>';
                        }
                        $new_source[] = $old_stream;
                    }
                    if( count($new_source) > 0 ) 
                    {
                        $data = [];
                        $data['stream_source'] = json_encode($new_source);
                        $intro->db->update('streams', $data, 'id=' . $id);
                    }
                }
            }
        }
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<h3>Affected rows = ' . $affected_rows . '</h3>');
    }
    public function doKey()
    {
        global $intro;
        global $array;
        global $error;
        $new = trim($intro->input->get_post('new'));
        if( !preg_match('/\?key=/i', $new) || $new == '' ) 
        {
            $error['msg'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h3>Error: please input new key with: <b>?key=</b></h3>', 'danger');
            $this->Token();
            exit();
        }
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h3>Success key=: <b>' . $tot . '</b> <br/><br/>' . $str . '</h3>', 'success');
        exit();
    }
    public function doToken()
    {
        global $intro;
        global $array;
        global $error;
        $new_red = trim($intro->input->get_post('new_red'));
        $red_token = $new_red;
        if( strlen($new_red) <= 10 ) 
        {
            $error['msg2'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h3>Error: please input new token</h3>', 'danger');
            $this->Token();
            exit();
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-exchange"></i> Token change result', 'success');
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h3>Success token=: <b>' . $num . '</b> <br/><br/>' . $str . '</h3>', 'success');
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function curl($url, $strip = false)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_USERAGENT, 'red');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        $answer = curl_exec($ch);
        if( $strip ) 
        {
            $answer = strip_tags($answer);
            $answer = substr($answer, 0, 1000);
            curl_close($ch);
        }
        return $answer;
    }
    public function Top100()
    {
        global $intro;
        $this->nav();
        $result = $intro->db->query('select stream_id,st.stream_display_name, count(stream_id) as tot ,(select ROUND(AVG(bitrate)) from streams_sys where stream_id=st.id ) as avgbitrate  FROM user_activity_now nn , streams st  where nn.stream_id=st.id group by stream_id order by tot DESC LIMIT 0,100');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Top 100 Streams (' . $totalrows . ')');
        echo "\r\n\t\t\r\n\t\t<table class=\"table table-bordered table-hover table-condensed\">\r\n            <tr>\r\n\t\t\t\t<th>#</th>\r\n\t\t\t\t<th>ID</th>\r\n\t\t\t\t<th>Stream Name</th>\r\n\t\t\t\t<th>Bit Rate</th>\r\n\t\t\t\t<th>Total Users</th>\r\n\t\t\t\t<th> </th>\r\n\t\t\t\r\n\t    </tr>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $tot = intval($tot);
            $avgbitrate = intval($avgbitrate);
            $bit = $avgbitrate * $tot * 1024;
            echo "<tr>\r\n\t\t\t\t\t<td class=\"center\">" . $i . "</td>\r\n\t\t\t\t\t<td class=\"center\">" . $stream_id . "</td>\r\n\t\t\t\t\t<td class=\"center\">" . $stream_display_name . "</td>\r\n                     <td class=\"center\">" . $avgbitrate . "K</th>\r\n                     <td class=\"center\">" . $tot . "</th>\r\n                     <td class=\"center\">" . $this->formatBytes($bit, 2) . "</th>\r\n     \r\n                     <td> </th>     \r\n\t\t </tr>";
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Highrate()
    {
        global $intro;
        $this->nav();
        $result = $intro->db->query('select st.id,st.stream_display_name,sys.bitrate  ,(select count(*) from user_activity_now where stream_id=st.id) as tot  FROM `streams` st, `streams_sys` sys  where st.id=sys.stream_id group by sys.stream_id order by sys.bitrate DESC LIMIT 0,100');
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('High BitRate Streams (' . $totalrows . ')');
        echo "\r\n\t\t\r\n\t\t<table class=\"table table-bordered table-hover table-condensed\">\r\n            <tr>\r\n\t\t\t\t<th>#</th>\r\n\t\t\t\t<th>ID</th>\r\n\t\t\t\t<th>Stream Name</th>\r\n\t\t\t\t<th>Bit Rate</th>\r\n\t\t\t\t<th>Total Users</th>\r\n\t\t\t\t<th> </th>\r\n\t\t\t\r\n\t    </tr>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $tot = intval($tot);
            $bitrate = intval($bitrate);
            $bit = $bitrate * $tot * 1024;
            echo "<tr>\r\n\t\t\t\t\t<td class=\"center\">" . $i . "</td>\r\n\t\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t\t<td class=\"center\">" . $stream_display_name . "</td>\r\n                     <td class=\"center\">" . $bitrate . "K</th>\r\n                     <td class=\"center\">" . $tot . "</th>\r\n                     <td class=\"center\">" . $this->formatBytes($bit, 2) . "</th>\r\n     \r\n                     <td> </th>     \r\n\t\t </tr>";
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function SortOrder()
    {
        global $intro;
        $result = $intro->db->query('select id,stream_display_name  ,`order` as view_order FROM `streams` WHERE type=1 ORDER BY `order` ASC ');
        $totalrows = $intro->db->returned_rows;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Sort Streams (' . $totalrows . ')');
        echo "\r\n\t\t<a href=\"" . $this->base . "/doSortOrder\" class=\"btn btn-danger btn-lg pull-right\">Click her to auto sort streams</a>\r\n\t\t<table border=1>\r\n            <tr>\r\n\t\t\t\t<th> Sort </th>\r\n\t\t\r\n\t\t\t\t<th>Stream Name</th>\r\n\t\t\t\r\n\t\t\t\t<th> </th>\r\n\t    </tr>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            echo "<tr>\r\n\t\t\t\t\t<td class=\"center\">" . $view_order . "</td>\r\n\t\t\t\t\t<td>" . $stream_display_name . "</td>\r\n                    <td> </th>     \r\n\t\t </tr>";
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function getAllStreams()
    {
        global $intro;
        $ar = [];
        $result = $intro->db->query('select id,stream_display_name from streams');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $ar[$id] = $stream_display_name;
        }
        return $ar;
    }
    public function doSortOrder()
    {
        global $intro;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Sorting Streams ');
        $AllStreams = $this->getAllStreams();
        echo '<ul>';
        $sql = $intro->db->query('SELECT * from bouquets WHERE bouquet_status=1 order by view_order ASC;');
        $i = 0;
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            @extract($row);
            echo '<li> ' . $bouquet_name;
            $chans = json_decode($bouquet_channels, true);
            if( is_array($chans) ) 
            {
                $totChans = count($chans);
            }
            else
            {
                $totChans = 0;
            }
            if( $totChans > 0 ) 
            {
                echo '<ol>';
                foreach( $chans as $stream ) 
                {
                    $i++;
                    $intro->db->query_fast('UPDATE `streams` set `order`=' . $i . ' WHERE id=' . $stream . ' AND type=1');
                    echo '<li>' . $i . ' | ' . ((isset($AllStreams[$stream]) ? $AllStreams[$stream] : ' ----deleted----- ')) . '</li>';
                }
                echo '</ol>';
            }
            echo '</li>';
        }
        echo '</ul>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function Abusers()
    {
        global $intro;
        global $array;
        $this->nav();
        $fixAll = trim($intro->input->get_post('fixAll'));
        $fields = [
            'users.id,users.username,users.created_by,streams.stream_display_name', 
            'online.activity_id', 
            'online.user_id', 
            'online.stream_id', 
            'online.server_id', 
            'online.user_agent', 
            'online.user_ip', 
            'online.container', 
            'online.date_start', 
            'online.date_end', 
            'online.geoip_country_code', 
            'online.isp'
        ];
        $SQL = 'SELECT ' . implode(',', $fields) . ' from `user_activity_now` online, streams  , users ' . ' where online.stream_id=streams.id AND online.user_id=users.id AND users.is_restreamer=0 AND users.max_connections<100 ' . '  GROUP BY user_ip HAVING COUNT(user_ip) >1 ';
        $result = $intro->db->query($SQL . '  order by user_ip ASC');
        $resultnumm = $intro->db->query($SQL);
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22(' Abusers with more than one ip (' . $totalrows . ')', 'success');
        echo "\r\n\t  <table dir=ltr class=\"table table-bordered table-condensed table-hover\">\r\n            <tr>\r\n\t\t\t\t<th class='c'>User</th>\r\n\t\t\t\t<th class='c'>Resel</th>\r\n\t\t\t\t<th class='c'>Stream</th>\r\n\t\t\t\t<th class='c'>Server</th>\r\n\t\t\t\t<th class='c'>UserAgent</th>\r\n\t\t\t\t<th class='c'></th>\r\n\t\t\t\t<th class='c'>IP</th>\r\n\t\t\t\t<th class='c'>Container</th>\r\n\t\t\t\t<th class='c'>Uptime</th>\r\n\t\t\t\t\r\n\t\t\t</tr>";
        $i = 0;
        $now = new DateTime('now');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $elapsed = new DateTime(date('Y-m-d H:i:s', $date_start));
            $diff = $now->diff($elapsed);
            $ago = $diff->format('%H:%I:%S');
            if( isset($array['admins'][$created_by]) ) 
            {
                $admin = $array['admins'][$created_by];
            }
            else
            {
                $admin = '-';
            }
            echo "<tr>\r\n\t\t\t\t\t<td class=\"center\">" . $username . "</td>\r\n\t\t\t\t\t<td class='c'>" . $admin . "</td>\r\n\t\t\t\t\t<td class=\"c\">" . $stream_display_name . "</td>\r\n                     <td class=\"c\">" . $server_id . "</th>\r\n                     <td class=\"c\"><a title=\"" . $user_agent . '">' . substr($user_agent, 0, 15) . "</a></th>\r\n\t\t\t\t\t <td class=\"c\"><img src=\"" . admin_path . 'style/css/flags/blank.gif" class="flag flag-' . strtolower($geoip_country_code) . ("\" /></th>\r\n                     <td class=\"c\"><a href='https://www.ip-tracker.org/locator/ip-lookup.php?ip=" . $user_ip . '\' target=\'_blank\' title="' . $isp . '">' . $user_ip . "</a> </th>\r\n                     <td class=\"c\">" . $container . "</th>\r\n                     <td class=\"c\">" . $ago . '</th>');
            echo "\r\n\t\t </tr>";
        }
        echo '</table>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function ReplaceID()
    {
        global $intro;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-edit"></i> Replace streams IDs ', 'info');
        if( $this->error != '' ) 
        {
            echo $this->error;
        }
        echo 'This will change all steams ids to new ones';
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doReplaceID\" enctype=\"multipart/form-data\">\r\n\t\t<div class=\"table-responsive\">\r\n\t\t<table class=\"table table-bordered table-hover table-striped\">";
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t<tr>\r\n\t\t\t<td style=\"width:25%;\">Paste all IDs here, line by line :  <span style='color:#ff0000'>*</span>\r\n\t\t\t\r\n\t\t\t</br>\r\n\t\t\tExample: <br/><b>\r\n\t\t\t1<br/>\r\n\t\t\t15<br/>\r\n\t\t\t16<br/>\r\n\t\t\t145</b><br/>\r\n\t\t\t... etc\r\n\t\t\t</td>\r\n\t\t\t<td> <textarea style=\"width:100%;height:200px;\" name=\"ids\"></textarea></td>\r\n\t\t</tr>";
        }
        echo "\r\n\t\t<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>\r\n\r\n\t\t\t\t<button type=\"submit\">\r\n\t\t\t\t\tSearch \r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t</div>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function doReplaceID()
    {
        global $intro;
        $ids = trim($intro->input->post('ids'));
        $maa = trim($intro->input->post('maa'));
        $x = explode("\n", $ids);
        $ar = [];
        if( is_array($x) ) 
        {
            foreach( $x as $line ) 
            {
                if( intval($line) > 0 ) 
                {
                    $ar[] = intval($line);
                }
            }
        }
        if( count($ar) == 0 ) 
        {
            $this->error = _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Error: nothing entered!', 'danger');
            $this->ReplaceID();
            exit();
        }
        $db_ids = implode(',', $ar);
        $sql = $intro->db->query('select max(id) as maxID FROM `streams`  LIMIT 1;');
        $r = $intro->db->fetch_assoc($sql);
        $newID = intval($r['maxID']);
        $result = $intro->db->query('select id,stream_display_name ' . (' ,`order` as view_order FROM `streams` WHERE id IN (' . $db_ids . ') ORDER BY `order` ASC '));
        $totalrows = $intro->db->returned_rows;
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Found streams (' . $totalrows . ') from (' . count($ar) . ')');
        echo "\r\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . "/doReplaceID\" enctype=\"multipart/form-data\">\r\n\t\t<table border=1>\r\n            <tr>\r\n\t\t\t\t<th> Old ID </th>\r\n\t\t\r\n\t\t\t\t<th>Stream Name</th>\r\n\t\t\t\r\n\t\t\t\t<th> New ID</th>\r\n\t    </tr>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $newID++;
            $oldid = intval($myrow['id']);
            $success = '';
            if( $maa == 'run' ) 
            {
                $intro->db->query('UPDATE `streams` SET id=\'' . $newID . '\' WHERE id=' . $oldid);
                $intro->db->query('UPDATE `streams_options` SET `stream_id` = \'' . $newID . '\' WHERE `stream_id` = ' . $oldid . '; ');
                $intro->db->query('UPDATE `streams_sys` SET `stream_id` = \'' . $newID . '\' WHERE `stream_id` = ' . $oldid . ';  ');
                $intro->db->query('UPDATE `bouquets` SET `bouquet_channels` = replace(bouquet_channels,\'"' . $oldid . '"\',\'"' . $newID . '"\') WHERE `bouquet_channels` LIKE \'%"' . $oldid . '"%\' ');
                $success = 'Success';
            }
            echo "<tr>\r\n\t\t\t\t\t<td class=\"center\">" . $id . "</td>\r\n\t\t\t\t\t<td>" . $stream_display_name . "</td>\r\n                    <td> " . $newID . ' ' . $success . "</th>     \r\n\t\t </tr>";
        }
        echo "<tr>\r\n\t\t\t<td></td>\r\n\t\t\t<td>";
        if( $maa == 'run' ) 
        {
            echo '<button class="icon-check btn btn-success btn-lg" > Done! </button>';
        }
        else
        {
            echo '<button type="submit" class="icon-floppy btn btn-danger" OnClick="return confirm(\'Are you sure?\');"> Do Replace </button></td>';
        }
        echo "\r\n\t\t\t<td></td>\r\n\t\t</tr>\r\n\t\t</table>\r\n\t\t<input type=\"hidden\" name=\"ids\"  value=\"" . $ids . "\">\r\n\t\t<input type=\"hidden\" name=\"maa\"  value=\"run\">\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
    }
    public function formatBytes($size, $precision = 0)
    {
        $unit = [
            'Byte', 
            'KiB', 
            'MiB', 
            'GiB', 
            'TiB', 
            'PiB', 
            'EiB', 
            'ZiB', 
            'YiB'
        ];
        for( $i = 0; $size >= 1024 && $i < (count($unit) - 1); $i++ ) 
        {
            $size /= 1024;
        }
        return round($size, $precision) . ' ' . $unit[$i];
    }
    public function SortStreams()
    {
        global $intro;
        $this->nav();
        $action = $this->base . '/doSortStreams';
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="icon-list"></i> Sort Streams ', 'info');
        echo '<form method="POST" id=\'drag\' enctype="multipart/form-data">';
        echo $this->Stream_Chanels();
        echo "\t\t\t\t</select>\r\n\t\t\t\t<input type='hidden' name='select1' id='select1' value=''> \r\n\t\t\t\t<input type='hidden' name='select2' id='select2' value=''> \r\n\t\t\t</td>\r\n\t\t\t<td style=\"width: 50%;\">\r\n\t\t\t\t<select style=\"width:100%;height:400px;\" id=\"vod_order_selection\" name=\"vod_order_selection[]\" multiple=\"multiple\">\r\n\t\t\t\t";
        echo $this->vedios_Chanels();
        echo "\t\t\t\t</select>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td colspan=\"2\">\r\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\r\n\t\t\t\t<i class=\"icon-floppy\"></i> Save Streams Order\r\n\t\t\t\t</button>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t</tbody>\r\n\t\t</table>\r\n\t\t<div id=result></div>\r\n\t\t</form>\r\n\t\t";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "\t\t<script>\r\n\t\t\$(document).ready(function() {\r\n\t\t\t\$(\"#drag\").submit(function(e) {\r\n\t\t\t\te.preventDefault();\r\n\t\t\t\t\$( \"#result\" ).html('Please wait. Loading ... ' );\r\n\t\t\t\tvar x = \"\";\r\n\t\t\t\t\$('#stream_order_selection > option').each((index, obj) => {\r\n\t\t\t\t\tx = x+ \$(obj).val()+',' ;\r\n\t\t\t\t\t\$(\"#select1\" ).val(x);\r\n\t\t\t\t});\r\n\r\n\t\t\t\tvar ved = \"\";\r\n\t\t\t\t\$('#vod_order_selection > option').each((index, obj) => {\r\n\t\t\t\t\tved = ved+ \$(obj).val()+',' ;\r\n\t\t\t\t\t\$(\"#select2\" ).val(ved);\r\n\t\t\t\t});\r\n\r\n\t\t\t\tvar form = \$(this);\r\n\t\t\t\t\$.ajax({\r\n\t\t\t\t\ttype: \"POST\",\r\n\t\t\t\t\turl: '";
        echo $action;
        echo "?NH=1',\r\n\t\t\t\t\tdata: form.serialize(),\r\n\t\t\t\t\tsuccess: function(data)\r\n\t\t\t\t\t{\r\n\t\t\t\t\t\t\$( \"#result\" ).html(data );\r\n\t\t\t\t\t}\r\n\t\t\t\t});\r\n\r\n\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$('#sbtn-up').bind('click', function() {\r\n\r\n\t\t\t\t\$('#stream_order_selection option:selected').each( function() {\r\n\t\t\t\t\tvar newPos = \$('#stream_order_selection option').index(this) - 1;\r\n\t\t\t\t\tif (newPos > -1) {\r\n\t\t\t\t\t\t\$('#stream_order_selection option').eq(newPos).before(\"<option value='\"+\$(this).val()+\"' selected='selected'>\"+\$(this).text()+\"</option>\");\r\n\t\t\t\t\t\t\$(this).remove();\r\n\t\t\t\t\t}\r\n\t\t\t\t});\r\n\t\t\t});\r\n\r\n\t\t\t\$('#sbtn-down').bind('click', function() {\r\n\t\t\t\tvar countOptions = \$('#stream_order_selection option').size();\r\n\t\t\t\tvar countSelected = \$('#stream_order_selection option:selected').size();\r\n\t\t\t\t\$('#stream_order_selection option:selected').each( function() {\r\n\t\t\t\t\tvar newPos = \$('#stream_order_selection option').index(this) + countSelected;\r\n\t\t\t\t\tif (newPos < countOptions) {\r\n\t\t\t\t\t\t\$('#stream_order_selection option').eq(newPos).after(\"<option value='\"+\$(this).val()+\"' selected='selected'>\"+\$(this).text()+\"</option>\");\r\n\t\t\t\t\t\t\$(this).remove();\r\n\t\t\t\t\t}\r\n\t\t\t\t});\r\n\t\t\t});\r\n\r\n\r\n\t\t\t\$('#vbtn-up').bind('click', function() {\r\n\r\n\t\t\t\t\$('#vod_order_selection option:selected').each( function() {\r\n\t\t\t\t\tvar newPos = \$('#vod_order_selection option').index(this) - 1;\r\n\t\t\t\t\tif (newPos > -1) {\r\n\t\t\t\t\t\t\$('#vod_order_selection option').eq(newPos).before(\"<option value='\"+\$(this).val()+\"' selected='selected'>\"+\$(this).text()+\"</option>\");\r\n\t\t\t\t\t\t\$(this).remove();\r\n\t\t\t\t\t}\r\n\t\t\t\t});\r\n\t\t\t});\r\n\r\n\t\t\t\$('#vbtn-down').bind('click', function() {\r\n\t\t\tvar countOptions = \$('#vod_order_selection option').size();\r\n\t\t\tvar countSelected = \$('#vod_order_selection option:selected').size();\r\n\t\t\t\$('#vod_order_selection option:selected').each( function() {\r\n\t\t\tvar newPos = \$('#vod_order_selection option').index(this) + countSelected;\r\n\t\t\tif (newPos < countOptions) {\r\n\t\t\t\$('#vod_order_selection option').eq(newPos).after(\"<option value='\"+\$(this).val()+\"' selected='selected'>\"+\$(this).text()+\"</option>\");\r\n\t\t\t\$(this).remove();\r\n\t\t\t}\r\n\t\t\t});\r\n\t\t\t});\t\t\r\n\t\t});\r\n\t\t</script> \r\n\t\t";
    }
    public function Stream_Chanels()
    {
        global $intro;
        global $array;
        $result = $intro->db->query('SELECT * FROM `streams` WHERE type=1 order by `order` ASC ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<option  value="' . $id . '" > ' . $stream_display_name . ' </option>';
        }
    }
    public function vedios_Chanels()
    {
        global $intro;
        global $array;
        $result = $intro->db->query('SELECT * FROM `streams` WHERE type=2 order by `order` ASC ');
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            echo '<option  value="' . $id . '" > ' . $stream_display_name . ' </option>';
        }
    }
    public function doSortStreams()
    {
        global $intro;
        $select1 = $intro->input->post('select1');
        $select2 = $intro->input->post('select2');
        $select1 = explode(',', $select1);
        $i = 0;
        foreach( $select1 as $key => $val ) 
        {
            $i++;
            $val = intval($val);
            $intro->db->query_fast('update `streams` set `order`=\'' . $i . '\' WHERE  id=' . $val . ';');
        }
        $select2 = explode(',', $select2);
        foreach( $select2 as $key => $val ) 
        {
            $i++;
            $val = intval($val);
            $intro->db->query_fast('update `streams` set `order`=\'' . $i . '\' WHERE  id=' . $val . ';');
        }
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Streams Order Saved.', 'success');
    }
}
