<?php 
class Users_AppAdmin
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $qry_admin = '';
    public $qry_admin_where = '';
    public $admin = [];
    public $adminRow = [];
    public $inputBy = [
        'Code', 
        'MAC', 
        'Serial'
    ];
    public $free = [
        -1, 
        101, 
        103, 
        107, 
        110
    ];
    public $output = [
        'ts' => ' MPEGTS (.ts)', 
        'm3u8' => 'HLS (.m3u8)'
    ];
    public $time = null;
    public $time7 = null;
    private $user_pattern = ':.@*_-';
    public function __construct($appname, $base, $img_path = '')
    {
        global $intro;
        global $array;
        $this->appname = $appname;
        $this->base = $base;
        $this->img_path = $img_path;
        $this->admin = $intro->auth->sess_admin();
        $adminid = intval($this->admin['adminid']);
        $this->adminRow = $intro->auth->admin_data($adminid);
        if( $this->admin['level'] == 1 ) 
        {
            $this->qry_admin = '';
            $this->qry_admin_where = '';
        }
        else
        {
            $this->qry_admin = ' and member_id=' . $adminid;
            $this->qry_admin_where = ' where member_id=' . $adminid;
        }
        if( $this->adminRow['level'] == 6 ) 
        {
            $this->qry_admin = ' and ( member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR main_father=' . $adminid . '))');
            $this->qry_admin_where = ' where (member_id=' . $adminid . ' OR member_id IN (select adminid from ' . PREFIX . ('_admin WHERE father=' . $adminid . ' OR main_father=' . $adminid . '))');
        }
        $this->time = time();
        $this->time7 = strtotime('+7 day');
        $this->free = $array['free'];
    }
    public function error($index = '')
    {
        global $error;
        return (isset($error[$index]) ? $error[$index] : '');
    }
    public function nav()
    {
        global $intro;
        global $sess_admin;
        $sql_all = $intro->db->query('SELECT id FROM `users` ' . $this->qry_admin_where . ';');
        $all = $intro->db->returned_rows;
        $sql = $intro->db->query('SELECT (SELECT COUNT(id) FROM `users` WHERE is_restreamer=1 ' . $this->qry_admin . ') AS tot_restreamer' . (',(SELECT COUNT(id) FROM `users` WHERE is_trial=1 ' . $this->qry_admin . ') AS tot_trial') . (',(SELECT COUNT(id) FROM `users` WHERE enabled=0 ' . $this->qry_admin . ') AS tot_disabled') . (',(SELECT COUNT(id) FROM `users` WHERE admin_enabled=0 ' . $this->qry_admin . ') AS tot_adm_disabled') . (',(SELECT COUNT(id) FROM `users` WHERE exp_date <= \'' . $this->time . '\' AND exp_date !=0 AND is_restreamer=0 AND exp_date IS NOT NULL ' . $this->qry_admin . ') AS tot_expired') . '');
        $myrow = $intro->db->fetch_assoc($sql);
        $tot_restreamer = intval($myrow['tot_restreamer']);
        $tot_trial = intval($myrow['tot_trial']);
        $tot_disabled = intval($myrow['tot_disabled']);
        $tot_expired = intval($myrow['tot_expired']);
        $tot_adm_disabled = intval($myrow['tot_adm_disabled']);
        echo "\r\n\t\t<div class=\"app_nav\">\r\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('index') . ('" href="' . $this->base . '/index"><icon class="icon-user"></icon> Users (') . money($all) . ")</a>  \r\n\t\t\t<a class=\"btn btn-" . _obf_0D112A0B38292C2D10301E34042E37091B2A160D5B2501('Form') . (' p_add" href="' . $this->base . "/Form?t=add\"><icon class=\"icon-plus-squared\"></icon> Add User</a>\r\n\t\t</div>");
        echo '<div class="app_nav">';
        if( $this->admin['level'] == 1 ) 
        {
            echo '<a class="btn btn-success" href="' . $this->base . '/index?is_restreamer=1"> Restreamers (' . money($tot_restreamer) . ')</a> ';
        }
        echo "\r\n\t\t<a class=\"btn btn-info\" href=\"" . $this->base . '/index?is_trial=1"> Trial (' . money($tot_trial) . (")</a> \r\n\t\t<a class=\"btn btn-warning\" href=\"" . $this->base . '/index?view=expired"> Expired (') . money($tot_expired) . (")</a>\r\n\t\t<a class=\"btn btn-danger icon-off\" href=\"" . $this->base . '/index?view=disabled"> Disabled (') . money($tot_disabled) . (")</a>\r\n\t\t<a class=\"btn btn-danger icon-block\" href=\"" . $this->base . '/index?view=banned"> Banned (') . money($tot_adm_disabled) . ")</a>\r\n\t\t</div>";
    }
    public function index()
    {
        global $intro;
        global $array;
        $qry = $params = '';
        $status = trim($intro->input->get_post('status'));
        $view = trim($intro->input->get_post('view'));
        $page = intval($intro->input->get_post('page'));
        $order = trim($intro->input->get_post('order'));
        $fullname = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('fullname'), ' {ar}'));
        $period = intval($intro->input->get_post('period'));
        $is_restreamer = intval($intro->input->get_post('is_restreamer'));
        $is_trial = intval($intro->input->get_post('is_trial'));
        $member_id = intval($intro->input->get_post('resid'));
        $adminid = intval($intro->input->get_post('adminid'));
        $admin_notes = trim($intro->db->escape($intro->input->get_post('admin_notes')));
        $reseller_notes = trim($intro->db->escape($intro->input->get_post('reseller_notes')));
        $date_add = trim($intro->db->escape($intro->input->get_post('date_add')));
        $date_addto = trim($intro->db->escape($intro->input->get_post('date_addto')));
        $date_expire = trim($intro->db->escape($intro->input->get_post('date_expire')));
        $date_expireto = trim($intro->db->escape($intro->input->get_post('date_expireto')));
        $mobile = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('mobile'), '\+\-\*'));
        $username = trim(_obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->get_post('username'), $this->user_pattern));
        $this->nav();
        if( $is_restreamer == 1 ) 
        {
            $qry .= ' AND is_restreamer=1';
            $params .= '&is_restreamer=1';
        }
        if( $is_trial == 1 ) 
        {
            $qry .= ' AND is_trial=1';
            $params .= '&is_trial=1';
        }
        if( $username != '' ) 
        {
            if( preg_match('/[*]/i', $username) ) 
            {
                $qry .= (' AND username  LIKE \'' . str_replace('*', '%', $username) . '\' ');
            }
            else
            {
                $qry .= (' AND username  LIKE \'%' . $username . '%\' ');
                $params .= ('&username=' . $username);
            }
        }
        if( $fullname != '' ) 
        {
            $qry .= (' AND ud.fullname  LIKE \'%' . $fullname . '%\' ');
            $params .= ('&fullname=' . $fullname);
        }
        if( $admin_notes != '' ) 
        {
            $qry .= (' AND admin_notes LIKE \'%' . $admin_notes . '%\' ');
            $params .= ('&admin_notes=' . $admin_notes);
        }
        if( $reseller_notes != '' ) 
        {
            $qry .= (' AND reseller_notes LIKE \'%' . $reseller_notes . '%\' ');
            $params .= ('&reseller_notes=' . $reseller_notes);
        }
        if( $mobile != '' ) 
        {
            $qry .= (' AND mobile=\'' . $mobile . '\' ');
            $params .= ('&mobile=' . $mobile);
        }
        if( $member_id != '' ) 
        {
            $qry .= (' AND member_id=' . $member_id . ' ');
            $params .= ('&resid=' . $member_id);
        }
        if( $period != 0 ) 
        {
            $qry .= (' AND period=' . $period . ' ');
            $params .= ('&period=' . $period);
        }
        if( $date_add != '' ) 
        {
            $qry_date = ' AND created_at BETWEEN \'' . strtotime($date_add . ' 00:00:00') . '\' AND \'' . strtotime($date_add . ' 23:59:59') . '\' ';
            if( $date_addto != '' ) 
            {
                $qry_date = ' AND created_at BETWEEN \'' . strtotime($date_add . ' 00:00:00') . '\' AND \'' . strtotime($date_addto . ' 23:59:59') . '\' ';
            }
            $qry = $qry_date;
            $params .= ('&date_add=' . $date_add . '&date_addto=' . $date_addto);
        }
        if( $date_expire != '' ) 
        {
            $qry_date = ' AND exp_date BETWEEN \'' . strtotime($date_expire . ' 00:00:00') . '\' AND \'' . strtotime($date_expire . ' 23:59:59') . '\' ';
            if( $date_expireto != '' ) 
            {
                $qry_date = ' AND exp_date BETWEEN \'' . strtotime($date_expire . ' 00:00:00') . '\' AND \'' . strtotime($date_expireto . ' 23:59:59') . '\' ';
            }
            $qry = $qry_date;
            $params .= ('&date_expire=' . $date_expire . '&date_expireto=' . $date_expireto);
        }
        if( $view == 'expired' ) 
        {
            $qry = ' AND is_restreamer=0 AND exp_date !=0 AND exp_date <= \'' . $this->time . '\' AND exp_date IS NOT NULL  ';
            $params .= '&view=expired';
        }
        if( $view == 'soon_to_expire' ) 
        {
            $qry = ' AND exp_date BETWEEN \'' . $this->time . '\' AND \'' . $this->time7 . '\' ';
            $params .= '&view=soon_to_expire';
            $order = 'exp_date:ASC';
        }
        if( $view == 'banned' ) 
        {
            $qry = ' AND admin_enabled=0 ';
            $params .= '&view=banned';
        }
        if( $view == 'disabled' ) 
        {
            $qry = ' AND enabled=0 ';
            $params .= '&view=disabled';
        }
        if( $view == 'UsersEqPass' ) 
        {
            $qry = ' AND ( SOUNDEX (`username`) = SOUNDEX (`password`) ) ';
            $params .= '&view=UsersEqPass';
        }
        if( $order == '' ) 
        {
            $order = 'id:desc';
        }
        $order = str_replace(':', ' ', $order);
        $rows_per_page = 50;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $concat = 'stream_id,\'|\',user_agent,\'|\',user_ip,\'|\',container,\'|\',geoip_country_code,\'|\',isp';
        $qry_online = ',IF(enabled=1,(select count(user_id) from user_activity_now tblonline  where tblonline.user_id=users.id),\'\') as online';
        $result = $intro->db->query('SELECT *' . $qry_online . ' , (SELECT member_group_id FROM solus_admin adm WHERE adm.adminid=users.member_id ) as reselPkg ' . ' from `users` ' . ' LEFT JOIN ' . PREFIX . '_users_data ud on users.id=ud.userid  ' . (' where is_mag=0 AND is_e2=0  ' . $this->qry_admin . ' ' . $qry . ' order by ' . $order . ' limit ' . $nexlimit . ',' . $rows_per_page));
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT id from `users`  LEFT JOIN ' . PREFIX . '_users_data ud on users.id=ud.userid  ' . (' where is_mag=0 AND is_e2=0 ' . $this->qry_admin . ' ' . $qry . ' '));
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Found users (' . money($totalrows) . ')', 'primary');
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        echo "\r\n\t\t<form action=\"\" method=\"GET\">\r\n\t\t\t<table class=\"table table-bordered table-condensed\">\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Username:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"username\" value=\"" . $username . "\" size=\"20\" placeholder='Username : Use * for wildcards.' autofocus></td>\r\n\t\t\t\t\t<td>Fullname:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"fullname\" value=\"" . $fullname . "\" size=\"15\" placeholder=Fullname></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Period: </td>\r\n\t\t\t\t\t<td>" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11(), $period, 'All') . "</td>\r\n\t\t\t\t\t<td>Reseller:</td>";
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t\t\t\t<td>" . form_resellers('resid', $member_id, 'All Resellers') . '</td>';
        }
        else if( $this->admin['level'] == 6 ) 
        {
            echo "\r\n\t\t\t\t\t\t<td>" . form_resellers('resid', $member_id, 'All Resellers', 'where father=' . $this->admin['adminid']) . '</td>';
        }
        else
        {
            echo '<td>' . $this->admin['admin_name'] . '</td>';
        }
        echo "\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t\t<td> </td>\r\n\t\t\t\t\t\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Date Created:</td>\r\n\t\t\t\t\t<td class='form-inline'><input class=\"form-control date_picker\" type=\"text\" name=\"date_add\" value=\"" . $date_add . "\" style=\"width:200px;\" placeholder='Date of adding this user'>\r\n\t\t\t\t\t<input class=\"form-control date_picker\" type=\"text\" name=\"date_addto\" value=\"" . $date_addto . "\" style=\"width:150px;\" placeholder='to date'>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t\t\r\n\t\t\t\t\t<td>Date Expire:</td>\r\n\t\t\t\t\t<td class='form-inline'><input class=\"form-control date_picker\" type=\"text\" name=\"date_expire\" value=\"" . $date_expire . "\" style=\"width:200px;\" placeholder='Date of expiry'>\r\n\t\t\t\t\t<input class=\"form-control date_picker\" type=\"text\" name=\"date_expireto\" value=\"" . $date_expireto . "\" style=\"width:150px;\" placeholder='to date'>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t\t\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Mobile:</td>\r\n\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"mobile\" value=\"" . $mobile . '" size="20" placeholder=\'Mobile\'></td>';
        if( $this->admin['level'] == 1 ) 
        {
            echo "<td>Admin Notes:</td>\r\n\t\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"admin_notes\" value=\"" . $admin_notes . '" size="20" placeholder=Notes></td>';
        }
        else
        {
            echo "<td>Notes:</td>\r\n\t\t\t\t\t\t<td><input class=\"form-control\" type=\"text\" name=\"reseller_notes\" value=\"" . $reseller_notes . '" size="20" placeholder=Notes></td>';
        }
        echo "<td><input type=\"submit\" class=\"btn btn-success\" value=\" Search! \" class='btn btn-default'></td>\r\n\t\t\t\t\t<td></td>\r\n\t\t\t\t</tr>\r\n\t\t\t</table>\r\n\t\t\t<input type=\"hidden\" name=\"status\" value=\"" . $status . "\">\r\n\t\t</form>";
        echo "\r\n\t\t<table class=\"DataTable table-striped table-bordered table-condensed\" id=\"table_codes\">\r\n        <thead>\r\n\t    <tr>\r\n\t\t\t<th>ID " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('id', 'index', $params) . " </th>\r\n\t\t\t<th></th>\r\n\t\t\t<th>Reseller " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('member_id', 'index', $params) . "</th>\r\n\t\t\t<th>Fullname</th>\r\n\t\t\t<th>Username " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('username', 'index', $params) . " </th>\r\n\t\t\t<th>Password</th>\r\n\t\t\t<th>Period " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('period', 'index', $params) . "</th>\r\n\t\t\t\r\n\t\t\t<th>Created on</th>\r\n\t\t\t<th>Expire " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('exp_date', 'index', $params) . "</th>\r\n\t\t\t<th>" . (($this->admin['level'] == 1 ? 'Admin ' : '')) . "Notes</th>\r\n\t\t\t<th>MAX Conn. " . _obf_0D0E3B101F1F141B17071E30192721091B1E0922351901('online', 'index', $params) . "</th>\r\n\t\t\t<th> </th>\r\n\t\t\t<th>Options</th>\r\n\t    </tr>\r\n\t\t</thead>\r\n\t\t\r\n\t\t<tbody>";
        $i = 0;
        while( $myrow = $intro->db->fetch_assoc($result) ) 
        {
            @extract($myrow);
            $i++;
            $user_id = $id;
            $userid = $id;
            if( $exp_date == '' ) 
            {
                $exp_date = 'Unlimited';
            }
            else if( $exp_date < time() ) 
            {
                $exp_date = 'Expired';
            }
            else
            {
                $exp_date = date('Y-m-d H:i', $exp_date);
            }
            if( intval($online) > 0 ) 
            {
                $online_txt = '<a class="AjaxModal" href="' . $intro->app_url('online', 'index') . ('/?id=' . $userid . '&for=user"><icon class="icon-globe" style=\'color:green;\' title="' . $online . '"></icon></a>');
            }
            else
            {
                $online_txt = '<a class="AjaxModal" href="' . $intro->app_url('online', 'was') . ('/?id=' . $userid . '&for=user"><icon class="icon-globe" style=\'color:gray;\' title="offline"></icon></a>');
            }
            if( $enabled == 0 ) 
            {
                $online = '<span class="icon-off label label-danger" title="Disabled!"> </span>';
            }
            if( $admin_enabled == 0 ) 
            {
                $online = '<span class="icon-block label label-danger" title="Banned!"> </span>';
            }
            $linethrough = ($exp_date == 'Expired' ? 'style=\'text-decoration: line-through;\'' : '');
            echo "\r\n\t\t\t<tr id='tr_" . $id . '\' ' . (($is_trial == 1 ? 'style=\'color:#ff2626\'' : '')) . ' ' . (($myrow['exp_date'] == '' ? 'style=\'color:#2db300\'' : '')) . ' ' . (($exp_date == 'Expired' ? 'style=\'color:#d90000;\'' : '')) . (">\r\n\t\t\t\t<td class='c'>" . $id . "</td>\r\n\t\t\t\t<td class='c' id='status_" . $id . '\'>' . $online_txt . "</td>\r\n\t\t\t\t<td class='c'>") . ((isset($array['admins'][$member_id]) ? $array['admins'][$member_id] : 'not set')) . ("</td>\t\r\n\t\t\t\t<td>" . $fullname . "</td>\r\n\t\t\t\t<td " . $linethrough . '>' . $username . "</td>\r\n\t\t\t\t<td " . $linethrough . ' id=\'pwd_' . $id . '\'>' . $password . "</td>\t\r\n\t\t\t\t<td>");
            if( $reselPkg > 0 ) 
            {
                if( intval($pkg) > 0 ) 
                {
                    echo $intro->packages[$pkg];
                }
                else
                {
                    echo $intro->packages[$period];
                }
            }
            echo "</td>\t\r\n\t\t\t\t\r\n\t\t\t\t<td>" . (($created_at != '' ? date('Y-m-d', $created_at) : '-')) . ("</td>\r\n\t\t\t\t<td class='c' " . $linethrough . '><span class="editExpireDate" data-type="text" data-pk="' . $id . '" data-name="exp_date">' . $exp_date . "</span></td>\r\n\t\t\t\t<td class='c'>") . (($this->admin['level'] == 1 ? $admin_notes : $reseller_notes)) . "</td>\r\n\t\t\t\t<td class='c' " . (($online > 0 ? 'style=\'color:green;background:#ccc\'' : '')) . ('>' . $online . '/' . $max_connections . "</td>\r\n\t\t\t\t<td class='c'></td>\r\n\t\t\t\t<td class='c'>");
            echo "\r\n\t\t\t\t\t<div class=\"btn-group\">\r\n                        <button class=\"btn btn-primary btn-xs dropdown-toggle\" href=\"#\" data-toggle=\"dropdown\">\r\n                        <span class='icon-cog'></span> <span class=\"caret\"></span>\r\n                        </button>\r\n                        <ul class=\"dropdown-menu stay-open pull-right\" role=\"menu\" style=\"padding: 15px; min-width: 200px;\">";
            if( $enabled == 0 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&NH=1&sus=off" OnClick="return false;"  title="Disable/Suspend"><span class="btn btn-success btn-xs icon-ok"></span>Enable</a></li>';
            }
            if( $enabled == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="p_edit AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&NH=1&sus=on" OnClick="return false;" title="Enable/unsuspend"><span class="btn btn-danger btn-xs icon-off"></span> Disable </a></li>';
            }
            if( $this->admin['level'] == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&sus=ban" title="Ban!"><span class="btn btn-danger btn-xs icon-cancel-circled2"></span> Ban!</a></li>';
            }
            if( $this->admin['level'] == 1 && $admin_enabled == 0 ) 
            {
                echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Suspend?uid=' . $user_id . '&sus=unban" title="Unban!"><span class="btn btn-success btn-xs icon-ok"></span> UnBan!</a></li>';
            }
            if( $enabled == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="AjaxModal" href="' . $intro->app_url('renew', 'User') . ('?id=' . $id . '" title="Renew User"><span class="btn btn-success btn-xs icon-cw"></span> Renew User</a></li>');
            }
            if( $enabled == 1 && $admin_enabled == 1 ) 
            {
                echo '<li><a class="p_edit AjaxModal" href="' . $this->base . '/m3u/?id=' . $id . "\" title=\"Download m3u\">\r\n\t\t\t\t\t\t\t\t<span class=\"btn btn-success btn-xs icon-download\"></span> m3u </a></li>";
            }
            echo '<li><a class="p_edit" href="' . $this->base . '/Form?t=edit&amp;id=' . $id . '" title="Edit User"><span class="btn btn-info btn-xs icon-edit"></span> Edit </a></li>';
            echo '<li><a class="AjaxModal" href="' . $this->base . '/ResetPassForm?id=' . $id . '" title="This will generate new random password"><span class="btn btn-info btn-xs icon-cw"></span> Reset Pass </a></li>';
            if( $this->admin['level'] == 1 || intval($this->admin['can_delete']) == 1 ) 
            {
                echo '<li><a class="p_del AjaxModal" href="' . $this->base . '/DelForm?id=' . $id . '" title="' . $intro->lang['del'] . '"><span class="btn btn-danger btn-xs icon-trash"></span> Delete</a></li>';
            }
            echo "\r\n\t\t\t\t\t\t\t<li class=\"divider\"></li>";
            if( $enabled == 1 ) 
            {
                echo '<li><a class="p_view AjaxModal" href="' . $this->base . '/OSDMessage?id=' . $id . '" title="OSD Message"><span class="btn btn-default btn-xs icon-desktop"></span> Send OSD Msg</a></li>';
            }
            echo '<li><a class="AjaxConfirm" href="' . $this->base . '/Kill?uid=' . $user_id . '" title="Kill Connection!"><span class="btn btn-success btn-xs icon-emo-shoot"></span>Kill</a></li>';
            echo "\r\n                        </ul>\r\n\t\t\t\t\t</div>";
        }
        echo "</tbody>\r\n\t\t\t</table>";
        $order = str_replace(' ', ':', $order);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411('<div class=\'text-center\'>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?' . $params, $totalrows, $rows_per_page, $page) . '</div>');
        echo "\t\t<script>\r\n\t\t\$(document).ready(function() {\r\n\r\n\t\t\t";
        if( $this->admin['level'] == 1 || $this->admin['level'] == 9 ) 
        {
            echo "\t\t\t\t\$.fn.editable.defaults.mode = 'pop';     \r\n\t\t\t\t\$('.editExpireDate').editable({\r\n\t\t\t\t\turl: '";
            echo $this->base;
            echo "/EditCodeDate?NH=1',\r\n\t\t\t\t\tsuccess: function(response) {\r\n\t\t\t\t\t\tif(response != \"success\" && response != \"\")\r\n\t\t\t\t\t\t\talert(response);\r\n\t\t\t\t\t}\r\n\t\t\t\t});\r\n\t\t\t";
        }
        echo "\t\t\t\r\n\t\t});\r\n\t\t</script>\r\n\t\t";
    }
    public function EditCodeDate()
    {
        global $intro;
        $data = $dataU = [];
        $id = intval($intro->input->get_post('pk'));
        $name = trim($intro->input->get_post('name'));
        $value = trim($intro->input->get_post('value'));
        if( $name == 'exp_date' ) 
        {
            if( !IntroDate::validateDate($value, 'Y-m-d H:i') ) 
            {
                exit( 'Wrong Date Format: use yyyy-mm-dd HH:ii' );
            }
            $value = strtotime($value);
        }
        $data[$name] = $value;
        if( $this->admin['level'] == 1 || $this->admin['level'] == 9 ) 
        {
            $intro->db->update('users', $data, 'id=' . $id);
            $af = $intro->db->affected_rows;
            exit( 'success (' . $af . ') ' );
        }
    }
    public function m3u()
    {
        global $intro;
        global $array;
        global $options;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        if( $username == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this username:\r\n\t\t\t\t<li>The username may not found or is deleted.\r\n\t\t\t\t<li>Or you don't have the right permisions to edit this username.", 'danger');
            exit();
        }
        $user = $username;
        $pass = $password;
        $url = _obf_0D3F5B5B312E2F352234142C1C1F3C1B0C06231A292732('m3u');
        if( $this->adminRow['host'] != '' ) 
        {
            $url['host'] = $this->adminRow['host'];
        }
        $host = $url['scheme'] . '://' . $url['host'] . ':' . $url['port'] . str_replace('//', '/', '/' . $url['path']);
        $sql = $intro->db->query('SELECT * from devices order by device_name asc;');
        $data = 'Host: http://' . $url['host'] . ':' . $url['port'] . "\n";
        $data .= ('Username: ' . $user . "\n");
        $data .= ('Password: ' . $pass . "\n");
        $maa = 1;
        $m3u8 = $host . ('?username=' . $user . '&password=' . $pass . '&type=m3u&output=ts');
        $m3u8_opt = $host . ('?username=' . $user . '&password=' . $pass . '&type=m3u_plus&output=ts');
        echo '<textarea class=\'AutoCopy form-control\' style=\'height:100px;font-size:16px;\' spellcheck="false" data-gramm="false">' . $data . '</textarea>';
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('M3U');
        echo '<textarea class=\'AutoCopy form-control\' style=\'height:60px;font-size:16px;\' spellcheck="false" data-gramm="false">' . $m3u8 . '</textarea>';
        echo 'M3U With Options:<br/><textarea class=\'AutoCopy form-control\' style=\'height:60px;font-size:16px;\' spellcheck="false" data-gramm="false">' . $m3u8_opt . '</textarea>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo '<br/><ul class="list-group">';
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $device_name = $row['device_name'];
            $device_key = $row['device_key'];
            $device_id = $row['device_id'];
            $link = $host . ('?username=' . $user . '&password=' . $pass . '&type=' . $device_key . '&output=mpegts');
            echo '<li data-id="' . $device_id . '" class="m3uSelector list-group-item ' . (($device_name == 'm3u' ? 'list-group-item-info' : '')) . ('"><a href="' . $link . "\" OnClick='return false;'>\r\n\t\t\t\t" . $device_name . " \r\n\t\t\t\t</a>\r\n\t\t\t\t<div id='div_m3uinput_" . $device_id . "' style='display:none'>\r\n\t\t\t\t<input id='m3uinput_" . $device_id . '\' type=\'text\' class=\'form-control\' value=\'' . $link . "' />\r\n\t\t\t\t</div>\r\n\t\t\t</li>");
        }
        echo '</ul>';
    }
    public function OSDMessage()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        @extract($row);
        if( $username == '' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this user:\r\n\t\t\t\t<li>The user may not found or is deleted.\r\n\t\t\t\t<li>Or you don't have the right permisions to edit this user.", 'danger');
            exit();
        }
        $exp_date = ($exp_date != '' ? date('Y-m-d', $exp_date) : '-');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Send OSD Message to username: ' . $username, 'success');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>username:</td>\r\n\t\t\t\t<td>" . $username . "</td>\r\n\t\t\t\t<td class='info'>Adminid:</td>\r\n\t\t\t\t<td>" . $array['admins'][$member_id] . ("</td>\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t\t<tr>\t\t\r\n\t\t\t\t<td class='info'>Days:</td>\r\n\t\t\t\t<td> </td>\r\n\t\t\t\t<td class='info'>Date Expire</td>\r\n\t\t\t\t<td>" . $exp_date . "</td>\t\r\n\t\t\t\t\r\n\t\t\t</tr>\r\n\t\t</table>");
        echo "\r\n\t\t<form name=\"frmSendOSD\"  id=\"frmSendOSD\" method=\"post\" action=\"" . $this->base . "/doSendOSD\">\r\n\t\t<div id='result'></div>\r\n\t\t<table class=\"table table-striped table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<td>Mesaage: </td>\r\n\t\t\t<td><textarea name=\"OSD_message\" style=\"width:99%;height:150px\">  </textarea></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Status:</td>\r\n\t\t\t<td>  </td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td> </td>\r\n\t\t\t<td> <input type=\"submit\" id=\"OsdSubmit\" value=\" Send \" class=\"btn btn-success\" OnClick=\"return confirm('Are you sure?')\" /> </td>\r\n\t\t</tr>\r\n\t\t\r\n\t\t</table>\r\n\r\n\t\t<input type=\"hidden\" name=\"userid\" value=\"" . $id . "\" />\r\n\t\t\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\$(\"#frmSendOSD\").submit(function(event){\r\n\t\t\t\tevent.preventDefault();\r\n\r\n\t\t\t\t\$.ajax({\r\n\t\t\t\t\turl:'" . $this->base . "/doSendOSD?NH=1',\r\n\t\t\t\t\ttype:'POST',\r\n\t\t\t\t\tdata:\$(this).serialize(),\r\n\t\t\t\t\tsuccess:function(result){\r\n\t\t\t\t\t\t\$('#result').html(result);\r\n\t\t\t\t\t}\r\n\r\n\t\t\t\t});\r\n\t\t\t});\r\n\t\t});\r\n\t\t</script>";
    }
    public function doSendOSD()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('userid'));
        $OSD_message = trim($intro->input->get_post('OSD_message'));
        $OSD_message = strip_tags($OSD_message);
        $OSD_message = preg_replace('/[^a-zA-Z0-9-أ-ي. ]/ui', '', $OSD_message);
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Success:  Message Sent. ', 'success');
    }
    public function Suspend()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('uid'));
        $sus = trim($intro->input->get_post('sus'));
        if( $sus == 'on' ) 
        {
            $qry = 'enabled=0';
            $span_sus = '<span class="icon-off label label-danger" title="Disabled!"> </span>';
        }
        else if( $sus == 'off' ) 
        {
            $qry = 'enabled=1';
            $span_sus = '<span class="label label-success">Active</span>';
        }
        else if( $sus == 'ban' ) 
        {
            $qry = 'admin_enabled=0';
            $span_sus = '<span class="icon-block label label-danger" title="Banned!"> </span>';
        }
        else if( $sus == 'unban' ) 
        {
            $qry = 'admin_enabled=1';
            $span_sus = '<span class="label label-success">Active</span>';
        }
        else
        {
            exit( 'Opps!!!' );
        }
        $qq = $code = '';
        if( intval($this->admin['level']) == 1 || intval($this->admin['level']) == 9 ) 
        {
            $qq = '';
        }
        else
        {
            $qq = ' and member_id=' . intval($this->admin['adminid']);
        }
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $qq . ';');
        $row = $intro->db->fetch_assoc($sql);
        $username = $row['username'];
        $intro->db->query('UPDATE users SET ' . $qry . ' WHERE id=' . $id . ' ' . $qq . ';');
        $arr = ['status_' . $id => $span_sus];
        header('Content-Type: application/json');
        echo json_encode($arr);
    }
    public function Kill()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('uid'));
        $span_sus = '<span class="icon-unlink label label-default" title="Killed"> </span>';
        $qq = $code = '';
        if( intval($this->admin['level']) == 1 || intval($this->admin['level']) == 9 ) 
        {
            $qq = '';
        }
        else
        {
            $qq = ' and member_id=' . intval($this->admin['adminid']);
        }
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $qq . ';');
        $row = $intro->db->fetch_assoc($sql);
        if( isset($row['id']) ) 
        {
            $x = new XtreamApi('EmptyFunc');
            $AllPids = [];
            $result = $intro->db->query('SELECT pid,server_id FROM `user_activity_now` WHERE user_id=' . $id . ';');
            while( $myrow = $intro->db->fetch_assoc($result) ) 
            {
                $AllPids[$myrow['server_id']][] = $myrow['pid'];
            }
            if( count($AllPids) > 0 ) 
            {
                foreach( $AllPids as $server_id => $pids ) 
                {
                    $res = $x->KillPids($server_id, $pids);
                    if( $res == 'success' ) 
                    {
                        $intro->db->query('DELETE FROM `user_activity_now` WHERE user_id=' . $id . ';');
                    }
                }
            }
        }
        else
        {
            $span_sus = '<span class="label label-danger">You have no perms.</span>';
        }
        $arr = ['status_' . $id => $span_sus];
        header('Content-Type: application/json');
        echo json_encode($arr);
    }
    public function DelForm()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        if( !is_array($row) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('User is not found or deleted. OR you are not authorized to delete this user.', 'danger');
            exit();
        }
        @extract($row);
        $sql2 = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $id . ';'));
        $row2 = $intro->db->fetch_assoc($sql2);
        @extract($row2);
        $exp_date = ($exp_date != '' ? date('Y-m-d H:s', $exp_date) : 'Unlimited');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Delete User: ' . $username, 'danger');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Fullname:</td>\r\n\t\t\t\t<td>" . $fullname . "</td>\r\n\t\t\t\t<td class='info'>Reseller:</td>\r\n\t\t\t\t<td>" . ((isset($array['admins'][$member_id]) ? $array['admins'][$member_id] : 'not set')) . ("</td>\r\n\t\t\t\t<td class='info'>Expire:</td>\r\n\t\t\t\t<td>" . $exp_date . "</td>\r\n\t\t\t</tr>");
        $sql = $intro->db->query('SELECT * from ' . PREFIX . ('_trans where type=1 AND userid=' . $id));
        $r = $intro->db->fetch_assoc($sql);
        if( is_array($r) ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Invoice:</td>\r\n\t\t\t\t<td>Amount: " . $r['amount'] . "</td>\r\n\t\t\t\t<td colspan='4'>Notes: " . $r['Notes'] . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t</table>";
        echo "<div class=\"btn-group\" role=\"group\" aria-label=\"Delete\">\r\n\t\t\t\t  \r\n\t\t\t\t  <a class=\"btn btn-danger p_del\" id=\"delete\" href=\"" . $this->base . '/Del?id=' . $id . '&code=' . $username . "&NH=1&db=1\">\r\n\t\t\t\t\t<i class=\"icon-cancel-circled2\"></i> Delete User From database\r\n\t\t\t\t  </a>\r\n\t\t\t\t  \r\n\t\t\t</div>\r\n\t\t\t\t\r\n\t\t\t\t<span id=\"spin\" class='icon-spin5'></span>";
        echo '<div id=\'result\'>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$('documnet').ready(function(){\r\n\t\t\t\$('#delete').click(function(e){\r\n\t\t\t\te.preventDefaults;\r\n\t\t\t\t\r\n\t\t\t\tif(!confirm('Are you sure?')) return false;\r\n\t\t\t\t\r\n\t\t\t\t\$('#spin').addClass('animate-spin');\r\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\r\n\t\t\t\t\t\$( \"#result\" ).html( data );\r\n\t\t\t\t\t\$('#spin').removeClass('animate-spin');\r\n\t\t\t\t});\r\n\t\t\t\treturn false;\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});\r\n\t\t</script>";
    }
    public function ResetPassForm()
    {
        global $intro;
        global $array;
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        if( !is_array($row) ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('User is not found or deleted. OR you are not authorized to edit this user.', 'danger');
            exit();
        }
        @extract($row);
        $sql2 = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $id . ';'));
        $row2 = $intro->db->fetch_assoc($sql2);
        @extract($row2);
        $exp_date = ($exp_date != '' ? date('Y-m-d H:s', $exp_date) : 'Unlimited');
        $this->nav();
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('Reset Password for user: ' . $username, 'info');
        echo "<table class=\"table table-striped table-bordered\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td class='info'>Username:</td>\r\n\t\t\t\t<td>" . $username . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td></td>\r\n\t\t\t\t<td>\r\n\t\t\t\t<a class=\"btn btn-success p_del\" id=\"btnResetPass\" href=\"" . $this->base . '/ResetPass?id=' . $id . "&NH=1\">\r\n\t\t\t\t\t<i class=\"icon-cancel-circled2\"></i> Yes: Reset Password\r\n\t\t\t\t  </a>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>";
        echo '<span id="spin" class=\'icon-spin5\'></span>';
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$('documnet').ready(function(){\r\n\t\t\t\$('#btnResetPass').click(function(e){\r\n\t\t\t\te.preventDefaults;\r\n\t\t\t\t\r\n\t\t\t\tif(!confirm('Are you sure?')) return false;\r\n\t\t\t\t\r\n\t\t\t\t\$('#spin').addClass('animate-spin');\r\n\t\t\t\t\$.get( \$(this).attr('href'), function( data ) {\r\n\t\t\t\t\t\$( \"#result\" ).html( data );\r\n\t\t\t\t\t\$('#spin').removeClass('animate-spin');\r\n\t\t\t\t});\r\n\t\t\t\treturn false;\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});\r\n\t\t</script>";
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $period;
        global $fullname;
        global $code;
        global $days;
        global $adminid;
        global $status;
        global $created_at;
        global $num;
        global $bouquets;
        global $forced_country;
        global $allowed_ua;
        global $allowed_ips;
        global $mobile;
        global $username;
        global $free_days;
        global $length;
        global $member_id;
        global $options;
        global $container;
        global $password;
        global $admin_notes;
        global $reseller_notes;
        global $force_server_id;
        global $bypass_ua;
        global $is_stalker;
        global $is_isplock;
        global $max_connections;
        global $bouquet;
        global $is_restreamer;
        global $created_by;
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $id = $userid = intval($intro->input->get_post('id'));
        $page = intval($intro->input->get_post('page'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        $btn = [];
        $password_dis = '';
        $user_dis = '';
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $qry = '';
            $sql = $intro->db->query('SELECT * FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $sql2 = $intro->db->query('SELECT * FROM ' . PREFIX . ('_users_data where userid=' . $id . ';'));
            $row2 = $intro->db->fetch_assoc($sql2);
            @extract($row2);
            if( $username == '' ) 
            {
                echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232("Error: you cannot change this user:\r\n\t\t\t\t\t<li>The user may not found or is deleted.\r\n\t\t\t\t\t<li>Or you don't have the right permisions to edit this user.", 'danger');
                exit();
            }
            $btn['legend_name'] = 'Edit user: <b>' . $username . '</b>';
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $bouquet = json_decode($bouquet, true);
            if( $allowed_ua != '' ) 
            {
                $tmp_ua = json_decode($allowed_ua, true);
                $allowed_ua = implode(',', $tmp_ua);
            }
            if( $allowed_ips != '' ) 
            {
                $tmp_ua = json_decode($allowed_ips, true);
                $allowed_ips = implode(',', $tmp_ua);
            }
            if( $this->adminRow['can_set_pass'] == 0 && $this->adminRow['level'] != 1 ) 
            {
                $password_dis = 'readonly=\'\'';
            }
            if( $this->admin['level'] != 1 ) 
            {
            }
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            new IntroPerms('CheckBalance', $this->adminRow);
            $btn['legend_name'] = 'Add new User';
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $intro->lang['save'];
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            $num = ($num == '' ? 1 : $num);
            $length = ($length == '' ? 12 : $length);
            if( $this->adminRow['num_free'] == 0 ) 
            {
            }
            $max_connections = ($max_connections == '' ? 1 : $max_connections);
            $is_isplock = ($is_isplock == '' ? 0 : $is_isplock);
            if( isset($_POST['bouquets']) && count($intro->input->post('bouquets')) > 0 ) 
            {
                $bouquet = $intro->input->post('bouquets');
            }
            if( $member_id == '' ) 
            {
                $member_id = $this->admin['adminid'];
            }
            if( $intro->input->get_post('adminid') != '' ) 
            {
                $member_id = intval($intro->input->get_post('adminid'));
            }
            if( $this->adminRow['can_set_pass'] == 0 && $this->adminRow['level'] != 1 ) 
            {
                $password_dis = 'disabled=\'\'';
                $password = 'Auto Generated';
            }
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $btn['legend_icon'] . '"></i> ' . $btn['legend_name'] . ' ') . ("\r\n\t\t\r\n\t\t<form method=\"POST\" name=\"form_add\" id='frmUsers' action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\">\r\n\t\t<table class=\"table table-bordered\">\r\n\t\t<tr>\r\n\t\t\t<td>") . $intro->lang['codes_fullname'] . (" :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"fullname\" value=\"" . $fullname . "\" class=\"form-control\" style='min-width:70%'>\r\n\t\t\t\t\t" . $this->error('fullname') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Mobile : </td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"mobile\" value=\"" . $mobile . "\" class=\"form-control\"  style='min-width:70%'> \r\n\t\t\t\t\t" . $this->error('mobile') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Username : <span style='color:#ff0000'>*</span></td>\r\n\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"username\" value=\"" . $username . '" class="form-control" style=\'min-width:300px\' ' . $user_dis . "> \r\n\t\t\t\t\t" . $this->error('username') . ' Allowed Chars: <strong>') . implode(' ', str_split($this->user_pattern)) . ("<strong>\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td>Password :  </td>\r\n\t\t\t<td>\r\n\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t<input  type=\"text\" name=\"password\" " . $password_dis . ' value="' . $password . "\" class=\"form-control\" style='min-width:300px' placeholder=\"Leave empty for random password\">\r\n\t\t\t\t\t" . $this->error('password') . "\r\n\t\t\t\t</div>\r\n\t\t\t</td>\r\n\t\t</tr>");
        if( $this->adminRow['member_group_id'] > 0 && $t == 'add' ) 
        {
            $pkg = new Packages($this->adminRow);
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Package: <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>";
            echo $pkg->FormDropDown();
            echo "\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bouquets:  <span style='color:#ff0000'>*</span>\r\n\t\t\t\t\t<div style=\"float:right;\">\r\n\t\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td> " . $this->error('bouquets') . " <div id='bouquets_result'></div></td>\r\n\t\t\t</tr>";
        }
        if( $this->adminRow['member_group_id'] == 0 && ($this->admin['level'] == 1 || $t == 'add') ) 
        {
            echo "\r\n\t\t\t\t<tr>\r\n\t\t\t\t\t<td>Period (days) :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t\t<td><div class=\"form-inline\">\r\n\t\t\t\t\t\t\t" . _obf_0D25032D2B210E1538102515291B2D08111A1816070622('period', _obf_0D322A5B141A102E2824032B03230A35140306272F2F11('page_users'), $period) . (string)$this->error('period');
            if( $this->admin['level'] == 1 ) 
            {
                echo '<span id="span_free_days" style="display:none">Free Extra Days: <input  type="number" name="free_days" value="' . $free_days . '" ' . (($t == 'add' ? 'min="1"' : '')) . ' class="form-control" size="10"></span>';
            }
            else if( strlen($this->adminRow['extra_free_days']) >= 2 ) 
            {
                echo extra_free_days($this->adminRow['extra_free_days'], $free_days);
            }
            echo "\r\n\t\t\t\t\t\t</div>\r\n\t\t\t\t\t</td>\r\n\t\t\t\t</tr>";
        }
        if( $t == 'edit' ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Created On : </td>\r\n\t\t\t\t<td>" . date('Y-m-d H:i:s', $created_at) . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 && $t == 'edit' ) 
        {
            if( $exp_date == '' ) 
            {
                $exp_date = 'UNLIMITED';
            }
            else
            {
                $exp_date = date('Y-m-d H:i:s', $exp_date);
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>End Date : </td>\r\n\t\t\t\t<td><input type=\"text\" name=\"exp_date\" value=\"" . $exp_date . "\" size=\"25\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Is Trial  : </td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_trial', $is_trial, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->adminRow['member_group_id'] == 0 || $this->admin['level'] == 1 || $t == 'edit' ) 
        {
            if( $this->admin['level'] == 1 ) 
            {
                echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Output formats  : <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>" . $this->stream_output_format($userid, $t) . "</td>\r\n\t\t\t</tr>";
            }
            if( $this->adminRow['member_group_id'] > 0 ) 
            {
                $intro->member_group_id = $this->adminRow['member_group_id'];
                $intro->code_pkg = $pkg;
            }
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bouquets: <span style='color:#ff0000'>*</span>\r\n\t\t\t\t\t<div style=\"float:right;\">\r\n\t\t\t\t\t\t   <input type=\"checkbox\" id=\"checkAll\"/> <b>Check All</b>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td> " . $this->error('bouquets') . ' ' . bouquets($bouquet) . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Force Connect to:  </td>\r\n\t\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('force_server_id', 'Don\'t Force', 'streaming_servers', $force_server_id, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc') . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 || $this->adminRow['can_set_country'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Override General Country Restriction:  </td>\r\n\t\t\t\t<td> " . forced_country($forced_country) . ' ' . (($t == 'edit' ? '(' . $forced_country . ')' : '')) . "</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>STALKER Portal  : </td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_stalker', $is_stalker, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Lock user to his ISP :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_isplock', $is_isplock, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Bypass Global User Agent Restriction List :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('bypass_ua', $bypass_ua, 1, 'Yes', 'No', 'primary') . "</td>\r\n\t\t\t</tr>";
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Is Restreamer :</td>\r\n\t\t\t\t<td>" . _obf_0D0E0C021E271714230F1135191C022F35343836305C01('is_restreamer', $is_restreamer, 1, 'Yes', 'No', 'success') . ("</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Max Connections :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" type=\"text\" name=\"max_connections\" value=\"" . $max_connections . '"> ' . $this->error('max_connections') . " \r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>");
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Allowed IPs :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" data-role=\"tagsinput\" type=\"text\" name=\"allowed_ips\" value=\"" . $allowed_ips . '" size="30"> ' . $this->error('allowed_ips') . " \r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Allowed User Agent :</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t<div class=\"form-inline\">\r\n\t\t\t\t\t\t<input class=\"form-control\" data-role=\"tagsinput\" type=\"text\" name=\"allowed_ua\" value=\"" . $allowed_ua . '" size="30"> ' . $this->error('allowed_ua') . " <i>(Allowed User Agents to use this account [Default all allowed])</i>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>";
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>" . $intro->lang['codes_adminid'] . " :  <span style='color:#ff0000'>*</span></td>\r\n\t\t\t\t<td>" . _obf_0D312C22263726180408322D1B0C363E320C351C1B0B32($member_id) . (' ' . $this->error('adminid') . "</td>\r\n\t\t\t</tr>");
        }
        if( $this->admin['level'] == 1 ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Admin Notes :</td>\r\n\t\t\t\t<td><textarea name=\"admin_notes\" class=\"form-control\" style='width:100%;height:70px;'>" . $admin_notes . '</textarea> ' . $this->error('admin_notes') . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Reseller Notes :</td>\r\n\t\t\t\t<td><textarea name=\"reseller_notes\" class=\"form-control\" style='width:100%;height:70px;'>" . $reseller_notes . '</textarea> ' . $this->error('reseller_notes') . "</td>\r\n\t\t\t</tr>";
        if( $t == 'add' ) 
        {
            echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td>Cost :</td>\r\n\t\t\t\t<td><div id='ResultCost'></div>" . $this->error('cost_err') . "</td>\r\n\t\t\t</tr>";
        }
        echo "\r\n\t\t\t<tr>\r\n\t\t\t\t<td class=\"center\" colspan=\"2\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"userid\"  value=\"" . $userid . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"usernameold\"  value=\"" . $username . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $userid . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\r\n\t\t\t\t\t<input type=\"hidden\" name=\"page\"  value=\"" . $page . "\">\r\n\t\t\t\t\t<button type=\"submit\" class=\"btn btn-success\" value=\"" . $btn['action'] . '"><i class="' . $btn['img_icon'] . '"></i> ' . $btn['name'] . " </button>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>\r\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo "<script>\r\n\t\t\$(document).ready(function(){\r\n\t\t\t\r\n\t\t\t\$(\"select[name='package']\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar package = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\t\$.post(\"" . $intro->app_url('renew', 'getBouquets') . "/?NH=1\", \r\n\t\t\t\t\t{package:package}, function(data,status,xhr){\t\r\n\t\t\t\t\t\$(\"#bouquets_result\").html(data);\r\n\t\t\t\t\t/*\$(\"#checkAll\").trigger('click');*/\r\n\t\t\t\t\t\$(\"#UsersBouquets\").find(':checkbox').prop('checked', true);\r\n\t\t\t\t});\r\n\t\t\t\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\$(\"select[name=period]\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar groupName = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\tCalcCost();\r\n\t\t\t\t\r\n\t\t\t\tif(groupName < 100 && groupName >= 1){\r\n\t\t\t\t\t\$('#span_free_days').show();\r\n\t\t\t\t\t\r\n\t\t\t\t}else{\r\n\t\t\t\t\t\$('#span_free_days').hide();\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\tvar CalcCost = function (){\r\n\t\t\t\t\r\n\t\t\t\tvar period = parseInt(\$(\"select[name=period]\").val()) || 0;\r\n\t\t\t\tvar admin = parseInt(\$(\"select[name=adminid]\").val()) || 0;\r\n\r\n\t\t\t\t\$.post(\"" . $intro->app_url('renew', 'calcCost') . "/?NH=1\", \r\n\t\t\t\t\t{period:period,resel:admin}, function(data,status,xhr){\t\r\n\t\t\t\t\t\$(\"#ResultCost\").html(data);\r\n\t\t\t\t});\r\n\t\t\t}\r\n\t\t\t\r\n\t\t\t\$(\"#checkAll\").change(function () {\r\n\t\t\t\t\$(this).closest('tr').find(':checkbox').prop('checked', \$(this).prop(\"checked\"));\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"select[name=period]\").change(function () {\r\n\t\t\t\t\r\n\t\t\t\tvar groupName = \$(this).val();\r\n\t\t\t\t\r\n\t\t\t\tCalcCost();\r\n\t\t\t\t\r\n\t\t\t\tif(groupName < 100 && groupName >= 1){\r\n\t\t\t\t\t\$('#span_free_days').show();\r\n\t\t\t\t\t\r\n\t\t\t\t}else{\r\n\t\t\t\t\t\$('#span_free_days').hide();\r\n\t\t\t\t}\r\n\t\t\t\t\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"select[name=adminid]\").change(function () {\r\n\t\t\t\tCalcCost();\r\n\t\t\t});\r\n\t\t\t\r\n\t\t\t\$(\"#frmUsers\").validate({\r\n\t\t\t\tignore: [],\r\n\t\t\t\trules: {\r\n\t\t\t\t\tfullname: \"required\",\r\n\t\t\t\t\tperiod: \"required\",\r\n\t\t\t\t\tadminid: \"required\",\r\n\t\t\t\t\tusername: {\r\n\t\t\t\t\t\trequired: true,\r\n\t\t\t\t\t\tminlength: 6\r\n\t\t\t\t\t},\r\n\t\t\t\t\t'stream_output_format[]': {\r\n\t\t\t\t\t\trequired: true,\r\n\t\t\t\t\t\tminlength: 1\r\n\t\t\t\t\t},\r\n\t\t\t\t\t'bouquets[]': {\r\n\t\t\t\t\t\trequired: true,\r\n\t\t\t\t\t\tminlength: 1\r\n\t\t\t\t\t}\r\n\t\t\t\t},\r\n\t\t\t\tmessages: {\r\n\t\t\t\t\tfullname: \"Required!\",\r\n\t\t\t\t\tperiod: \"Choose Period!\",\r\n\t\t\t\t\tusername: \"Required! and minimum of 5 characters.\",\r\n\t\t\t\t\t'stream_output_format[]': \"Choose Output.\",\r\n\t\t\t\t\t'bouquets[]': \"Choose Bouquets.\"\r\n\t\t\t\t}\r\n\t\t\t});\r\n\t\t\t\r\n\t\t});";
        if( $period >= 1 && $period < 100 ) 
        {
            echo "\$('#span_free_days').show();\n";
        }
        else
        {
            echo "\$('#span_free_days').hide();\n";
        }
        echo "\r\n\t\t</script>";
    }
    public function stream_output_format($userid, $t = '')
    {
        global $intro;
        $html = '';
        $outputs = [
            '1' => 'HLS', 
            '2' => 'MPEGTS', 
            '3' => 'RTMP'
        ];
        $output = [];
        $sql = $intro->db->query('select access_output_id from user_output where user_id=' . $userid . ';');
        while( $row = $intro->db->fetch_assoc($sql) ) 
        {
            $output[] = intval($row['access_output_id']);
        }
        if( isset($_POST['stream_output_format']) && count($_POST['stream_output_format']) > 0 ) 
        {
            $output = $intro->input->post('stream_output_format');
        }
        foreach( $outputs as $key => $val ) 
        {
            $html .= ("<label class=\"checkbox-inline\">\r\n\t\t\t\t<input type=\"checkbox\" name=\"stream_output_format[]\" value=\"" . $key . '" ' . (($t == 'add' ? 'checked' : '')) . ' ' . ((in_array($key, $output) ? 'checked' : '')) . ('> ' . $val . "\r\n\t\t\t\t</label>"));
        }
        return $html;
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        global $array;
        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('fullname'), ' {ar}');
        $mobile = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mobile'), '+-');
        $username = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('username'), $this->user_pattern);
        $password = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('password'));
        $allowed_ips = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('allowed_ips'), ',');
        $stream_output_format = $intro->input->post('stream_output_format');
        $period = intval($intro->input->post('period'));
        $adminid = intval($intro->input->post('adminid'));
        $bypass_ua = intval($intro->input->post('bypass_ua'));
        $is_isplock = intval($intro->input->post('is_isplock'));
        $is_stalker = intval($intro->input->post('is_stalker'));
        $max_connections = intval($intro->input->post('max_connections'));
        $is_restreamer = intval($intro->input->post('is_restreamer'));
        $free_days = intval($intro->input->post('free_days'));
        $package = intval($intro->input->post('package'));
        $bouquets = $intro->input->post('bouquets');
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_ua = trim($intro->input->post('allowed_ua'));
        $admin_notes = $intro->db->escape($intro->input->post('admin_notes'));
        $reseller_notes = $intro->db->escape($intro->input->post('reseller_notes'));
        if( $adminid == 0 && $this->admin['level'] != 1 ) 
        {
            $adminid = intval($this->admin['adminid']);
        }
        if( $fullname == '' || $username == '' || $password != '' && strlen($password) < 6 || $adminid == 0 || $period == 0 && $package == 0 || $bouquets == null || $this->adminRow['num_free'] == 0 && in_array($period, $array['free']) && $package == 0 ) 
        {
            if( $fullname == '' ) 
            {
                $error['fullname'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $username == '' ) 
            {
                $error['username'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $password != '' && strlen($password) < 6 ) 
            {
                $error['password'] = '<span class=error>The password must be at least six characters in length.</span>';
            }
            if( $period == 0 && $package == 0 ) 
            {
                $error['period'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $this->adminRow['num_free'] == 0 && in_array($period, $array['free']) && $package == 0 ) 
            {
                $error['period'] = '<span class=error>Error: you can\'t Add free users at this time. Please contact admin.</span>';
            }
            if( $adminid == 0 ) 
            {
                $error['adminid'] = '<span class=error>' . $intro->lang['required'] . '</span>';
            }
            if( $bouquets == null ) 
            {
                $error['bouquets'] = '<span class=error>Please choose at least one Bouquets/PACKAGE</span>';
            }
            $this->Form('add');
            exit();
        }
        $sql = $intro->db->query('SELECT username FROM users where username=\'' . $username . '\';');
        if( $intro->db->returned_rows > 0 ) 
        {
            $error['username'] = '<span class=error>Username already exists! Please choose another one.</span>';
            $this->Form('add');
            exit();
        }
        if( $password != '' ) 
        {
            similar_text($username, $password, $perc);
            $reverse_similar = false;
            similar_text($username, strrev($password), $perc2);
            if( round($perc) >= 50 || round($perc2) >= 50 ) 
            {
                $error['username'] = '<span class=error>Username and Password must be different! please don\'t use the same characters.</span>';
                $this->Form('add');
                exit();
            }
        }
        $adm = $intro->auth->admin_data($adminid);
        $p = new IntroPerms('CheckCost', $adm, 1, $period, $package);
        if( $p->error != '' ) 
        {
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($p->error, 'danger');
            $error['cost_err'] = _obf_0D3D40321528110F062A0B0321102712170C15030F2232($p->error, 'danger');
            $this->Form('add');
            exit();
        }
        if( $max_connections == 0 ) 
        {
            $max_connections = 1;
        }
        $data = $data2 = [];
        $data2['fullname'] = $fullname;
        $data2['mobile'] = $mobile;
        $data2['period'] = $period;
        $data2['free_days'] = $free_days;
        $data['username'] = $username;
        $data['password'] = ($password == '' ? _obf_0D2F32243C12041507380F0603331A24041D1E32150A32() : $password);
        $data['bypass_ua'] = $bypass_ua;
        $data['member_id'] = $adminid;
        $data['is_isplock'] = $is_isplock;
        $data['is_stalker'] = $is_stalker;
        $data['is_restreamer'] = $is_restreamer;
        $data['created_by'] = $adminid;
        $data['max_connections'] = $max_connections;
        $data['exp_date'] = _obf_0D1E12391F102F2E2A3E23330537315C320C3910402322($period, $free_days);
        $data['bouquet'] = '[' . implode(',', $bouquets) . ']';
        $data['forced_country'] = $forced_country;
        $data['allowed_ua'] = $this->allowed_uagent($allowed_ua, 'save');
        $data['allowed_ips'] = $this->allowed_uagent($allowed_ips, 'save');
        $data['is_trial'] = (in_array($period, $array['free']) && $period != -1 ? 1 : 0);
        $data['admin_enabled'] = 1;
        $data['enabled'] = 1;
        $data['created_at'] = time();
        $data['pkg'] = $package;
        $data['admin_notes'] = $admin_notes . '';
        $data['reseller_notes'] = $reseller_notes . '';
        $data['force_server_id'] = intval($intro->input->post('force_server_id'));
        if( $package > 0 ) 
        {
            $pkg = _obf_0D0E122A21280A14271F3B1D1727291E290A0A2A092E11($package);
            $data['max_connections'] = $pkg['max_connections'];
            $data['exp_date'] = $pkg['exp_date'];
            $data['is_trial'] = $pkg['is_trial'];
            $data2['period'] = $package;
            $stream_output_format = $pkg['output_formats_array'];
        }
        $intro->db->insert('users', $data);
        $userid = $intro->db->insert_id();
        $data2['userid'] = $userid;
        $intro->db->insert('' . PREFIX . '_users_data', $data2, true);
        if( $this->admin['level'] == 1 ) 
        {
            foreach( $stream_output_format as $key => $val ) 
            {
                $intro->db->insert('user_output', [
                    'user_id' => $userid, 
                    'access_output_id' => $val
                ]);
            }
        }
        else
        {
            $intro->db->insert('user_output', [
                'user_id' => $userid, 
                'access_output_id' => 1
            ]);
            $intro->db->insert('user_output', [
                'user_id' => $userid, 
                'access_output_id' => 2
            ]);
        }
        $success = 1;
        if( $package == 0 ) 
        {
            if( !in_array($period, $array['free']) ) 
            {
                $inv = new IntroInvoice();
                $inv->set('adminid', $adminid);
                $inv->set('period', $period);
                $inv->set('num', 1);
                $inv->set('code_trans', 0);
                $inv->set('all_data', '');
                $inv->set('userid', $userid);
                $inv->set('notes', 'add user: ' . $username . ' Days:' . $array['period'][$period]);
                $inv->Save();
            }
        }
        else
        {
            $inv = new IntroInvoice();
            $inv->set('isPackage', true);
            $inv->set('adminid', $adminid);
            $inv->set('package', $package);
            $inv->set('period', $package);
            $inv->set('num', 1);
            $inv->set('code_trans', 0);
            $inv->set('all_data', '');
            $inv->set('userid', $userid);
            $inv->set('notes', 'add user: ' . $username . ' Days:' . $pkg['inv_notes']);
            $inv->Save();
        }
        if( in_array($period, $array['free']) && $this->adminRow['num_free'] > 0 && $success > 0 ) 
        {
            $intro->db->query('UPDATE ' . PREFIX . ('_admin SET num_free=num_free-' . $success . ' WHERE num_free>0 AND adminid=' . $adminid . ';'));
            if( $this->adminRow['father'] > 0 ) 
            {
                $intro->db->query('UPDATE ' . PREFIX . ('_admin SET num_free=num_free-' . $success . ' WHERE num_free>0 AND adminid=' . $this->adminRow['father'] . ';'));
            }
            $intro->db->query('UPDATE ' . PREFIX . '_admin SET num_free=0 WHERE num_free<-1;');
        }
        _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Username <strong>(' . $username . ')</strong> added successfully.', 'success');
        $intro->redirect($this->appname);
    }
    public function checkRepeated($string)
    {
        preg_match_all('/(.)\1+/', $string, $matches);
        $result = array_combine($matches[1], array_map('strlen', $matches[0]));
        arsort($result);
        if( isset($result[0]) && count($result[0]) >= 3 ) 
        {
            return false;
        }
        return true;
    }
    public function random_number($length)
    {
        $random = substr(number_format(time() * rand(), 0, '', ''), 0, $length);
        return $random;
    }
    public function allowed_uagent($allowed_ua, $for = 'save')
    {
        if( $for == 'save' ) 
        {
            if( $allowed_ua != '' ) 
            {
                $ex = explode(',', $allowed_ua);
                $agnet = json_encode($ex);
                return $agnet;
            }
            else
            {
                return '';
            }
        }
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        global $error;
        $userid = $id = intval($intro->input->get_post('userid'));
        $fullname = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('fullname'), ' {ar}');
        $mobile = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('mobile'), '\+');
        $usernameold = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('usernameold'), $this->user_pattern);
        $username = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('username'), $this->user_pattern);
        $password = _obf_0D162C393D0808073D1A062223322C0919102C28242A11($intro->input->post('password'));
        $stream_output_format = $intro->input->post('stream_output_format');
        $period = intval($intro->input->post('period'));
        $adminid = intval($intro->input->post('adminid'));
        $bypass_ua = intval($intro->input->post('bypass_ua'));
        $is_isplock = intval($intro->input->post('is_isplock'));
        $is_stalker = intval($intro->input->post('is_stalker'));
        $max_connections = intval($intro->input->post('max_connections'));
        $free_days = intval($intro->input->post('free_days'));
        $exp_date = trim($intro->input->post('exp_date'));
        $forced_country = trim($intro->input->post('forced_country'));
        $allowed_ua = trim($intro->input->post('allowed_ua'));
        $allowed_ips = trim($intro->input->post('allowed_ips'));
        $admin_notes = $intro->db->escape($intro->input->post('admin_notes'));
        $reseller_notes = $intro->db->escape($intro->input->post('reseller_notes'));
        $bouquets = $intro->input->post('bouquets');
        $sql = $intro->db->query('SELECT id FROM users ' . (' where username=\'' . $username . '\' AND id!=' . $userid . ';'));
        if( $intro->db->returned_rows > 0 ) 
        {
            $_POST['userid'] = $userid;
            $_POST['id'] = $_POST['userid'];
            $error['username'] = '<span class=error>' . $userid . ' Username (' . $username . ') already exists!</span>';
            $this->Form('edit');
            exit();
        }
        $data = $data2 = [];
        $data2['userid'] = $userid;
        $data2['fullname'] = $fullname;
        $data2['mobile'] = $mobile;
        if( $this->admin['level'] == 1 ) 
        {
            $data2['period'] = $period;
            $data2['free_days'] = $free_days;
            $data['member_id'] = intval($intro->input->post('adminid'));
            $data['created_by'] = intval($intro->input->post('adminid'));
            $data['admin_notes'] = $admin_notes . '';
            $data['max_connections'] = $max_connections;
            $data['exp_date'] = ($exp_date != '' && $exp_date != 'UNLIMITED' ? strtotime($exp_date) : null);
            $data['is_trial'] = (in_array($period, $array['free']) && $period != -1 ? 1 : 0);
            if( isset($_POST['is_trial']) ) 
            {
                $data['is_trial'] = intval($intro->input->post('is_trial'));
            }
            $data['is_restreamer'] = intval($intro->input->post('is_restreamer'));
            $data['force_server_id'] = intval($intro->input->post('force_server_id'));
        }
        else if( $reseller_notes != '' ) 
        {
            $data['reseller_notes'] = $reseller_notes;
        }
        $data['bouquet'] = '[' . implode(',', $bouquets) . ']';
        if( $this->admin['level'] == 1 ) 
        {
            $data['username'] = $username;
        }
        if( $this->adminRow['can_set_pass'] == 1 || $this->admin['level'] == 1 ) 
        {
            $data['password'] = ($password == '' ? _obf_0D060735305C5C07152D1733241F3E070A1221100A4032() : $password);
        }
        if( $this->admin['level'] == 1 ) 
        {
            $data['bypass_ua'] = $bypass_ua;
            $data['forced_country'] = $forced_country;
            $data['allowed_ua'] = $this->allowed_uagent($allowed_ua, 'save');
            $data['allowed_ips'] = $this->allowed_uagent($allowed_ips, 'save');
            $data['is_isplock'] = $is_isplock;
        }
        $data['is_stalker'] = $is_stalker;
        $qry = '';
        $intro->db->update('users', $data, 'id=' . $userid . ' ' . $this->qry_admin);
        $intro->db->insert_update('' . PREFIX . '_users_data', $data2, $data2);
        $outIDs = [];
        if( is_array($stream_output_format) && count($stream_output_format) > 0 ) 
        {
            foreach( $stream_output_format as $key => $val ) 
            {
                $sql = $intro->db->query('select user_id from user_output where user_id=' . $userid . ' AND access_output_id=' . $val);
                if( $intro->db->returned_rows == 0 ) 
                {
                    $intro->db->insert('user_output', [
                        'user_id' => $userid, 
                        'access_output_id' => $val
                    ]);
                }
                $outIDs[] = $val;
            }
        }
        if( count($outIDs) >= 1 ) 
        {
            $intro->db->query('delete from user_output where user_id=' . $userid . ' AND access_output_id NOT IN(' . implode(',', $outIDs) . ')');
        }
        $intro->redirect($this->appname);
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        $sql = $intro->db->query('SELECT id,username FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        $username = $row['username'];
        if( intval($row['id']) == 0 ) 
        {
            echo '<h1>Not authorized!</h1>';
            exit();
        }
        if( $this->admin['level'] == 1 || $this->admin['can_delete'] == 1 ) 
        {
            $intro->db->query('delete from users WHERE id=' . $id . ' ' . $this->qry_admin);
            $intro->db->query('delete from user_output where user_id=' . $id . ';');
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('user deleted form database forever!', 'success');
            echo "<script>\r\n\t\t\t\$(function () {\r\n\t\t\t   setTimeout(function()\r\n\t\t\t   {\r\n\t\t\t\t\t\$('#m3u-modal').modal('hide');\r\n\t\t\t\t\t\$('#tr_" . $id . "').fadeOut();\r\n\t\t\t   }, 1000);\r\n\t\t\t   \r\n\t\t\t});</script>";
            exit();
        }
        else
        {
            exit( '<h1>Not authorized!</h1>' );
        }
    }
    public function ResetPass()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        sleep(2);
        $sql = $intro->db->query('SELECT id,username FROM users where id=' . $id . ' ' . $this->qry_admin . ';');
        $row = $intro->db->fetch_assoc($sql);
        $username = $row['username'];
        if( intval($row['id']) == 0 ) 
        {
            echo '<h1>Not authorized!</h1>';
            exit();
        }
        $newpass = _obf_0D060735305C5C07152D1733241F3E070A1221100A4032();
        $intro->db->query('update users set password=\'' . $newpass . '\' WHERE id=' . $id . ' ' . $this->qry_admin);
        echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Password Changed! New Password = ' . $newpass, 'success');
        echo "<script>\r\n\t\t\$(function () {\r\n\t\t\t\$('#pwd_" . $id . '\').html(\'<span class="blinking" style="color:red;font-size:16px;">' . $newpass . "</span>');\r\n\t\t   setTimeout(function()\r\n\t\t   {\r\n\t\t\t\t\$('#m3u-modal').modal('hide');\r\n\t\t\t\t\r\n\t\t   }, 1000);\r\n\t\t   \r\n\t\t});</script>";
        exit();
    }
}
