<?php 
class AdminStreams
{
    public $appname = null;
    public $base = null;
    public $img_path = null;
    public $error = null;
    public $app_name = '';
    public $app_color = 'info';
    public $msg = null;
    public $type = 0;
    public $array_stream_status = [
        'all' => 'All', 
        'online' => 'Online', 
        'offline' => 'Offline', 
        'stopped' => 'Stopped'
    ];
    public $array_stream_status_qry = [
        'all' => '', 
        'online' => ' AND sys.stream_status=0 ', 
        'offline' => ' AND sys.stream_id IS NULL ', 
        'stopped' => ' AND sys.stream_status=1 '
    ];
    public function index()
    {
        global $intro;
        global $array;
        $edit = new StreamsEdit($this->base, $this->type);
        $qry = $params = '';
        $JOIN = 'LEFT JOIN';
        $JOIN = 'LEFT OUTER JOIN';
        $page = intval($intro->input->get_post('page'));
        $category_id = intval($intro->input->get_post('category_id'));
        $order = trim($intro->input->get_post('order'));
        $stream_display_name = trim($intro->input->get_post('stream_display_name'));
        $status = trim($intro->input->get_post('status'));
        $stream_status = trim($intro->input->get_post('stream_status'));
        $source = trim($intro->input->get_post('source'));
        $stream_icon = trim($intro->input->get_post('stream_icon'));
        $ids = trim($intro->input->get_post('ids'));
        $server = $intro->input->get_post('server');
        $view = trim($intro->input->get_post('view'));
        $ds = intval($intro->input->get_post('ds'));
        $rs = intval($intro->input->get_post('rs'));
        $ar = intval($intro->input->get_post('ar'));
        $et = intval($intro->input->get_post('et'));
        $tvr = intval($intro->input->get_post('tvr'));
        $this->nav();
        echo _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911();
        if( $intro->input->get('from') == 'edit' ) 
        {
            echo _obf_0D3D40321528110F062A0B0321102712170C15030F2232('<h4> Stream id (' . $intro->input->get_post('id') . (") updated successfully. \n\t\t\t\t<a class='btn btn-default RestartStreamSingle' href=\"" . $this->base . '/RestartCycle?NH=1&id=') . intval($intro->input->get_post('id')) . "\" OnCLick='return false;'>Click to Restart Stream</a>  \n\t\t\t\t<span id='span_single_status'></span></h4>", 'success');
        }
        $qry = ' WHERE s.type=' . $this->type;
        if( $rs == 1 ) 
        {
            $qry .= ' AND s.redirect_stream=1';
            $params .= '&rs=1';
        }
        if( $ds == 1 ) 
        {
            $qry .= ' AND s.direct_source=1';
            $params .= '&ds=1';
        }
        if( $ar == 1 ) 
        {
            $qry .= ' AND s.allow_record=1';
            $params .= '&ar=1';
        }
        if( $et != '' ) 
        {
            $qry .= ' AND s.enable_transcode=1';
            $params .= '&et=1';
        }
        if( $tvr != '' ) 
        {
            $qry .= ' AND s.tv_archive_duration!=0';
            $params .= '&tvr=1';
        }
        if( $ids != '' ) 
        {
            $qry .= (' AND s.id  in (' . $ids . ') ');
        }
        if( $stream_display_name != '' ) 
        {
            $qry .= (' AND stream_display_name  LIKE \'%' . $stream_display_name . '%\' ');
            $params .= ('&stream_display_name=' . $stream_display_name);
        }
        if( $view == 'stopped' ) 
        {
            $qry .= ' AND stream_status=1';
            $params .= '&view=stopped';
        }
        if( $category_id != 0 ) 
        {
            $qry = ' WHERE category_id=' . $category_id;
            $params .= ('&category_id=' . $category_id);
        }
        if( array_key_exists($stream_status, $this->array_stream_status) ) 
        {
            $qry .= $this->array_stream_status_qry[$stream_status];
            $params .= ('&stream_status=' . $stream_status);
        }
        if( $stream_status == 'online' || $stream_status == 'stopped' ) 
        {
            $JOIN = 'INNER JOIN';
        }
        if( $source != '' ) 
        {
            $qry .= (' AND stream_source LIKE \'%' . $source . '%\' ');
            $params .= ('&source=' . $source);
        }
        if( $stream_icon != '' ) 
        {
            $qry .= (' AND stream_icon LIKE \'%' . $stream_icon . '%\' ');
            $params .= ('&stream_icon=' . $stream_icon);
        }
        if( is_array($server) && count($server) >= 1 ) 
        {
            $allssid = [];
            foreach( $server as $ss ) 
            {
                $allssid[] = intval($ss);
            }
            $server = $allssid;
            $qry .= (' AND sys.server_id IN (' . implode(',', $server) . ') ');
            $query = http_build_query(['server' => $server]);
            $params .= ('&' . $query);
        }
        if( $stream_status == 'online' ) 
        {
            $qry .= ' AND sys.pid > 0 AND sys.stream_status = 0 ';
            $params .= '&view=online';
        }
        if( $view == 'missing' ) 
        {
            $qry .= ' AND s.direct_source=0 AND s.id NOT IN (select stream_id from streams_sys) ';
            $params .= ('&view=' . $view);
        }
        if( $order == '' ) 
        {
            $order = 's.`order`:asc';
        }
        $order = str_replace(':', ' ', $order);
        $order2 = $order;
        $rows_per_page = 100;
        if( $page == 0 ) 
        {
            $page = 1;
        }
        $nexlimit = $page * $rows_per_page - $rows_per_page;
        $result = $intro->db->query('SELECT * ,(select count(*) from user_activity_now where stream_id=s.id AND server_id=sys.server_id) as tot  from streams s ' . (' ' . $JOIN . ' `streams_sys` sys ON s.id=sys.stream_id ') . ('   ' . $qry . ' order by ' . $order . ' limit ' . $nexlimit . ',' . $rows_per_page));
        $totrows = $intro->db->returned_rows;
        $sql_all_rows = $intro->db->query('SELECT id from streams s' . (' ' . $JOIN . ' `streams_sys` sys ON s.id=sys.stream_id ') . ('  ' . $qry . ' '));
        $totalrows = $intro->db->returned_rows;
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $this->app_icon . '"></i> ' . $this->app_name . ' (' . $totalrows . ')', $this->app_color);
        echo "\n\t\t\n\t\t<fieldset>\n\t\t\t<form action=\"\" method=\"post\">\n\t\t\t\tServer:<br/>\n\t\t\t\t" . _obf_0D31033702041D1F0B1015180339183714070C36032811('server[]', $server) . ("\n\t\t\t\t<hr>\n\t\t\t\t<input type=\"text\" name=\"ids\" value=\"" . $ids . "\" placeholder=\"IDs\" size=\"15\">\n\t\t\t\t<input type=\"text\" name=\"stream_display_name\" value=\"" . $stream_display_name . "\" placeholder=\"Stream Name\" size=\"30\">\n\t\t\t\t\n\t\t\t\t") . _obf_0D3114132D0E1B5C14292309230C3F01222903383B2811('stream_status', $this->array_stream_status, $stream_status, 'Stream Status', '') . ("\n\t\t\t\t\n\t\t\t\t<input type=\"text\" name=\"source\" value=\"" . $source . "\" placeholder=\"Stream Source\" size=\"20\">\n\t\t\t\t<input type=\"text\" name=\"stream_icon\" value=\"" . $stream_icon . "\" placeholder=\"Icon\" size=\"20\">\n\t\t\t\t") . _obf_0D311A13371B215B013B112303362D1032353D2E344022('category_id', 'ALL Categories', 'stream_categories', 0, 'id', 'category_name', 'where category_type=\'live\'', 'order by category_name ASC', 'chosen') . "\n\t\t\t\t<input name=\"name\" value=\" Search \" type=\"submit\">\n\t\t\t</form>\n\t\t</fieldset>";
        $edit->TableStart($params);
        $i = 0;
        while( $row = $intro->db->fetch_assoc($result) ) 
        {
            $i++;
            $edit->Row($row, $i);
        }
        echo "</tbody>\n\t\t</table>\n\t\t</div>";
        $order = str_replace(' ', ':', $order2);
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        echo '<center>' . _obf_0D310332094006251F2A1D300709060C1C245B0E110B32($this->base . '/index?&amp;order=' . $order . $params, $totalrows, $rows_per_page, $page) . '</center>';
        echo '</fieldset>';
        $edit->JavaScript();
        echo "<script>\n\t\t\$(\"#category_id\").addClass('chosen').chosen({search_contains: true});\n\t\t</script>";
    }
    public function getStreamStatus()
    {
        global $intro;
        global $array;
        $e = new StreamsEdit($this->base, $this->type);
        $e->getStreamStatus();
    }
    public function Start()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));
        $x = new XtreamApi('EmptyFunc');
        $x->type = $this->type;
        echo $x->Start($streams);
    }
    public function Play()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));
        $bypass = intval($intro->input->get_post('bypass'));
        $host = _obf_0D30011C3F2A2E3F22302707253C09162F3D0E082D0E11('host_port') . ('live/' . $intro->option['play_strm_user'] . '/' . $intro->option['play_strm_pass'] . '/' . $id . '.m3u8');
        $sql = $intro->db->query('SELECT * FROM users where username=\'' . $intro->option['play_strm_user'] . '\' AND password=\'' . $intro->option['play_strm_pass'] . '\';');
        $row = $intro->db->fetch_assoc($sql);
        if( isset($row['id']) ) 
        {
            $userid = $row['id'];
            $x = new XtreamApi('EmptyFunc');
            $AllPids = [];
            if( $bypass == 0 ) 
            {
                $result = $intro->db->query('SELECT pid,server_id FROM `user_activity_now` WHERE user_id=' . $userid . ';');
                while( $myrow = $intro->db->fetch_assoc($result) ) 
                {
                    $AllPids[$myrow['server_id']][] = $myrow['pid'];
                }
                if( count($AllPids) > 0 ) 
                {
                    foreach( $AllPids as $server_id => $pids ) 
                    {
                        $res = $x->KillPids($server_id, $pids);
                        if( $res == 'success' ) 
                        {
                            $intro->db->query('DELETE FROM `user_activity_now` WHERE user_id=' . $userid . ';');
                        }
                    }
                    $intro->redirect('streams', 'Play', '?NH=1&id=' . $id . '&bypass=1&res=' . $res);
                    exit();
                }
            }
        }
        else
        {
            exit( _obf_0D3D40321528110F062A0B0321102712170C15030F2232("<h3>Please set: User/Pass to Play Streams <br/>Go to \n\t\t\t<a href=\"" . $intro->app_url('options', 'index', '#userToPlayStrm') . "\">Tools-> Codes Options</a>\n\t\t\t<br/> First create username from <a href=\"" . $intro->app_url('users', 'Form', '?t=add') . "\">Users</a> with 5 connections for HLS\n\t\t\t<br/> This user will be used to play streams.\n\t\t\t<br>Then set: User/Pass to Play Streams from Streams List</h3>", 'danger') );
        }
        echo "<html>\n\t\t<head>\n\t\t<script src=\"https://cdn.jsdelivr.net/npm/hls.js@latest\"></script>\n\t\t</head>\n\t\t<body>\n\t\t<video id=\"video\" width=\"100%\" height=\"100%\" controls></video>\n\t\t<script>\n\t\tvar video = document.getElementById('video');\n\t\tif(Hls.isSupported()) {\n\t\t\tvar hls = new Hls();\n\t\t\thls.loadSource('" . $host . "');\n\t\t\thls.attachMedia(video);\n\t\t\thls.on(Hls.Events.MANIFEST_PARSED,function() {video.play();});\n\t\t}\n\t\t</script>\n\t\t</body>\n\t\t</html>";
    }
    public function Stop()
    {
        global $intro;
        global $sess_admin;
        $id = $streams = intval($intro->input->get_post('id'));
        $x = new XtreamApi('EmptyFunc');
        echo $x->Stop($streams);
    }
    public function RestartCycle()
    {
        global $intro;
        global $sess_admin;
        $id = intval($intro->input->get_post('id'));
        $x = new XtreamApi('EmptyFunc');
        echo $x->Restart($id);
    }
    public function EditChannel()
    {
        global $intro;
        global $array;
        $edit = new StreamsEdit($this->base, $this->type);
        $edit->EditChannel();
    }
    public function doEditChannel()
    {
        global $intro;
        global $array;
        $edit = new StreamsEdit($this->base, $this->type);
        $edit->doEditChannel();
    }
    public function update_status()
    {
        global $intro;
        global $error;
        global $sess_admin;
        $status = trim($intro->input->get_post('status'));
        $status = ($status == 'true' ? 1 : 0);
        $id = intval($intro->input->get_post('id'));
        $sql = $intro->db->query('update streams set status=' . $status . ' WHERE id=' . $id . '; ');
        echo 'Success';
    }
    public function single_multi()
    {
        global $intro;
        $add_type = intval($intro->input->get_post('add_type'));
        $html = "<select id='singleMulti' name='add_type'>\n\t\t\t<option value=\"1\" " . (($add_type == 1 ? 'selected=""' : '')) . ">Add Single Stream</option>\n\t\t\t<option value=\"2\" " . (($add_type == 2 ? 'selected=""' : '')) . ">Upload m3u file</option>\n\t\t</select>";
        return $html;
    }
    public function Form($t = '')
    {
        global $intro;
        global $error;
        global $sess_admin;
        global $array;
        global $category_id;
        global $direct_source;
        global $redirect_stream;
        global $notes;
        global $stream_display_name;
        global $stream_source;
        global $stream_icon;
        global $status;
        global $stream_servers;
        global $rtmp_output;
        global $gen_timestamps;
        global $read_native;
        global $stream_all;
        global $custom_sid;
        global $custom_ffmpeg;
        global $custom_map;
        global $tv_archive_duration;
        global $tv_archive_server_id;
        global $number;
        global $allow_recordm;
        global $probesize_ondemand;
        global $allow_record;
        global $enable_transcode;
        global $transcode_profile_id;
        global $movie_location;
        global $delay_minutes;
        $StreamsEdit = new StreamsEdit($this->base, $this->type);
        $on_demand = '';
        if( $error || $_POST != null ) 
        {
            @extract($_POST);
        }
        $IF = intval($intro->input->get_post('IF'));
        $id = intval($intro->input->get_post('id'));
        $page = intval($intro->input->get_post('page'));
        $t = ($t == '' ? $intro->input->get_post('t') : $t);
        if( $IF != 1 ) 
        {
            $this->nav();
        }
        if( $t == 'edit' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'edit');
            $sql = $intro->db->query('SELECT * ' . (' FROM streams where id=\'' . $id . '\''));
            $row = $intro->db->fetch_assoc($sql);
            @extract($row);
            $btn['legend_name'] = $this->app_edit . (' <b>' . $id . '</b> ' . $stream_display_name);
            $btn['legend_icon'] = 'icon-edit';
            $btn['name'] = $intro->lang['save_changes'];
            $btn['img_icon'] = 'icon-floppy';
            $btn['action'] = 'doEdit';
            $stream_source = json_decode($stream_source, true);
            $stream_servers = _obf_0D3B0A102B29073D0C153B282D0C1D183D1E3D27320122($id);
            $sql2 = $intro->db->query('SELECT on_demand FROM `streams_sys` where stream_id=\'' . $id . '\' LIMIT 1');
            $row2 = $intro->db->fetch_assoc($sql2);
            @extract($row2);
            if( $on_demand == 1 ) 
            {
                $on_demand = 'on';
            }
            else if( $on_demand == 0 ) 
            {
                $on_demand = 'off';
            }
            $newSruce = '';
            if( $this->type == 3 ) 
            {
                foreach( $stream_source as $strSource ) 
                {
                    $newSruce .= ($strSource . "\n");
                }
                unset($stream_source);
                $stream_source = $newSruce;
                $movie_location = $stream_servers[0];
            }
        }
        else if( $t == 'add' ) 
        {
            policy($sess_admin['adminid'], $this->appname . '.php', 'add');
            $btn['legend_name'] = $this->app_add;
            $btn['legend_icon'] = 'icon-plus-squared';
            $btn['name'] = $this->app_add;
            $btn['img_icon'] = 'icon-plus-squared';
            $btn['action'] = 'doAdd';
            if( isset($_POST['stream_source']) ) 
            {
                $stream_source = $intro->input->post('stream_source');
            }
            if( isset($_POST['server']) ) 
            {
                $stream_servers = $intro->input->post('server');
            }
            if( is_null($stream_servers) || !is_array($stream_servers) ) 
            {
                $stream_servers = [];
            }
            ($direct_source == '' ? 0 : $direct_source);
            ($redirect_stream == '' ? 0 : $redirect_stream);
            $on_demand = ($on_demand == '' ? 'off' : $on_demand);
            $probesize_ondemand = ($probesize_ondemand == '' ? 512000 : $probesize_ondemand);
            if( $this->type == 3 && isset($stream_source[0]) ) 
            {
                $stream_source = $stream_source[0];
            }
        }
        if( $this->type == 3 ) 
        {
            echo "\n\t\t<script>var base = '" . $intro->app_url('movies', 'brws') . "/'; var type='created';</script>\n\t\t<link rel=\"stylesheet\" href=\"" . admin_path . "style/tree/proton/proton.min.css\">\n\t\t<script src=\"" . admin_path . "style/tree/jstree.min.js\"></script>\n\t\t<script src=\"" . admin_path . 'style/js/vod.js?v=2"></script>';
        }
        echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('<i class="' . $this->app_icon . '"></i> ' . $btn['legend_name'] . ' ', $this->app_color);
        $star = '<span style=\'color:#ff0000\'>*</span>';
        echo "\n\t\t<form method=\"POST\" name=\"form_add\"  action=\"" . $this->base . '/' . $btn['action'] . "\" enctype=\"multipart/form-data\" >\n\t\t\n\t\t" . _obf_0D0713255B04072D042B135C2E233E1902393B0C1B2911() . "\n\t\t<table class=\"table table-bordered table-hover table-striped\" >";
        if( $t == 'add' && $this->type != 3 ) 
        {
            echo "\n\t\t<tr>\n\t\t\t<td> </td>\n\t\t\t<td>" . $this->single_multi() . ("</td>\n\t\t</tr>\n\t\t<tr id='upload_m3u' style='display:none;'>\n\t\t\t<td>Upload M3U8 File: (Optional)</td>\n\t\t\t<td><input  type=\"file\" name=\"m3u_file\" accept=\".m3u,.m3u8\"> \n\t\t\t" . $this->error('m3u_file') . " \n\t\t\t<!-- <span style='color:red'>(file contents should starts with: #EXTM3U)</span>--> </td>\n\t\t</tr>");
        }
        echo "\n\t\t<tr>\n\t\t\t<td style='width:20%;'>Category  : " . $star . "</td>\n\t\t\t<td >" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('category_id', 'Choose Category', 'stream_categories', $category_id, 'id', 'category_name', 'where category_type=\'live\'', 'order by category_name ASC') . ($this->error('category_id') . "</td>\n\t\t</tr>");
        if( $this->type == 3 ) 
        {
            echo "\n\t\t<tr>\n\t\t\t<td>Channel Location:</td>\n\t\t\t<td>\n\t\t\t\t" . _obf_0D12262623113F1D022A011A3E1D1B253D294027090E01('movie_location', $movie_location) . (' ' . $this->error('movie_location') . " \n\t\t\t\t<span id=\"local\">\n\t\t\t\t\t<button type=\"button\" class=\"btn btn-danger\" id=\"PickFile\">Pick Files</button>\n\t\t\t\t</span>\n\t\t\t</td>\n\t\t</tr>");
        }
        echo "\n\t\t<tr class='singleTR'>\n\t\t\t<td>Stream Display Name :  <span style='color:#ff0000'>*</span></td>\n\t\t\t<td><input  type=\"text\" name=\"stream_display_name\" value=\"" . $stream_display_name . '" class=\'form-control\'> ' . $this->error('stream_display_name') . "</td>\n\t\t</tr>";
        if( $this->type == 3 ) 
        {
            echo "\n\t\t<tr id=\"movie_source_form\">\n\t\t\t<td>Channel Source : " . $star . " <span id='total_selected_from_tree'>0</span></td>\n\t\t\t<td><textarea name=\"stream_source[]\" id=\"stream_source\" class='form-control' style='height:200px;'>" . $stream_source . '</textarea>' . $this->error('stream_source') . "</td>\n\t\t</tr>";
        }
        if( $this->type != 3 ) 
        {
            echo "\n\t\t<tr class='singleTR'>\n\t\t\t<td>Stream Source:  <span style='color:#ff0000'>*</span></td>\n\t\t\t<td>\n\t\t\t<table class=\"table table-bordered table-hover table-striped\" id=\"tblStream" . $id . "\">\n\t\t\t<tbody>";
            if( is_array($stream_source) ) 
            {
                $i = 0;
                foreach( $stream_source as $val ) 
                {
                    $i++;
                    $val = stripslashes($val);
                    echo "\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>" . $i . " </td>\n\t\t\t\t\t\t<td><input type=\"text\" name=\"stream_source[]\" value=\"" . $val . "\" class='form-control'></td>\n\t\t\t\t\t\t<td><button type=\"button\" class='btn btn-danger btnDelStreamRow'><span class='icon-trash'></span></button></td>\n\t\t\t\t\t</tr>";
                }
            }
            else
            {
                echo "<tr class='singleTR'>\n\t\t\t\t\t<td>1 </td>\n\t\t\t\t\t<td><input type=\"text\" name=\"stream_source[]\" value=\"\" class='form-control'></td>\n\t\t\t\t\t<td><button type=\"button\" class='btn btn-danger btnDelStreamRow'><span class='icon-trash'></span></button></td>\n\t\t\t\t</tr>";
            }
            echo "\t\n\t\t\t</tbody>\n\t\t\t</table>\n\t\t\t<div>\n\t\t\t\t<button data-id=\"" . $id . "\" type=\"button\" class='btn btn-default btnAddNewStreamRowFirst'><span class='icon-plus-squared'></span>First</button>\n\t\t\t\t<button data-id=\"" . $id . "\" type=\"button\" class='btn btn-default btnAddNewStreamRowLast'><span class='icon-plus-squared'></span>Last</button>\n\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>";
        }
        echo "\n\t\t<tr>\n\t\t\t<td>Stream Icon : </td>\n\t\t\t<td><input  type=\"text\" name=\"stream_icon\" value=\"" . $stream_icon . '" class=\'form-control\'> ' . $this->error('stream_icon') . "</td>\n\t\t</tr>";
        if( $this->type == 1 ) 
        {
            echo "\n\t\t<tr>\n\t\t\t<th colspan='2'>Source Options</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Use Direct Source & don't restream it : </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('direct_source', $direct_source, 'yes') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Redirect Stream : </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('redirect_stream', $redirect_stream, 'yes') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>RTMP Output: </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('rtmp_output', $rtmp_output, 'yes') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Generate New Timestamps: </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('gen_timestamps', $gen_timestamps, 'yes') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Read Input Source in Native Frames: </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('read_native', $read_native, 'yes') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Stream all the codecs found on the video: </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('stream_all', $stream_all, 'yes') . "</td>\n\t\t</tr>";
        }
        echo "\n\t\t<tr>\n\t\t\t<th colspan='2'>Custom Options</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Custom Channel SID : </td>\n\t\t\t<td><input  type=\"text\" name=\"custom_sid\" value=\"" . $custom_sid . '" class=\'form-control\'> ' . $this->error('custom_sid') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Custom FFmpeg command : </td>\n\t\t\t<td><input  type=\"text\" name=\"custom_ffmpeg\" value=\"" . $custom_ffmpeg . '" class=\'form-control\'> ' . $this->error('custom_ffmpeg') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Custom MAP Stream : </td>\n\t\t\t<td><input  type=\"text\" name=\"custom_map\" value=\"" . $custom_map . '" class=\'form-control\'> ' . $this->error('custom_map') . "</td>\n\t\t</tr>";
        echo "\n\t\t<tr>\n\t\t\t<th colspan='2'>Servers</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>OnDemand/Live:</td>\n\t\t\t<td>" . _obf_0D1029270D2B062E351F39253F1B39061037400E130401('on_demand', [
            'on' => 'OnDemand on selected servers', 
            'off' => 'Live'
        ], $on_demand, 'Don\'t Change') . "</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Load Balance Servers: <span style='color:#ff0000'>*</span> </td>\n\t\t\t<td>";
        echo _obf_0D31033702041D1F0B1015180339183714070C36032811('server[]', $stream_servers);
        echo $this->error('server') . "\n\t\t\t</td>\n\t\t</tr>";
        if( $this->type == 1 ) 
        {
            echo "\t\n\t\t<tr>\n\t\t\t<td>Probesize On-Demand:</td>\n\t\t\t<td><input type=\"text\" name=\"probesize_ondemand\" value=\"" . $probesize_ondemand . "\"> Default: 128000 or 512000</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Delay Stream:</td>\n\t\t\t<td><input type=\"text\" name=\"delay_minutes\" value=\"" . $delay_minutes . "\"> Delay stream to start after X minutes (Only for live streams)</td>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<th colspan='2'>TV Archive</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Number of Days to keep recording this stream : </td>\n\t\t\t<td><input  type=\"text\" name=\"tv_archive_duration\" value=\"" . $tv_archive_duration . "\"></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Server to Save the Recordings In : </td>\n\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('tv_archive_server_id', 'None', 'streaming_servers', $tv_archive_server_id, 'id', 'server_name', 'bouquet_status', 'where `status`=1', 'order by server_name asc') . "\n\t\t\t<br/> This server must be the same as load balance server. </td>\n\t\t</tr>";
        }
        $arguments = [];
        $arguments[1] = '';
        $arguments[2] = '';
        $arguments[17] = '';
        if( $t == 'edit' ) 
        {
            $sql6 = $intro->db->query('select id,stream_id,argument_id,value from `streams_options` WHERE stream_id=' . $id);
            while( $row6 = $intro->db->fetch_assoc($sql6) ) 
            {
                $argument_id = $row6['argument_id'];
                $arguments[$argument_id] = $row6['value'];
            }
        }
        if( is_array($intro->input->post('arguments')) ) 
        {
            $arguments = $intro->input->post('arguments');
        }
        if( $this->type == 1 ) 
        {
            echo "\n\t\t\n\t\t<tr>\n\t\t\t<th colspan='2'>Fetching Options</th>\n\t\t</tr>\n\t\t\n\t\t<tr>\n\t\t\t<td>User Agent : </td>\n\t\t\t<td><input  type=\"text\" name=\"arguments[1]\" value=\"" . $arguments[1] . "\" class='form-control'></td>\n\t\t</tr>\n\n\t\t<tr>\n\t\t\t<td>HTTP Proxy : </td>\n\t\t\t<td><input  type=\"text\" name=\"arguments[2]\" value=\"" . $arguments[2] . "\" class='form-control' placeholder=\"example: 192.168.1.1:8080\"></td>\n\t\t</tr>\n\n\t\t<tr>\n\t\t\t<td>Cookie : </td>\n\t\t\t<td><input  type=\"text\" name=\"arguments[17]\" value=\"" . $arguments[17] . "\" class='form-control'></td>\n\t\t</tr>";
            echo "\n\t\t<tr>\n\t\t\t<th colspan='2'>STB Devices (Stalker Portal)</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Assign Stalker Portal Number : </td>\n\t\t\t<td><input  type=\"text\" name=\"number\" value=\"" . $number . "\"></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Allow Recording of The Stream : </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('allow_record', $allow_record, 'yes') . "</td>\n\t\t</tr>";
        }
        echo "\n\t\t<tr>\n\t\t\t<th colspan='2'>Transcode Stream</th>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td>Enable Transcode : </td>\n\t\t\t<td>" . _obf_0D363B0530401A36170C40253C1B2D5C2B1D340A0D3D22('enable_transcode', $enable_transcode, 'yes') . "</td>\n\t\t</tr>\n\t\t<tr class='transcode'>\n\t\t\t<td>" . tooltip('tooltip_streams', 'transcode_profile_id') . " Select Transcode Profile (Optional): </td>\n\t\t\t<td>" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('transcode_profile_id', 'No Transcode', 'transcoding_profiles', $transcode_profile_id, 'profile_id', 'profile_name', '', ' order by profile_name ASC') . ("\n\t\t\t\t" . $this->error('transcode_profile_id') . "\n\t\t\t\t<a href=\"") . $intro->app_url('transcode_profiles', 'index') . "\" target=\"_blank\" class=\"btn btn-default\">Manage</a>\n\t\t\t</td>\n\t\t</tr>";
        if( $t == 'add' ) 
        {
            echo "\n\t\t<tr>\n\t\t\t\t<td>(Optional) Add to Bouquet: </td>\n\t\t\t\t<td>\n\t\t\t\t" . _obf_0D311A13371B215B013B112303362D1032353D2E344022('bouqet_id', 'Choose bouquet', 'bouquets', 0, 'id', 'bouquet_name', 'bouquet_status', 'where bouquet_status=1', 'order by bouquet_name asc') . "\n\t\t\t\t (This will add streams to selected Bouquet directly.)\n\t\t\t\t</td>\n\t\t</tr>";
        }
        echo "\n\t\t\n\t\t<tr>\n\t\t\t<td></td>\n\t\t\t<td>\n\t\t\t\t<input type=\"hidden\" name=\"app_name\"  value=\"" . $this->appname . "\">\n\t\t\t\t<input type=\"hidden\" name=\"t\"  value=\"" . $t . "\">\n\t\t\t\t<input type=\"hidden\" name=\"id\"  value=\"" . $id . "\">\n\t\t\t\t<input type=\"hidden\" name=\"IF\"  value=\"" . $IF . "\">\n\t\t\t\t<input type=\"hidden\" name=\"page\"  value=\"" . $page . "\">\n\t\t\t\t<button type=\"submit\" class=\"btn btn-success\">\n\t\t\t\t\t<i class=\"" . $btn['img_icon'] . '"></i> ' . $btn['name'] . " \n\t\t\t\t</button>\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t\t\n\t\t</form>";
        echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
        $StreamsEdit->JavaScript();
    }
    public function validate_source($stream_source)
    {
        if( !is_array($stream_source) ) 
        {
            return false;
        }
        foreach( $stream_source as $link ) 
        {
            if( $link == '' ) 
            {
                return false;
            }
        }
        return true;
    }
    public function validate_servers($server)
    {
        if( is_null($server) ) 
        {
            return false;
        }
        if( !is_array($server) ) 
        {
            return false;
        }
        foreach( $server as $srv ) 
        {
            if( intval($srv) == 0 ) 
            {
                return false;
            }
        }
        return true;
    }
    public function InsertUpdateArguments($stream_id, $arguments, $type = 'insert')
    {
        global $intro;
        global $error;
        $stream_id = intval($stream_id);
        if( is_array($arguments) && count($arguments) > 0 ) 
        {
            foreach( $arguments as $argument_id => $value ) 
            {
                if( $value != '' ) 
                {
                    $arg = [];
                    $arg['stream_id'] = $stream_id;
                    $arg['argument_id'] = $argument_id;
                    $arg['value'] = $value;
                    if( $type == 'insert' ) 
                    {
                        $intro->db->insert('streams_options', $arg);
                    }
                    if( $type == 'update' ) 
                    {
                        $sql7 = $intro->db->query_fast('select id,value from `streams_options` ' . (' WHERE argument_id=' . $argument_id . ' AND stream_id=' . $stream_id));
                        if( $intro->db->returned_rows == 0 ) 
                        {
                            $intro->db->insert('streams_options', $arg);
                        }
                        else
                        {
                            $intro->db->update('streams_options', $arg, 'argument_id=' . $argument_id . ' AND stream_id=' . $stream_id);
                        }
                    }
                }
                else
                {
                    $intro->db->delete('streams_options', 'argument_id=' . $argument_id . ' AND stream_id=' . $stream_id);
                }
            }
        }
    }
    public function doAdd()
    {
        global $intro;
        global $error;
        $msg = '';
        $time = time();
        $category_id = intval($intro->input->post('category_id'));
        $stream_display_name = trim($intro->input->post('stream_display_name'));
        $stream_display_name = str_replace('\'', '\'', $stream_display_name);
        $notes = trim($intro->input->post('notes'));
        $stream_source = $intro->input->post('stream_source');
        $movie_location = $intro->input->post('movie_location');
        $server = $intro->input->post('server');
        $stream_icon = trim($intro->input->post('stream_icon'));
        $direct_source = intval($intro->input->post('direct_source'));
        $redirect_stream = intval($intro->input->post('redirect_stream'));
        $bouqet_id = intval($intro->input->post('bouqet_id'));
        $on_demand = trim($intro->input->post('on_demand'));
        $probesize_ondemand = intval($intro->input->post('probesize_ondemand'));
        $transcode_profile_id = intval($intro->input->post('transcode_profile_id'));
        $arguments = $intro->input->post('arguments');
        if( $category_id == 0 || !$this->validate_servers($server) ) 
        {
            if( $category_id == 0 ) 
            {
                $msg .= '<li>Category is required! </li>';
            }
            if( !$this->validate_servers($server) ) 
            {
                $msg .= '<li>Please Choose Server!</li>';
            }
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'danger');
            $this->Form('add');
            exit();
        }
        if( $this->type == 3 ) 
        {
            if( !isset($server[0]) || is_array($server) && count($server) > 1 ) 
            {
                if( !isset($server[0]) || is_array($server) && count($server) > 1 ) 
                {
                    $error['server'] = '<li class=\'error\'>Please Choose only on Server!</li>';
                }
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Please fix errors' . implode(' ', $error), 'danger');
                $this->Form('add');
                exit();
            }
            if( $server[0] != intval($movie_location) ) 
            {
                $error['server'] = '<li class=\'error\'>(Channel Location) and (Load Balance Servers) must be the same server.</li>';
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('Please fix errors' . implode(' ', $error), 'danger');
                $this->Form('add');
                exit();
            }
        }
        $success_count = $duplicated_count = 0;
        if( !is_uploaded_file($_FILES['m3u_file']['tmp_name']) ) 
        {
            if( $stream_display_name == '' || !$this->validate_source($stream_source) ) 
            {
                if( $stream_display_name == '' ) 
                {
                    $msg .= '<li>Name is required </li>';
                }
                if( !$this->validate_source($stream_source) ) 
                {
                    $msg .= '<li>stream source is required </li>';
                }
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'danger');
                $this->Form('add');
                exit();
            }
            $data = [];
            $data['category_id'] = $category_id;
            $data['stream_display_name'] = $stream_display_name;
            $data['stream_source'] = json_encode($stream_source);
            $data['stream_icon'] = trim($intro->input->post('stream_icon'));
            $data['added'] = $time;
            $data['redirect_stream'] = $redirect_stream;
            $data['direct_source'] = $direct_source;
            $data['notes'] = $notes;
            $data['type'] = $this->type;
            $data['rtmp_output'] = intval($intro->input->post('rtmp_output'));
            $data['gen_timestamps'] = intval($intro->input->post('gen_timestamps'));
            $data['read_native'] = intval($intro->input->post('read_native'));
            $data['stream_all'] = intval($intro->input->post('stream_all'));
            $data['custom_sid'] = trim($intro->input->post('custom_sid'));
            $data['custom_ffmpeg'] = trim($intro->input->post('custom_ffmpeg'));
            $data['custom_map'] = trim($intro->input->post('custom_map'));
            $data['enable_transcode'] = intval($intro->input->post('enable_transcode'));
            $data['transcode_profile_id'] = intval($intro->input->post('transcode_profile_id'));
            if( $this->type == 1 ) 
            {
                $data['tv_archive_duration'] = intval($intro->input->post('tv_archive_duration'));
                $data['tv_archive_server_id'] = intval($intro->input->post('tv_archive_server_id'));
                $data['number'] = intval($intro->input->post('number'));
                $data['allow_record'] = intval($intro->input->post('allow_record'));
                $data['delay_minutes'] = intval($intro->input->post('delay_minutes'));
                $data['probesize_ondemand'] = ($probesize_ondemand == 0 ? 128000 : $probesize_ondemand);
            }
            if( $this->type == 3 ) 
            {
                $data['stream_source'] = json_encode(array_filter(explode("\n", $stream_source[0]), function($a)
                {
                    return trim(preg_replace("/\r|\n/", '', $a)) !== '';
                }));
                $data['created_channel_location'] = $server[0];
                $data['stream_all'] = 1;
                $data['read_native'] = 1;
                $data['transcode_profile_id'] = $transcode_profile_id;
                $on_demand = 'off';
            }
            $intro->db->insert('streams', $data);
            $stream_id = $intro->db->insert_id();
            if( $this->type == 1 ) 
            {
                $this->InsertUpdateArguments($stream_id, $arguments, 'insert');
            }
            foreach( $server as $key => $val ) 
            {
                $data2 = [];
                $data2['server_id'] = $val;
                $data2['stream_id'] = $stream_id;
                $data2['on_demand'] = ($on_demand == 'on' ? 1 : 0);
                $intro->db->insert('streams_sys', $data2);
            }
            if( $bouqet_id > 0 ) 
            {
                $sql2 = $intro->db->query('SELECT bouquet_channels FROM bouquets WHERE id=' . $bouqet_id . ';');
                $row2 = $intro->db->fetch_assoc($sql2);
                $bouquet_channels = json_decode($row2['bouquet_channels'], true);
                if( is_array($bouquet_channels) && count($bouquet_channels) > 0 ) 
                {
                    array_unshift($bouquet_channels, $stream_id);
                    $intro->db->update('bouquets', ['bouquet_channels' => json_encode($bouquet_channels)], 'id=' . $bouqet_id);
                }
            }
            $msg = '<h3>Stream (' . $stream_display_name . ') added successfully.</h3>';
        }
        else if( is_uploaded_file($_FILES['m3u_file']['tmp_name']) ) 
        {
            $strms = new M3uParse($_FILES['m3u_file']['tmp_name']);
            if( !is_array($strms->found_titles) ) 
            {
                _obf_0D103C08311F24242D2F281F0B3E28333032320A031011('<li>Error: nothing found in the uploaded m3u file!</li>', 'danger');
                $this->Form('add');
                exit();
            }
            $ar_strm_ids = [];
            foreach( $strms->found_titles as $sn => $row ) 
            {
                if( isset($row['title']) && isset($row['url']) ) 
                {
                    $stream_display_name = trim($row['title']);
                    $stream_display_name = str_replace('\'', '\'', $stream_display_name);
                    $url = trim($row['url']);
                    $intro->db->query('SELECT stream_display_name FROM streams where stream_display_name=\'' . $stream_display_name . '\'');
                    if( $intro->db->returned_rows > 0 ) 
                    {
                        $msg .= _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Duplicated: ' . $stream_display_name, 'danger');
                        $duplicated_count++;
                    }
                    else
                    {
                        $data = [];
                        $data['category_id'] = $category_id;
                        $data['stream_display_name'] = $stream_display_name;
                        $data['stream_source'] = json_encode([$url]);
                        $data['stream_icon'] = trim($intro->input->post('stream_icon'));
                        $data['added'] = $time;
                        $data['redirect_stream'] = $redirect_stream;
                        $data['direct_source'] = $direct_source;
                        $data['notes'] = $notes;
                        $data['type'] = $this->type;
                        $data['rtmp_output'] = intval($intro->input->post('rtmp_output'));
                        $data['gen_timestamps'] = intval($intro->input->post('gen_timestamps'));
                        $data['read_native'] = intval($intro->input->post('read_native'));
                        $data['stream_all'] = intval($intro->input->post('stream_all'));
                        $data['custom_sid'] = trim($intro->input->post('custom_sid'));
                        $data['custom_ffmpeg'] = trim($intro->input->post('custom_ffmpeg'));
                        $data['custom_map'] = trim($intro->input->post('custom_map'));
                        if( $this->type == 1 ) 
                        {
                            $data['tv_archive_duration'] = intval($intro->input->post('tv_archive_duration'));
                            $data['tv_archive_server_id'] = intval($intro->input->post('tv_archive_server_id'));
                            $data['number'] = intval($intro->input->post('number'));
                            $data['allow_record'] = intval($intro->input->post('allow_record'));
                            $data['delay_minutes'] = intval($intro->input->post('delay_minutes'));
                            $data['probesize_ondemand'] = ($probesize_ondemand == 0 ? 128000 : $probesize_ondemand);
                        }
                        $intro->db->insert('streams', $data);
                        $stream_id = $inset_id = $intro->db->insert_id();
                        $this->InsertUpdateArguments($stream_id, $arguments, 'insert');
                        $ar_strm_ids[] = $inset_id;
                        foreach( $server as $key => $val ) 
                        {
                            $data2 = [];
                            $data2['server_id'] = $val;
                            $data2['stream_id'] = $inset_id;
                            $data2['pid'] = -1;
                            $data2['monitor_pid'] = -1;
                            $data2['on_demand'] = ($on_demand == 'on' ? 1 : 0);
                            $intro->db->insert('streams_sys', $data2);
                        }
                        $success_count++;
                        $msg .= _obf_0D3D40321528110F062A0B0321102712170C15030F2232('Success: ' . $stream_display_name, 'success');
                    }
                }
            }
            if( $bouqet_id > 0 && count($ar_strm_ids) > 0 ) 
            {
                $sql2 = $intro->db->query('SELECT bouquet_channels FROM bouquets WHERE id=' . $bouqet_id . ';');
                $row2 = $intro->db->fetch_assoc($sql2);
                $bouquet_channels = json_decode($row2['bouquet_channels'], true);
                $bouquet_channels = array_merge($ar_strm_ids, $bouquet_channels);
                if( is_array($bouquet_channels) && count($bouquet_channels) > 0 ) 
                {
                    $intro->db->update('bouquets', ['bouquet_channels' => json_encode($bouquet_channels)], 'id=' . $bouqet_id);
                }
            }
        }
        if( $msg == '' ) 
        {
            $msg = '<h3 style=\'color:red\'>Unknow error!!! nothing added.</h3>';
        }
        if( $success_count > 0 || $duplicated_count > 0 ) 
        {
            $this->nav();
            echo _obf_0D032526222A033D1A2F331C092F2C3636101E15182F22('m3u upload results');
            echo '<h1>Total added Streams = ' . $success_count . "</h1>\n\t\t\t<h1>Total duplicated Streams = " . $duplicated_count . '</h1>' . $msg;
            echo _obf_0D011E16010C0A3322370E3E072C312F130B400C152411();
            unset($msg);
            exit();
        }
        if( $this->type == 3 ) 
        {
            $x = new XtreamApi('EmptyFunc');
            $x->Created($stream_id, $data['stream_source']);
        }
        _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'success');
        $intro->redirect($this->appname, 'Form', '?t=add');
    }
    public function doEdit()
    {
        global $intro;
        global $array;
        $data = [];
        $stream_display_name = trim($intro->input->post('stream_display_name'));
        $stream_source = $intro->input->post('stream_source');
        $arguments = $intro->input->post('arguments');
        $server = $intro->input->post('server');
        $page = intval($intro->input->post('page'));
        $on_demand = trim($intro->input->post('on_demand'));
        $id = $stream_id = intval($intro->input->post('id'));
        $probesize_ondemand = intval($intro->input->post('probesize_ondemand'));
        if( $stream_display_name == '' || !$this->validate_source($stream_source) || !$this->validate_servers($server) ) 
        {
            if( $stream_display_name == '' ) 
            {
                $msg .= '<li>Stream name is required. </li>';
            }
            if( !$this->validate_source($stream_source) ) 
            {
                $msg .= '<li>Stream source is required </li>';
            }
            if( !$this->validate_servers($server) ) 
            {
                $msg .= '<li>Please Choose Server</li>';
            }
            _obf_0D103C08311F24242D2F281F0B3E28333032320A031011($msg, 'danger');
            $this->Form('edit');
            exit();
        }
        $data = [];
        $data['category_id'] = intval($intro->input->post('category_id'));
        $data['stream_display_name'] = $stream_display_name;
        $data['stream_source'] = json_encode($stream_source);
        $data['stream_icon'] = trim($intro->input->post('stream_icon'));
        $data['redirect_stream'] = intval($intro->input->post('redirect_stream'));
        $data['direct_source'] = intval($intro->input->post('direct_source'));
        $data['notes'] = trim($intro->input->post('notes'));
        $data['rtmp_output'] = intval($intro->input->post('rtmp_output'));
        $data['gen_timestamps'] = intval($intro->input->post('gen_timestamps'));
        $data['read_native'] = intval($intro->input->post('read_native'));
        $data['stream_all'] = intval($intro->input->post('stream_all'));
        $data['custom_sid'] = trim($intro->input->post('custom_sid'));
        $data['custom_ffmpeg'] = trim($intro->input->post('custom_ffmpeg'));
        $data['custom_map'] = trim($intro->input->post('custom_map'));
        $data['enable_transcode'] = intval($intro->input->post('enable_transcode'));
        $data['transcode_profile_id'] = intval($intro->input->post('transcode_profile_id'));
        if( $this->type == 1 ) 
        {
            $data['tv_archive_duration'] = intval($intro->input->post('tv_archive_duration'));
            $data['tv_archive_server_id'] = intval($intro->input->post('tv_archive_server_id'));
            $data['number'] = intval($intro->input->post('number'));
            $data['allow_record'] = intval($intro->input->post('allow_record'));
            $data['delay_minutes'] = intval($intro->input->post('delay_minutes'));
            $data['probesize_ondemand'] = ($probesize_ondemand == 0 ? 128000 : $probesize_ondemand);
        }
        if( $this->type == 3 ) 
        {
            $data['stream_source'] = json_encode(array_filter(explode("\n", $stream_source[0]), function($a)
            {
                return trim(preg_replace("/\r|\n/", '', $a)) !== '';
            }));
        }
        if( $this->admin['level'] == 5 ) 
        {
            $data = [];
            $data['stream_icon'] = trim($intro->input->post('stream_icon'));
        }
        $intro->db->update('streams', $data, 'id=' . $id);
        $this->InsertUpdateArguments($id, $arguments, 'update');
        $this->InsertUpdateStreamServers($server, $id, $on_demand);
        if( $this->type == 3 ) 
        {
            $x = new XtreamApi('EmptyFunc');
            $x->Created($stream_id, $data['stream_source']);
            $intro->redirect('streams_created', 'index', '?page=' . $page . '&id=' . $id . '&from=edit');
            exit();
        }
        $intro->redirect($this->appname, 'index', '?page=' . $page . '&id=' . $id . '&from=edit');
    }
    public function InsertUpdateStreamServers($LB_Servers, $stream_id, $on_demand)
    {
        global $intro;
        global $sess_admin;
        global $array;
        $dbServ = [];
        $changes = false;
        $sql = $intro->db->query('SELECT server_id FROM streams_sys WHERE stream_id=' . $stream_id . ';');
        if( $intro->db->returned_rows > 0 ) 
        {
            while( $row = $intro->db->fetch_assoc($sql) ) 
            {
                $dbServ[] = $row['server_id'];
            }
            if( serialize($LB_Servers) != serialize($dbServ) ) 
            {
                $changes = true;
            }
        }
        else
        {
            $changes = true;
        }
        if( !$changes ) 
        {
            return null;
        }
        $x = new XtreamApi('EmptyFunc');
        $x->Stop($stream_id);
        $sql = $intro->db->query('DELETE FROM streams_sys WHERE stream_id=' . $stream_id . ';');
        foreach( $LB_Servers as $key => $val ) 
        {
            $data2 = [];
            $data2['server_id'] = $val;
            $data2['stream_id'] = $stream_id;
            $data2['pid'] = -1;
            $data2['monitor_pid'] = -1;
            if( $on_demand == 'on' ) 
            {
                $data2['on_demand'] = 1;
            }
            if( $on_demand == 'off' ) 
            {
                $data2['on_demand'] = 0;
            }
            $intro->db->insert('streams_sys', $data2);
        }
    }
    public function Del()
    {
        global $intro;
        global $sess_admin;
        global $array;
        $id = intval($intro->input->get_post('id'));
        policy($sess_admin['adminid'], $this->appname . '.php', 'del');
        if( $this->admin['level'] == 1 ) 
        {
            $sql = $intro->db->query('DELETE FROM streams WHERE id=' . $id . ' ');
            $sql = $intro->db->query('DELETE FROM streams_sys WHERE stream_id=' . $id . ' ');
        }
        $intro->redirect($this->appname);
    }
}
