<?php 
class FtpBackup
{
    public $db_count = -1;
    public $ftp_count = -1;
    public $db = null;
    public function __construct()
    {
        set_time_limit(0);
        $this->db_count++;
        $this->db[$this->db_count]['db_user'] = '';
        $this->db[$this->db_count]['db_password'] = '';
        $this->db[$this->db_count]['db_name'] = '';
        $this->db[$this->db_count]['sql_file'] = 'dump_' . date('Y-m-d_H-i-s') . ('_' . $this->db[$this->db_count]['db_name'] . '.sql');
        $this->ftp_count++;
        $this->ftp[$this->ftp_count]['ftps'] = false;
        $this->ftp[$this->ftp_count]['ftp_server'] = '';
        $this->ftp[$this->ftp_count]['ftp_user'] = '';
        $this->ftp[$this->ftp_count]['ftp_password'] = '';
        $this->ftp[$this->ftp_count]['ftp_passive_mode'] = true;
        $this->ftp[$this->ftp_count]['ftp_remote_folder'] = '';
    }
    public function run()
    {
        foreach( $this->db as $db_item ) 
        {
            exec('mysqldump -u ' . $db_item['db_user'] . ' -p' . $db_item['db_password'] . ' --allow-keywords --add-drop-table --complete-insert --hex-blob --quote-names ' . $db_item['db_name'] . ' > ' . $db_item['sql_file']);
            exec('gzip ' . $db_item['sql_file']);
            if( $this->ftp_count >= 0 ) 
            {
                foreach( $this->ftp as $ftp_item ) 
                {
                    if( $ftp_item['ftps'] ) 
                    {
                        $connection_id = _obf_0D1E2E0D072304062E1A2A36080936371D1F3C5C310D01($ftp_item['ftp_server']);
                    }
                    else
                    {
                        $connection_id = ftp_connect($ftp_item['ftp_server']);
                    }
                    if( !$connection_id ) 
                    {
                        echo 'Error: Can\'t connect to ' . $ftp_item['ftp_server'] . "\n";
                    }
                    $login_result = ftp_login($connection_id, $ftp_item['ftp_user'], $ftp_item['ftp_password']);
                    if( !$login_result ) 
                    {
                        echo 'Error: Login wrong for ' . $ftp_item['ftp_server'] . "\n";
                    }
                    ftp_pasv($connection_id, $ftp_item['ftp_passive_mode']);
                    if( !ftp_put($connection_id, $ftp_item['ftp_remote_folder'] . '/' . $db_item['sql_file'] . '.gz', $db_item['sql_file'] . '.gz', FTP_BINARY) ) 
                    {
                        echo 'Error: While uploading ' . $db_item['sql_file'] . '.gz to ' . $ftp_item['ftp_server'] . ".\n";
                    }
                    ftp_close($connection_id);
                }
            }
            if( file_exists($db_item['sql_file']) ) 
            {
                unlink($db_item['sql_file']);
            }
        }
    }
}
