<?php 
class Input
{
    public $ip_address = false;
    public $user_agent = false;
    public $_allow_get_array = true;
    public $_standardize_newlines = true;
    public $_enable_xss = false;
    public $_enable_csrf = false;
    protected $headers = [];
    public function __construct()
    {
        $this->_allow_get_array = true;
        $this->_enable_xss = true;
        $this->_enable_csrf = true;
        global $SEC;
        $this->security =& $SEC;
    }
    public function _fetch_from_array(&$array, $index = '', $xss_clean = false)
    {
        if( !isset($array[$index]) ) 
        {
            return false;
        }
        if( $xss_clean === true ) 
        {
            return $this->security->xss_clean($array[$index]);
        }
        return $array[$index];
    }
    public function get($index = null, $xss_clean = false)
    {
        if( $index === null && !empty($_GET) ) 
        {
            $get = [];
            foreach( array_keys($_GET) as $key ) 
            {
                $get[$key] = $this->_fetch_from_array($_GET, $key, $xss_clean);
            }
            return $get;
        }
        return $this->_fetch_from_array($_GET, $index, $xss_clean);
    }
    public function post($index = null, $xss_clean = false)
    {
        if( $index === null && !empty($_POST) ) 
        {
            $post = [];
            foreach( array_keys($_POST) as $key ) 
            {
                $post[$key] = $this->_fetch_from_array($_POST, $key, $xss_clean);
            }
            return $post;
        }
        return $this->_fetch_from_array($_POST, $index, $xss_clean);
    }
    public function get_post($index = '', $xss_clean = false)
    {
        if( !isset($_POST[$index]) ) 
        {
            return $this->get($index, $xss_clean);
        }
        else
        {
            return $this->post($index, $xss_clean);
        }
    }
    public function cookie($index = '', $xss_clean = false)
    {
        return $this->_fetch_from_array($_COOKIE, $index, $xss_clean);
    }
    public function set_cookie($name = '', $value = '', $expire = '', $domain = '', $path = '/', $prefix = '', $secure = false)
    {
        if( is_array($name) ) 
        {
            foreach( [
                'value', 
                'expire', 
                'domain', 
                'path', 
                'prefix', 
                'secure', 
                'name'
            ] as $item ) 
            {
                if( isset($name[$item]) ) 
                {
                    ${$item} = $name[$item];
                }
            }
        }
        if( !is_numeric($expire) ) 
        {
            $expire = time() - 86500;
        }
        else
        {
            $expire = ($expire > 0 ? time() + $expire : 0);
        }
        setcookie($prefix . $name, $value, $expire, $path, $domain, $secure);
    }
    public function server($index = '', $xss_clean = false)
    {
        return $this->_fetch_from_array($_SERVER, $index, $xss_clean);
    }
    public function ip_address()
    {
        if( !empty($_SERVER['HTTP_CLIENT_IP']) ) 
        {
            $ip = $this->server('HTTP_CLIENT_IP');
        }
        else if( !empty($_SERVER['HTTP_X_FORWARDED_FOR']) ) 
        {
            $ip = $this->server('HTTP_X_FORWARDED_FOR');
        }
        else
        {
            $ip = $this->server('REMOTE_ADDR');
        }
        if( strpos($ip, ',') !== false ) 
        {
            $x = explode(',', $ip);
            $ip = trim($x[0]);
        }
        return $ip;
    }
    public function ip_address2()
    {
        if( $this->ip_address !== false ) 
        {
            return $this->ip_address;
        }
        if( $this->server('HTTP_X_FORWARDED_FOR') && $this->server('REMOTE_ADDR') ) 
        {
            $proxies = null;
            $proxies = ['127.0.0.1'];
            $this->ip_address = (in_array($_SERVER['REMOTE_ADDR'], $proxies) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $_SERVER['REMOTE_ADDR']);
        }
        else if( $this->server('REMOTE_ADDR') && $this->server('HTTP_CLIENT_IP') ) 
        {
            $this->ip_address = $_SERVER['HTTP_CLIENT_IP'];
        }
        else if( $this->server('REMOTE_ADDR') ) 
        {
            $this->ip_address = $_SERVER['REMOTE_ADDR'];
        }
        else if( $this->server('HTTP_CLIENT_IP') ) 
        {
            $this->ip_address = $_SERVER['HTTP_CLIENT_IP'];
        }
        else if( $this->server('HTTP_X_FORWARDED_FOR') ) 
        {
            $this->ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
        if( $this->ip_address === false ) 
        {
            $this->ip_address = '0.0.0.0';
            return $this->ip_address;
        }
        if( strpos($this->ip_address, ',') !== false ) 
        {
            $x = explode(',', $this->ip_address);
            $this->ip_address = trim(end($x));
        }
        if( !$this->valid_ip($this->ip_address) ) 
        {
            $this->ip_address = '0.0.0.0';
        }
        return $this->ip_address;
    }
    public function valid_ip($ip)
    {
        $ip_segments = explode('.', $ip);
        if( count($ip_segments) != 4 ) 
        {
            return false;
        }
        if( $ip_segments[0][0] == '0' ) 
        {
            return false;
        }
        foreach( $ip_segments as $segment ) 
        {
            if( $segment == '' || preg_match('/[^0-9]/', $segment) || $segment > 255 || strlen($segment) > 3 ) 
            {
                return false;
            }
        }
        return true;
    }
    public function user_agent()
    {
        if( $this->user_agent !== false ) 
        {
            return $this->user_agent;
        }
        $this->user_agent = (!isset($_SERVER['HTTP_USER_AGENT']) ? false : $_SERVER['HTTP_USER_AGENT']);
        return $this->user_agent;
    }
    public function _sanitize_globals()
    {
        $protected = [
            '_SERVER', 
            '_GET', 
            '_POST', 
            '_FILES', 
            '_REQUEST', 
            '_SESSION', 
            '_ENV', 
            'GLOBALS', 
            'HTTP_RAW_POST_DATA', 
            'system_folder', 
            'application_folder', 
            'BM', 
            'EXT', 
            'CFG', 
            'URI', 
            'RTR', 
            'OUT', 
            'IN'
        ];
        foreach( [
            $_GET, 
            $_POST, 
            $_COOKIE
        ] as $global ) 
        {
            if( !is_array($global) ) 
            {
                if( !in_array($global, $protected) ) 
                {
                    global ${$global};
                    ${$global} = null;
                }
            }
            else
            {
                foreach( $global as $key => $val ) 
                {
                    if( !in_array($key, $protected) ) 
                    {
                        global ${$key};
                        ${$key} = null;
                    }
                }
            }
        }
        if( !$this->_allow_get_array ) 
        {
            $_GET = [];
        }
        else if( is_array($_GET) && count($_GET) > 0 ) 
        {
            foreach( $_GET as $key => $val ) 
            {
                $_GET[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
            }
        }
        if( is_array($_POST) && count($_POST) > 0 ) 
        {
            foreach( $_POST as $key => $val ) 
            {
                $_POST[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
            }
        }
        if( is_array($_COOKIE) && count($_COOKIE) > 0 ) 
        {
            unset($_COOKIE['$Version']);
            unset($_COOKIE['$Path']);
            unset($_COOKIE['$Domain']);
            foreach( $_COOKIE as $key => $val ) 
            {
                $_COOKIE[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
            }
        }
        $_SERVER['PHP_SELF'] = strip_tags($_SERVER['PHP_SELF']);
        if( $this->_enable_csrf ) 
        {
            $this->security->csrf_verify();
        }
    }
    public function _clean_input_data($str)
    {
        if( is_array($str) ) 
        {
            $new_array = [];
            foreach( $str as $key => $val ) 
            {
                $new_array[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
            }
            return $new_array;
        }
        if( !is_php('5.4') && get_magic_quotes_gpc() ) 
        {
            $str = stripslashes($str);
        }
        if( UTF8_ENABLED === true ) 
        {
            $str = $this->uni->clean_string($str);
        }
        $str = remove_invisible_characters($str);
        if( $this->_enable_xss === true ) 
        {
            $str = $this->security->xss_clean($str);
        }
        if( $this->_standardize_newlines && strpos($str, "\r") !== false ) 
        {
            $str = str_replace([
                "\r\n", 
                "\r", 
                "\r\n\n"
            ], PHP_EOL, $str);
        }
        return $str;
    }
    public function _clean_input_keys($str)
    {
        if( !preg_match('/^[a-z0-9:_\/-]+$/i', $str) ) 
        {
            exit( 'Disallowed Key Characters.' );
        }
        if( UTF8_ENABLED === true ) 
        {
            $str = $this->uni->clean_string($str);
        }
        return $str;
    }
    public function request_headers($xss_clean = false)
    {
        if( function_exists('apache_request_headers') ) 
        {
            $headers = apache_request_headers();
        }
        else
        {
            $headers['Content-Type'] = (isset($_SERVER['CONTENT_TYPE']) ? $_SERVER['CONTENT_TYPE'] : @getenv('CONTENT_TYPE'));
            foreach( $_SERVER as $key => $val ) 
            {
                if( strncmp($key, 'HTTP_', 5) === 0 ) 
                {
                    $headers[substr($key, 5)] = $this->_fetch_from_array($_SERVER, $key, $xss_clean);
                }
            }
        }
        foreach( $headers as $key => $val ) 
        {
            $key = str_replace('_', ' ', strtolower($key));
            $key = str_replace(' ', '-', ucwords($key));
            $this->headers[$key] = $val;
        }
        return $this->headers;
    }
    public function get_request_header($index, $xss_clean = false)
    {
        if( empty($this->headers) ) 
        {
            $this->request_headers();
        }
        if( !isset($this->headers[$index]) ) 
        {
            return false;
        }
        if( $xss_clean === true ) 
        {
            return $this->security->xss_clean($this->headers[$index]);
        }
        return $this->headers[$index];
    }
    public function is_ajax_request()
    {
        return $this->server('HTTP_X_REQUESTED_WITH') === 'XMLHttpRequest';
    }
    public function is_cli_request()
    {
        return php_sapi_name() == 'cli' || defined('STDIN');
    }
}
