<?php 
class Movie extends ApiBaseObject
{
    private $_tmdb = null;
    public function getTitle()
    {
        return $this->_data['title'];
    }
    public function getTagline()
    {
        return $this->_data['tagline'];
    }
    public function getDirectorIds()
    {
        $director_ids = [];
        $crew = $this->getCrew();
        foreach( $crew as $crew_member ) 
        {
            if( $crew_member->getJob() === Person::JOB_DIRECTOR ) 
            {
                $director_ids[] = $crew_member->getID();
            }
        }
        return $director_ids;
    }
    public function getTrailers()
    {
        return $this->_data['trailers'];
    }
    public function getTrailer()
    {
        $trailers = $this->getTrailers();
        if( !array_key_exists('youtube', $trailers) ) 
        {
            return null;
        }
        if( count($trailers['youtube']) === 0 ) 
        {
            return null;
        }
        return $trailers['youtube'][0]['source'];
    }
    public function getReviews()
    {
        $reviews = [];
        foreach( $this->_data['review']['result'] as $data ) 
        {
            $reviews[] = new Review($data);
        }
        return $reviews;
    }
    public function getCompanies()
    {
        $companies = [];
        foreach( $this->_data['production_companies'] as $data ) 
        {
            $companies[] = new Company($data);
        }
        return $companies;
    }
    public function setAPI($tmdb)
    {
        $this->_tmdb = $tmdb;
    }
    public function getJSON()
    {
        return json_encode($this->_data, JSON_PRETTY_PRINT);
    }
    public function getMediaType()
    {
        return self::MEDIA_TYPE_MOVIE;
    }
}
